/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.lib.tile;

import frogcraftrebirth.common.lib.tile.TileFrog;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class TileEnergyGenerator
extends TileFrog
implements ITickable,
IEnergySource {
    public int charge;
    public int sourceTier;
    public int output;
    protected boolean isInENet;

    public TileEnergyGenerator(int sourceTier, int output) {
        this.sourceTier = sourceTier;
        this.output = output;
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K && this.isInENet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.isInENet = false;
        }
        super.func_145843_s();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !this.isInENet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.isInENet = true;
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.charge = tag.func_74762_e("charge");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74768_a("charge", this.charge);
        return super.func_189515_b(tag);
    }

    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing direction) {
        return true;
    }

    public double getOfferedEnergy() {
        return Math.min(this.charge, this.output);
    }

    public void drawEnergy(double amount) {
        this.charge = (double)this.charge <= amount ? 0 : (this.charge -= (int)amount);
    }

    public int getSourceTier() {
        return this.sourceTier;
    }
}

