/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.tile;

import frogcraftrebirth.api.air.IAirConsumer;
import frogcraftrebirth.api.air.IAirPump;
import frogcraftrebirth.common.lib.FrogFluidTank;
import frogcraftrebirth.common.lib.tile.TileEnergySink;
import frogcraftrebirth.common.lib.util.ItemUtil;
import frogcraftrebirth.common.tile.IHasWork;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileLiquefier
extends TileEnergySink
implements IAirConsumer,
IHasWork {
    public final ItemStackHandler inv = new ItemStackHandler(2);
    public final FrogFluidTank tank = new FrogFluidTank(8000);
    public int process;
    public boolean working;

    public TileLiquefier() {
        super(2, 10000);
    }

    @Override
    public boolean isWorking() {
        return this.working;
    }

    @Override
    public void func_73660_a() {
        TileEntity tile;
        ItemStack remainder;
        ItemStack result;
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
            return;
        }
        super.func_73660_a();
        if (this.inv.getStackInSlot(0) != null && this.inv.getStackInSlot(0).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && (result = FluidUtil.tryFillContainer((ItemStack)this.inv.extractItem(0, 1, false), (IFluidHandler)this.tank, (int)1000, null, (boolean)true)) != null && result.field_77994_a > 0 && (remainder = this.inv.insertItem(1, result, false)) != null && remainder.field_77994_a > 0) {
            ItemUtil.dropItemStackAsEntityInsanely(this.field_145850_b, this.func_174877_v(), remainder);
        }
        if ((tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b())) == null || !(tile instanceof IAirPump) || this.tank.isFull()) {
            this.working = false;
            this.sendTileUpdatePacket(this);
            this.func_70296_d();
            return;
        }
        this.working = true;
        if (this.charge >= 128) {
            this.charge -= 128;
            ++this.process;
        } else if (this.charge < 0) {
            this.charge = 0;
        }
        if (this.process == 200) {
            if (((IAirPump)tile).airAmount() >= 1000) {
                ((IAirPump)tile).extractAir(EnumFacing.DOWN, 1000, false);
                this.tank.fill(FluidRegistry.getFluidStack((String)"ic2air", (int)10), true);
            }
            this.process = 0;
        }
        this.sendTileUpdatePacket(this);
        this.func_70296_d();
    }

    @Override
    public void readPacketData(DataInputStream input) throws IOException {
        super.readPacketData(input);
        this.tank.readPacketData(input);
        this.process = input.readInt();
        this.working = input.readBoolean();
    }

    @Override
    public void writePacketData(DataOutputStream output) throws IOException {
        super.writePacketData(output);
        this.tank.writePacketData(output);
        output.writeInt(this.process);
        output.writeBoolean(this.working);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag);
        this.process = tag.func_74762_e("process");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        this.tank.writeToNBT(tag);
        tag.func_74768_a("process", this.process);
        return super.func_189515_b(tag);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public int inject(EnumFacing facing, int amount, boolean doInject) {
        return amount;
    }
}

