/*
 * Decompiled with CFR 0.152.
 */
package uk.co.talonius.ic2;

import uk.co.talonius.ic2.DataTracker;
import uk.co.talonius.ic2.ItemReactorCondensator;
import uk.co.talonius.ic2.ItemReactorDepletedUranium;
import uk.co.talonius.ic2.ItemReactorHeatStorage;
import uk.co.talonius.ic2.ItemReactorHeatSwitch;
import uk.co.talonius.ic2.ItemReactorHeatpack;
import uk.co.talonius.ic2.ItemReactorPlating;
import uk.co.talonius.ic2.ItemReactorReflector;
import uk.co.talonius.ic2.ItemReactorUranium;
import uk.co.talonius.ic2.ItemReactorVent;
import uk.co.talonius.ic2.ItemReactorVentSpread;
import uk.co.talonius.ic2.ReactorCore;
import uk.co.talonius.ic2.ReactorPlanner;

class ReactorCell {
    static final int BLANK = 0;
    static final int URANIUM_SINGLE = 1;
    static final int URANIUM_DUAL = 2;
    static final int URANIUM_QUAD = 3;
    static final int ISOTOPE = 4;
    static final int REFLECTOR_NORMAL = 5;
    static final int REFLECTOR_THICK = 6;
    static final int VENT_NORMAL = 7;
    static final int VENT_REACTOR = 8;
    static final int VENT_OVERCLOCKED = 9;
    static final int VENT_ADVANCED = 10;
    static final int VENT_SPREAD = 11;
    static final int CONDENSATOR_REDSTONE = 12;
    static final int CONDENSATOR_LAPIS = 13;
    static final int HEATSWITCH_NORMAL = 14;
    static final int HEATSWITCH_REACTOR = 15;
    static final int HEATSWITCH_COMPONENT = 16;
    static final int HEATSWITCH_ADVANCED = 17;
    static final int PLATING_STANDARD = 18;
    static final int PLATING_HEATMAX = 19;
    static final int PLATING_CONTAINMENT = 20;
    static final int HEATSTORE_10K = 21;
    static final int HEATSTORE_30K = 22;
    static final int HEATSTORE_60K = 23;
    static final int HEATPACK = 24;
    static final int THORIUM_SINGLE = 32;
    static final int THORIUM_DUAL = 33;
    static final int THORIUM_QUAD = 34;
    static final int PLUTONIUM_SINGLE = 35;
    static final int PLUTONIUM_DUAL = 36;
    static final int PLUTONIUM_QUAD = 37;
    static final int REFLECTOR_IRIDIUM = 38;
    static final int HEATSTORE_H_60K = 39;
    static final int HEATSTORE_H_180K = 40;
    static final int HEATSTORE_H_360K = 41;
    static final int HEATSTORE_S_60K = 42;
    static final int HEATSTORE_S_180K = 43;
    static final int HEATSTORE_S_360K = 44;
    static final int TYPE_CONDENSATOR = 1;
    static final int TYPE_HEATSTORE = 2;
    static final int TYPE_HEATSWITCH = 3;
    static final int TYPE_PLATING = 4;
    static final int TYPE_REFLECTOR = 5;
    static final int TYPE_URANIUM = 6;
    static final int TYPE_VENT = 7;
    static final int FLAG_SELFCOOLING = 0;
    static final int FLAG_SPREADINGHEAT = 1;
    static final int FLAG_CHARGING = 2;
    static final int FLAG_CHARGED = 3;
    static final int FLAG_MELTED = 4;
    static final int FLAG_CONNECTEDTOHULL = 5;
    static final int FLAG_NEEDSREPLACMENT = 6;
    private final int cellID;
    private final int cellType;
    int damage;
    int maxDamage = 10000;
    int highestDamage = 0;
    int replacements = 0;
    int heatedStart = 0;
    int pulses = 0;
    int rechargePulses = 0;
    int tickHeat = 0;
    int highestOutgoingCoreheat = 0;
    int highestIncomingCoreheat = 0;
    int stackSize;
    int highestCooling = 0;
    private float partialChange;
    private DataTracker damageTracker;
    private boolean[] flags;
    int testCounter = 0;
    float generationDamage;
    float generationDamageRate;
    float estimatedLifeLeft;

    ReactorCell(int var1) {
        this.cellID = var1;
        this.cellType = ReactorCell.getTypeForID(var1);
        this.damage = var1 == 4 ? 10000 : 0;
        this.stackSize = 1;
        this.maxDamage = 10000;
        this.partialChange = 0.0f;
        this.damageTracker = new DataTracker();
        this.flags = new boolean[7];
        this.flags[0] = false;
        this.flags[1] = false;
        this.flags[2] = false;
        this.flags[3] = false;
        this.flags[4] = false;
        this.flags[5] = false;
        this.flags[6] = false;
    }

    ReactorCell(int var1, int var2) {
        this(var1);
    }

    ReactorCell(int var1, int var2, int var3) {
        this(var1);
        if (this instanceof ItemReactorReflector || this instanceof ItemReactorCondensator) {
            this.maxDamage = var3;
        }
    }

    static int getTypeForID(int id) {
        switch (id) {
            case 12: 
            case 13: {
                return 1;
            }
            case 21: 
            case 22: 
            case 23: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return 2;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return 3;
            }
            case 18: 
            case 19: 
            case 20: {
                return 4;
            }
            case 5: 
            case 6: 
            case 38: {
                return 5;
            }
            case 1: 
            case 2: 
            case 3: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                return 6;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return 7;
            }
        }
        return 0;
    }

    static ReactorCell createCell(int cellID) {
        switch (cellID) {
            case 0: {
                return null;
            }
            case 1: {
                return new ItemReactorUranium(cellID, 0, 1, 10000, 1.0f, 1.0f);
            }
            case 2: {
                return new ItemReactorUranium(cellID, 0, 2, 10000, 1.0f, 1.0f);
            }
            case 3: {
                return new ItemReactorUranium(cellID, 0, 4, 10000, 1.0f, 1.0f);
            }
            case 35: {
                return new ItemReactorUranium(cellID, 0, 1, 20000, 2.0f, 2.25f);
            }
            case 36: {
                return new ItemReactorUranium(cellID, 0, 2, 20000, 2.0f, 2.25f);
            }
            case 37: {
                return new ItemReactorUranium(cellID, 0, 4, 20000, 2.0f, 2.25f);
            }
            case 32: {
                return new ItemReactorUranium(cellID, 0, 1, 50000, 0.2f, 0.25f);
            }
            case 33: {
                return new ItemReactorUranium(cellID, 0, 2, 50000, 0.2f, 0.25f);
            }
            case 34: {
                return new ItemReactorUranium(cellID, 0, 4, 50000, 0.2f, 0.25f);
            }
            case 4: {
                return new ItemReactorDepletedUranium(cellID, 0);
            }
            case 5: {
                return new ItemReactorReflector(cellID, 0, 10000);
            }
            case 6: {
                return new ItemReactorReflector(cellID, 0, 40000);
            }
            case 38: {
                return new ItemReactorReflector(cellID, 0, -1);
            }
            case 7: {
                return new ItemReactorVent(cellID, 0, 1000, 6, 0);
            }
            case 8: {
                return new ItemReactorVent(cellID, 0, 1000, 5, 5);
            }
            case 9: {
                return new ItemReactorVent(cellID, 0, 1000, 20, 36);
            }
            case 11: {
                return new ItemReactorVentSpread(cellID, 0, 4);
            }
            case 10: {
                return new ItemReactorVent(cellID, 0, 1000, 12, 0);
            }
            case 14: {
                return new ItemReactorHeatSwitch(cellID, 0, 2500, 12, 4);
            }
            case 15: {
                return new ItemReactorHeatSwitch(cellID, 0, 5000, 0, 72);
            }
            case 16: {
                return new ItemReactorHeatSwitch(cellID, 0, 5000, 36, 0);
            }
            case 17: {
                return new ItemReactorHeatSwitch(cellID, 0, 10000, 24, 8);
            }
            case 12: {
                return new ItemReactorCondensator(cellID, 0, 20000);
            }
            case 13: {
                return new ItemReactorCondensator(cellID, 0, 100000);
            }
            case 18: {
                return new ItemReactorPlating(cellID, 0, 1000, 0.95f);
            }
            case 19: {
                return new ItemReactorPlating(cellID, 0, 2000, 0.99f);
            }
            case 20: {
                return new ItemReactorPlating(cellID, 0, 500, 0.9f);
            }
            case 21: {
                return new ItemReactorHeatStorage(cellID, 0, 10000);
            }
            case 22: {
                return new ItemReactorHeatStorage(cellID, 0, 30000);
            }
            case 23: {
                return new ItemReactorHeatStorage(cellID, 0, 60000);
            }
            case 39: {
                return new ItemReactorHeatStorage(cellID, 0, 60000);
            }
            case 40: {
                return new ItemReactorHeatStorage(cellID, 0, 180000);
            }
            case 41: {
                return new ItemReactorHeatStorage(cellID, 0, 360000);
            }
            case 42: {
                return new ItemReactorHeatStorage(cellID, 0, 60000);
            }
            case 43: {
                return new ItemReactorHeatStorage(cellID, 0, 180000);
            }
            case 44: {
                return new ItemReactorHeatStorage(cellID, 0, 360000);
            }
            case 24: {
                return new ItemReactorHeatpack(cellID, 0, 1000, 1);
            }
        }
        return null;
    }

    int getCellID() {
        return this.cellID;
    }

    int getCellType() {
        return this.cellType;
    }

    ReactorCell getItem() {
        return this;
    }

    int getDamage() {
        return this.damage;
    }

    int getMaxDamage() {
        return this.maxDamage;
    }

    void partialDamage(float change) {
        this.partialChange += change;
        if (this.partialChange <= -1.0f) {
            this.changeDamage((int)Math.ceil(this.partialChange));
            this.partialChange -= (float)Math.floor(this.partialChange);
        } else if (this.partialChange >= 1.0f) {
            this.changeDamage((int)Math.floor(this.partialChange));
            this.partialChange -= (float)Math.floor(this.partialChange);
        }
    }

    void changeDamage(int change) {
        if (this.maxDamage == -1) {
            return;
        }
        this.damage += change;
        if (change > 0 && this.damage > this.highestDamage) {
            this.highestDamage = this.damage;
        }
        if (ReactorPlanner.simulator.generationPhase) {
            this.damageTracker.addChange(change);
        }
    }

    void setFlag(int flag, boolean value) {
        this.flags[flag] = value;
    }

    boolean getFlag(int flag) {
        return this.flags[flag];
    }

    void commitTrackers() {
        this.damageTracker.commitChange();
    }

    void resetTrackers() {
        this.damageTracker.reset();
    }

    float getAverageHealthChange() {
        return this.damageTracker.getAverageChange();
    }

    void processChamber(ReactorCore reactor, ReactorCell yourStack, int x, int y) {
    }

    boolean acceptUraniumPulse(ReactorCore reactor, ReactorCell yourStack, ReactorCell pulsingStack, int youX, int youY, int pulseX, int pulseY) {
        return false;
    }

    boolean canStoreHeat(ReactorCore reactor, ReactorCell yourStack, int x, int y) {
        return false;
    }

    int getMaxHeat(ReactorCore reactor, ReactorCell yourStack, int x, int y) {
        return 0;
    }

    int getCurrentHeat(ReactorCore reactor, ReactorCell yourStack, int x, int y) {
        return 0;
    }

    int alterHeat(ReactorCore reactor, ReactorCell yourStack, int x, int y, int heat) {
        return 0;
    }

    float influenceExplosion(ReactorCore reactor, ReactorCell yourStack) {
        return 1.0f;
    }
}

