/*
 * Decompiled with CFR 0.152.
 */
package uk.co.talonius.ic2;

import uk.co.talonius.ic2.ReactorCell;
import uk.co.talonius.ic2.ReactorData;
import uk.co.talonius.ic2.ReactorSimulator;

class ReactorCore {
    ReactorSimulator simulator;
    ReactorData data;
    int output = 0;
    int maxHeat = 10000;
    float hem = 1.0f;
    boolean cellDeath = false;
    int size;
    ReactorCell[][] cellGrid = null;
    int currentHeat = 0;

    ReactorCore(ReactorSimulator newSim, ReactorData newData) {
        this.simulator = newSim;
        this.data = newData;
        this.size = 3;
        this.cellGrid = new ReactorCell[9][6];
        this.cellDeath = false;
    }

    boolean processComponents() {
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < this.size; ++x) {
                if (this.cellGrid[x][y] != null) {
                    this.cellGrid[x][y].processChamber(this, this.cellGrid[x][y], x, y);
                }
                if (!this.cellDeath) continue;
                return false;
            }
        }
        return true;
    }

    int getHeat() {
        return this.currentHeat;
    }

    void addHeat(int heat) {
        this.simulator.heatTracker.addChange(heat);
        this.currentHeat += heat;
        if (this.produceEnergy()) {
            this.data.coreGenerationHeatChange += heat;
        }
    }

    void setHeat(int heat) {
        this.currentHeat = heat;
    }

    int getMaxHeat() {
        return this.maxHeat;
    }

    void setMaxHeat(int heat) {
        this.maxHeat = heat;
    }

    float getHeatEffectModifier() {
        return this.hem;
    }

    void setHeatEffectModifier(float newHem) {
        this.hem = newHem;
    }

    boolean produceEnergy() {
        return this.simulator.generationPhase;
    }

    int getPulsePower() {
        return 5;
    }

    void addOutput(int power) {
        this.output += power;
    }

    ReactorCell getItemAt(int gridX, int gridY) {
        if (gridX < 0 || gridX >= this.size || gridY < 0 || gridY >= 6) {
            return null;
        }
        return this.cellGrid[gridX][gridY];
    }

    void setItemAt(int gridX, int gridY, ReactorCell cell) {
        if (cell == null) {
            if (this.cellGrid[gridX][gridY].getCellType() == 6) {
                if (this.simulator.tickCount < this.data.maxGenerationTicks - 1) {
                    ReactorCell temp = this.cellGrid[gridX][gridY];
                    ++temp.replacements;
                    temp.damage = 0;
                    temp.highestDamage = 0;
                    temp.setFlag(6, true);
                }
            } else if (this.cellGrid[gridX][gridY].getCellType() == 1 || this.cellGrid[gridX][gridY].getCellType() == 5) {
                ReactorCell temp = this.cellGrid[gridX][gridY];
                temp.damage = 0;
                temp.highestDamage = 0;
                ++temp.replacements;
            } else if (!this.cellGrid[gridX][gridY].getFlag(4)) {
                this.cellDeath = true;
                this.simulator.stopSimulation(2);
                this.cellGrid[gridX][gridY].setFlag(4, true);
                this.cellGrid[gridX][gridY].damage = this.cellGrid[gridX][gridY].getMaxDamage() - 1;
            }
        } else {
            this.cellGrid[gridX][gridY] = cell;
        }
    }
}

