/*
 * Decompiled with CFR 0.152.
 */
package uk.co.talonius.ic2;

import java.util.ArrayList;
import uk.co.talonius.ic2.ItemReactorUranium;
import uk.co.talonius.ic2.ReactorCell;
import uk.co.talonius.ic2.ReactorCore;

class ItemReactorUranium
extends ReactorCell {
    int numberOfCells;
    int lifeTime;
    float energyMultiplier;
    float heatMultiplier;

    ItemReactorUranium(int var1, int var2, int var3, int var4, float var5, float var6) {
        super(var1, var2);
        this.numberOfCells = var3;
        this.lifeTime = var4;
        this.maxDamage = var4;
        this.energyMultiplier = var5;
        this.heatMultiplier = var6;
    }

    @Override
    void processChamber(ReactorCore var1, ReactorCell var2, int var3, int var4) {
        super.processChamber(var1, var2, var3, var4);
        if (var1.produceEnergy()) {
            for (int var5 = 0; var5 < this.numberOfCells; ++var5) {
                int var7;
                int var6 = 1 + this.numberOfCells / 2;
                for (var7 = 0; var7 < var6; ++var7) {
                    this.acceptUraniumPulse(var1, var2, var2, var3, var4, var3, var4);
                }
                var7 = (int)Math.ceil((float)(this.sumUp(var6 += this.checkPulseable(var1, var3 - 1, var4, var2, var3, var4) + this.checkPulseable(var1, var3 + 1, var4, var2, var3, var4) + this.checkPulseable(var1, var3, var4 - 1, var2, var3, var4) + this.checkPulseable(var1, var3, var4 + 1, var2, var3, var4)) * 4) * this.heatMultiplier);
                if (var1.simulator.firstTick) {
                    this.tickHeat += var7;
                    var1.data.heatPerTick += var7;
                }
                ArrayList var8 = new ArrayList();
                this.checkHeatAcceptor(var1, var3 - 1, var4, var8);
                this.checkHeatAcceptor(var1, var3 + 1, var4, var8);
                this.checkHeatAcceptor(var1, var3, var4 - 1, var8);
                this.checkHeatAcceptor(var1, var3, var4 + 1, var8);
                while (var8.size() > 0 && var7 > 0) {
                    int var9 = var7 / var8.size();
                    var7 -= var9;
                    var9 = ((ItemReactorUranium.ItemStackCoord)var8.get((int)0)).stack.getItem().alterHeat(var1, ((ItemReactorUranium.ItemStackCoord)var8.get((int)0)).stack, ((ItemReactorUranium.ItemStackCoord)var8.get((int)0)).x, ((ItemReactorUranium.ItemStackCoord)var8.get((int)0)).y, var9);
                    var7 += var9;
                    var8.remove(0);
                }
                if (var7 > 0) {
                    var1.addHeat(var7);
                    if (var1.simulator.firstTick) {
                        var1.data.incomingCoreHeat += var7;
                    }
                }
                if (var5 != 0) continue;
                if (var2.damage >= this.getMaxDamage() - 1) {
                    var1.setItemAt(var3, var4, null);
                    continue;
                }
                var2.changeDamage(1);
            }
        }
    }

    private int checkPulseable(ReactorCore var1, int var2, int var3, ReactorCell var4, int var5, int var6) {
        boolean pulsed;
        ReactorCell var7 = var1.getItemAt(var2, var3);
        boolean bl = pulsed = var7 != null && var7.getItem().acceptUraniumPulse(var1, var7, var4, var2, var3, var5, var6);
        if (var1.simulator.firstTick && pulsed && var7.getCellType() != 6) {
            ++this.pulses;
            if (var7.getCellID() == 4) {
                ++this.rechargePulses;
            }
        }
        return pulsed ? 1 : 0;
    }

    private int sumUp(int var1) {
        int var2 = 0;
        for (int var3 = 1; var3 <= var1; ++var3) {
            var2 += var3;
        }
        return var2;
    }

    private void checkHeatAcceptor(ReactorCore var1, int var2, int var3, ArrayList var4) {
        ReactorCell var5 = var1.getItemAt(var2, var3);
        if (var5 != null && var5.getItem().canStoreHeat(var1, var5, var2, var3)) {
            var4.add(new ItemReactorUranium.ItemStackCoord(this, this, var5, var2, var3));
        }
    }

    @Override
    boolean acceptUraniumPulse(ReactorCore var1, ReactorCell var2, ReactorCell var3, int var4, int var5, int var6, int var7) {
        var1.addOutput((int)Math.floor((float)var1.getPulsePower() * this.energyMultiplier));
        if (var1.simulator.firstTick) {
            if (this.lifeTime == 20000) {
                ++var1.data.plutoniumPulses;
            } else if (this.lifeTime == 50000) {
                ++var1.data.thoriumPulses;
            } else {
                ++var1.data.uraniumPulses;
            }
            ++this.pulses;
        }
        return true;
    }

    @Override
    boolean canStoreHeat(ReactorCore var1, ReactorCell var2, int var3, int var4) {
        return false;
    }

    @Override
    int getMaxDamage() {
        return this.lifeTime;
    }

    @Override
    int getMaxHeat(ReactorCore var1, ReactorCell var2, int var3, int var4) {
        return this.lifeTime;
    }

    @Override
    int getCurrentHeat(ReactorCore var1, ReactorCell var2, int var3, int var4) {
        return 0;
    }

    @Override
    int alterHeat(ReactorCore var1, ReactorCell var2, int var3, int var4, int var5) {
        return var5;
    }

    @Override
    float influenceExplosion(ReactorCore var1, ReactorCell var2) {
        return 2 * this.numberOfCells;
    }
}

