/*
 * Decompiled with CFR 0.152.
 */
package uk.co.talonius.ic2;

import java.util.ArrayList;
import uk.co.talonius.ic2.ItemReactorHeatStorage;
import uk.co.talonius.ic2.ItemReactorHeatSwitch;
import uk.co.talonius.ic2.ReactorCell;
import uk.co.talonius.ic2.ReactorCore;

class ItemReactorHeatSwitch
extends ItemReactorHeatStorage {
    int switchSide;
    int switchReactor;

    ItemReactorHeatSwitch(int var1, int var2, int var3, int var4, int var5) {
        super(var1, var2, var3);
        this.switchSide = var4;
        this.switchReactor = var5;
    }

    @Override
    void processChamber(ReactorCore var1, ReactorCell var2, int var3, int var4) {
        super.processChamber(var1, var2, var3, var4);
        int var5 = 0;
        ArrayList var6 = new ArrayList();
        double var7 = (double)this.getCurrentHeat(var1, var2, var3, var4) / (double)this.getMaxHeat(var1, var2, var3, var4);
        int var9 = 1;
        if (this.switchReactor > 0) {
            ++var9;
            var7 += (double)var1.getHeat() / (double)var1.getMaxHeat();
        }
        if (this.switchSide > 0) {
            var7 += this.checkHeatAcceptor(var1, var3 - 1, var4, var6);
            var7 += this.checkHeatAcceptor(var1, var3 + 1, var4, var6);
            var7 += this.checkHeatAcceptor(var1, var3, var4 - 1, var6);
            var7 += this.checkHeatAcceptor(var1, var3, var4 + 1, var6);
        }
        var7 /= (double)(var9 + var6.size());
        if (this.switchSide > 0) {
            for (ItemReactorHeatSwitch.ItemStackCoord var11 : var6) {
                ReactorCell var12 = var11.stack.getItem();
                int var13 = (int)(var7 * (double)var12.getMaxHeat(var1, var11.stack, var11.x, var11.y)) - var12.getCurrentHeat(var1, var11.stack, var11.x, var11.y);
                if (var13 > this.switchSide) {
                    var13 = this.switchSide;
                }
                if (var13 < -this.switchSide) {
                    var13 = -this.switchSide;
                }
                if (this.damage + (var5 - var13) < 0) {
                    var13 = this.damage + var5;
                }
                var5 -= var13;
                int heatToTransfer = var13;
                var13 = var12.alterHeat(var1, var11.stack, var11.x, var11.y, var13);
                if (!this.getFlag(1) && var13 != heatToTransfer) {
                    this.setFlag(1, true);
                }
                var5 += var13;
            }
        }
        if (this.switchReactor > 0) {
            int var14 = (int)(var7 * (double)var1.getMaxHeat()) - var1.getHeat();
            if (var14 > this.switchReactor) {
                var14 = this.switchReactor;
            }
            if (var14 < -this.switchReactor) {
                var14 = -this.switchReactor;
            }
            if (this.damage + (var5 - var14) < 0) {
                var14 = this.damage + var5;
            }
            var5 -= var14;
            var1.addHeat(var14);
            if (!this.getFlag(1) && var14 != 0) {
                this.setFlag(1, true);
            }
            if (var1.produceEnergy()) {
                if (var14 > this.highestIncomingCoreheat) {
                    this.highestIncomingCoreheat = var14;
                }
                if (-var14 > this.highestOutgoingCoreheat) {
                    this.highestOutgoingCoreheat = -var14;
                }
            }
        }
        this.alterHeat(var1, var2, var3, var4, var5);
    }

    private double checkHeatAcceptor(ReactorCore var1, int var2, int var3, ArrayList var4) {
        ReactorCell var6;
        ReactorCell var5 = var1.getItemAt(var2, var3);
        if (var5 != null && (var6 = var5.getItem()).canStoreHeat(var1, var5, var2, var3)) {
            var4.add(new ItemReactorHeatSwitch.ItemStackCoord(this, this, var5, var2, var3));
            double var7 = var6.getMaxHeat(var1, var5, var2, var3);
            if (var7 <= 0.0) {
                return 0.0;
            }
            double var9 = var6.getCurrentHeat(var1, var5, var2, var3);
            return var9 / var7;
        }
        return 0.0;
    }
}

