/*
 * Decompiled with CFR 0.152.
 */
package uk.co.talonius.ic2;

import java.awt.Color;
import uk.co.talonius.ic2.ItemReactorUranium;
import uk.co.talonius.ic2.ReactorApplet;
import uk.co.talonius.ic2.ReactorCell;
import uk.co.talonius.ic2.ReactorPlanner;

class ReactorData {
    int[] cellTotals = new int[64];
    int[] cellTypeTotals = new int[8];
    ReactorCell[][] cellGrid = new ReactorCell[9][6];
    long totalGeneratedEU = 0L;
    int maxHullHeat = 0;
    boolean heatStable = false;
    int internalEffectiveCooling = 0;
    float internalCooling = 0.0f;
    int condensatorGenerationCooling = 0;
    int condensatorCooldownCooling = 0;
    int heatpackHeating = 0;
    int uraniumPulses = 0;
    int plutoniumPulses = 0;
    int thoriumPulses = 0;
    int rechargePulses = 0;
    float totalReacharging = 0.0f;
    int firstChargedTicks = 0;
    int heatPerTick = 0;
    long totalEU = 0L;
    int totalBaseEU = 0;
    int totalStartingHeat = 0;
    int totalFinshedHeat = 0;
    int heatingStopCause = 0;
    int heatLoss = 0;
    int incomingCoreHeat = 0;
    int outgoingCoreHeat = 0;
    int coreGenerationHeatChange = 0;
    int generationStopCause = 0;
    int generationTicks = 0;
    int maxGenerationTicks = 0;
    float generationHeat;
    float generationHeatRate;
    float totalGenerationHeatRate;
    float estimatedCycles;
    float excessHeat = 0.0f;
    int cooldownStopCause = 0;
    int cooldownTicks = 0;

    ReactorData() {
    }

    void populateAppletData(boolean isScaled) {
        float overallCoreheatRate;
        ReactorApplet applet = ReactorPlanner.applet;
        this.excessHeat = this.heatPerTick + this.heatpackHeating - (this.internalEffectiveCooling + (this.generationTicks > 0 ? this.condensatorGenerationCooling / this.generationTicks : 0));
        applet.dataInternalCooling.setText(String.format("%d (%.0f)", this.internalEffectiveCooling, Float.valueOf(this.internalCooling)));
        applet.dataHeatGenerated.setText(String.format("%d", this.heatPerTick));
        applet.dataHeatpackHeating.setText(String.format("%d", this.heatpackHeating));
        if (this.generationTicks > 0) {
            applet.dataCondensatorCooling.setText(this.floatToString(this.condensatorGenerationCooling / this.generationTicks, 1, null));
        } else {
            applet.dataCondensatorCooling.setText("0");
        }
        if (this.excessHeat < 0.0f) {
            applet.labelExcessHeat.setText("Excess cooling:");
            applet.dataExcessHeat.setText(this.floatToString(this.excessHeat * -1.0f, 1, null));
        } else {
            applet.labelExcessHeat.setText("Excess heating:");
            applet.dataExcessHeat.setText(this.floatToString(this.excessHeat, 1, null));
        }
        if (this.generationStopCause == 4) {
            applet.dataGenerationTime.setText("Full Cycle");
            if (!isScaled) {
                if (this.heatStable || ReactorPlanner.data.estimatedCycles >= 100.0f) {
                    applet.dataMaxCycles.setText("Infinite");
                } else {
                    applet.dataMaxCycles.setText(this.floatToString(ReactorPlanner.data.estimatedCycles + 1.0f, 2, " cycle%s"));
                }
            }
        } else if (this.generationTicks == 0) {
            applet.dataGenerationTime.setText("None");
            applet.dataMaxCycles.setText("None");
            applet.dataTotalTime.setText("None");
        } else {
            applet.dataGenerationTime.setText(this.intToTime(this.generationTicks));
            if (!isScaled) {
                applet.dataMaxCycles.setText(this.floatToString((float)this.generationTicks / 100.0f, 2, "%% of a cycle"));
            }
        }
        if (this.generationTicks > 0) {
            if (this.generationHeat < 0.85f && (this.generationStopCause == 4 || this.generationStopCause == 8)) {
                applet.dataGenerationTime.setForeground(Color.black);
            } else {
                applet.dataGenerationTime.setForeground(Color.red);
            }
        } else {
            applet.dataGenerationTime.setForeground(Color.black);
        }
        applet.dataUnusedTime.setText("0%");
        if (ReactorPlanner.data.cooldownStopCause == 6) {
            if (this.heatStable) {
                applet.dataCooldownTime.setText("None");
                applet.dataCooldownTime.setForeground(Color.black);
                this.cooldownTicks = 0;
            } else {
                applet.dataCooldownTime.setForeground(Color.red);
                applet.dataCooldownTime.setText("Impossible");
                this.cooldownTicks = 100000000;
            }
        } else if (this.cooldownStopCause == 2) {
            applet.dataCooldownTime.setText("Component melted!");
            applet.dataCooldownTime.setForeground(Color.red);
            this.cooldownTicks = 100000000;
        } else if (ReactorPlanner.data.generationStopCause == 4 && this.heatStable || this.cooldownTicks == 0 || this.generationTicks > 1 && this.totalGenerationHeatRate <= 0.001f) {
            applet.dataCooldownTime.setText("None");
            applet.dataCooldownTime.setForeground(Color.black);
            this.cooldownTicks = 0;
        } else {
            applet.dataCooldownTime.setText(this.intToTime(this.cooldownTicks));
            applet.dataCooldownTime.setForeground(Color.black);
        }
        int totalTime = 0;
        if (this.generationStopCause == 4 || this.heatStable) {
            applet.dataTotalTime.setText(this.intToTime(ReactorPlanner.data.generationTicks, true));
            totalTime = ReactorPlanner.data.generationTicks;
            if (this.cooldownTicks > 0 && this.cooldownTicks != 100000000) {
                totalTime += this.cooldownTicks;
            }
        } else if ((this.cooldownTicks > 0 && this.cooldownTicks != 100000000 || this.generationStopCause == 8) && ReactorPlanner.data.cooldownStopCause != 6) {
            int totalGeneration;
            totalTime = this.generationTicks;
            for (totalGeneration = this.generationTicks; totalGeneration < 10000 && this.generationTicks > 0; totalGeneration += this.generationTicks) {
                if (this.cooldownTicks != 100000000) {
                    totalTime += this.cooldownTicks;
                }
                totalTime += this.generationTicks;
            }
            int unusedGeneration = 0;
            if (this.cooldownTicks > 0 && this.cooldownTicks != 100000000) {
                unusedGeneration = totalGeneration - 10000;
            }
            applet.dataUnusedTime.setText(this.floatToString((float)unusedGeneration / (float)this.generationTicks * 100.0f, 1, "%%"));
            if (this.cooldownTicks != 100000000) {
                totalTime = (int)((float)totalTime + (float)this.cooldownTicks * (1.0f - (float)unusedGeneration / (float)this.generationTicks));
            }
            applet.dataTotalTime.setText(this.intToTime(totalTime - unusedGeneration, true));
        } else {
            applet.dataTotalTime.setText("Never");
        }
        int cellCount = 0;
        int baseCellCount = 0;
        for (int x = 0; x < 9; ++x) {
            block19: for (int y = 0; y < 6; ++y) {
                ReactorCell cell = this.cellGrid[x][y];
                if (cell == null || cell.getCellType() != 6) continue;
                float cellUsage = (float)this.maxGenerationTicks / (float)cell.maxDamage;
                int cells = (int)Math.ceil(cellUsage) * ((ItemReactorUranium)cell).numberOfCells;
                cellCount += cells;
                baseCellCount += ((ItemReactorUranium)cell).numberOfCells;
                switch (cell.getCellID()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.totalBaseEU = (int)((float)this.totalBaseEU + cellUsage * 1000000.0f);
                        this.totalEU = (long)((float)this.totalEU + (float)(cell.pulses - cell.rechargePulses) * cellUsage * 1000000.0f);
                        continue block19;
                    }
                    case 32: 
                    case 33: 
                    case 34: {
                        this.totalBaseEU = (int)((float)this.totalBaseEU + cellUsage * 1000000.0f);
                        this.totalEU = (long)((float)this.totalEU + (float)(cell.pulses - cell.rechargePulses) * cellUsage * 1000000.0f);
                        continue block19;
                    }
                    case 35: 
                    case 36: 
                    case 37: {
                        this.totalBaseEU = (int)((float)this.totalBaseEU + cellUsage * 4000000.0f);
                        this.totalEU = (long)((float)this.totalEU + (float)(cell.pulses - cell.rechargePulses) * cellUsage * 4000000.0f);
                    }
                }
            }
        }
        applet.dataOutputEU.setText(String.format("%,d EU", this.totalGeneratedEU));
        applet.dataTotalEU.setText(String.format("%,d EU", ReactorPlanner.data.totalEU));
        float activeEUt = this.uraniumPulses * 5 + this.thoriumPulses + this.plutoniumPulses * 10;
        float effectiveEUt = 0.0f;
        applet.dataActiveEUt.setText(this.floatToString(activeEUt, 1, " EU/t"));
        if (totalTime > 0 && ReactorPlanner.data.cooldownStopCause != 6) {
            effectiveEUt = (float)ReactorPlanner.data.totalEU / (float)(totalTime * 20);
            applet.dataEffectiveEUt.setText(this.floatToString(effectiveEUt, 1, " EU/t"));
        } else {
            applet.dataEffectiveEUt.setText("0 EU/t");
        }
        int totalPulses = ReactorPlanner.data.uraniumPulses + ReactorPlanner.data.thoriumPulses + ReactorPlanner.data.plutoniumPulses;
        float euEfficiency = ReactorPlanner.data.totalBaseEU != 0 ? (float)totalPulses / (float)baseCellCount : 0.0f;
        float totalEfficiency = ReactorPlanner.data.totalBaseEU != 0 ? (float)(totalPulses + ReactorPlanner.data.rechargePulses) / (float)baseCellCount : 0.0f;
        applet.dataEffciency.setText(this.floatToString(euEfficiency, 2, null) + " of " + this.floatToString(totalEfficiency, 2, null));
        applet.dataHeatBurn.setText(String.format("%,.0f", Float.valueOf((float)this.maxHullHeat * 0.4f)));
        applet.dataHeatEvaporate.setText(String.format("%,.0f", Float.valueOf((float)this.maxHullHeat * 0.5f)));
        applet.dataHeatHurt.setText(String.format("%,.0f", Float.valueOf((float)this.maxHullHeat * 0.7f)));
        applet.dataHeatMelt.setText(String.format("%,.0f", Float.valueOf((float)this.maxHullHeat * 0.85f)));
        applet.dataHeatCurrent.setText(String.format("%,.0f", Float.valueOf(this.generationHeat * (float)this.maxHullHeat)));
        applet.progressReactorHeat.setMaximum(this.maxHullHeat);
        applet.progressReactorHeat.setValue((int)((float)this.maxHullHeat * this.generationHeat));
        Color barColour = this.generationHeat < 0.4f ? Color.getHSBColor(0.25f, 1.0f, 1.0f) : (this.generationHeat < 0.5f ? Color.getHSBColor(0.16f, 1.0f, 1.0f) : (this.generationHeat < 0.7f ? Color.getHSBColor(0.11f, 1.0f, 1.0f) : (this.generationHeat < 0.85f ? Color.getHSBColor(0.05f, 1.0f, 1.0f) : Color.getHSBColor(0.0f, 1.0f, 1.0f))));
        applet.progressReactorHeat.setForeground(barColour);
        if (!isScaled) {
            StringBuilder classification = new StringBuilder();
            if (this.generationTicks == 0) {
                classification.append("No Classification");
            } else {
                if (this.excessHeat <= 0.0f && this.heatStable && this.generationStopCause == 4) {
                    classification.append("Mark I");
                } else if (this.generationStopCause == 4) {
                    classification.append("Mark II-");
                    if (this.estimatedCycles >= 15.0f) {
                        classification.append('E');
                    } else {
                        classification.append((int)Math.floor(this.estimatedCycles + 1.0f));
                    }
                } else if ((float)this.generationTicks >= 1000.0f) {
                    classification.append("Mark III");
                } else {
                    float timeUntilCritical = (0.85f - this.generationHeat) * (float)this.maxHullHeat / this.excessHeat + (float)this.generationTicks;
                    if (timeUntilCritical >= 1000.0f) {
                        classification.append("Mark IV");
                    } else {
                        classification.append("Mark V");
                    }
                }
                if (this.condensatorGenerationCooling + this.condensatorCooldownCooling > 0) {
                    classification.append("-SUC");
                }
                if (this.rechargePulses > 0) {
                    classification.append(" Breeder");
                }
                if (this.uraniumPulses > 0 || this.thoriumPulses > 0 || this.plutoniumPulses > 0 || this.rechargePulses > 0) {
                    if (totalEfficiency == 7.0f) {
                        classification.append(" EA*");
                    } else if (totalEfficiency >= 6.0f) {
                        classification.append(" EA++");
                    } else if (totalEfficiency >= 5.0f) {
                        classification.append(" EA+");
                    } else if (totalEfficiency >= 4.0f) {
                        classification.append(" EA");
                    } else if (totalEfficiency >= 3.0f) {
                        classification.append(" EB");
                    } else if (totalEfficiency >= 2.0f) {
                        classification.append(" EC");
                    } else if (totalEfficiency > 1.0f) {
                        classification.append(" ED");
                    } else if (totalEfficiency == 1.0f) {
                        classification.append(" EE");
                    }
                }
            }
            applet.progressReactorHeat.setString(classification.toString());
        }
        applet.progressReactorHeat.setToolTipText(String.format("%,d of %,d heat (%.0f%%)", (int)Math.floor(this.generationHeat * (float)this.maxHullHeat), this.maxHullHeat, Float.valueOf(this.generationHeat * 100.0f)));
        applet.dataCellTotalBlank.setText(String.format("%d", this.cellTotals[0]));
        applet.dataCellTotalUranium.setText(String.format("%d", this.cellTypeTotals[6]));
        applet.dataCellTotalIsotope.setText(String.format("%d", this.cellTotals[4]));
        applet.dataCellTotalReflector.setText(String.format("%d", this.cellTypeTotals[5]));
        applet.dataCellTotalHeatPack.setText(String.format("%d", this.cellTotals[24]));
        applet.dataCellTotalPlating.setText(String.format("%d", this.cellTypeTotals[4]));
        applet.dataCellTotalExchanger.setText(String.format("%d", this.cellTypeTotals[3]));
        applet.dataCellTotalHeatStorage.setText(String.format("%d", this.cellTypeTotals[2]));
        applet.dataCellTotalVent.setText(String.format("%d", this.cellTypeTotals[7]));
        applet.dataCellTotalCondensator.setText(String.format("%d", this.cellTypeTotals[1]));
        int rshCooling = 0;
        int lzhCooling = 0;
        int replacedIsotopes = 0;
        int replacedReflectors = 0;
        float replacedReflectorsPartial = 0.0f;
        int replacedThickReflectors = 0;
        float replacedThickReflectorsPartial = 0.0f;
        int maxIncomingCoreheat = this.incomingCoreHeat;
        int maxOutgoingCoreheat = this.outgoingCoreHeat;
        for (int x = 0; x < 9; ++x) {
            block21: for (int y = 0; y < 6; ++y) {
                ReactorCell cell = this.cellGrid[x][y];
                if (cell == null) continue;
                this.incomingCoreHeat += cell.highestIncomingCoreheat;
                this.outgoingCoreHeat += cell.highestOutgoingCoreheat;
                switch (cell.getCellID()) {
                    case 12: {
                        rshCooling += cell.damage + cell.replacements * 20000;
                        continue block21;
                    }
                    case 13: {
                        lzhCooling += cell.damage + cell.replacements * 100000;
                        continue block21;
                    }
                    case 4: {
                        replacedIsotopes += cell.replacements;
                        continue block21;
                    }
                    case 5: {
                        replacedReflectors += cell.replacements;
                        replacedReflectorsPartial += (float)cell.damage / (float)cell.maxDamage;
                        continue block21;
                    }
                    case 6: {
                        replacedThickReflectors += cell.replacements;
                        replacedThickReflectorsPartial += (float)cell.damage / (float)cell.maxDamage;
                        continue block21;
                    }
                    case 14: {
                        maxIncomingCoreheat += 4;
                        maxOutgoingCoreheat += 4;
                        continue block21;
                    }
                    case 15: {
                        maxIncomingCoreheat += 72;
                        maxOutgoingCoreheat += 72;
                        continue block21;
                    }
                    case 17: {
                        maxIncomingCoreheat += 8;
                        maxOutgoingCoreheat += 8;
                        continue block21;
                    }
                    case 8: {
                        maxOutgoingCoreheat += 5;
                        continue block21;
                    }
                    case 9: {
                        maxOutgoingCoreheat += 36;
                    }
                }
            }
        }
        float ratio = 0.0f;
        if (this.generationTicks > 0 && this.cooldownTicks > 0) {
            ratio = (float)this.generationTicks / (float)(this.generationTicks + this.cooldownTicks);
        } else if (this.generationTicks > 0) {
            ratio = 1.0f;
        }
        applet.dataSUCGenerationRedstoneUsed.setText("None");
        applet.dataSUCGenerationRedstoneRate.setText("None");
        applet.dataSUCCooldownRedstoneUsed.setText("None");
        applet.dataSUCCooldownRedstoneRate.setText("None");
        applet.dataSUCRedstoneUsed.setText("None");
        applet.dataSUCRedstoneRate.setText("None");
        if (rshCooling > 0) {
            if (this.generationTicks > 0) {
                applet.dataSUCGenerationRedstoneUsed.setText(String.format("%,.0f", Float.valueOf((float)rshCooling * ratio / 10000.0f)));
                applet.dataSUCGenerationRedstoneRate.setText(String.format("%d secs", (int)Math.floor((float)this.generationTicks / ((float)rshCooling * ratio / 10000.0f))));
            }
            if (this.cooldownTicks > 0) {
                applet.dataSUCCooldownRedstoneUsed.setText(String.format("%,.0f", Float.valueOf((float)rshCooling * (1.0f - ratio) / 10000.0f)));
                applet.dataSUCCooldownRedstoneRate.setText(String.format("%d secs", (int)Math.floor((float)this.cooldownTicks / ((float)rshCooling * (1.0f - ratio) / 10000.0f))));
            }
            if (this.generationTicks > 0 || this.cooldownTicks > 0) {
                applet.dataSUCRedstoneUsed.setText(String.format("%,.0f", Float.valueOf((float)rshCooling / 10000.0f)));
                applet.dataSUCRedstoneRate.setText(String.format("%d secs", (int)Math.floor((float)(this.generationTicks + this.cooldownTicks) / ((float)rshCooling / 10000.0f))));
            }
        }
        applet.dataSUCGenerationLapisUsed.setText("None");
        applet.dataSUCGenerationLapisRate.setText("None");
        applet.dataSUCCooldownLapisUsed.setText("None");
        applet.dataSUCCooldownLapisRate.setText("None");
        applet.dataSUCLapisUsed.setText("None");
        applet.dataSUCLapisRate.setText("None");
        if (lzhCooling > 0) {
            if (this.generationTicks > 0) {
                applet.dataSUCGenerationLapisUsed.setText(String.format("%,.0f", Float.valueOf((float)lzhCooling * ratio / 40000.0f)));
                applet.dataSUCGenerationLapisRate.setText(String.format("%d secs", (int)Math.floor((float)this.generationTicks / ((float)lzhCooling * ratio / 40000.0f))));
            }
            if (this.cooldownTicks > 0) {
                applet.dataSUCCooldownLapisUsed.setText(String.format("%,.0f", Float.valueOf((float)lzhCooling * (1.0f - ratio) / 40000.0f)));
                applet.dataSUCCooldownLapisRate.setText(String.format("%d secs", (int)Math.floor((float)this.cooldownTicks / ((float)lzhCooling * (1.0f - ratio) / 40000.0f))));
            }
            if (this.generationTicks > 0 || this.cooldownTicks > 0) {
                applet.dataSUCLapisUsed.setText(String.format("%,.0f", Float.valueOf((float)lzhCooling / 40000.0f)));
                applet.dataSUCLapisRate.setText(String.format("%d secs", (int)Math.floor((float)(this.generationTicks + this.cooldownTicks) / ((float)lzhCooling / 40000.0f))));
            }
        }
        applet.dataReplacedIsotopes.setText(String.format("%d", replacedIsotopes));
        applet.dataReplacedReflectors.setText(String.format("%d", replacedReflectors));
        applet.dataReplacedThickReflectors.setText(String.format("%d", replacedThickReflectors));
        applet.dataCoreheatIncoming.setText(String.format("%,d", this.incomingCoreHeat));
        applet.dataCoreheatMaxIncoming.setText(String.format("%,d", maxIncomingCoreheat));
        applet.dataCoreheatOutgoing.setText(String.format("%,d", this.outgoingCoreHeat));
        applet.dataCoreheatMaxOutgoing.setText(String.format("%,d", maxOutgoingCoreheat));
        float f = overallCoreheatRate = this.generationTicks > 0 ? (float)this.coreGenerationHeatChange / (float)this.generationTicks : 0.0f;
        if (overallCoreheatRate > 0.0f) {
            applet.dataLabelCoreheatOverall.setText("Overall incoming:");
            applet.dataCoreheatOverall.setText(String.format("%,.0f", Float.valueOf(overallCoreheatRate)));
        } else if (overallCoreheatRate < 0.0f) {
            applet.dataLabelCoreheatOverall.setText("Overall outgoing:");
            applet.dataCoreheatOverall.setText(String.format("%,.0f", Float.valueOf(-overallCoreheatRate)));
        } else {
            applet.dataLabelCoreheatOverall.setText("Overall incoming:");
            applet.dataCoreheatOverall.setText("None");
        }
        if (this.cellTotals[4] > 0) {
            applet.dataCellsCharged.setText(this.floatToString(this.totalReacharging / 10000.0f, 1, " cell%s"));
            if (this.firstChargedTicks > 0) {
                applet.dataFirstCellCharge.setText(this.intToTime(this.firstChargedTicks));
            } else {
                applet.dataFirstCellCharge.setText("Never");
            }
            float rechargeingperTick = this.totalReacharging / (float)this.generationTicks;
            applet.dataChargingEfficientcy.setText(this.floatToString(rechargeingperTick, 1, null));
            applet.dataReachargingPerCell.setText(this.floatToString(rechargeingperTick / (float)this.cellTotals[4], 1, null));
            applet.dataRechargingPerUranium.setText(this.floatToString(rechargeingperTick / (float)cellCount, 1, null));
        } else {
            applet.dataCellsCharged.setText("None");
            applet.dataFirstCellCharge.setText("Never");
            applet.dataChargingEfficientcy.setText("N/A");
            applet.dataReachargingPerCell.setText("N/A");
            applet.dataRechargingPerUranium.setText("N/A");
            applet.dataRechargeEfficiency.setText("0");
        }
        applet.dataRechargeEfficiency.setText(this.floatToString(totalEfficiency - euEfficiency, 2, null) + " of " + this.floatToString(totalEfficiency, 2, null));
        float uraniumUsage = (float)this.maxGenerationTicks / 10000.0f;
        float plutoniumUsage = (float)this.maxGenerationTicks / 20000.0f;
        float resourceIron = 36.0f;
        float resourceTin = 4.0f;
        float resourceCopper = 99.5f;
        float resourceBronze = 0.0f;
        int resourceRubber = 7;
        int resourceRedstone = 8;
        int resourceGlowstone = 2;
        int resourceLapis = 2;
        int resourceCoal = 0;
        int resourceUranium = 0;
        int resourceGold = 0;
        int resourceDiamond = 0;
        int resourceGlass = 0;
        int resourceIridium = 0;
        resourceIron += 8.0f * (float)ReactorPlanner.simulator.intChamberCount;
        resourceIron += 5.5f * (float)this.cellTotals[7];
        resourceIron += 5.5f * (float)this.cellTotals[8];
        resourceIron += 5.5f * (float)this.cellTotals[9];
        resourceIron += 13.25f * (float)this.cellTotals[10];
        resourceIron += 7.0f * (float)this.cellTotals[11];
        resourceIron += 1.0f * (float)this.cellTotals[14];
        resourceIron += 1.0f * (float)this.cellTotals[15];
        resourceIron += 1.0f * (float)this.cellTotals[16];
        resourceIron += 4.0f * (float)this.cellTotals[17];
        resourceIron += 6.0f * (float)this.cellTotals[38];
        resourceIron += 6.5f * (float)this.cellTotals[12];
        resourceIron += 19.5f * (float)this.cellTotals[13];
        resourceIron += 1.5f * (float)this.cellTotals[18];
        resourceIron += 1.5f * (float)this.cellTotals[19];
        resourceIron += 4.5f * (float)this.cellTotals[20];
        resourceIron += 1.0f * (float)this.cellTotals[24];
        resourceTin += 0.5f * (float)this.cellTotals[1] * uraniumUsage;
        resourceTin += 1.0f * (float)this.cellTotals[2] * uraniumUsage;
        resourceTin += 2.0f * (float)this.cellTotals[3] * uraniumUsage;
        resourceTin += 0.5f * (float)this.cellTotals[32];
        resourceTin += 1.0f * (float)this.cellTotals[33];
        resourceTin += 2.0f * (float)this.cellTotals[34];
        resourceTin += 0.5f * (float)this.cellTotals[35] * plutoniumUsage;
        resourceTin += 1.0f * (float)this.cellTotals[36] * plutoniumUsage;
        resourceTin += 2.0f * (float)this.cellTotals[37] * plutoniumUsage;
        resourceTin += 4.0f * (float)this.cellTotals[5];
        resourceTin += 16.0f * (float)this.cellTotals[6];
        resourceTin += 137.0f * (float)this.cellTotals[38];
        resourceTin += 4.0f * (float)this.cellTotals[11];
        resourceTin += 3.0f * (float)this.cellTotals[14];
        resourceTin += 3.0f * (float)this.cellTotals[15];
        resourceTin += 3.0f * (float)this.cellTotals[16];
        resourceTin += 6.0f * (float)this.cellTotals[17];
        resourceTin += 3.0f * (float)this.cellTotals[12];
        resourceTin += 9.0f * (float)this.cellTotals[13];
        resourceTin += 1.5f * (float)this.cellTotals[18];
        resourceTin += 1.5f * (float)this.cellTotals[19];
        resourceTin += 4.5f * (float)this.cellTotals[20];
        resourceTin += 4.5f * (float)this.cellTotals[21];
        resourceTin += 19.5f * (float)this.cellTotals[22];
        resourceTin += 45.0f * (float)this.cellTotals[23];
        resourceTin += 4.5f * (float)this.cellTotals[39];
        resourceTin += 19.5f * (float)this.cellTotals[40];
        resourceTin += 45.0f * (float)this.cellTotals[41];
        resourceTin += 6.5f * (float)this.cellTotals[42];
        resourceTin += 25.5f * (float)this.cellTotals[43];
        resourceTin += 57.0f * (float)this.cellTotals[44];
        resourceTin += 0.5f * (float)this.cellTotals[24];
        resourceCopper += 32.0f * (float)ReactorPlanner.simulator.intChamberCount;
        resourceCopper += 8.0f * (float)this.cellTotals[2] * uraniumUsage;
        resourceCopper += 40.0f * (float)this.cellTotals[3] * uraniumUsage;
        resourceCopper += 8.0f * (float)this.cellTotals[33];
        resourceCopper += 40.0f * (float)this.cellTotals[34];
        resourceCopper += 8.0f * (float)this.cellTotals[36] * plutoniumUsage;
        resourceCopper += 40.0f * (float)this.cellTotals[37] * plutoniumUsage;
        resourceCopper += 8.0f * (float)this.cellTotals[5];
        resourceCopper += 40.0f * (float)this.cellTotals[6];
        resourceCopper += 292.0f * (float)this.cellTotals[38];
        resourceCopper += 16.0f * (float)this.cellTotals[8];
        resourceCopper += 16.0f * (float)this.cellTotals[9];
        resourceCopper += 11.0f * (float)this.cellTotals[14];
        resourceCopper += 27.0f * (float)this.cellTotals[15];
        resourceCopper += 11.0f * (float)this.cellTotals[16];
        resourceCopper += 30.0f * (float)this.cellTotals[17];
        resourceCopper += 11.0f * (float)this.cellTotals[12];
        resourceCopper += 65.0f * (float)this.cellTotals[13];
        resourceCopper += 8.0f * (float)this.cellTotals[18];
        resourceCopper += 24.0f * (float)this.cellTotals[19];
        resourceCopper += 8.0f * (float)this.cellTotals[20];
        resourceCopper += 8.0f * (float)this.cellTotals[23];
        resourceCopper += 8.0f * (float)this.cellTotals[41];
        resourceCopper += 8.0f * (float)this.cellTotals[44];
        resourceCopper += 11.0f * (float)this.cellTotals[24];
        resourceBronze += 1.5f * (float)this.cellTotals[18];
        resourceBronze += 1.5f * (float)this.cellTotals[19];
        resourceBronze += 4.5f * (float)this.cellTotals[20];
        resourceRubber += 6 * this.cellTotals[14];
        resourceRubber += 6 * this.cellTotals[15];
        resourceRubber += 6 * this.cellTotals[16];
        resourceRubber += 24 * this.cellTotals[17];
        resourceRubber += 6 * this.cellTotals[12];
        resourceRubber += 18 * this.cellTotals[13];
        resourceRubber += 6 * this.cellTotals[24];
        resourceRedstone += 2 * this.cellTotals[14];
        resourceRedstone += 2 * this.cellTotals[15];
        resourceRedstone += 2 * this.cellTotals[16];
        resourceRedstone += 10 * this.cellTotals[17];
        resourceRedstone += 9 * this.cellTotals[12];
        resourceRedstone += 24 * this.cellTotals[13];
        resourceRedstone += 2 * this.cellTotals[24];
        resourceLapis += 9 * this.cellTotals[13];
        resourceUranium += cellCount - (this.cellTotals[32] + this.cellTotals[33] * 2 + this.cellTotals[34] * 4);
        resourceCoal += this.cellTotals[4];
        resourceCoal += 4 * this.cellTotals[5];
        resourceCoal += 16 * this.cellTotals[6];
        resourceCoal += 128 * this.cellTotals[38];
        resourceCoal += 64 * this.cellTotals[32];
        resourceCoal += 128 * this.cellTotals[33];
        resourceCoal += 256 * this.cellTotals[34];
        resourceGold += 2 * this.cellTotals[9];
        resourceGold += 4 * this.cellTotals[16];
        resourceDiamond += 1 * this.cellTotals[10];
        resourceDiamond += 1 * this.cellTotals[17];
        resourceDiamond += 1 * this.cellTotals[38];
        resourceGlass += 6 * this.cellTotals[17];
        resourceIridium += 4 * this.cellTotals[38];
        applet.dataResourceCopper.setText(this.floatToString((float)Math.ceil(resourceCopper), 0, null));
        applet.dataResourceTin.setText(this.floatToString((float)Math.ceil(resourceTin), 0, null));
        applet.dataResourceBronze.setText(this.floatToString((float)Math.ceil(resourceBronze), 0, null));
        applet.dataResourceIron.setText(this.floatToString((float)Math.ceil(resourceIron), 0, null));
        applet.dataResourceGold.setText(this.floatToString((float)Math.ceil(resourceGold), 0, null));
        applet.dataResourceGlass.setText(String.format("%d", resourceGlass));
        applet.dataResourceRubber.setText(String.format("%d", resourceRubber));
        applet.dataResourceCoal.setText(String.format("%d", resourceCoal));
        applet.dataResourceRedstone.setText(String.format("%d", resourceRedstone));
        applet.dataResourceGlowstone.setText(String.format("%d", resourceGlowstone));
        applet.dataResourceLapis.setText(String.format("%d", resourceLapis));
        applet.dataResourceDiamond.setText(String.format("%d", resourceDiamond));
        applet.dataResourceUranium.setText(String.format("%d", resourceUranium));
        applet.dataResourceIridium.setText(String.format("%d", resourceIridium));
        float buildUUM = 1.25f * resourceIron + 0.3f * resourceTin + 0.3f * resourceCopper + 0.6f * resourceBronze + 0.06349207f * (float)resourceRubber + 0.16666667f * (float)resourceRedstone + 0.44444445f * (float)resourceLapis + 0.15f * (float)resourceCoal + 1.25f * (float)resourceGold + 9.0f * (float)resourceDiamond + 0.1875f * (float)resourceGlowstone + 0.125f * (float)resourceGlass + (float)(6 * resourceIridium) + (float)(8 * this.cellTotals[35]) * plutoniumUsage + (float)(16 * this.cellTotals[36]) * plutoniumUsage + (float)(32 * this.cellTotals[37]) * plutoniumUsage;
        applet.dataBuildCostUUM.setText(String.format("%,.2f UU Matter", Float.valueOf(buildUUM)));
        float buildEMC = 256.0f * resourceIron + 256.0f * resourceTin + 85.0f * resourceCopper + 256.0f * resourceBronze + (float)(8 * resourceRubber) + (float)(64 * resourceRedstone) + (float)(864 * resourceLapis) + (float)(128 * resourceCoal) + (float)(2048 * resourceGold) + (float)(8192 * resourceDiamond) + (float)(384 * resourceGlowstone) + (float)(1 * resourceGlass);
        applet.dataBuildCostEMC.setText(String.format("%,.0f EMC", Float.valueOf(buildEMC)));
        float lifetime = (float)this.maxGenerationTicks / (float)this.generationTicks;
        float runningCost = 0.0f + (float)(435920 * this.cellTotals[2]) * uraniumUsage + (float)(2179600 * this.cellTotals[3]) * uraniumUsage + (float)(435920 * this.cellTotals[33]) + (float)(2179600 * this.cellTotals[34]) + (float)(1429328 * this.cellTotals[35]) * plutoniumUsage + (float)(3383243 * this.cellTotals[36]) * plutoniumUsage + (float)(8432912 * this.cellTotals[37]) * plutoniumUsage + 762320.0f * (((float)replacedReflectors + replacedReflectorsPartial) * lifetime) + 3485200.0f * (((float)replacedThickReflectors + replacedThickReflectorsPartial) * lifetime) + 29777.78f * ((float)rshCooling / 10000.0f * lifetime) + 79407.41f * ((float)lzhCooling / 40000.0f * lifetime);
        float runningUUM = 0.0f + 2.4f * (float)this.cellTotals[2] * uraniumUsage + (float)(12 * this.cellTotals[3]) * uraniumUsage + 2.4f * (float)this.cellTotals[33] + (float)(12 * this.cellTotals[34]) + 8.0f * (float)this.cellTotals[35] * plutoniumUsage + 18.4f * (float)this.cellTotals[36] * plutoniumUsage + (float)(44 * this.cellTotals[37]) * plutoniumUsage + 4.2f * (((float)replacedReflectors + replacedReflectorsPartial) * lifetime) + 19.2f * (((float)replacedThickReflectors + replacedThickReflectorsPartial) * lifetime) + 0.16666667f * ((float)rshCooling / 10000.0f * lifetime) + 0.44444445f * ((float)lzhCooling / 40000.0f * lifetime);
        applet.dataRunningCostUUM.setText(String.format("%,.2f UU Matter", Float.valueOf(runningUUM)));
        float runningEMC = 0.0f + (float)(680 * this.cellTotals[2]) * uraniumUsage + (float)(3400 * this.cellTotals[3]) * uraniumUsage + (float)(680 * this.cellTotals[33]) + (float)(3400 * this.cellTotals[34]) + (float)(680 * this.cellTotals[36]) * plutoniumUsage + (float)(3400 * this.cellTotals[37]) * plutoniumUsage + 2216.0f * ((float)replacedReflectors + replacedReflectorsPartial) + 9544.0f * ((float)replacedThickReflectors + replacedThickReflectorsPartial) + 64.0f * ((float)rshCooling / 10000.0f) + 864.0f * ((float)lzhCooling / 40000.0f);
        applet.dataRunningCostEMC.setText(String.format("%,.0f EMC", Float.valueOf(runningEMC)));
        float profitRatio = 1.0f - runningCost / (float)ReactorPlanner.data.totalEU;
        applet.dataOverallProfit.setText(this.floatToString(effectiveEUt * profitRatio, 1, " EU/t") + String.format(" (%.0f%%)", Float.valueOf(profitRatio * 100.0f)));
        applet.dataOverallEfficiency.setText(this.floatToString(euEfficiency * profitRatio, 2, null));
    }

    private String floatToString(float value, int places, String suffix) {
        if ((double)value - Math.floor(value) >= (double)0.01f) {
            StringBuilder formatString = new StringBuilder();
            formatString.append('%');
            formatString.append('.');
            formatString.append(places);
            formatString.append('f');
            if (suffix != null) {
                formatString.append(suffix);
            }
            return String.format(formatString.toString(), Float.valueOf(value), value == 1.0f ? "" : "s");
        }
        value = (float)Math.floor(value);
        if (suffix != null) {
            return String.format("%d" + suffix, (int)value, value == 1.0f ? "" : "s");
        }
        return String.format("%d", (int)value, value == 1.0f ? "" : "s");
    }

    String intToTime(int value) {
        return this.intToTime(value, false);
    }

    private String intToTime(int value, boolean showHours) {
        String hours = null;
        if (showHours && value >= 3600) {
            int hrs = (value - value % 3600) / 3600;
            hours = String.format("%d hour%s", hrs, hrs > 1 ? "s" : "");
            value %= 3600;
        }
        String minutes = null;
        if (value >= 60) {
            int mins = (value - value % 60) / 60;
            minutes = String.format("%d min%s", mins, mins > 1 ? "s" : "");
            value %= 60;
        }
        String seconds = null;
        if (value > 0) {
            seconds = String.format("%d secs", value, value > 1 ? "s" : "");
        }
        StringBuilder timeString = new StringBuilder();
        if (showHours) {
            if (hours != null) {
                timeString.append(hours);
            }
            if (hours != null && (minutes != null || seconds != null)) {
                timeString.append(' ');
            }
        }
        if (minutes != null) {
            timeString.append(minutes);
        }
        if (minutes != null && seconds != null) {
            timeString.append(' ');
        }
        if (seconds != null) {
            timeString.append(seconds);
        }
        return timeString.toString();
    }

    void scaledTimings(int scale) {
        float coolingDiff;
        ReactorData fullData = ReactorPlanner.data;
        float percent = (float)scale / (float)fullData.generationTicks;
        ReactorApplet applet = ReactorPlanner.applet;
        float ratio = -1.0f;
        if ((float)fullData.cooldownTicks != 1.0E8f) {
            ratio = (float)fullData.cooldownTicks / (float)fullData.generationTicks;
        } else if ((float)this.cooldownTicks != 1.0E8f) {
            ratio = (float)this.cooldownTicks / (float)this.generationTicks;
        }
        int moddedCoolTime = Math.round((float)scale * ratio);
        if (moddedCoolTime == 0 && fullData.cooldownTicks != 0) {
            moddedCoolTime = 1;
        }
        if (fullData.cooldownTicks > 0 && fullData.generationTicks > 0 && moddedCoolTime > 0 && ((coolingDiff = (float)fullData.generationTicks / (float)fullData.cooldownTicks / ((float)scale / (float)moddedCoolTime)) < 0.95f || moddedCoolTime < 1)) {
            moddedCoolTime = (int)Math.ceil((float)scale * ratio);
        }
        if (this.generationTicks == this.maxGenerationTicks && scale == this.maxGenerationTicks) {
            applet.dataGenerationTime.setText("Full Cycle");
            applet.dataOutputEU.setText(String.format("%,d EU", this.totalGeneratedEU));
        } else if (this.generationTicks > 0) {
            applet.dataGenerationTime.setText(this.intToTime(scale));
            applet.dataOutputEU.setText(String.format("%,d EU", (int)Math.floor((float)scale / (float)this.generationTicks * (float)this.totalGeneratedEU)));
        } else {
            applet.dataGenerationTime.setText("None");
            applet.dataOutputEU.setText(String.format("%,d EU", (int)Math.floor((float)scale / (float)this.generationTicks * (float)this.totalGeneratedEU)));
        }
        applet.progressReactorHeat.setValue((int)((float)this.maxHullHeat * fullData.generationHeat * percent));
        applet.progressReactorHeat.setToolTipText(String.format("%,d of %,d heat (%.0f%%)", (int)Math.floor(fullData.generationHeat * (float)this.maxHullHeat * percent), this.maxHullHeat, Float.valueOf(this.generationHeat * percent * 100.0f)));
        Color barColour = fullData.generationHeat * percent < 0.4f ? Color.getHSBColor(0.25f, 1.0f, 1.0f) : (fullData.generationHeat * percent < 0.5f ? Color.getHSBColor(0.16f, 1.0f, 1.0f) : (fullData.generationHeat * percent < 0.7f ? Color.getHSBColor(0.11f, 1.0f, 1.0f) : (fullData.generationHeat * percent < 0.85f ? Color.getHSBColor(0.05f, 1.0f, 1.0f) : Color.getHSBColor(0.0f, 1.0f, 1.0f))));
        applet.progressReactorHeat.setForeground(barColour);
        if (scale > 0 && ratio != -1.0f && this.cooldownTicks != 0 && (fullData.generationTicks <= 1 || !(this.totalGenerationHeatRate <= 0.001f)) && this.excessHeat > 0.0f && ReactorPlanner.data.cooldownStopCause != 6) {
            int totalGeneration;
            int totalTime = scale;
            for (totalGeneration = scale; totalGeneration < ReactorPlanner.data.maxGenerationTicks && scale > 0; totalGeneration += scale) {
                totalTime += moddedCoolTime;
                totalTime += scale;
            }
            int unusedGeneration = totalGeneration - ReactorPlanner.data.maxGenerationTicks;
            applet.dataTotalTime.setText(this.intToTime(totalTime - unusedGeneration, true));
            float effectiveEUt = (float)ReactorPlanner.data.totalEU / (float)((totalTime += moddedCoolTime) * 20);
            applet.dataEffectiveEUt.setText(this.floatToString(effectiveEUt, 1, " EU/t"));
            applet.dataUnusedTime.setText(this.floatToString((float)unusedGeneration / (float)scale * 100.0f, 1, "%%"));
        }
    }
}

