/*
 * Decompiled with CFR 0.152.
 */
package uk.co.talonius.ic2;

import uk.co.talonius.ic2.ItemReactorHeatSwitch;
import uk.co.talonius.ic2.ItemReactorVent;
import uk.co.talonius.ic2.ReactorCell;
import uk.co.talonius.ic2.ReactorCore;

class ItemReactorHeatStorage
extends ReactorCell {
    int heatStorage;

    ItemReactorHeatStorage(int var1, int var2, int var3) {
        super(var1, var2);
        this.heatStorage = var3;
        this.maxDamage = var3;
    }

    @Override
    void processChamber(ReactorCore var1, ReactorCell var2, int var3, int var4) {
        if (this instanceof ItemReactorHeatSwitch || this instanceof ItemReactorVent) {
            super.processChamber(var1, var2, var3, var4);
        }
    }

    @Override
    boolean acceptUraniumPulse(ReactorCore var1, ReactorCell var2, ReactorCell var3, int var4, int var5, int var6, int var7) {
        return false;
    }

    @Override
    boolean canStoreHeat(ReactorCore var1, ReactorCell var2, int var3, int var4) {
        return true;
    }

    @Override
    int getMaxHeat(ReactorCore var1, ReactorCell var2, int var3, int var4) {
        return this.heatStorage;
    }

    @Override
    int getCurrentHeat(ReactorCore var1, ReactorCell var2, int var3, int var4) {
        return this.getHeatOfStack(var2);
    }

    @Override
    int alterHeat(ReactorCore var1, ReactorCell var2, int var3, int var4, int var5) {
        super.alterHeat(var1, var2, var3, var4, var5);
        int var6 = this.getHeatOfStack(var2);
        int excess = 0;
        if ((var6 += var5) > this.heatStorage) {
            var1.setItemAt(var3, var4, null);
            excess = this.heatStorage - var6 + 1;
            this.changeDamage(var5 - excess);
        } else if (var6 < 0) {
            this.changeDamage(var5 - var6);
            excess = var6;
            var6 = 0;
        } else {
            this.changeDamage(var5);
        }
        return excess;
    }

    @Override
    float influenceExplosion(ReactorCore var1, ReactorCell var2) {
        return 0.0f;
    }

    private void setHeatForStack(ReactorCell var1, int var2) {
        var1.damage = var2;
    }

    private int getHeatOfStack(ReactorCell var1) {
        return var1.damage;
    }
}

