/*
 * Decompiled with CFR 0.152.
 */
package uk.co.talonius.ic2;

import uk.co.talonius.ic2.DataTracker;
import uk.co.talonius.ic2.ReactorCell;
import uk.co.talonius.ic2.ReactorCore;
import uk.co.talonius.ic2.ReactorData;
import uk.co.talonius.ic2.ReactorPlanner;

class ReactorSimulator {
    static final int CAUSE_HULLHEAT = 1;
    static final int CAUSE_CELLDEATH = 2;
    static final int CAUSE_BOOM = 3;
    static final int CAUSE_FULLCYCLE = 4;
    static final int CAUSE_COOLED = 5;
    static final int CAUSE_CANTCOOL = 6;
    static final int CAUSE_HOTENOUGH = 7;
    static final int CAUSE_MAXTIME = 8;
    int intChamberCount = 6;
    int[][] reactorGrid = new int[9][6];
    int[][] reactorStackSize = new int[9][6];
    private ReactorCore mainCore;
    int intStartingTemp = 0;
    int heatedStart = 0;
    private boolean isScaled = false;
    private boolean simulating;
    int tickCount;
    private ReactorData data;
    boolean firstTick;
    DataTracker heatTracker;
    private boolean heatingPhase;
    boolean generationPhase;
    private boolean cooldownPhase;

    ReactorSimulator() {
    }

    void evaluateReactor() {
        this.evaluateReactor(0);
    }

    void evaluateReactor(int scale) {
        this.isScaled = scale > 0;
        this.data = this.isScaled ? (ReactorPlanner.dataScaled = new ReactorData()) : (ReactorPlanner.data = new ReactorData());
        this.countCells();
        this.resetValues();
        this.data.maxHullHeat = 10000 + 1000 * this.data.cellTotals[18] + 500 * this.data.cellTotals[20] + 2000 * this.data.cellTotals[19];
        if ((float)this.data.maxHullHeat * 0.85f < (float)this.intStartingTemp) {
            this.intStartingTemp = (int)(Math.floor((float)this.data.maxHullHeat * 0.0085f) * 100.0) - 100;
        }
        if (this.data.cellTotals[0] < (this.intChamberCount + 3) * 6) {
            int y;
            int x;
            this.tickCount = 0;
            this.tickCount = 0;
            this.firstTick = true;
            this.generationPhase = true;
            this.simulating = true;
            int highHeat = 0;
            int highHeatTicks = 0;
            while (this.simulating && this.tickCount < (this.isScaled ? scale : this.data.maxGenerationTicks)) {
                this.updateEntity();
                this.sendEnergy(this.mainCore.output);
                int currentHeat = this.mainCore.getHeat();
                for (x = 0; x < 9; ++x) {
                    for (y = 0; y < 6; ++y) {
                        if (this.data.cellGrid[x][y] == null) continue;
                        this.data.cellGrid[x][y].commitTrackers();
                        if (!this.data.cellGrid[x][y].canStoreHeat(this.mainCore, this.data.cellGrid[x][y], x, y) || this.data.cellGrid[x][y].getCellType() == 1) continue;
                        currentHeat += this.data.cellGrid[x][y].getDamage();
                    }
                }
                this.heatTracker.commitChange();
                if (currentHeat > highHeat) {
                    highHeat = currentHeat;
                    highHeatTicks = 0;
                } else {
                    ++highHeatTicks;
                }
                if (this.firstTick) {
                    this.firstTick = false;
                }
                ++this.tickCount;
            }
            if (this.data.generationStopCause == 0) {
                this.data.generationStopCause = this.isScaled ? 8 : 4;
            }
            this.data.heatStable = highHeatTicks >= 30;
            this.mainCore.output = 0;
            this.data.generationTicks = this.tickCount;
            this.generationPhase = false;
            float lowestLifeLeft = 1000000.0f;
            for (x = 0; x < 9; ++x) {
                block10: for (y = 0; y < 6; ++y) {
                    ReactorCell temp = this.mainCore.getItemAt(x, y);
                    if (temp == null) continue;
                    this.data.internalEffectiveCooling += temp.highestCooling;
                    if (!temp.canStoreHeat(this.mainCore, temp, x, y)) continue;
                    temp.generationDamage = (float)temp.getDamage() / (float)temp.getMaxDamage();
                    temp.generationDamageRate = temp.getAverageHealthChange();
                    temp.estimatedLifeLeft = (float)(temp.getMaxDamage() - temp.getDamage()) / temp.generationDamageRate;
                    this.data.totalGenerationHeatRate += temp.generationDamageRate;
                    if (temp.generationDamageRate > 0.0f && temp.estimatedLifeLeft < lowestLifeLeft) {
                        lowestLifeLeft = temp.estimatedLifeLeft;
                    }
                    if (temp.getCellType() != 7) continue;
                    switch (temp.getCellID()) {
                        case 7: {
                            this.data.internalCooling += 6.0f;
                            continue block10;
                        }
                        case 8: {
                            this.data.internalCooling += 5.0f;
                            continue block10;
                        }
                        case 9: {
                            this.data.internalCooling += 20.0f;
                            continue block10;
                        }
                        case 10: {
                            this.data.internalCooling += 12.0f;
                        }
                    }
                }
            }
            this.data.generationHeat = (float)this.mainCore.getHeat() / (float)this.data.maxHullHeat;
            this.data.generationHeatRate = this.heatTracker.getAverageChange();
            this.data.totalGenerationHeatRate += this.data.generationHeatRate;
            this.data.estimatedCycles = this.data.generationHeatRate > 0.0f ? Math.min(lowestLifeLeft, (float)(this.data.maxHullHeat - this.mainCore.getHeat()) / this.data.generationHeatRate) / 10000.0f : 100.0f;
            this.cooldownPhase = true;
            this.simulating = true;
            this.tickCount = 0;
            int strikeCount = 0;
            float highestPercent = 0.0f;
            this.mainCore.cellDeath = false;
            int previousTotalHeat = 1000000;
            while (this.simulating && this.tickCount < 15000) {
                int totalHeat = 0;
                int totalHullConnectedHeat = 0;
                highestPercent = (float)this.mainCore.currentHeat / (float)this.mainCore.maxHeat;
                boolean cooledEnough = this.mainCore.getHeat() <= this.heatedStart;
                for (int x2 = 0; x2 < 9; ++x2) {
                    for (int y2 = 0; y2 < 6; ++y2) {
                        ReactorCell cell = this.mainCore.getItemAt(x2, y2);
                        if (cell == null) continue;
                        cell.commitTrackers();
                        if (!cell.canStoreHeat(this.mainCore, cell, x2, y2) || cell.getCellType() == 1) continue;
                        totalHeat += cell.getDamage();
                        float percent = (float)cell.getDamage() / (float)cell.getMaxDamage();
                        if (percent > highestPercent) {
                            highestPercent = percent;
                        }
                        if (cell.getFlag(5)) {
                            totalHullConnectedHeat += cell.getDamage();
                            cooledEnough = cooledEnough && cell.getDamage() <= cell.heatedStart;
                            continue;
                        }
                        cooledEnough = cooledEnough && cell.getDamage() <= 0;
                    }
                }
                this.heatTracker.commitChange();
                highestPercent -= (float)this.intStartingTemp / (float)this.mainCore.maxHeat;
                if ((totalHeat += this.mainCore.getHeat()) == 0 || this.intStartingTemp > 0 && cooledEnough) {
                    this.data.totalFinshedHeat = totalHullConnectedHeat;
                    this.stopSimulation(5);
                } else if (totalHeat >= previousTotalHeat) {
                    if (strikeCount++ > 5) {
                        this.data.totalFinshedHeat = totalHullConnectedHeat;
                        if (highestPercent < 0.025f) {
                            this.stopSimulation(5);
                        } else {
                            if (!this.data.heatStable && this.data.estimatedCycles >= 100.0f) {
                                this.data.estimatedCycles = 1.0f / highestPercent;
                            }
                            this.stopSimulation(6);
                        }
                    }
                } else {
                    previousTotalHeat = totalHeat;
                    strikeCount = 0;
                }
                if (!this.simulating) continue;
                this.updateEntity();
                ++this.tickCount;
            }
            this.data.cooldownTicks = this.tickCount;
        }
        this.cooldownPhase = false;
        this.data.populateAppletData(this.isScaled);
    }

    private void resetValues() {
        this.mainCore = new ReactorCore(this, this.data);
        this.mainCore.size = this.intChamberCount + 3;
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 6; ++y) {
                ReactorCell newCell = ReactorCell.createCell(this.reactorGrid[x][y]);
                if (newCell != null) {
                    newCell.stackSize = this.reactorStackSize[x][y];
                }
                this.data.cellGrid[x][y] = newCell;
                this.mainCore.cellGrid[x][y] = newCell;
            }
        }
        this.heatTracker = new DataTracker();
        this.generationPhase = false;
        this.cooldownPhase = false;
        this.mainCore.output = 0;
        this.mainCore.currentHeat = this.intStartingTemp;
    }

    private void resetTrackers() {
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 6; ++y) {
                ReactorCell cell = this.mainCore.getItemAt(x, y);
                if (cell == null) continue;
                cell.resetTrackers();
            }
        }
        this.heatTracker.reset();
    }

    private void countCells() {
        this.data.maxGenerationTicks = 10000;
        for (int x = 0; x < 9; ++x) {
            block5: for (int y = 0; y < 6; ++y) {
                if (x >= this.intChamberCount + 3) continue;
                int n = this.reactorGrid[x][y];
                this.data.cellTotals[n] = this.data.cellTotals[n] + 1;
                int n2 = ReactorCell.getTypeForID(this.reactorGrid[x][y]);
                this.data.cellTypeTotals[n2] = this.data.cellTypeTotals[n2] + 1;
                switch (this.reactorGrid[x][y]) {
                    case 32: 
                    case 33: 
                    case 34: {
                        if (this.data.maxGenerationTicks >= 50000) continue block5;
                        this.data.maxGenerationTicks = 50000;
                        continue block5;
                    }
                    case 35: 
                    case 36: 
                    case 37: {
                        if (this.data.maxGenerationTicks >= 20000) continue block5;
                        this.data.maxGenerationTicks = 20000;
                    }
                }
            }
        }
    }

    private boolean hasIHDNeighbour(int x, int y) {
        if (x < this.intChamberCount + 2 && ReactorCell.getTypeForID(this.reactorGrid[x + 1][y]) == 3) {
            return true;
        }
        if (x > 0 && ReactorCell.getTypeForID(this.reactorGrid[x - 1][y]) == 3) {
            return true;
        }
        if (y < 5 && ReactorCell.getTypeForID(this.reactorGrid[x][y + 1]) == 3) {
            return true;
        }
        return y > 0 && ReactorCell.getTypeForID(this.reactorGrid[x][y - 1]) == 3;
    }

    private int sendEnergy(int i) {
        this.data.totalGeneratedEU += (long)(i * 20);
        return i;
    }

    void stopSimulation(int cause) {
        if (!(cause != 4 && cause != 8 || this.simulating)) {
            return;
        }
        if (this.heatingPhase) {
            this.data.heatingStopCause = cause;
        }
        if (this.generationPhase) {
            this.data.generationStopCause = cause;
        }
        if (this.cooldownPhase) {
            this.data.cooldownStopCause = cause;
        }
        this.simulating = false;
    }

    private void updateEntity() {
        this.mainCore.output = 0;
        this.mainCore.maxHeat = 10000;
        this.mainCore.hem = 1.0f;
        if (!this.mainCore.processComponents()) {
            // empty if block
        }
        this.calculateHeatEffects(this.mainCore);
    }

    private boolean calculateHeatEffects(ReactorCore reactor) {
        if (reactor.getHeat() < 4000) {
            return false;
        }
        int i = reactor.maxHeat;
        float f = (float)reactor.getHeat() / (float)i;
        if (f >= 1.0f && this.generationPhase) {
            this.stopSimulation(3);
            return true;
        }
        if (f >= 0.85f && this.generationPhase) {
            this.stopSimulation(1);
        }
        return false;
    }
}

