/*
 * Decompiled with CFR 0.152.
 */
package uk.co.talonius.ic2;

import java.math.BigInteger;

class URLEncoder {
    private BigInteger dataStack = null;

    URLEncoder() {
        this.dataStack = new BigInteger("0");
    }

    URLEncoder(String dataCode) {
        if (dataCode != null) {
            try {
                this.dataStack = new BigInteger(dataCode, 36);
            }
            catch (Exception e) {
                this.dataStack = new BigInteger("0");
            }
        } else {
            this.dataStack = new BigInteger("0");
        }
    }

    boolean readBoolean() {
        return this.readBigInteger(1).intValue() != 0;
    }

    int readInt(int bits) {
        return this.readBigInteger(bits).intValue();
    }

    BigInteger readBigInteger(int bits) {
        StringBuilder bitString = new StringBuilder();
        for (int i = 0; i < bits; ++i) {
            bitString.append('1');
        }
        BigInteger data = this.dataStack.and(new BigInteger(bitString.toString(), 2));
        this.dataStack = this.dataStack.shiftRight(bits);
        return data;
    }

    void writeBigInteger(BigInteger data, int bits) {
        this.dataStack = this.dataStack.shiftLeft(bits);
        this.dataStack = this.dataStack.add(data);
    }

    void writeInteger(int data, int bits) {
        this.dataStack = this.dataStack.shiftLeft(bits);
        this.dataStack = this.dataStack.add(BigInteger.valueOf(data));
    }

    void writeBoolean(boolean data) {
        this.dataStack = this.dataStack.shiftLeft(1);
        this.dataStack = this.dataStack.add(BigInteger.valueOf(data ? 1L : 0L));
    }

    String getDataCode() {
        return this.dataStack.toString(36);
    }
}

