/*
 * Decompiled with CFR 0.152.
 */
package chocohead.AdvMachines.te;

import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.RecipeOutput;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.ITeBlock;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Redstone;
import ic2.core.block.comp.TileEntityComponent;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotProcessable;
import ic2.core.block.invslot.InvSlotProcessableGeneric;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.gui.dynamic.DynamicContainer;
import ic2.core.gui.dynamic.DynamicGui;
import ic2.core.gui.dynamic.GuiParser;
import ic2.core.gui.dynamic.IGuiValueProvider;
import ic2.core.network.GuiSynced;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityHeatingMachine
extends TileEntityElectricMachine
implements IHasGui,
IGuiValueProvider,
IUpgradableBlock {
    protected static final byte DEFAULT_TIER = 2;
    protected static final byte DEFAULT_IDLE_EU = 1;
    protected static final byte DEFAULT_ACTIVE_EU = 15;
    public final InvSlotProcessable inputSlot;
    public final InvSlotOutput outputSlot;
    public final InvSlotUpgrade upgradeSlot;
    protected final Redstone redstone;
    protected final int maxHeat;
    protected final int idleEU;
    protected final int activeEU;
    @GuiSynced
    public short heat = 0;
    @GuiSynced
    public short progress = 0;

    public TileEntityHeatingMachine(int maxHeat, byte numberOfOutputs, IMachineRecipeManager recipeSet) {
        this(maxHeat, 2, numberOfOutputs, recipeSet);
    }

    public TileEntityHeatingMachine(int maxHeat, byte tier, byte numberOfOutputs, IMachineRecipeManager recipeSet) {
        this(maxHeat, tier, numberOfOutputs, recipeSet, 1, 15);
    }

    public TileEntityHeatingMachine(int maxHeat, byte numberOfOutputs, IMachineRecipeManager recipeSet, int idleEU, int activeEU) {
        this(maxHeat, 2, numberOfOutputs, recipeSet, idleEU, activeEU);
    }

    public TileEntityHeatingMachine(int maxHeat, byte tier, byte numberOfOutputs, IMachineRecipeManager recipeSet, int idleEU, int activeEU) {
        super(maxHeat, (int)tier);
        assert (numberOfOutputs > 0) : "Must have at least one output slot";
        this.maxHeat = maxHeat;
        this.idleEU = idleEU;
        this.activeEU = activeEU;
        this.inputSlot = new InvSlotProcessableGeneric((TileEntityInventory)this, "input", 1, recipeSet);
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", (int)numberOfOutputs);
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 2);
        this.redstone = (Redstone)this.addComponent((TileEntityComponent)new Redstone((TileEntityBlock)this));
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.heat = nbt.func_74765_d("heat");
        this.progress = nbt.func_74765_d("progress");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74777_a("heat", this.heat);
        nbt.func_74777_a("progress", this.progress);
        return nbt;
    }

    protected void updateEntityServer() {
        boolean canOperate;
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        boolean newActive = this.getActive();
        if (this.heat == 0) {
            newActive = false;
        }
        if (this.progress >= 4000) {
            this.operate();
            needsInvUpdate = true;
            this.progress = 0;
            newActive = false;
        }
        if (((canOperate = this.canOperate()) || this.redstone.hasRedstoneInput()) && this.canIdle()) {
            if (this.heat < this.maxHeat) {
                this.heat = (short)Math.min(this.heat + this.getSpeedFactor(), this.maxHeat);
            }
            newActive = true;
        } else {
            this.heat = (short)(this.heat - Math.min(this.heat, 4 * this.getSpeedFactor()));
        }
        if (!newActive || this.progress == 0) {
            if (canOperate) {
                if (this.energy.getEnergy() >= (double)this.activeEU) {
                    newActive = true;
                }
            } else {
                this.progress = 0;
            }
        } else if (!canOperate || this.energy.getEnergy() < (double)this.activeEU) {
            if (!canOperate) {
                this.progress = 0;
            }
            newActive = false;
        }
        if (newActive && canOperate) {
            this.progress = (short)(this.progress + this.heat * this.getSpeedFactor() / 25);
            this.energy.useEnergy((double)this.activeEU);
        }
        for (ItemStack stack : this.upgradeSlot) {
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem)) continue;
            needsInvUpdate |= ((IUpgradeItem)stack.func_77973_b()).onTick(stack, (IUpgradableBlock)this);
        }
        this.setActive(newActive);
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    protected int getSpeedFactor() {
        return 1;
    }

    public boolean canIdle() {
        return this.energy.useEnergy((double)this.idleEU);
    }

    public boolean canOperate() {
        if (this.inputSlot.isEmpty()) {
            return false;
        }
        RecipeOutput output = this.inputSlot.process();
        return output != null && this.outputSlot.canAdd(output.items);
    }

    public void operate() {
        if (!this.canOperate()) {
            return;
        }
        this.outputSlot.add(this.inputSlot.process().items);
        this.inputSlot.consume();
    }

    protected int getComparatorInputOverride() {
        return this.heat * 15 / this.maxHeat;
    }

    public short getHeat() {
        return this.heat;
    }

    public double getGuiValue(String name) {
        if ("progress".equals(name)) {
            return (double)(1000 * this.progress / 4000) / 1000.0;
        }
        throw new IllegalArgumentException("Unknown GUI value: " + name);
    }

    public ContainerBase<? extends TileEntityHeatingMachine> getGuiContainer(EntityPlayer player) {
        return DynamicContainer.create((IInventory)this, (EntityPlayer)player, (GuiParser.GuiNode)GuiParser.parse((ITeBlock)this.teBlock));
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return DynamicGui.create((IInventory)this, (EntityPlayer)player, (GuiParser.GuiNode)GuiParser.parse((ITeBlock)this.teBlock));
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public double getEnergy() {
        return this.energy.getEnergy();
    }

    public boolean useEnergy(double amount) {
        return this.energy.useEnergy(amount);
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.RedstoneSensitive, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing);
    }
}

