/*
 * Decompiled with CFR 0.152.
 */
package ihl.datanet;

import ihl.datanet.Contact;
import ihl.interfaces.IDataNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DataGrid {
    public final Set<IDataNode> telist = new HashSet<IDataNode>();
    public double energy = 0.0;
    private IDataNode sink;
    private IDataNode source;
    private double voltage;
    private short frequency = 0;
    private double lastVoltage;
    public boolean isGridValid = true;
    private double total20TicksEU;
    private int lastTickCounter = 0;

    public Set<IDataNode> getListOfExcludedNodes() {
        HashSet<IDataNode> excludedNodes = new HashSet<IDataNode>();
        if (this.telist.isEmpty()) {
            return excludedNodes;
        }
        excludedNodes.addAll(this.telist);
        IDataNode startNode = this.telist.iterator().next();
        this.recursiveGridNodesSearch(excludedNodes, startNode);
        this.telist.removeAll(excludedNodes);
        return excludedNodes;
    }

    public void recursiveGridNodesSearch(Set<IDataNode> excludedNodes, IDataNode startNode) {
        Iterator<IDataNode> nodei = startNode.getConnectedDataNodes().iterator();
        excludedNodes.remove(startNode);
        while (nodei.hasNext()) {
            IDataNode node = nodei.next();
            if (!excludedNodes.contains(node)) continue;
            this.recursiveGridNodesSearch(excludedNodes, node);
        }
    }

    public boolean isConnectedToContact(Contact emitter, int id) {
        for (IDataNode ate1 : this.telist) {
            if (ate1.getInnerId() == id) {
                return true;
            }
            if (emitter == ate1 || !ate1.isIndirectlyConnectedWithContact(id)) continue;
            return true;
        }
        return false;
    }
}

