/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.IC2;
import ihl.IHLMod;
import ihl.flexible_cable.FlexibleCableHolderBaseTileEntity;
import ihl.flexible_cable.NodeEntity;
import ihl.utils.IHLUtils;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class FrequencyGeneratorTileEntity
extends FlexibleCableHolderBaseTileEntity
implements INetworkClientTileEntityEventListener,
IEnergySink {
    public double energy;
    public int maxStorage = 4096;
    private boolean addedToEnergyNet = false;

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void setFacing(short facing1) {
        short facing2 = (short)Math.max(facing1, 2);
        double d = 0.3;
        double f = -0.1;
        double range = 2.0;
        AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)(this.connectionX - range), (double)(this.connectionY - range), (double)(this.connectionZ - range), (double)(this.connectionX + range), (double)(this.connectionY + range), (double)(this.connectionZ + range));
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
        super.setFacing(facing2);
        switch (this.getFacing()) {
            case 4: {
                this.setConnectionX((double)this.field_145851_c + 0.5);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + 1.0 - f);
                break;
            }
            case 5: {
                this.setConnectionX((double)this.field_145851_c + 0.5);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + f);
                break;
            }
            case 2: {
                this.setConnectionX((double)this.field_145851_c + 1.0 - f);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + 0.5);
                break;
            }
            case 3: {
                this.setConnectionX((double)this.field_145851_c + f);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + 0.5);
                break;
            }
            default: {
                this.setConnectionX((double)this.field_145851_c + 1.0 - f);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + 0.5);
            }
        }
        if (!nodeList.isEmpty()) {
            for (NodeEntity ne : nodeList) {
                if (!this.cableListContains(ne.getChainUniqueID())) continue;
                ne.func_70107_b(this.connectionX, this.connectionY, this.connectionZ);
            }
        }
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public ItemStack getWrenchDrop(EntityPlayer player) {
        return IHLUtils.getThisModItemStack("frequencyGenerator");
    }

    public double getDemandedEnergy() {
        if (this.gridID == -1) {
            return (double)this.maxStorage - this.energy;
        }
        return this.getGrid().getDemandedEnergy();
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy < (double)this.maxStorage) {
            this.energy += amount;
            return 0.0;
        }
        if (this.gridID != -1 && this.getGrid().energy <= 0.0) {
            this.getGrid().injectEnergy(amount, 400.0, this);
            return 0.0;
        }
        return amount;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("energy", this.energy);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy = nbt.func_74769_h("energy");
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            default: 
        }
    }

    public void updateEntityServer() {
        if (this.gridID != -1 && this.getGrid().energy > 0.0 && this.energy < (double)this.maxStorage) {
            this.energy += this.getGrid().energy;
            this.getGrid().drawEnergy(this.getGrid().energy, this);
        }
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public double requestEnergy(ForgeDirection direction, int maxValue) {
        if (ForgeDirection.getOrientation((int)this.getFacing()).equals((Object)direction)) {
            double energyLoss = Math.min((double)maxValue * (1.0 + IHLMod.config.additionalPowerLossesAtFrequencyGenerator), this.energy);
            double energyToReturn = Math.min((double)maxValue, this.energy / (1.0 + IHLMod.config.additionalPowerLossesAtFrequencyGenerator));
            this.energy -= energyLoss;
            return energyToReturn;
        }
        return 0.0;
    }

    @Override
    public double getMaxAllowableVoltage() {
        return 64000.0;
    }

    public String func_145825_b() {
        return null;
    }

    @Override
    public void remove(NBTTagCompound cable) {
        this.cableList.remove(cable);
    }
}

