/*
 * Decompiled with CFR 0.152.
 */
package ihl.items_blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.item.tool.ItemToolCutter;
import ic2.core.item.tool.ItemToolWrench;
import ihl.IHLCreativeTab;
import ihl.IHLMod;
import ihl.collector.GlassBoxTileEntity;
import ihl.datanet.RedstoneSignalConverterTileEntity;
import ihl.flexible_cable.BatterySwitchUnitTileEntity;
import ihl.flexible_cable.FrequencyGeneratorTileEntity;
import ihl.flexible_cable.RectifierTransformerUnitTileEntity;
import ihl.interfaces.IEnergyNetNode;
import ihl.items_blocks.IHLItemBlock;
import ihl.processing.chemistry.ChemicalReactorTileEntity;
import ihl.processing.chemistry.CryogenicDistillerTileEntity;
import ihl.processing.chemistry.ElectrolysisBathTileEntity;
import ihl.processing.chemistry.FluidizedBedReactorTileEntity;
import ihl.processing.chemistry.FractionatorBottomTileEntity;
import ihl.processing.chemistry.FractionatorCoverTileEntity;
import ihl.processing.chemistry.FractionatorSectionTileEntity;
import ihl.processing.chemistry.GaedesMercuryRotaryPumpTileEntity;
import ihl.processing.chemistry.GoldChimneyKneeTileEntity;
import ihl.processing.chemistry.LabElectrolyzerTileEntity;
import ihl.processing.chemistry.LeadOvenTileEntity;
import ihl.processing.chemistry.LoomTileEntity;
import ihl.processing.chemistry.PaperMachineTileEntity;
import ihl.processing.chemistry.PrecipitatorCondenserTileEntity;
import ihl.processing.chemistry.RefluxCondenserTileEntity;
import ihl.processing.metallurgy.AchesonFurnanceTileEntity;
import ihl.processing.metallurgy.CoilerTileEntity;
import ihl.processing.metallurgy.DetonationSprayingMachineTileEntity;
import ihl.processing.metallurgy.ExtruderTileEntity;
import ihl.processing.metallurgy.GasWeldingStationTileEntity;
import ihl.processing.metallurgy.ImpregnatingMachineTileEntity;
import ihl.processing.metallurgy.LathePart1TileEntity;
import ihl.processing.metallurgy.LathePart2TileEntity;
import ihl.processing.metallurgy.MuffleFurnanceTileEntity;
import ihl.processing.metallurgy.RollingMachinePart1TileEntity;
import ihl.processing.metallurgy.RollingMachinePart2TileEntity;
import ihl.processing.metallurgy.VacuumInductionMeltingFurnaceTileEntity;
import ihl.processing.metallurgy.VulcanizationExtrudingMoldTileEntity;
import ihl.processing.metallurgy.WireMillTileEntity;
import ihl.processing.metallurgy.WoodenRollingMachinePart1TileEntity;
import ihl.processing.metallurgy.WoodenRollingMachinePart2TileEntity;
import ihl.tunneling_shield.HydrotransportPulpRegeneratorTileEntity;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineBaseBlock
extends Block
implements ITileEntityProvider {
    MachineType type;
    private static List<MachineBaseBlock> instances = new ArrayList<MachineBaseBlock>();
    @SideOnly(value=Side.CLIENT)
    IIcon textureSide;
    @SideOnly(value=Side.CLIENT)
    IIcon textureBack;
    @SideOnly(value=Side.CLIENT)
    IIcon textureFrontMuffleFurnance;
    @SideOnly(value=Side.CLIENT)
    IIcon textureTop;
    @SideOnly(value=Side.CLIENT)
    IIcon textureTopAchesonFurnance;
    @SideOnly(value=Side.CLIENT)
    IIcon textureTopGoldFurnace;
    @SideOnly(value=Side.CLIENT)
    IIcon textureFrontGoldFurnace;
    @SideOnly(value=Side.CLIENT)
    IIcon textureSideGoldFurnace;
    @SideOnly(value=Side.CLIENT)
    IIcon textureFrontCryogenicDistiller;
    @SideOnly(value=Side.CLIENT)
    IIcon textureTopCryogenicDistiller;
    @SideOnly(value=Side.CLIENT)
    IIcon textureBackCryogenicDistiller;
    @SideOnly(value=Side.CLIENT)
    IIcon textureFrontChemicalReactor;
    @SideOnly(value=Side.CLIENT)
    IIcon textureLeftMachineCasing;
    @SideOnly(value=Side.CLIENT)
    IIcon textureTopMachineCasing;
    @SideOnly(value=Side.CLIENT)
    IIcon textureRightMachineCasing;
    @SideOnly(value=Side.CLIENT)
    IIcon textureFrontMachineCasing;
    @SideOnly(value=Side.CLIENT)
    IIcon textureFrontPaperMachine;
    @SideOnly(value=Side.CLIENT)
    IIcon textureBackMachineCasing;
    @SideOnly(value=Side.CLIENT)
    IIcon frequencyGeneratorBack;
    @SideOnly(value=Side.CLIENT)
    IIcon frequencyGeneratorBottom;
    @SideOnly(value=Side.CLIENT)
    IIcon frequencyGeneratorFront;
    @SideOnly(value=Side.CLIENT)
    IIcon frequencyGeneratorLeft;
    @SideOnly(value=Side.CLIENT)
    IIcon frequencyGeneratorRight;
    @SideOnly(value=Side.CLIENT)
    IIcon frequencyGeneratorTop;
    @SideOnly(value=Side.CLIENT)
    IIcon bronzeTubTop;
    @SideOnly(value=Side.CLIENT)
    IIcon bronzeTubSide;
    @SideOnly(value=Side.CLIENT)
    IIcon glassBoxTop;
    @SideOnly(value=Side.CLIENT)
    IIcon glassBoxSide;
    @SideOnly(value=Side.CLIENT)
    IIcon glassBoxBottom;
    @SideOnly(value=Side.CLIENT)
    IIcon glassBoxInnerSide;
    @SideOnly(value=Side.CLIENT)
    IIcon glassBoxInnerBottom;
    @SideOnly(value=Side.CLIENT)
    IIcon vacuumInductionMeltingFurnaceFront;
    @SideOnly(value=Side.CLIENT)
    IIcon vacuumInductionMeltingFurnaceBack;
    @SideOnly(value=Side.CLIENT)
    IIcon vacuumInductionMeltingFurnaceLeft;
    @SideOnly(value=Side.CLIENT)
    IIcon vacuumInductionMeltingFurnaceRight;
    @SideOnly(value=Side.CLIENT)
    IIcon hydrotransportPulpRegeneratorFront;
    @SideOnly(value=Side.CLIENT)
    IIcon hydrotransportPulpRegeneratorBack;
    @SideOnly(value=Side.CLIENT)
    IIcon redstoneSignalConverterEmitterSide;
    @SideOnly(value=Side.CLIENT)
    IIcon redstoneSignalConverterEmptySide;
    @SideOnly(value=Side.CLIENT)
    IIcon redstoneSignalConverterSensorSide;
    @SideOnly(value=Side.CLIENT)
    IIcon steel;
    @SideOnly(value=Side.CLIENT)
    IIcon redPaint;
    @SideOnly(value=Side.CLIENT)
    IIcon greenPaint;
    @SideOnly(value=Side.CLIENT)
    IIcon rubberInsulatedCase;
    @SideOnly(value=Side.CLIENT)
    IIcon powerPort;

    public MachineBaseBlock(MachineType type1) {
        super(Material.field_151573_f);
        this.type = type1;
        this.func_149647_a(IHLCreativeTab.tab);
        this.func_149663_c(this.type.unlocalizedName);
        this.func_149711_c(2.0f);
        this.func_149752_b(1.0f);
        instances.add(this);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (IC2.platform.isSimulating()) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (world.func_147439_a(x, y + 1, z) == Blocks.field_150480_ab && te instanceof DetonationSprayingMachineTileEntity) {
                ((DetonationSprayingMachineTileEntity)te).operate();
                world.func_147468_f(x, y + 1, z);
            }
            if (te instanceof RedstoneSignalConverterTileEntity) {
                RedstoneSignalConverterTileEntity rscte = (RedstoneSignalConverterTileEntity)te;
                rscte.linksOrInventoryChanged = true;
            }
        }
    }

    public void func_149725_f(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te != null && te instanceof IEnergyNetNode) {
                IEnergyNetNode ate = (IEnergyNetNode)te;
                ate.removeAttachedChains();
            }
            if (te != null && te instanceof IInventory) {
                IInventory inventory = (IInventory)te;
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    if (inventory.func_70301_a(i) == null) continue;
                    world.func_72838_d((Entity)new EntityItem(world, (double)x, (double)(y + 1), (double)z, inventory.func_70301_a(i)));
                }
            }
            if (te != null && te instanceof RedstoneSignalConverterTileEntity) {
                RedstoneSignalConverterTileEntity rsce = (RedstoneSignalConverterTileEntity)te;
                rsce.removeAttachedChains();
            }
        }
        super.func_149725_f(world, x, y, z, meta);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        switch (this.type) {
            case BronzeTub: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.1f, 1.0f);
                super.func_149743_a(world, x, y, z, aabb, list, entity);
                this.func_149676_a(0.0f, 0.0f, 0.0f, 0.1f, 1.0f, 1.0f);
                super.func_149743_a(world, x, y, z, aabb, list, entity);
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.1f);
                super.func_149743_a(world, x, y, z, aabb, list, entity);
                this.func_149676_a(0.9f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                super.func_149743_a(world, x, y, z, aabb, list, entity);
                this.func_149676_a(0.0f, 0.0f, 0.9f, 1.0f, 1.0f, 1.0f);
                super.func_149743_a(world, x, y, z, aabb, list, entity);
                this.func_149683_g();
                break;
            }
            case GlassBox: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.1f, 1.0f);
                super.func_149743_a(world, x, y, z, aabb, list, entity);
                this.func_149676_a(0.0f, 0.0f, 0.0f, 0.1f, 1.0f, 1.0f);
                super.func_149743_a(world, x, y, z, aabb, list, entity);
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.1f);
                super.func_149743_a(world, x, y, z, aabb, list, entity);
                this.func_149676_a(0.9f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                super.func_149743_a(world, x, y, z, aabb, list, entity);
                this.func_149676_a(0.0f, 0.0f, 0.9f, 1.0f, 1.0f, 1.0f);
                super.func_149743_a(world, x, y, z, aabb, list, entity);
                this.func_149683_g();
                break;
            }
            case RedstoneSignalConverter: {
                this.func_149676_a(0.2f, 0.2f, 0.2f, 0.8f, 0.8f, 0.8f);
                super.func_149743_a(world, x, y, z, aabb, list, entity);
                break;
            }
            default: {
                super.func_149743_a(world, x, y, z, aabb, list, entity);
            }
        }
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        int facing = 3;
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te != null && te instanceof IWrenchable) {
            IWrenchable tebh = (IWrenchable)te;
            facing = tebh.getFacing();
        }
        block0 : switch (this.type) {
            case VacuumInductionMeltingFurnace: {
                switch (facing) {
                    case 0: {
                        this.func_149676_a(-1.0f, -2.0f, 0.0f, 2.0f, 1.0f, 3.0f);
                        break block0;
                    }
                    case 1: {
                        this.func_149676_a(-1.0f, 0.0f, 0.0f, 2.0f, 3.0f, 3.0f);
                        break block0;
                    }
                    case 2: {
                        this.func_149676_a(-1.0f, 0.0f, -2.0f, 2.0f, 3.0f, 1.0f);
                        break block0;
                    }
                    case 3: {
                        this.func_149676_a(-1.0f, 0.0f, 0.0f, 2.0f, 3.0f, 3.0f);
                        break block0;
                    }
                    case 4: {
                        this.func_149676_a(-2.0f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f);
                        break block0;
                    }
                    case 5: {
                        this.func_149676_a(0.0f, 0.0f, -1.0f, 3.0f, 3.0f, 2.0f);
                        break block0;
                    }
                }
                break;
            }
            default: {
                super.func_149719_a(blockAccess, x, y, z);
            }
        }
    }

    public static void init() {
        MachineType[] var1 = MachineType.values();
        for (int i = 0; i < var1.length; ++i) {
            if (var1[i].unlocalizedName.equalsIgnoreCase(IHLMod.config.preventMachineBlockRegistrationName)) continue;
            GameRegistry.registerBlock((Block)new MachineBaseBlock(var1[i]), IHLItemBlock.class, (String)var1[i].unlocalizedName);
            GameRegistry.registerTileEntity((Class)var1[i].teclass, (String)var1[i].unlocalizedName);
        }
        IHLUtils.getThisModBlock("tubBronze").func_149658_d("tubBronzeIcon");
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float chance, int flag) {
        if (this.type.itemDroppedOnBlockDestroy != null) {
            this.func_149642_a(world, x, y, z, this.type.itemDroppedOnBlockDestroy.func_77946_l());
        } else {
            super.func_149690_a(world, x, y, z, meta, chance, flag);
        }
    }

    public TileEntity func_149915_a(World world, int var2) {
        TileEntity newTE = null;
        try {
            newTE = (TileEntity)this.type.teclass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return newTE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("ihl:brickOvenSide");
        this.textureBack = par1IconRegister.func_94245_a("ihl:brickOvenBack");
        this.textureSide = par1IconRegister.func_94245_a("ihl:brickOvenSide");
        this.textureTop = par1IconRegister.func_94245_a("ihl:brickOvenTop");
        this.textureFrontMuffleFurnance = par1IconRegister.func_94245_a("ihl:muffleOvenFront");
        this.textureTopAchesonFurnance = par1IconRegister.func_94245_a("ihl:achesonOvenTop");
        this.textureTopGoldFurnace = par1IconRegister.func_94245_a("ihl:porcelainFurnaceTop");
        this.textureFrontGoldFurnace = par1IconRegister.func_94245_a("ihl:porcelainFurnaceFront");
        this.textureSideGoldFurnace = par1IconRegister.func_94245_a("ihl:porcelainFurnaceSide");
        this.textureLeftMachineCasing = par1IconRegister.func_94245_a("ihl:fiberglassSpinneretsLeft");
        this.textureTopMachineCasing = par1IconRegister.func_94245_a("ihl:fiberglassSpinneretsTop");
        this.textureRightMachineCasing = par1IconRegister.func_94245_a("ihl:fiberglassSpinneretsRight");
        this.textureFrontMachineCasing = par1IconRegister.func_94245_a("ihl:fiberglassSpinneretsFront");
        this.textureBackMachineCasing = par1IconRegister.func_94245_a("ihl:fiberglassSpinneretsBack");
        this.textureFrontCryogenicDistiller = par1IconRegister.func_94245_a("ihl:cryogenicDistillerOxygenSide");
        this.textureTopCryogenicDistiller = par1IconRegister.func_94245_a("ihl:cryogenicDistillerNitrogenSide");
        this.textureBackCryogenicDistiller = par1IconRegister.func_94245_a("ihl:cryogenicDistillerInputSide");
        this.textureFrontChemicalReactor = par1IconRegister.func_94245_a("ihl:chemicalReactorOutputSide");
        this.textureFrontPaperMachine = par1IconRegister.func_94245_a("ihl:paperMachineFront");
        this.frequencyGeneratorBack = par1IconRegister.func_94245_a("ihl:frequencyGeneratorBack");
        this.frequencyGeneratorFront = par1IconRegister.func_94245_a("ihl:frequencyGeneratorFront");
        this.frequencyGeneratorTop = par1IconRegister.func_94245_a("ihl:frequencyGeneratorTop");
        this.frequencyGeneratorLeft = par1IconRegister.func_94245_a("ihl:frequencyGeneratorLeft");
        this.frequencyGeneratorRight = par1IconRegister.func_94245_a("ihl:frequencyGeneratorRight");
        this.frequencyGeneratorBottom = par1IconRegister.func_94245_a("ihl:frequencyGeneratorBottom");
        this.bronzeTubTop = par1IconRegister.func_94245_a("ihl:tubBronzeTop");
        this.bronzeTubSide = par1IconRegister.func_94245_a("ihl:tubBronzeSide");
        this.glassBoxBottom = par1IconRegister.func_94245_a("ihl:glassBoxBottom");
        this.glassBoxInnerBottom = par1IconRegister.func_94245_a("ihl:glassBoxInnerBottom");
        this.glassBoxInnerSide = par1IconRegister.func_94245_a("ihl:glassBoxInnerSide");
        this.glassBoxSide = par1IconRegister.func_94245_a("ihl:glassBoxSide");
        this.glassBoxTop = par1IconRegister.func_94245_a("ihl:glassBoxTop");
        this.vacuumInductionMeltingFurnaceFront = par1IconRegister.func_94245_a("ihl:vacuumInductionMeltingFurnaceFront");
        this.vacuumInductionMeltingFurnaceBack = par1IconRegister.func_94245_a("ihl:vacuumInductionMeltingFurnaceBack");
        this.vacuumInductionMeltingFurnaceLeft = par1IconRegister.func_94245_a("ihl:vacuumInductionMeltingFurnaceLeft");
        this.vacuumInductionMeltingFurnaceRight = par1IconRegister.func_94245_a("ihl:vacuumInductionMeltingFurnaceRight");
        this.hydrotransportPulpRegeneratorFront = par1IconRegister.func_94245_a("ihl:hydrotransportPulpRegeneratorFront");
        this.hydrotransportPulpRegeneratorBack = par1IconRegister.func_94245_a("ihl:hydrotransportPulpRegeneratorBack");
        this.redstoneSignalConverterEmitterSide = par1IconRegister.func_94245_a("ihl:redstoneSignalConverterEmitterSide");
        this.redstoneSignalConverterEmptySide = par1IconRegister.func_94245_a("ihl:redstoneSignalConverterEmptySide");
        this.redstoneSignalConverterSensorSide = par1IconRegister.func_94245_a("ihl:redstoneSignalConverterSensorSide");
        this.steel = par1IconRegister.func_94245_a("ihl:steel");
        this.redPaint = par1IconRegister.func_94245_a("ihl:redPaint");
        this.greenPaint = par1IconRegister.func_94245_a("ihl:greenPaint");
        this.rubberInsulatedCase = par1IconRegister.func_94245_a("ihl:rubberInsulatedCase");
        this.powerPort = par1IconRegister.func_94245_a("ihl:powerPort");
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int i, float pos_x, float pos_y, float pos_z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (IC2.platform.isSimulating()) {
            TileEntity lte;
            if (te instanceof RedstoneSignalConverterTileEntity) {
                RedstoneSignalConverterTileEntity t = (RedstoneSignalConverterTileEntity)te;
                if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemToolWrench) {
                    if (t.cableSlots.isEmpty()) {
                        return false;
                    }
                    for (int i2 = 0; i2 < t.cableSlots.size(); ++i2) {
                        if (t.cableSlots.get(i2) == null) continue;
                        world.func_72838_d((Entity)new EntityItem(world, (double)x, (double)(y + 1), (double)z, t.cableSlots.get(i2)));
                    }
                    t.removeAttachedChains();
                    return true;
                }
            }
            if (te instanceof DetonationSprayingMachineTileEntity && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == Items.field_151033_d) {
                ((DetonationSprayingMachineTileEntity)te).operate();
                return true;
            }
            if (te instanceof LathePart2TileEntity) {
                lte = (LathePart2TileEntity)te;
                te = world.func_147438_o(x - ForgeDirection.getOrientation((int)lte.getFacing()).offsetX, y - ForgeDirection.getOrientation((int)lte.getFacing()).offsetY, z - ForgeDirection.getOrientation((int)lte.getFacing()).offsetZ);
            }
            if (te instanceof RollingMachinePart2TileEntity) {
                lte = (RollingMachinePart2TileEntity)te;
                te = world.func_147438_o(x - ForgeDirection.getOrientation((int)lte.getFacing()).offsetX, y - ForgeDirection.getOrientation((int)lte.getFacing()).offsetY, z - ForgeDirection.getOrientation((int)lte.getFacing()).offsetZ);
            }
            if (te instanceof WoodenRollingMachinePart2TileEntity) {
                lte = (WoodenRollingMachinePart2TileEntity)te;
                te = world.func_147438_o(x - ForgeDirection.getOrientation((int)lte.getFacing()).offsetX, y - ForgeDirection.getOrientation((int)lte.getFacing()).offsetY, z - ForgeDirection.getOrientation((int)lte.getFacing()).offsetZ);
            }
            if (te instanceof RectifierTransformerUnitTileEntity) {
                RectifierTransformerUnitTileEntity rtu = (RectifierTransformerUnitTileEntity)te;
                if (player.func_71045_bC() == null) {
                    if (IC2.keyboard.isModeSwitchKeyDown(player)) {
                        rtu.switchModeDown();
                    } else {
                        rtu.switchModeUp();
                    }
                    IC2.platform.messagePlayer(player, "ic2.tooltip.mode", new Object[]{" Voltage output was set to " + rtu.getVoltageOut() + "V"});
                }
            }
            if (te instanceof IEnergyNetNode) {
                IEnergyNetNode node = (IEnergyNetNode)te;
                if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemToolCutter) {
                    node.removeAttachedChains();
                }
            }
        }
        return te instanceof IHasGui ? (IC2.platform.isSimulating() ? IC2.platform.launchGui(player, (IHasGui)te) : true) : false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        TileEntity t = world.func_147438_o(x, y, z);
        if (t != null && t instanceof IWrenchable) {
            ((IWrenchable)t).setFacing(IHLUtils.getFacingFromPlayerView(player, false));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int facing = 3;
        int[] mask = new int[]{0, 1, 2, 3, 4, 5, 1, 0, 3, 2, 4, 5, 2, 3, 0, 1, 4, 5, 2, 3, 1, 0, 4, 5, 2, 3, 5, 4, 0, 1, 2, 3, 4, 5, 1, 0};
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IWrenchable) {
            IWrenchable tebh = (IWrenchable)te;
            facing = tebh.getFacing();
        }
        return this.getIconFromFacing(facing, side);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (this.type == MachineType.RedstoneSignalConverter) {
            return this.redstoneSignalConverterEmptySide;
        }
        if (this.type == MachineType.RectifierTransformerUnit) {
            switch (side) {
                case 0: {
                    return this.bronzeTubSide;
                }
                case 1: {
                    return this.textureSideGoldFurnace;
                }
                case 2: {
                    return this.redPaint;
                }
                case 3: {
                    return this.greenPaint;
                }
                case 4: {
                    return this.rubberInsulatedCase;
                }
                case 5: {
                    return this.powerPort;
                }
            }
        }
        return this.getIconFromFacing(3, side);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromFacing(int facing, int side) {
        int[] mask = new int[]{0, 1, 2, 3, 4, 5, 1, 0, 3, 2, 4, 5, 2, 3, 0, 1, 4, 5, 2, 3, 1, 0, 4, 5, 2, 3, 5, 4, 0, 1, 2, 3, 4, 5, 1, 0};
        switch (this.type) {
            case RefluxCondenser: {
                return this.steel;
            }
            case RectifierTransformerUnit: {
                return this.bronzeTubSide;
            }
        }
        switch (mask[facing * 6 + side]) {
            case 0: {
                switch (this.type) {
                    case HydrotransportPulpRegenerator: {
                        return this.hydrotransportPulpRegeneratorFront;
                    }
                    case GlassBox: {
                        return this.glassBoxSide;
                    }
                    case BronzeTub: {
                        return this.bronzeTubSide;
                    }
                    case AchesonFurnace: {
                        return this.field_149761_L;
                    }
                    case MuffleFurnace: {
                        return this.textureFrontMuffleFurnance;
                    }
                    case LeadOven: {
                        return this.textureFrontGoldFurnace;
                    }
                    case WireMill: {
                        return this.textureFrontMachineCasing;
                    }
                    case LabElectrolyzer: {
                        return this.textureTopMachineCasing;
                    }
                    case FluidizedBedReactor: {
                        return this.textureTopMachineCasing;
                    }
                    case ChemicalReactor: {
                        return this.textureFrontChemicalReactor;
                    }
                    case CryogenicDistiller: {
                        return this.textureFrontCryogenicDistiller;
                    }
                    case PaperMachine: {
                        return this.textureFrontPaperMachine;
                    }
                    case FrequencyGenerator: {
                        return this.frequencyGeneratorFront;
                    }
                    case VacuumInductionMeltingFurnace: {
                        return this.vacuumInductionMeltingFurnaceFront;
                    }
                }
            }
            case 1: {
                switch (this.type) {
                    case HydrotransportPulpRegenerator: {
                        return this.hydrotransportPulpRegeneratorBack;
                    }
                    case GlassBox: {
                        return this.glassBoxSide;
                    }
                    case BronzeTub: {
                        return this.bronzeTubSide;
                    }
                    case LeadOven: {
                        return this.textureSideGoldFurnace;
                    }
                    case WireMill: {
                        return this.textureBackMachineCasing;
                    }
                    case CryogenicDistiller: {
                        return this.textureBackCryogenicDistiller;
                    }
                    case PaperMachine: {
                        return this.textureBackCryogenicDistiller;
                    }
                    case LabElectrolyzer: {
                        return this.textureBackCryogenicDistiller;
                    }
                    case FluidizedBedReactor: {
                        return this.textureBackCryogenicDistiller;
                    }
                    case ChemicalReactor: {
                        return this.textureBackCryogenicDistiller;
                    }
                    case FrequencyGenerator: {
                        return this.frequencyGeneratorBack;
                    }
                    case VacuumInductionMeltingFurnace: {
                        return this.vacuumInductionMeltingFurnaceBack;
                    }
                }
                return this.textureBack;
            }
            case 2: {
                switch (this.type) {
                    case HydrotransportPulpRegenerator: {
                        return this.textureBackMachineCasing;
                    }
                    case GlassBox: {
                        return this.glassBoxBottom;
                    }
                    case BronzeTub: {
                        return this.bronzeTubSide;
                    }
                    case LeadOven: {
                        return this.textureSideGoldFurnace;
                    }
                    case WireMill: {
                        return this.textureBackMachineCasing;
                    }
                    case CryogenicDistiller: {
                        return this.textureBackMachineCasing;
                    }
                    case PaperMachine: {
                        return this.textureBackMachineCasing;
                    }
                    case LabElectrolyzer: {
                        return this.textureBackMachineCasing;
                    }
                    case FluidizedBedReactor: {
                        return this.textureBackMachineCasing;
                    }
                    case ChemicalReactor: {
                        return this.textureBackMachineCasing;
                    }
                    case FrequencyGenerator: {
                        return this.frequencyGeneratorBottom;
                    }
                    case VacuumInductionMeltingFurnace: {
                        return this.vacuumInductionMeltingFurnaceRight;
                    }
                }
                return this.textureTop;
            }
            case 3: {
                switch (this.type) {
                    case HydrotransportPulpRegenerator: {
                        return this.textureTopMachineCasing;
                    }
                    case GlassBox: {
                        return this.glassBoxTop;
                    }
                    case BronzeTub: {
                        return this.bronzeTubTop;
                    }
                    case AchesonFurnace: {
                        return this.textureTopAchesonFurnance;
                    }
                    case MuffleFurnace: {
                        return this.textureTop;
                    }
                    case LeadOven: {
                        return this.textureTopGoldFurnace;
                    }
                    case WireMill: {
                        return this.textureTopMachineCasing;
                    }
                    case CryogenicDistiller: {
                        return this.textureTopCryogenicDistiller;
                    }
                    case PaperMachine: {
                        return this.textureTopMachineCasing;
                    }
                    case LabElectrolyzer: {
                        return this.textureTopMachineCasing;
                    }
                    case FluidizedBedReactor: {
                        return this.textureTopMachineCasing;
                    }
                    case ChemicalReactor: {
                        return this.textureTopMachineCasing;
                    }
                    case FrequencyGenerator: {
                        return this.frequencyGeneratorTop;
                    }
                    case VacuumInductionMeltingFurnace: {
                        return this.vacuumInductionMeltingFurnaceRight;
                    }
                }
                return this.textureTop;
            }
            case 4: {
                switch (this.type) {
                    case HydrotransportPulpRegenerator: {
                        return this.textureRightMachineCasing;
                    }
                    case GlassBox: {
                        return this.glassBoxSide;
                    }
                    case BronzeTub: {
                        return this.bronzeTubSide;
                    }
                    case LeadOven: {
                        return this.textureSideGoldFurnace;
                    }
                    case WireMill: {
                        return this.textureRightMachineCasing;
                    }
                    case CryogenicDistiller: {
                        return this.textureRightMachineCasing;
                    }
                    case PaperMachine: {
                        return this.textureRightMachineCasing;
                    }
                    case LabElectrolyzer: {
                        return this.textureRightMachineCasing;
                    }
                    case FluidizedBedReactor: {
                        return this.textureRightMachineCasing;
                    }
                    case ChemicalReactor: {
                        return this.textureRightMachineCasing;
                    }
                    case FrequencyGenerator: {
                        return this.frequencyGeneratorRight;
                    }
                    case VacuumInductionMeltingFurnace: {
                        return this.vacuumInductionMeltingFurnaceRight;
                    }
                }
                return this.textureSide;
            }
            case 5: {
                switch (this.type) {
                    case HydrotransportPulpRegenerator: {
                        return this.textureLeftMachineCasing;
                    }
                    case GlassBox: {
                        return this.glassBoxSide;
                    }
                    case BronzeTub: {
                        return this.bronzeTubSide;
                    }
                    case LeadOven: {
                        return this.textureSideGoldFurnace;
                    }
                    case CryogenicDistiller: {
                        return this.textureLeftMachineCasing;
                    }
                    case PaperMachine: {
                        return this.textureLeftMachineCasing;
                    }
                    case WireMill: {
                        return this.textureLeftMachineCasing;
                    }
                    case ChemicalReactor: {
                        return this.textureLeftMachineCasing;
                    }
                    case LabElectrolyzer: {
                        return this.textureLeftMachineCasing;
                    }
                    case FluidizedBedReactor: {
                        return this.textureLeftMachineCasing;
                    }
                    case FrequencyGenerator: {
                        return this.frequencyGeneratorLeft;
                    }
                    case VacuumInductionMeltingFurnace: {
                        return this.vacuumInductionMeltingFurnaceLeft;
                    }
                }
                return this.textureSide;
            }
        }
        return this.textureSide;
    }

    public boolean func_149696_a(World world, int x, int y, int z, int metadata, int flag) {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof RedstoneSignalConverterTileEntity) {
            RedstoneSignalConverterTileEntity rte = (RedstoneSignalConverterTileEntity)te;
            return rte.isProvidingRedstonePower(side);
        }
        return 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int metadata) {
        return this.func_149709_b(world, x, y, z, metadata);
    }

    public int func_149645_b() {
        if (this.type.hasSpecialBlockRenderer) {
            return IHLMod.proxy.shareBlockRendererByMachineType(this.type);
        }
        return this.type.specialBlockRendererId;
    }

    public boolean func_149662_c() {
        return this.type == null ? false : this.type.isNormalBlock;
    }

    public boolean func_149686_d() {
        return this.type.isNormalBlock;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getAdditionalIconsForBlockRenderer(int flag) {
        switch (this.type) {
            case BronzeTub: {
                return this.bronzeTubSide;
            }
            case GlassBox: {
                switch (flag) {
                    case 0: {
                        return this.glassBoxInnerSide;
                    }
                    case 1: {
                        return this.glassBoxInnerBottom;
                    }
                }
            }
            case RedstoneSignalConverter: {
                switch (flag) {
                    case 0: {
                        return this.redstoneSignalConverterEmptySide;
                    }
                    case 1: {
                        return this.redstoneSignalConverterEmitterSide;
                    }
                    case 2: {
                        return this.redstoneSignalConverterSensorSide;
                    }
                }
            }
        }
        return this.field_149761_L;
    }

    public static enum MachineType {
        RedstoneSignalConverter("redstoneSignalConverter", RedstoneSignalConverterTileEntity.class, true, true, IHLUtils.getThisModItemStack("foilSteel")),
        HydrotransportPulpRegenerator("hydrotransportPulpRegenerator", HydrotransportPulpRegeneratorTileEntity.class, true, IHLUtils.getThisModItemStack("extruderSetOfMoldedPartsSteel")),
        VacuumInductionMeltingFurnace("vacuumInductionMeltingFurnace", VacuumInductionMeltingFurnaceTileEntity.class, true, IHLUtils.getThisModItemStack("foilSteel")),
        GlassBox("glassBoxBlock", GlassBoxTileEntity.class, false, true, IHLUtils.getThisModItemStack("dustGlass")),
        ElectrolysisBath("electrolysisBath", ElectrolysisBathTileEntity.class, false, IHLUtils.getThisModItemStack("plateGraphite")),
        RectifierTransformerUnit("rectifierTransformerUnit", RectifierTransformerUnitTileEntity.class, false, true, IHLUtils.getThisModItemStack("foilSteel")),
        FrequencyGenerator("frequencyGenerator", FrequencyGeneratorTileEntity.class, true, IHLUtils.getThisModItemStack("foilSteel")),
        BatterySwitchUnit("batterySwitchUnit", BatterySwitchUnitTileEntity.class, false, IHLUtils.getThisModItemStack("foilSteel")),
        FractionatorBottom("fractionatorBottom", FractionatorBottomTileEntity.class, false, IHLUtils.getThisModItemStack("foilSteel")),
        FractionatorSection("fractionatorSection", FractionatorSectionTileEntity.class, false, IHLUtils.getThisModItemStackWithSize("ringPorcelain", 16)),
        FractionatorCover("fractionatorCover", FractionatorCoverTileEntity.class, false, IHLUtils.getThisModItemStack("foilSteel")),
        RefluxCondenser("refluxCondenser", RefluxCondenserTileEntity.class, false, false, IHLUtils.getThisModItemStack("foilSteel")),
        PaperMachine("paperMachine", PaperMachineTileEntity.class, true, IHLUtils.getThisModItemStack("stickSteel")),
        GaedesMercuryRotaryPump("gaedesMercuryRotaryPump", GaedesMercuryRotaryPumpTileEntity.class, false, IHLUtils.getThisModItemStack("foilSteel")),
        LabElectrolyzer("labElectrolyzer", LabElectrolyzerTileEntity.class, true, IHLUtils.getThisModItemStack("stickGraphite")),
        FluidizedBedReactor("fluidizedBedReactor", FluidizedBedReactorTileEntity.class, true, IHLUtils.getThisModItemStack("highPressureVesselSteel")),
        ChemicalReactor("chemicalReactor", ChemicalReactorTileEntity.class, true, IHLUtils.getThisModItemStack("highPressureVesselSteel")),
        CryogenicDistiller("cryogenicDistiller", CryogenicDistillerTileEntity.class, true, IHLUtils.getThisModItemStack("highPressureVesselSteel")),
        GasWeldingStation("gasWeldingStation", GasWeldingStationTileEntity.class, false, null),
        WoodenRollingMachine1("woodenRollingMachinePart1", WoodenRollingMachinePart1TileEntity.class, false, IHLUtils.getThisModItemStack("barD10Steel")),
        WoodenRollingMachine2("woodenRollingMachinePart2", WoodenRollingMachinePart2TileEntity.class, false, IHLUtils.getThisModItemStack("barD10Steel")),
        WireMill("wireMill", WireMillTileEntity.class, true, IHLUtils.getThisModItemStack("stickSteel")),
        VulcanizationExtrudingMold("vulcanizationExtrudingMold", VulcanizationExtrudingMoldTileEntity.class, false, IHLUtils.getThisModItemStack("dustCarborundum")),
        Extruder("extruder", ExtruderTileEntity.class, false, IHLUtils.getThisModItemStack("dustCarborundum")),
        RollingMachine1("rollingMachinePart1", RollingMachinePart1TileEntity.class, false, IHLUtils.getThisModItemStack("stickSteel")),
        RollingMachine2("rollingMachinePart2", RollingMachinePart2TileEntity.class, false, IHLUtils.getThisModItemStack("stickSteel")),
        Loom("loom", LoomTileEntity.class, false, new ItemStack(Items.field_151055_y)),
        Coiler("coiler", CoilerTileEntity.class, false, new ItemStack(Items.field_151055_y)),
        Lathe1("lathePart1", LathePart1TileEntity.class, false, IHLUtils.getThisModItemStack("stickSteel")),
        Lathe2("lathePart2", LathePart2TileEntity.class, false, IHLUtils.getOreDictItemStack("plateSteel")),
        PrecipitatorCondenser("goldPrecipitatorCondenser", PrecipitatorCondenserTileEntity.class, false, IHLUtils.getThisModItemStack("dustPorcelain")),
        GoldChimneyKnee("goldChimneyKnee", GoldChimneyKneeTileEntity.class, false, IHLUtils.getThisModItemStack("dustPorcelain")),
        LeadOven("leadOven", LeadOvenTileEntity.class, true, IHLUtils.getThisModItemStack("dustPorcelain")),
        DetonationSprayingMachine("cannonBronze", DetonationSprayingMachineTileEntity.class, false, new ItemStack(Items.field_151055_y)),
        BronzeTub("tubBronze", ImpregnatingMachineTileEntity.class, false, true, null),
        AchesonFurnace("achesonFurnance", AchesonFurnanceTileEntity.class, true, new ItemStack(Items.field_151118_aC)),
        MuffleFurnace("muffleFurnance", MuffleFurnanceTileEntity.class, true, new ItemStack(Items.field_151118_aC));

        String unlocalizedName;
        Class teclass;
        boolean isNormalBlock = true;
        boolean hasSpecialBlockRenderer = false;
        int specialBlockRendererId = -2;
        ItemStack itemDroppedOnBlockDestroy;

        private MachineType(String unlocalizedName1, Class teclass1, boolean isNormalBlock1, ItemStack itemDroppedOnBlockDestroy1) {
            this.unlocalizedName = unlocalizedName1;
            this.teclass = teclass1;
            this.isNormalBlock = isNormalBlock1;
            this.specialBlockRendererId = this.isNormalBlock ? 0 : -2;
            this.itemDroppedOnBlockDestroy = itemDroppedOnBlockDestroy1;
        }

        private MachineType(String unlocalizedName1, Class teclass1, boolean isNormalBlock1, boolean hasSpecialBlockRenderer1, ItemStack itemDroppedOnBlockDestroy1) {
            this.unlocalizedName = unlocalizedName1;
            this.teclass = teclass1;
            this.isNormalBlock = isNormalBlock1;
            this.hasSpecialBlockRenderer = hasSpecialBlockRenderer1;
            this.itemDroppedOnBlockDestroy = itemDroppedOnBlockDestroy1;
        }
    }
}

