/*
 * Decompiled with CFR 0.152.
 */
package ihl.utils;

import ihl.IHLMod;
import ihl.utils.IHLUtils;
import ihl.utils.WorldSavedDataBlastWave;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S26PacketMapChunkBulk;
import net.minecraft.util.DamageSource;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class ExplosionVector {
    public Set<Long> startVectors = new HashSet<Long>();
    private Set<Long> sv;
    private Set<Chunk> chunksToUpdate = new HashSet<Chunk>(64);
    public Map<Long, Set<Long>> vectors = new HashMap<Long, Set<Long>>(32786);
    public Map<Long, Explosion> explosions = new HashMap<Long, Explosion>();
    public Map<Long, Integer> explosionPower = new HashMap<Long, Integer>();
    public Map<Long, Float> explosionPowerDampingFactor = new HashMap<Long, Float>(32786);
    public Map<Long, ExtendedBlockStorage> cachedEBS = new HashMap<Long, ExtendedBlockStorage>(128);
    public Map<Long, Integer> cachedEBSHardness = new HashMap<Long, Integer>(128);
    public Map<Long, Map<Long, Integer>> cachedEBSDrops = new HashMap<Long, Map<Long, Integer>>(128);
    public Map<Long, List<Entity>> cachedEBSEntity = new HashMap<Long, List<Entity>>(128);
    public Map<Integer, WorldSavedDataBlastWave> blastWaveByDimensionId = new HashMap<Integer, WorldSavedDataBlastWave>();
    private Random random = new Random();

    public ExplosionVector() {
        this.precalculateExplosion();
    }

    public void precalculateExplosion() {
        int maxExplosionRadius = 32;
        for (int levelRadius = 1; levelRadius < maxExplosionRadius; ++levelRadius) {
            for (int ix = -levelRadius; ix <= levelRadius; ++ix) {
                for (int iy = -levelRadius; iy <= levelRadius; ++iy) {
                    for (int iz = -levelRadius; iz <= levelRadius; ++iz) {
                        long coordinateKey = IHLUtils.encodeXYZ(ix, iy, iz);
                        if (this.vectors.containsKey(coordinateKey)) continue;
                        int prevX = ix;
                        int prevY = iy;
                        int prevZ = iz;
                        if (Math.abs(ix) + Math.abs(iy) + Math.abs(iz) > Math.round((float)levelRadius * 1.8f)) {
                            prevX = IHLUtils.reduceVariableByAbsoluteValue(prevX);
                            prevY = IHLUtils.reduceVariableByAbsoluteValue(prevY);
                            prevZ = IHLUtils.reduceVariableByAbsoluteValue(prevZ);
                        } else if (Math.abs(ix) <= Math.abs(iy) && Math.abs(ix) <= Math.abs(iz)) {
                            prevY = IHLUtils.reduceVariableByAbsoluteValue(prevY);
                            prevZ = IHLUtils.reduceVariableByAbsoluteValue(prevZ);
                        } else if (Math.abs(iy) <= Math.abs(ix) && Math.abs(iy) <= Math.abs(iz)) {
                            prevX = IHLUtils.reduceVariableByAbsoluteValue(prevX);
                            prevZ = IHLUtils.reduceVariableByAbsoluteValue(prevZ);
                        } else if (Math.abs(iz) <= Math.abs(ix) && Math.abs(iz) <= Math.abs(iy)) {
                            prevY = IHLUtils.reduceVariableByAbsoluteValue(prevY);
                            prevX = IHLUtils.reduceVariableByAbsoluteValue(prevX);
                        }
                        long prevKey = IHLUtils.encodeXYZ(prevX, prevY, prevZ);
                        if (prevX == ix && prevY == iy && prevZ == iz && levelRadius > 1) {
                            IHLMod.log.error("Was:" + ix + "/" + iy + "/" + iz + "/");
                            IHLMod.log.error("Now:" + prevX + "/" + prevY + "/" + prevZ + "/");
                            throw new ArithmeticException("Variables are out of expected range. \n Expected are not equal: " + ix + "=" + prevX + " " + iy + "=" + prevY + " " + iz + "=" + prevZ);
                        }
                        if (levelRadius == 1) {
                            this.startVectors.add(coordinateKey);
                            this.addElement(coordinateKey, prevX, prevY, prevZ, ix, iy, iz);
                            continue;
                        }
                        if (this.vectors.containsKey(prevKey)) {
                            this.vectors.get(prevKey).add(coordinateKey);
                            this.addElement(coordinateKey, prevX, prevY, prevZ, ix, iy, iz);
                            continue;
                        }
                        IHLMod.log.error("Was:" + ix + "/" + iy + "/" + iz + "/");
                        IHLMod.log.error("Now:" + prevX + "/" + prevY + "/" + prevZ + "/");
                        IHLMod.log.info("ExplosionVector is missing parent! Help him!");
                    }
                }
            }
        }
    }

    private void addElement(long coordinateKey, int prevX, int prevY, int prevZ, int ix, int iy, int iz) {
        this.vectors.put(coordinateKey, new HashSet());
        float df = (float)(prevX * prevX + prevY * prevY + prevZ * prevZ + 1) / (float)(ix * ix + iy * iy + iz * iz + 1);
        this.explosionPowerDampingFactor.put(coordinateKey, Float.valueOf(df));
    }

    public void setPower(Set<Long> sv2, int power1) {
        for (long ev : sv2) {
            this.setPower(ev, power1);
        }
    }

    public void setPower(Long ev, int power1) {
        this.explosionPower.put(ev, power1);
    }

    public Set<Long> breakBlocksAndGetDescendantsForEBS(World world, int sourceX, int sourceY, int sourceZ, Explosion explosion, long longNumber) {
        int[] xyz = IHLUtils.decodeXYZ(longNumber);
        int power1 = this.explosionPower.remove(longNumber);
        power1 = this.getNewPowerAndProcessBlocksEBS(world, longNumber, sourceX, sourceY, sourceZ, explosion, xyz, power1);
        if ((power1 = Math.round((float)power1 * this.explosionPowerDampingFactor.get(longNumber).floatValue() - 0.5f)) <= 1 || !this.vectors.containsKey(longNumber) || this.vectors.get(longNumber).isEmpty()) {
            return null;
        }
        for (long d1 : this.vectors.get(longNumber)) {
            this.explosionPower.put(d1, power1);
        }
        return this.vectors.get(longNumber);
    }

    private int getNewPowerAndProcessBlocksEBS(World world, long longNumber, int sourceX, int sourceY, int sourceZ, Explosion explosion, int[] xyz, int power2) {
        int power1 = power2;
        int absEBSX = xyz[0] + (sourceX >> 4);
        int absEBSY = xyz[1] + (sourceY >> 4);
        int absEBSZ = xyz[2] + (sourceZ >> 4);
        long chunkXZKey = ChunkCoordIntPair.func_77272_a((int)absEBSX, (int)absEBSZ);
        if (absEBSY < 0 || absEBSY >= 16) {
            return 0;
        }
        if (world.func_72863_F().func_73149_a(absEBSX, absEBSZ)) {
            long absEBShash = IHLUtils.getXYZHash(absEBSX, absEBSY, absEBSZ);
            int explosionResistance = this.getEBSResistance(world, absEBShash, absEBSX, absEBSY, absEBSZ, sourceX, sourceY, sourceZ);
            if (explosionResistance >= power1) {
                power1 = 0;
            } else {
                power1 -= explosionResistance;
                if (this.cachedEBSEntity.containsKey(absEBShash)) {
                    List<Entity> entityList = this.cachedEBSEntity.get(absEBShash);
                    for (Object entity : entityList.toArray()) {
                        if (entity == null) continue;
                        ((Entity)entity).func_70097_a(DamageSource.func_94539_a((Explosion)explosion), (float)power1 / 10.0f);
                    }
                }
                this.onEBSDestroy(world, absEBShash, absEBSX, absEBSY, absEBSZ);
            }
        } else {
            WorldSavedDataBlastWave blastWave = null;
            int dimensionId = world.field_73011_w.field_76574_g;
            if (this.blastWaveByDimensionId.containsKey(dimensionId)) {
                blastWave = this.blastWaveByDimensionId.get(dimensionId);
            } else {
                blastWave = new WorldSavedDataBlastWave("blastWave");
                this.blastWaveByDimensionId.put(dimensionId, blastWave);
            }
            blastWave.scheduleExplosionEffectsOnChunkLoad(chunkXZKey, longNumber, sourceX, sourceY, sourceZ, power1, absEBSY);
        }
        return power1;
    }

    public int getEBSResistance(World world, long absEBShash, int absEBSX, int absEBSY, int absEBSZ, int sourceX, int sourceY, int sourceZ) {
        if (this.cachedEBSHardness.containsKey(absEBShash)) {
            return this.cachedEBSHardness.get(absEBShash);
        }
        this.precacheChunk(world, absEBSX, absEBSZ, sourceX, sourceY, sourceZ);
        return this.cachedEBSHardness.containsKey(absEBShash) ? this.cachedEBSHardness.get(absEBShash) : 0;
    }

    public void precacheChunk(World world, int absEBSX, int absEBSZ, int sourceX, int sourceY, int sourceZ) {
        Chunk chunk = world.func_72863_F().func_73154_d(absEBSX, absEBSZ);
        ExtendedBlockStorage[] ebsA = chunk.func_76587_i();
        for (int y3 = 0; y3 < ebsA.length; ++y3) {
            ExtendedBlockStorage ebs = ebsA[y3];
            int ebsHardness = 0;
            long absEBShash1 = IHLUtils.getXYZHash(absEBSX, y3, absEBSZ);
            if (ebs == null || ebs.func_76663_a()) continue;
            byte[] lbsArray = ebs.func_76658_g();
            HashMap<Long, Integer> drops = new HashMap<Long, Integer>();
            for (int i4 = 0; i4 < lbsArray.length; ++i4) {
                int var4 = lbsArray[i4] & 0xFF;
                if (ebs.func_76660_i() != null) {
                    var4 |= ebs.func_76660_i().func_76582_a(i4 & 0xF, i4 >> 8 & 0xF, i4 >> 4 & 0xF) << 8;
                }
                int blockWorldX = (i4 & 0xF) + (absEBSX << 4);
                int blockWorldY = (i4 >> 8 & 0xF) + (y3 << 4);
                int blockWorldZ = (i4 >> 4 & 0xF) + (absEBSZ << 4);
                Block block = Block.func_149729_e((int)var4);
                ArrayList dropsList = block.getDrops(world, blockWorldX, blockWorldY, blockWorldZ, ebs.func_76665_b(i4 & 0xF, i4 >> 8 & 0xF, i4 >> 4 & 0xF), 0);
                if (dropsList != null) {
                    for (ItemStack drop : dropsList) {
                        long key = Item.func_150891_b((Item)drop.func_77973_b()) << 16 | drop.func_77960_j();
                        if (drops.containsKey(key)) {
                            int ss = (Integer)drops.get(key);
                            drops.put(key, drop.field_77994_a + ss);
                            continue;
                        }
                        drops.put(key, drop.field_77994_a);
                    }
                }
                if (block.func_149712_f(world, blockWorldX, blockWorldY, blockWorldZ) < 0.0f) {
                    ebsHardness = Integer.MAX_VALUE;
                    break;
                }
                ebsHardness += Math.round(block.getExplosionResistance(null, world, blockWorldX, blockWorldY, blockWorldZ, (double)sourceX, (double)sourceY, (double)sourceZ) * 10.0f);
            }
            this.cachedEBSDrops.put(absEBShash1, drops);
            this.cachedEBSEntity.put(absEBShash1, chunk.field_76645_j[y3]);
            this.cachedEBSHardness.put(absEBShash1, ebsHardness);
            this.cachedEBS.put(absEBShash1, ebs);
        }
    }

    public void onEBSDestroy(World world, long absEBShash, int absEBSX, int absEBSY, int absEBSZ) {
        if (this.cachedEBS.containsKey(absEBShash)) {
            ExtendedBlockStorage ebs = this.cachedEBS.get(absEBShash);
            ebs.func_76673_a(new NibbleArray(4096, 4));
            ebs.func_76664_a(new byte[4096]);
            this.cachedEBS.remove(absEBShash);
            this.cachedEBSDrops.remove(absEBShash);
            this.cachedEBSEntity.remove(absEBShash);
            this.cachedEBSHardness.remove(absEBShash);
            this.chunksToUpdate.add(world.func_72863_F().func_73154_d(absEBSX, absEBSZ));
        }
    }

    public void sendChunkUpdateToPlayersInExplosionAffectedZone(World world) {
        for (Object player : world.field_73010_i) {
            if (!(player instanceof EntityPlayerMP)) continue;
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            ArrayList<Chunk> chunks = new ArrayList<Chunk>();
            chunks.addAll(this.chunksToUpdate);
            playerMP.field_71135_a.func_147359_a((Packet)new S26PacketMapChunkBulk(chunks));
            this.chunksToUpdate.clear();
        }
    }

    public void doExplosion(World world, int sourceX, int sourceY, int sourceZ, Set<Long> startVectors1) {
        boolean doExplosion = true;
        long sourceHash = IHLUtils.getXYZHash(sourceX, sourceY, sourceZ);
        Explosion explosion = new Explosion(world, null, (double)sourceX, (double)sourceY, (double)sourceZ, 100.0f);
        this.explosions.put(sourceHash, explosion);
        while (doExplosion) {
            HashSet<Long> sv2 = new HashSet<Long>();
            if (this.sv == null) {
                this.sv = startVectors1;
            }
            for (long ev : this.sv) {
                Set<Long> sv3 = this.breakBlocksAndGetDescendantsForEBS(world, sourceX, sourceY, sourceZ, explosion, ev);
                if (sv3 == null) continue;
                sv2.addAll(sv3);
            }
            if (sv2.isEmpty()) {
                doExplosion = false;
                this.sv = null;
                this.sendChunkUpdateToPlayersInExplosionAffectedZone(world);
                break;
            }
            this.sv = sv2;
        }
    }
}

