/*
 * Decompiled with CFR 0.152.
 */
package ihl.utils;

public class IHLMathUtils {
    private static final int accuracy_level = 65536;
    private static float[] sin_table;
    private static float[] atan_table;
    private static final float PI = (float)Math.PI;

    public static float sin(float angle) {
        float angle1 = angle % ((float)Math.PI * 2);
        if (angle1 < 0.0f) {
            angle1 += (float)Math.PI * 2;
        }
        return sin_table[(int)(angle1 * 65536.0f / 2.0f / (float)Math.PI)];
    }

    public static float atan(float tan_value) {
        if (tan_value < -32.0f) {
            return -1.54f;
        }
        if (tan_value > 32.0f) {
            return 1.54f;
        }
        return atan_table[(int)((tan_value + 32.0f) * 65536.0f / 64.0f)];
    }

    static {
        int i;
        sin_table = new float[65536];
        atan_table = new float[65536];
        for (i = 0; i < 65536; ++i) {
            IHLMathUtils.sin_table[i] = (float)Math.sin(Math.PI * 2 * (double)i / 65536.0);
        }
        for (i = 0; i < 65536; ++i) {
            IHLMathUtils.atan_table[i] = (float)Math.atan(-32.0 + 64.0 * (double)i / 65536.0);
        }
    }
}

