/*
 * Decompiled with CFR 0.152.
 */
package ihl.worldgen.ores;

import cpw.mods.fml.common.registry.GameRegistry;
import ic2.core.Ic2Items;
import ihl.IHLCreativeTab;
import ihl.items_blocks.IHLFluidBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class IHLFluid
extends Fluid {
    private IHLFluidType type;
    private static List<Fluid> fluidInstances = new ArrayList<Fluid>();
    private static Map<String, IHLFluidType> localFluidRegistry = new HashMap<String, IHLFluidType>();
    private static Map<String, Float> realDensityMap = new HashMap<String, Float>();
    private static Map<String, String> condensationMap = new HashMap<String, String>();
    private static Map<String, List<String>> solutionMap = new HashMap<String, List<String>>();
    public static final int maxGaseousStateVapoursDensity = 40;

    public IHLFluid(IHLFluidType type1) {
        super(type1.fluidRegistryName);
        this.type = type1;
        this.setTemperature(this.type.temperature);
        this.setDensity(Math.round(this.type.density));
        realDensityMap.put(type1.fluidRegistryName, Float.valueOf(this.type.density));
        this.setGaseous(this.type.isGaseous);
        this.setUnlocalizedName(this.type.fluidRegistryName.replaceFirst("fluid", ""));
        IHLFluid instance = this;
        if (!FluidRegistry.registerFluid((Fluid)instance)) {
            instance = FluidRegistry.getFluid((String)this.type.fluidRegistryName);
        }
        if (instance.getBlock() == null && !this.type.noBlock) {
            instance.setBlock(new IHLFluidBlock(instance, this.type.blockMaterial, this.type.textureName, "fluid" + this.type.fluidName.replaceFirst("fluid", "")).setFlammable(this.type.flammable).func_149663_c("block" + this.type.fluidName).func_149647_a(IHLCreativeTab.tab));
        }
        if (this.type.haveBucket) {
            Item bucket = new ItemBucket(this.block).func_111206_d("ihl:bucket_" + this.type.fluidName).func_77655_b("bucket_" + this.type.fluidName).func_77637_a(IHLCreativeTab.tab);
            GameRegistry.registerItem((Item)bucket, (String)("bucket_" + this.type.fluidName));
            FluidContainerRegistry.registerFluidContainer((Fluid)instance, (ItemStack)new ItemStack(bucket), (ItemStack)FluidContainerRegistry.EMPTY_BUCKET);
        }
        this.type.fluid = instance;
        localFluidRegistry.put(type1.fluidRegistryName, this.type);
        fluidInstances.add(this);
    }

    public static void init() {
        IHLFluidType[] var1 = IHLFluidType.values();
        for (int i = 0; i < var1.length; ++i) {
            new IHLFluid(var1[i]);
        }
        condensationMap.put("steam", "ic2distilledwater");
        condensationMap.put("ic2steam", "ic2distilledwater");
        condensationMap.put("ic2superheatedsteam", "ic2distilledwater");
        condensationMap.put("vapour.sulfuricacid", "sulfuricacid");
        solutionMap.put("water", Arrays.asList("aquaregia", "sulfuricacid", "solution.nickelsulfate", "solution.bluevitriol"));
        solutionMap.put("ic2distilledwater", Arrays.asList("aquaregia", "sulfuricacid", "solution.nickelsulfate", "solution.bluevitriol"));
    }

    public static void registerIcons(TextureMap iconRegistry) {
        for (Fluid instance : fluidInstances) {
            IHLFluidType instanceType = localFluidRegistry.get(instance.getName());
            instance.setIcons(iconRegistry.func_94245_a("ihl:" + instanceType.textureName + "Still"), iconRegistry.func_94245_a("ihl:" + instanceType.textureName + "Flowing"));
        }
    }

    public static ItemStack getCell(String fluidname1) {
        ItemStack filledCell = FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(FluidRegistry.getFluid((String)fluidname1), 1000), (ItemStack)Ic2Items.cell.func_77946_l());
        return filledCell;
    }

    public static Block getBlock(String fluidname) {
        return IHLFluid.localFluidRegistry.get((Object)fluidname).fluid.getBlock();
    }

    public static int getMeltingPoint(Fluid fluid) {
        if (localFluidRegistry.get(fluid.getName()) != null) {
            IHLFluidType type = localFluidRegistry.get(fluid.getName());
            return type.meltingPoint;
        }
        if (fluid.isGaseous()) {
            return fluid.getTemperature() > 100 ? fluid.getTemperature() - 100 : 0;
        }
        return fluid.getTemperature();
    }

    public static int getBoilingPoint(Fluid fluid) {
        if (localFluidRegistry.containsKey(fluid.getName())) {
            IHLFluidType type = localFluidRegistry.get(fluid.getName());
            return type.boilingPoint;
        }
        if (fluid.getName() == "steam" || fluid.getName() == "ic2steam" || fluid.getName() == "ic2superheatedsteam") {
            return 373;
        }
        if (fluid.isGaseous()) {
            return fluid.getTemperature();
        }
        return fluid.getTemperature() + 100;
    }

    public static FluidStack getCondensationResult(FluidStack condensatedGas) {
        int quantity;
        String fluidname = condensationMap.get(condensatedGas.getFluid().getName());
        Fluid fluid = FluidRegistry.getFluid((String)fluidname);
        if (fluid != null && (quantity = Math.round((float)condensatedGas.amount * IHLFluid.getCondensationConversionRate(condensatedGas.getFluid()))) > 0) {
            return new FluidStack(fluid.getID(), quantity);
        }
        return null;
    }

    public static float getCondensationConversionRate(Fluid gas) {
        String fluidname = condensationMap.get(gas.getName());
        Fluid fluid = FluidRegistry.getFluid((String)fluidname);
        if (fluid != null) {
            float rate = (float)gas.getDensity() / (float)fluid.getDensity();
            if (gas.getDensity() < 0) {
                rate = -8000.0f / (float)gas.getDensity() / (float)fluid.getDensity();
            }
            return rate;
        }
        return 0.0f;
    }

    public static boolean canBeDissolvedIn(FluidStack solvent, String impurity) {
        return solutionMap.get(solvent.getFluid().getName()).contains(impurity);
    }

    public static float getRealDensity(Fluid gas) {
        if (realDensityMap.containsKey(gas.getName())) {
            return realDensityMap.get(gas.getName()).floatValue();
        }
        float density = gas.getDensity();
        if (gas.getDensity() < 0) {
            density = -8000.0f / (float)gas.getDensity();
        }
        return density;
    }

    public static enum IHLFluidType {
        LithiumChloride("LithiumChlorideDissolvedInWater", 10046, 293, 249, 373, 1530.0f, "solution.lithiumchloride", Material.field_151586_h, false, false, false),
        CalciumChloride("CalciumChlorideDissolvedInWater", 10045, 293, 249, 373, 1630.0f, "solution.calciumchloride", Material.field_151586_h, false, false, false),
        ZeolitePulp("ZeolitePulp", "fluidPulpZeolite", 10044, 293, 249, 373, 1150.0f, "pulp.sodiumzeolite", Material.field_151586_h, false, false, false),
        MoltenTarPitch("MoltenTarPitch", "fluidOil", 10043, 373, 373, 800, 1250.0f, "molten.tarpitch", Material.field_151587_i, false, false, false),
        CrackingGas("CrackingGas", "fluidAcetylene", 10042, 293, 135, 273, 2.27f, "crackinggas", (Material)new MaterialLiquid(MapColor.field_151646_E), false, false, false),
        Trichlorosilane("Trichlorosilane", "fluidHydrogenChloride", 10041, 293, 147, 305, 1342.0f, "trichlorosilane", (Material)new MaterialLiquid(MapColor.field_151651_C), true, false, false),
        SiliconTetrachloride("SiliconTetrachloride", "fluidChlorine", 10040, 293, 204, 330, 584.0f, "silicontetrachloride", (Material)new MaterialLiquid(MapColor.field_151679_y), true, false, false),
        Chlorine("Chlorine", 10039, 293, 172, 238, 3.21f),
        BoricAcid("BoricAcid", 10038, 373, 249, 373, 1275.0f, "boricacid", Material.field_151586_h, false, false, false),
        MicaPulp("PulpMica", 10037, 293, 249, 373, 1150.0f, "pulp.mica", Material.field_151586_h, false, false, false),
        CellulosePulp("PulpCellulose", 10036, 293, 249, 373, 1075.0f, "pulp.cellulose", Material.field_151586_h, false, false, false),
        Fuel("Fuel", 10035, 293, 268, 633, 840.0f, "fuel", Material.field_151586_h, true, false, true),
        MineralOil("MineralOil", 10034, 293, 238, 704, 845.0f, "mineraloil", Material.field_151586_h, true, false, true),
        FuelOil("FuelOil", 10033, 293, 293, 693, 991.0f, "fueloil", Material.field_151586_h, true, false, true),
        Oil("Oil", 10032, 293, 284, 773, 850.0f, "oil", Material.field_151586_h, true, false, true),
        Mercury("Mercury", 10031, 293, 234, 630, 13546.0f),
        VapourMercury("VapourMercury", 10030, 630, 234, 630, 9.229f, "vapour.mercury", (Material)new MaterialLiquid(MapColor.field_151679_y), false, false, false),
        Hydrogen("Hydrogen", 10029, 293, 14, 20, 0.046f, "hydrogen", (Material)new MaterialLiquid(MapColor.field_151649_A), true, false, true),
        SaltWater("SaltWater", 10028, 293, 253, 373, 1360.0f),
        HydrogenChloride("HydrogenChloride", 10027, 293, 159, 188, 1.477f, "hydrogenchloride", (Material)new MaterialLiquid(MapColor.field_151673_t), true, false, true),
        NatriumTungstate("NatriumTungstateDissolvedInWater", 10026, 293, 249, 373, 1730.0f, "solution.natriumtungstate", Material.field_151586_h, true, false, false),
        Turpentine("Turpentine", 10025, 293, 217, 453, 1470.0f, "turpentine", Material.field_151586_h, true, false, true),
        Air("Air", 293, 55, 93, 1.292f, Ic2Items.airCell),
        Nitrogen("Nitrogen", 10024, 92, 56, 92, 1.251f, "nitrogen", (Material)new MaterialLiquid(MapColor.field_151660_b), true, false, true),
        Acetylene("Acetylene", 10023, 293, 17, 190, 1.173f, "acetylene", Material.field_151586_h, true, false, true),
        Oxygen("Oxygen", 10022, 93, 55, 93, 1.429f, "oxygen", (Material)new MaterialLiquid(MapColor.field_151660_b), true, false, true),
        NatriumHydroxide("NatriumHydroxideDissolvedInWater", 10021, 293, 249, 373, 1525.0f, "solution.natriumhydroxide", Material.field_151586_h, true, false, false),
        LiquidGlass("LiquidGlass", 10020, 293, 253, 373, 2400.0f),
        fluidRubberTreeSap("fluidRubberTreeSap", 10019, 293, 273, 393, 1200.0f, "fluidrubbertreesap", Material.field_151586_h, true, true, false),
        SpruceResin("SpruceResin", 10018, 293, 273, 533, 1080.0f, "spruceresin", Material.field_151586_h, true, true, true),
        CablingColophony("CablingColophony", 10017, 363, 363, 533, 1070.0f, "cablingcolophony", Material.field_151586_h, true, false, true),
        Glyceryl("Glyceryl", 10016, 293, 291, 583, 1261.0f, "glyceryl", Material.field_151586_h, true, false, true),
        SeedOil("SeedOil", 10015, 293, 256, 583, 920.0f, "seedoil", Material.field_151586_h, true, false, true),
        AquaRegia("AquaRegia", 10014, 293, 231, 356, 1060.0f),
        SodiumPeroxide("SodiumPeroxide", 10013, 950, 950, 2223, 1800.0f),
        OsmiumTetroxide("OsmiumTetroxide", 10012, 313, 313, 403, 9.0f),
        OleicAcid("OleicAcid", 10011, 293, 288, 633, 895.0f, "oleicacid", Material.field_151586_h, true, false, true),
        Limemilk("Limemilk", 10010, 293, 250, 373, 1020.0f),
        NickelSulfateDissolvedInWater("NickelSulfateDissolvedInWater", 10009, 293, 253, 373, 1220.0f, "solution.nickelsulfate", Material.field_151586_h, true, false, false),
        BlueVitriolDissolvedInWater("BlueVitriolDissolvedInWater", 10008, 293, 253, 373, 1180.0f, "solution.bluevitriol", Material.field_151586_h, true, false, false),
        MoltenRubberWithSulfur("MoltenRubberWithSulfur", 10007, 600, 600, 1000, 1200.0f, "molten.rubber", Material.field_151587_i, false, false, true),
        MoltenLithium("MoltenLithium", "fluidMolten", 10042, 454, 454, 1613, 512.0f, "molten.lithium", Material.field_151587_i, false, false, false),
        MoltenSodiumChloride("MoltenSodiumChloride", "fluidMolten", 10006, 1273, 1273, 1740, 1556.0f, "molten.sodiumchloride", Material.field_151587_i, false, false, false),
        MoltenGlass("MoltenGlass", "fluidMolten", 10048, 600, 600, 1950, 2270.0f, "molten.glass", Material.field_151587_i, false, false, false, true),
        MoltenMagnesium("MoltenMagnesium", "fluidMolten", 10006, 923, 923, 1623, 1584.0f, "molten.magnesium", Material.field_151587_i, false, false, false),
        MoltenSteel("MoltenSteel", "fluidMolten", 10006, 1800, 1800, 3134, 6980.0f, "molten.steel", Material.field_151587_i, false, false, false),
        MoltenCopper("MoltenCopper", "fluidMolten", 10048, 1356, 1356, 2840, 8920.0f, "molten.copper", Material.field_151587_i, false, false, false),
        MoltenBronze("MoltenBronze", 10005, 940, 940, 2840, 8000.0f, "molten.bronze", Material.field_151587_i, false, false, false),
        MoltenGold("MoltenGold", 10005, 1337, 1337, 3129, 17310.0f, "molten.gold", Material.field_151587_i, false, false, false),
        VapourSulfuricAcid("VapourSulfuricAcid", 10004, 610, 283, 610, 4.522f, "vapour.sulfuricacid", (Material)new MaterialLiquid(MapColor.field_151645_D), false, false, false),
        SulfuricAnhydride("SulfuricAnhydride", 10003, 45, 17, 45, 2.0f, "sulfuricanhydride", (Material)new MaterialLiquid(MapColor.field_151645_D), true, false, false),
        SulfuricAcid("SulfuricAcid", 10002, 293, 283, 610, 1836.0f),
        NitricAcid("NitricAcid", 10001, 293, 231, 356, 1100.0f);

        public String fluidName;
        public String fluidRegistryName;
        public String cellName;
        public String textureName;
        int temperature;
        float density;
        boolean isGaseous;
        boolean flammable = false;
        boolean noBlock = false;
        boolean haveBucket;
        Material blockMaterial = Material.field_151586_h;
        int meltingPoint;
        int boilingPoint;
        public boolean hasCell = true;
        public ItemStack cell;
        public Fluid fluid;
        public final int damage;

        private IHLFluidType(String fluidName1, int celldamage, int temperature1, int meltingPoint1, int boilingPoint1, float density1) {
            this.fluidName = fluidName1;
            this.fluidRegistryName = this.fluidName.toLowerCase();
            this.textureName = "fluid" + this.fluidName.replaceFirst("fluid", "");
            this.temperature = temperature1;
            this.density = density1;
            this.cellName = "itemCell" + this.fluidName;
            this.haveBucket = false;
            this.isGaseous = density1 < 40.0f;
            this.boilingPoint = boilingPoint1;
            this.meltingPoint = meltingPoint1;
            this.damage = celldamage;
        }

        private IHLFluidType(String fluidName1, int temperature1, int meltingPoint1, int boilingPoint1, float density1, ItemStack cell1) {
            this.fluidName = fluidName1;
            this.fluidRegistryName = this.fluidName.toLowerCase();
            this.textureName = "fluid" + this.fluidName.replaceFirst("fluid", "");
            this.temperature = temperature1;
            this.density = density1;
            this.cellName = "itemCell" + this.fluidName;
            this.haveBucket = false;
            this.isGaseous = density1 < 40.0f;
            this.boilingPoint = boilingPoint1;
            this.meltingPoint = meltingPoint1;
            this.damage = 99999;
            this.hasCell = false;
            this.cell = cell1;
        }

        private IHLFluidType(String fluidName1, int celldamage, int temperature1, int meltingPoint1, int boilingPoint1, float density1, String fluidRegistryName1, Material blockMaterial1, boolean hasCell1, boolean haveBucket1, boolean flammable1) {
            this.fluidName = fluidName1;
            this.fluidRegistryName = fluidRegistryName1;
            this.textureName = "fluid" + this.fluidName.replaceFirst("fluid", "");
            this.temperature = temperature1;
            this.density = density1;
            this.cellName = "itemCell" + this.fluidName;
            this.haveBucket = haveBucket1;
            this.flammable = flammable1;
            this.isGaseous = density1 < 40.0f;
            this.blockMaterial = blockMaterial1;
            this.boilingPoint = boilingPoint1;
            this.meltingPoint = meltingPoint1;
            this.hasCell = hasCell1;
            this.damage = celldamage;
        }

        private IHLFluidType(String fluidName1, String textureName1, int celldamage, int temperature1, int meltingPoint1, int boilingPoint1, float density1, String fluidRegistryName1, Material blockMaterial1, boolean hasCell1, boolean haveBucket1, boolean flammable1) {
            this.fluidName = fluidName1;
            this.fluidRegistryName = fluidRegistryName1;
            this.textureName = textureName1;
            this.temperature = temperature1;
            this.density = density1;
            this.cellName = "itemCell" + this.fluidName;
            this.haveBucket = haveBucket1;
            this.flammable = flammable1;
            this.isGaseous = density1 < 40.0f;
            this.blockMaterial = blockMaterial1;
            this.boilingPoint = boilingPoint1;
            this.meltingPoint = meltingPoint1;
            this.hasCell = hasCell1;
            this.damage = celldamage;
        }

        private IHLFluidType(String fluidName1, String textureName1, int celldamage, int temperature1, int meltingPoint1, int boilingPoint1, float density1, String fluidRegistryName1, Material blockMaterial1, boolean hasCell1, boolean haveBucket1, boolean flammable1, boolean noBlock1) {
            this.noBlock = noBlock1;
            this.fluidName = fluidName1;
            this.fluidRegistryName = fluidRegistryName1;
            this.textureName = textureName1;
            this.temperature = temperature1;
            this.density = density1;
            this.cellName = "itemCell" + this.fluidName;
            this.haveBucket = haveBucket1;
            this.flammable = flammable1;
            this.isGaseous = density1 < 40.0f;
            this.blockMaterial = blockMaterial1;
            this.boilingPoint = boilingPoint1;
            this.meltingPoint = meltingPoint1;
            this.hasCell = hasCell1;
            this.damage = celldamage;
        }
    }
}

