/*
 * Decompiled with CFR 0.152.
 */
package ihl;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import ic2.api.item.IC2Items;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.core.util.StackUtil;
import ihl.IHLMod;
import ihl.flexible_cable.IronWorkbenchTileEntity;
import ihl.recipes.IronWorkbenchRecipe;
import ihl.recipes.RecipeInputDie;
import ihl.recipes.RecipeInputWire;
import ihl.recipes.RecipeOutputItemStack;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fluids.FluidStack;

public class IHLModConfig {
    public int handpumpTier = 1;
    public int handpumpMaxCharge = 30000;
    public int handpumpOperationEUCost = 180;
    public int advancedHandpumpTier = 3;
    public int advancedHandpumpMaxCharge = 1000000;
    public int advancedHandpumpOperationEUCost = 10000;
    public int harvesterTier = 1;
    public int harvesterMaxEnergyStorage = 110;
    public int harvesterIdleEUCost = 1;
    public int harvesterOperationEUCost = 100;
    public int blowerTier = 1;
    public int blowerMaxEnergyStorage = 100;
    public int blowerEnergyConsumePerTick = 5;
    public int tditTier = 4;
    public int tditMaxEnergyStorage = 12000;
    public int tditEnergyConsumePerStack = 12000;
    public int ts02DefaultTier = 1;
    public int ts02DefaultMaxEnergyStorage = 1000;
    public int ts02DefaultSpeed = 400;
    public int ts02DefaultOperationEUCost = 5;
    public String[] ts02BlockBlackListString;
    public String[] ts02BlockWhiteListString;
    public boolean enableExtendedLiquidPhysics = true;
    public boolean enableHandpump = true;
    public boolean enableFan = true;
    public boolean enableTunnelingShield = true;
    public boolean enableHarvester = true;
    public boolean enableRubberTreeSack = true;
    public boolean enableCollectors = true;
    public boolean enableWailers = true;
    public boolean enableTDIT = true;
    public boolean enablePentlanditeProcessing = true;
    public int chanceToGetSiliconDioxideFromSludge = 10000;
    public int chanceToGetGoldFromSludge = 10000;
    public int chanceToGetPlatinumFromSludge = 10000;
    public int chanceToGetPalladiumFromSludge = 8000;
    public int chanceToGetIridiumFromSludge = 6000;
    public int chanceToGetOsmiumFromSludge = 6000;
    public boolean enableFlexibleCablesCrafting = true;
    public boolean enableFlexibleCablesGridPowerLossCalculations = true;
    public double additionalPowerLossesAtFrequencyGenerator = 0.01;
    public boolean generateApatiteOre = true;
    public boolean generateSaltpeterOre = true;
    public boolean generateLimestone = true;
    public boolean generateGypsum = true;
    public boolean generatePotassiumFeldspar = true;
    public boolean generateTrona = true;
    public boolean generateRocksalt = true;
    public boolean generateCinnabar = true;
    public boolean generateGyubnera = true;
    public boolean generateBauxite = true;
    public boolean generateChromite = true;
    public boolean generateMuscovite = true;
    public boolean generateOil = true;
    public boolean generateDatolite = true;
    public boolean generateSaltwater = true;
    public boolean generateBischofite = true;
    public int mirrorReflectionRange = 14;
    public int mirrorReflectionUpdateSpeed = 128;
    public String preventMachineBlockRegistrationName = "null";
    public boolean skipRecipeLoad = false;
    public boolean giveIHLManualOnPlayerWakeUpEvent = true;

    public IHLModConfig(FMLPreInitializationEvent evt) throws IOException {
        Configuration config = new Configuration(evt.getSuggestedConfigurationFile());
        config.load();
        this.skipRecipeLoad = config.get("general", "skipRecipeLoad", this.skipRecipeLoad).getBoolean(this.skipRecipeLoad);
        this.preventMachineBlockRegistrationName = config.get("general", "preventMachineBlockRegistrationName", this.preventMachineBlockRegistrationName).getString();
        String[] bl = new String[]{"bedrock", "reinforcedStone", "reinforcedGlass", "reinforcedDoorBlock", "personalSafe", "end_portal_frame"};
        String[] wl = new String[]{"brown_mushroom_block", "cake", "fire", "lava", "water", "flowing_lava", "flowing_water", "redstone_torch", "redstone_wire", "web", "torch"};
        this.enableExtendedLiquidPhysics = config.get("general", "enableExtendedLiquidPhysics", this.enableExtendedLiquidPhysics).getBoolean(this.enableExtendedLiquidPhysics);
        this.enableHandpump = config.get("general", "enableHandpump", this.enableHandpump).getBoolean(this.enableHandpump);
        this.enableFan = config.get("general", "enableFan", this.enableFan).getBoolean(this.enableFan);
        this.enableTunnelingShield = config.get("general", "enableTunnelingShield", this.enableTunnelingShield).getBoolean(this.enableTunnelingShield);
        this.enableRubberTreeSack = config.get("general", "enableRubberTreeSack", this.enableRubberTreeSack).getBoolean(this.enableRubberTreeSack);
        this.enableCollectors = config.get("general", "enableCollectors", this.enableCollectors).getBoolean(this.enableCollectors);
        this.enableWailers = config.get("general", "enableWailers", this.enableWailers).getBoolean(this.enableWailers);
        this.enableTDIT = config.get("general", "enableTDIT", this.enableTDIT).getBoolean(this.enableTDIT);
        this.enablePentlanditeProcessing = config.get("general", "enablePentlanditeProcessing", this.enablePentlanditeProcessing).getBoolean(this.enablePentlanditeProcessing);
        this.giveIHLManualOnPlayerWakeUpEvent = config.get("general", "giveIHLManualOnPlayerWakeUpEvent", this.giveIHLManualOnPlayerWakeUpEvent).getBoolean(this.giveIHLManualOnPlayerWakeUpEvent);
        this.generateApatiteOre = config.get("general", "generateApatiteOre", this.generateApatiteOre).getBoolean(this.generateApatiteOre);
        this.generateSaltpeterOre = config.get("general", "generateSaltpeterOre", this.generateSaltpeterOre).getBoolean(this.generateSaltpeterOre);
        this.generateLimestone = config.get("general", "generateLimestone", this.generateLimestone).getBoolean(this.generateLimestone);
        this.generateGypsum = config.get("general", "generateGypsum", this.generateGypsum).getBoolean(this.generateGypsum);
        this.generatePotassiumFeldspar = config.get("general", "generatePotassiumFeldspar", this.generatePotassiumFeldspar).getBoolean(this.generatePotassiumFeldspar);
        this.generateTrona = config.get("general", "generateTrona", this.generateTrona).getBoolean(this.generateTrona);
        this.generateRocksalt = config.get("general", "generateRocksalt", this.generateRocksalt).getBoolean(this.generateRocksalt);
        this.generateCinnabar = config.get("general", "generateCinnabar", this.generateCinnabar).getBoolean(this.generateCinnabar);
        this.generateGyubnera = config.get("general", "generateGyubnera", this.generateGyubnera).getBoolean(this.generateGyubnera);
        this.generateBauxite = config.get("general", "generateBauxite", this.generateBauxite).getBoolean(this.generateBauxite);
        this.generateChromite = config.get("general", "generateChromite", this.generateChromite).getBoolean(this.generateChromite);
        this.generateMuscovite = config.get("general", "generateMuscovite", this.generateMuscovite).getBoolean(this.generateMuscovite);
        this.generateOil = config.get("general", "generateOil", this.generateOil).getBoolean(this.generateOil);
        this.generateDatolite = config.get("general", "generateDatolite", this.generateDatolite).getBoolean(this.generateDatolite);
        this.generateSaltwater = config.get("general", "generateSaltwater", this.generateSaltwater).getBoolean(this.generateSaltwater);
        this.generateBischofite = config.get("general", "generateBischofite", this.generateBischofite).getBoolean(this.generateBischofite);
        this.chanceToGetSiliconDioxideFromSludge = config.get("general", "chanceToGetSiliconDioxideFromSludge", this.chanceToGetSiliconDioxideFromSludge).getInt();
        this.chanceToGetGoldFromSludge = config.get("general", "chanceToGetGoldFromSludge", this.chanceToGetGoldFromSludge).getInt();
        this.chanceToGetPlatinumFromSludge = config.get("general", "chanceToGetPlatinumFromSludge", this.chanceToGetPlatinumFromSludge).getInt();
        this.chanceToGetPalladiumFromSludge = config.get("general", "chanceToGetPalladiumFromSludge", this.chanceToGetPalladiumFromSludge).getInt();
        this.chanceToGetIridiumFromSludge = config.get("general", "chanceToGetIridiumFromSludge", this.chanceToGetIridiumFromSludge).getInt();
        this.chanceToGetOsmiumFromSludge = config.get("general", "chanceToGetOsmiumFromSludge", this.chanceToGetOsmiumFromSludge).getInt();
        this.handpumpTier = config.get("general", "handpumpTier", this.handpumpTier).getInt();
        this.handpumpMaxCharge = config.get("general", "handpumpMaxCharge", this.handpumpMaxCharge).getInt();
        this.handpumpOperationEUCost = config.get("general", "handpumpOperationEUCost", this.handpumpOperationEUCost).getInt();
        this.advancedHandpumpTier = config.get("general", "advancedHandpumpTier", this.advancedHandpumpTier).getInt();
        this.advancedHandpumpMaxCharge = config.get("general", "advancedHandpumpMaxCharge", this.advancedHandpumpMaxCharge).getInt();
        this.advancedHandpumpOperationEUCost = config.get("general", "advancedHandpumpOperationEUCost", this.advancedHandpumpOperationEUCost).getInt();
        this.blowerTier = config.get("general", "blowerTier", this.blowerTier).getInt();
        this.blowerMaxEnergyStorage = config.get("general", "blowerMaxEnergyStorage", this.blowerMaxEnergyStorage).getInt();
        this.blowerEnergyConsumePerTick = config.get("general", "blowerEnergyConsumePerTick", this.blowerEnergyConsumePerTick).getInt();
        this.tditTier = config.get("general", "tditTier", this.tditTier).getInt();
        this.tditMaxEnergyStorage = config.get("general", "tditMaxEnergyStorage", this.tditMaxEnergyStorage).getInt();
        this.tditEnergyConsumePerStack = config.get("general", "tditEnergyConsumePerStack", this.tditEnergyConsumePerStack).getInt();
        this.ts02DefaultTier = config.get("general", "ts02DefaultTier", this.ts02DefaultTier).getInt();
        this.ts02DefaultMaxEnergyStorage = config.get("general", "ts02DefaultMaxEnergyStorage", this.ts02DefaultMaxEnergyStorage).getInt();
        this.ts02DefaultSpeed = config.get("general", "ts02DefaultSpeed", this.ts02DefaultSpeed).getInt();
        this.ts02DefaultOperationEUCost = config.get("general", "ts02DefaultOperationEUCost", this.ts02DefaultOperationEUCost).getInt();
        this.harvesterTier = config.get("general", "harvesterTier", this.harvesterTier).getInt();
        this.harvesterMaxEnergyStorage = config.get("general", "harvesterMaxEnergyStorage", this.harvesterMaxEnergyStorage).getInt();
        this.harvesterIdleEUCost = config.get("general", "harvesterIdleEUCost", this.harvesterIdleEUCost).getInt();
        this.harvesterOperationEUCost = config.get("general", "harvesterOperationEUCost", this.harvesterOperationEUCost).getInt();
        this.enableFlexibleCablesGridPowerLossCalculations = config.get("general", "enableFlexibleCablesGridPowerLossCalculations", this.enableFlexibleCablesGridPowerLossCalculations).getBoolean(this.enableFlexibleCablesGridPowerLossCalculations);
        this.additionalPowerLossesAtFrequencyGenerator = config.get("general", "additionalPowerLossesAtFrequencyGenerator", this.additionalPowerLossesAtFrequencyGenerator).getDouble(this.additionalPowerLossesAtFrequencyGenerator);
        this.enableFlexibleCablesCrafting = config.get("general", "enableFlexibleCablesCrafting", this.enableFlexibleCablesCrafting).getBoolean(this.enableFlexibleCablesCrafting);
        this.mirrorReflectionRange = config.get("general", "mirrorReflectionRange", this.mirrorReflectionRange).getInt();
        this.mirrorReflectionUpdateSpeed = config.get("general", "mirrorReflectionUpdateSpeed", this.mirrorReflectionUpdateSpeed).getInt();
        Property blp = config.get("general", "ts02BlockBlackList", bl);
        Property wlp = config.get("general", "ts02BlockWhiteList", wl);
        if (blp.isList()) {
            this.ts02BlockBlackListString = config.get("general", "ts02BlockBlackList", bl).getStringList();
        } else {
            blp.set(bl);
            this.ts02BlockBlackListString = bl;
        }
        if (wlp.isList()) {
            this.ts02BlockWhiteListString = config.get("general", "ts02BlockWhiteList", wl).getStringList();
        } else {
            wlp.set(wl);
            this.ts02BlockWhiteListString = wl;
        }
        config.save();
    }

    private void loadRecipeConfig(InputStream resourceAsStream, boolean rewriteConfig) throws IOException {
        String line;
        OutputStreamWriter osWriter = null;
        BufferedWriter writer = null;
        if (rewriteConfig) {
            osWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(IHLModConfig.getFile()), "UTF-8");
            writer = new BufferedWriter(osWriter);
        }
        InputStreamReader isReader = new InputStreamReader(resourceAsStream, "UTF-8");
        LineNumberReader reader = new LineNumberReader(isReader);
        StringBuffer currentModificator = new StringBuffer("");
        int bracketCounter = 0;
        boolean modificatorStart = false;
        while ((line = reader.readLine()) != null) {
            if (osWriter != null) {
                writer.newLine();
                writer.append(line);
            }
            if ((line = IHLUtils.trim(line)).isEmpty() || line.startsWith("//") || line.startsWith(";")) continue;
            currentModificator.append(line);
            for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (c == '(') {
                    ++bracketCounter;
                    modificatorStart = true;
                } else if (c == ')') {
                    --bracketCounter;
                }
                if (bracketCounter != 0 || !modificatorStart) continue;
                this.processModificator(currentModificator.toString());
                modificatorStart = false;
                currentModificator.delete(0, currentModificator.length());
            }
        }
        isReader.close();
        if (osWriter != null) {
            writer.newLine();
            writer.newLine();
            writer.append("//Available machines:");
            writer.newLine();
            writer.append("//ironworkbench");
            Iterator<Map.Entry<String, UniversalRecipeManager>> urmi = UniversalRecipeManager.machineRecipeManagers.entrySet().iterator();
            while (urmi.hasNext()) {
                writer.newLine();
                writer.append("//" + urmi.next().getKey());
            }
            writer.close();
            osWriter.close();
        }
    }

    private void processModificator(String string) {
        String action = null;
        String machineName = null;
        String recipeInput = null;
        String recipeOutput = null;
        UniversalRecipeInput uRecipeInput = null;
        UniversalRecipeOutput uRecipeOutput = null;
        String[] functionAndParameters = this.extractFunctionAndParameters(string);
        action = functionAndParameters[0].toLowerCase();
        List<String> parameters = this.splitParameters(functionAndParameters[1]);
        for (String parameter : parameters) {
            if (parameter.equalsIgnoreCase("ironworkbench")) {
                machineName = parameter;
                continue;
            }
            if (UniversalRecipeManager.machineRecipeManagers.containsKey(parameter)) {
                machineName = parameter;
                continue;
            }
            if (parameter.startsWith("recipeinput")) {
                recipeInput = parameter;
                continue;
            }
            if (!parameter.startsWith("recipeoutput")) continue;
            recipeOutput = parameter;
        }
        ArrayList<IRecipeInput> recipeInputsItems = new ArrayList<IRecipeInput>();
        ArrayList<IRecipeInput> recipeInputsTools = new ArrayList<IRecipeInput>();
        ArrayList<ItemStack> recipeInputsMachines = new ArrayList<ItemStack>();
        if (recipeInput != null) {
            ArrayList<FluidStack> recipeInputsFluids = new ArrayList<FluidStack>();
            String[] rifunctionAndParameters = this.extractFunctionAndParameters(recipeInput);
            List<String> riparameters = this.splitParameters(rifunctionAndParameters[1]);
            for (String parameter : riparameters) {
                ItemStack stack;
                String[] modAndItemName;
                List<String> riItemStackparameters;
                String[] riItemFunctionAndParameters = this.extractFunctionAndParameters(parameter);
                if (riItemFunctionAndParameters[0].startsWith("itemstack")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    modAndItemName = riItemStackparameters.get(0).split(":");
                    stack = IHLUtils.getOtherModItemStackWithDamage(modAndItemName[0], modAndItemName[1], Integer.parseInt(riItemStackparameters.get(2)));
                    stack.field_77994_a = Integer.parseInt(riItemStackparameters.get(1));
                    recipeInputsItems.add((IRecipeInput)new RecipeInputItemStack(stack, stack.field_77994_a));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("die")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    recipeInputsItems.add(new RecipeInputDie("setOfDies1_5sqmm", Integer.parseInt(riItemStackparameters.get(0))));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("fiber")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    ItemStack stack2 = IHLUtils.getThisModWireItemStackWithLength(riItemStackparameters.get(0), Integer.parseInt(riItemStackparameters.get(1)));
                    recipeInputsItems.add(new RecipeInputWire(stack2, Integer.parseInt(riItemStackparameters.get(1))));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("wire")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    recipeInputsItems.add(new RecipeInputWire(riItemStackparameters.get(0), Integer.parseInt(riItemStackparameters.get(1)), Integer.parseInt(riItemStackparameters.get(2))));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("cable")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    recipeInputsItems.add(new RecipeInputWire(riItemStackparameters.get(0), Integer.parseInt(riItemStackparameters.get(1)), Integer.parseInt(riItemStackparameters.get(2)), riItemStackparameters.get(3), Integer.parseInt(riItemStackparameters.get(4)), Integer.parseInt(riItemStackparameters.get(5))));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("oredict")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    recipeInputsItems.add((IRecipeInput)new RecipeInputOreDict(riItemStackparameters.get(0), Integer.parseInt(riItemStackparameters.get(1))));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("toolitemstack")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    modAndItemName = riItemStackparameters.get(0).split(":");
                    stack = IHLUtils.getOtherModItemStackWithDamage(modAndItemName[0], modAndItemName[1], Integer.parseInt(riItemStackparameters.get(2)));
                    stack.field_77994_a = Integer.parseInt(riItemStackparameters.get(1));
                    recipeInputsTools.add((IRecipeInput)new RecipeInputItemStack(stack, stack.field_77994_a));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("tooloredict")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    recipeInputsTools.add((IRecipeInput)new RecipeInputOreDict(riItemStackparameters.get(0), Integer.parseInt(riItemStackparameters.get(1))));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("machine")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    modAndItemName = riItemStackparameters.get(0).split(":");
                    recipeInputsMachines.add(IHLUtils.getThisModItemStack(modAndItemName[1]));
                    continue;
                }
                if (!riItemFunctionAndParameters[0].startsWith("fluidstack")) continue;
                List<String> riFluidStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                recipeInputsFluids.add(IHLUtils.getFluidStackWithSize(riFluidStackparameters.get(0), Integer.parseInt(riFluidStackparameters.get(1))));
            }
            uRecipeInput = new UniversalRecipeInput(recipeInputsFluids, recipeInputsItems);
        }
        ArrayList<ItemStack> recipeOutputsItems = new ArrayList<ItemStack>();
        ArrayList<RecipeOutputItemStack> recipeOutputsRecipeOut = new ArrayList<RecipeOutputItemStack>();
        if (recipeOutput != null) {
            ArrayList<FluidStack> recipeOutputsFluids = new ArrayList<FluidStack>();
            String[] rifunctionAndParameters = this.extractFunctionAndParameters(recipeOutput);
            List<String> riparameters = this.splitParameters(rifunctionAndParameters[1]);
            for (String parameter : riparameters) {
                ItemStack stack;
                List<String> riItemStackparameters;
                String[] riItemFunctionAndParameters = this.extractFunctionAndParameters(parameter);
                if (riItemFunctionAndParameters[0].startsWith("itemstack")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    String[] modAndItemName = riItemStackparameters.get(0).split(":");
                    ItemStack stack3 = IHLUtils.getOtherModItemStackWithDamage(modAndItemName[0], modAndItemName[1], Integer.parseInt(riItemStackparameters.get(2)));
                    stack3.field_77994_a = Integer.parseInt(riItemStackparameters.get(1));
                    recipeOutputsItems.add(stack3);
                    recipeOutputsRecipeOut.add(new RecipeOutputItemStack(stack3, Float.parseFloat(riItemStackparameters.get(1))));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("fiber")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    stack = IHLUtils.getThisModWireItemStackWithLength(riItemStackparameters.get(0), Integer.parseInt(riItemStackparameters.get(1)));
                    recipeOutputsItems.add(stack);
                    recipeOutputsRecipeOut.add(new RecipeOutputItemStack(stack, 1.0f));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("wire")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    stack = IHLUtils.getUninsulatedWire(riItemStackparameters.get(0), Integer.parseInt(riItemStackparameters.get(1)), Integer.parseInt(riItemStackparameters.get(2)));
                    recipeOutputsItems.add(stack);
                    recipeOutputsRecipeOut.add(new RecipeOutputItemStack(stack, 1.0f));
                    continue;
                }
                if (riItemFunctionAndParameters[0].startsWith("cable")) {
                    riItemStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                    stack = IHLUtils.getInsulatedWire(riItemStackparameters.get(0), Integer.parseInt(riItemStackparameters.get(1)), Integer.parseInt(riItemStackparameters.get(2)), riItemStackparameters.get(3), Integer.parseInt(riItemStackparameters.get(4)));
                    recipeOutputsItems.add(stack);
                    recipeOutputsRecipeOut.add(new RecipeOutputItemStack(stack, 1.0f));
                    continue;
                }
                if (!riItemFunctionAndParameters[0].startsWith("fluidstack")) continue;
                List<String> riFluidStackparameters = this.splitParameters(riItemFunctionAndParameters[1]);
                recipeOutputsFluids.add(IHLUtils.getFluidStackWithSize(riFluidStackparameters.get(0), Integer.parseInt(riFluidStackparameters.get(1))));
            }
            uRecipeOutput = new UniversalRecipeOutput(recipeOutputsFluids, recipeOutputsRecipeOut, 200);
        }
        if (action.equalsIgnoreCase("addrecipe")) {
            if (machineName.equalsIgnoreCase("ironworkbench")) {
                IronWorkbenchTileEntity.addRecipe(new IronWorkbenchRecipe(recipeInputsTools, recipeInputsItems, recipeOutputsItems, recipeInputsMachines));
            } else {
                UniversalRecipeManager.machineRecipeManagers.get(machineName).addRecipe(uRecipeInput, uRecipeOutput);
            }
        } else if (action.equalsIgnoreCase("removerecipe")) {
            if (machineName.equalsIgnoreCase("ironworkbench")) {
                if (recipeInputsTools.isEmpty() && recipeInputsItems.isEmpty() && recipeInputsMachines.isEmpty()) {
                    IronWorkbenchTileEntity.removeRecipeByOutput(recipeOutputsItems);
                } else {
                    IronWorkbenchTileEntity.removeRecipeByInput(recipeInputsTools, recipeInputsItems, recipeInputsMachines);
                }
            } else if (uRecipeInput == null) {
                UniversalRecipeManager.machineRecipeManagers.get(machineName).removeRecipeByOutput(uRecipeOutput);
            } else {
                UniversalRecipeManager.machineRecipeManagers.get(machineName).removeRecipeByInput(uRecipeInput);
            }
        }
    }

    private List<String> splitParameters(String string) {
        ArrayList<String> result = new ArrayList<String>();
        int bracketCounter = 0;
        boolean modificatorStart = false;
        Object function = null;
        Object parameters = null;
        StringBuffer currentModificator = new StringBuffer("");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ',') {
                if (!modificatorStart) {
                    result.add(currentModificator.toString());
                    currentModificator.delete(0, currentModificator.length());
                }
            } else if (c == '(') {
                ++bracketCounter;
                modificatorStart = true;
            } else if (c == ')') {
                --bracketCounter;
            }
            if (bracketCounter == 0 && modificatorStart) {
                modificatorStart = false;
            }
            if (c == ',' && !modificatorStart) continue;
            currentModificator.append(c);
        }
        result.add(currentModificator.toString());
        return result;
    }

    private String[] extractFunctionAndParameters(String string) {
        int bracketCounter = 0;
        boolean modificatorStart = false;
        String function = null;
        String parameters = null;
        StringBuffer currentModificator = new StringBuffer("");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '(') {
                ++bracketCounter;
                if (!modificatorStart) {
                    function = currentModificator.toString();
                    currentModificator.delete(0, currentModificator.length());
                    modificatorStart = true;
                }
            } else if (c == ')') {
                --bracketCounter;
            }
            if (bracketCounter == 0 && modificatorStart) {
                parameters = currentModificator.substring(1, currentModificator.length());
                break;
            }
            currentModificator.append(c);
        }
        return new String[]{function, parameters};
    }

    private void loadRecipeConfig(File configFile) throws IOException {
        FileInputStream is = new FileInputStream(configFile);
        this.loadRecipeConfig(is, false);
    }

    public void CheckLists() {
        ItemStack stack;
        Block block;
        String blockName;
        for (int i6 = 0; i6 < this.ts02BlockBlackListString.length; ++i6) {
            blockName = this.ts02BlockBlackListString[i6];
            block = Block.func_149684_b((String)blockName);
            if (block != null || (stack = IC2Items.getItem((String)blockName)) == null) continue;
            block = StackUtil.getBlock((ItemStack)stack);
        }
        for (int i7 = 0; i7 < this.ts02BlockWhiteListString.length; ++i7) {
            blockName = this.ts02BlockWhiteListString[i7];
            block = Block.func_149684_b((String)blockName);
            if (block != null || (stack = IC2Items.getItem((String)blockName)) == null) continue;
            Block block2 = StackUtil.getBlock((ItemStack)stack);
        }
    }

    private static File getFile() {
        File folder = new File(IHLMod.proxy.getMinecraftDir(), "config");
        folder.mkdirs();
        return new File(folder, "ihl-recipe.cfg");
    }

    public void loadRecipeModificators() throws IOException {
        File configFile = IHLModConfig.getFile();
        if (configFile.exists()) {
            this.loadRecipeConfig(configFile);
        } else {
            InputStream inputStream = IHLMod.class.getResourceAsStream("/assets/ihl/config/ihl-recipe.cfg");
            this.loadRecipeConfig(inputStream, true);
        }
    }
}

