/*
 * Decompiled with CFR 0.152.
 */
package ihl.datanet;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.network.NetworkManager;
import ihl.IHLMod;
import ihl.datanet.Contact;
import ihl.datanet.DataCableItem;
import ihl.datanet.RedstoneSignalConverterContainer;
import ihl.datanet.RedstoneSignalConverterGui;
import ihl.interfaces.IDataCableHolder;
import ihl.interfaces.IDataNode;
import ihl.processing.invslots.InvSlotSignalProcessor;
import ihl.utils.IHLInvSlotDischarge;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class RedstoneSignalConverterTileEntity
extends TileEntityInventory
implements IDataCableHolder,
INetworkClientTileEntityEventListener,
IHasGui {
    public final InvSlotSignalProcessor sensorEmitterSlots;
    public final InvSlotSignalProcessor cableSlots;
    public final IHLInvSlotDischarge dischargeSlot;
    public final List<Integer> links = new ArrayList<Integer>();
    public int prevButtonPressed = -1;
    public short energy = 0;
    public static final short maxEnergy = Short.MAX_VALUE;
    private int tick = 0;
    public boolean linksOrInventoryChanged = false;
    private int inventoryCheckSum = 0;
    public final Contact[] contacts = new Contact[68];
    private NBTTagCompound nbtread;
    public boolean checkCables = true;

    public RedstoneSignalConverterTileEntity() {
        int i1;
        this.sensorEmitterSlots = new InvSlotSignalProcessor(this, "sensorEmitterSlots", 0, InvSlot.Access.IO, 6, 2);
        this.cableSlots = new InvSlotSignalProcessor(this, "cableSlots", 1, InvSlot.Access.NONE, 4, 8);
        this.cableSlots.setStackSizeLimit(1);
        this.dischargeSlot = new IHLInvSlotDischarge(this, 2, InvSlot.Access.IO, 4);
        this.contacts[0] = new Contact((TileEntity)this, 0, null, -1, 0);
        this.contacts[1] = new Contact((TileEntity)this, 1, null, -1, 1);
        for (i1 = 2; i1 < 8; ++i1) {
            this.contacts[i1] = new Contact((TileEntity)this, i1, this.sensorEmitterSlots, i1 - 2, 0);
        }
        for (i1 = 8; i1 < 14; ++i1) {
            this.sensorEmitterSlots.setStackSizeLimit(1);
            this.contacts[i1] = new Contact((TileEntity)this, i1, this.sensorEmitterSlots, i1 - 8, 1);
        }
        for (i1 = 14; i1 < 50; ++i1) {
            this.contacts[i1] = new Contact((TileEntity)this, i1, null, -1, -1);
        }
        for (i1 = 50; i1 < 56; ++i1) {
            this.contacts[i1] = new Contact((TileEntity)this, i1, this.sensorEmitterSlots, i1 - 50, 2);
        }
        for (i1 = 56; i1 < 62; ++i1) {
            this.contacts[i1] = new Contact((TileEntity)this, i1, this.sensorEmitterSlots, i1 - 56, 3);
        }
        for (i1 = 62; i1 < 68; ++i1) {
            this.contacts[i1] = new Contact((TileEntity)this, i1, this.sensorEmitterSlots, i1 - 2, 4);
        }
    }

    public boolean wrenchCanRemove(EntityPlayer var1) {
        return this.cableSlots.isEmpty();
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "sensorEmitterSlots");
            if (this.nbtread != null) {
                for (Contact contact1 : this.contacts) {
                    contact1.readFromNBT(this.nbtread);
                }
            }
            this.nbtread = null;
        }
    }

    public List<String> getNetworkedFields() {
        List fields = super.getNetworkedFields();
        fields.add("sensorEmitterSlots");
        return fields;
    }

    public void updateEntityClient() {
        int checkSum = 0;
        for (int i = 0; i < this.sensorEmitterSlots.size(); ++i) {
            if (this.sensorEmitterSlots.get(i) == null) continue;
            if (IHLUtils.isItemStacksIsEqual(this.sensorEmitterSlots.get(i), Ic2Items.splitterCableItem, true)) {
                ++checkSum;
                continue;
            }
            if (!IHLUtils.isItemStacksIsEqual(this.sensorEmitterSlots.get(i), Ic2Items.detectorCableItem, true)) continue;
            checkSum += 2;
        }
        if (checkSum != this.inventoryCheckSum) {
            this.inventoryCheckSum = checkSum;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.linksOrInventoryChanged && this.energy > 0) {
            HashSet<Integer> checkedGrids = new HashSet<Integer>();
            HashSet<Integer> unCheckedGrids = new HashSet<Integer>();
            InvSlotSignalProcessor slots = this.sensorEmitterSlots;
            for (int i = 0; i < slots.size(); ++i) {
                Contact c4;
                ItemStack is = slots.get(i);
                if (is == null || !IHLUtils.isItemStacksIsEqual(is, Ic2Items.splitterCableItem, true)) continue;
                int dgid1 = this.contacts[i + 2].getDataGridID();
                int dgid2 = this.contacts[i + 8].getDataGridID();
                if (dgid1 != -1) {
                    for (IDataNode contact3 : IHLMod.datanet.getGrid((int)dgid1).telist) {
                        contact3.checkAttachedSlots();
                        if (contact3.getAttachedSlot() == null || checkedGrids.contains((c4 = contact3.getAttachedSlot().getOppositeContact(contact3)).getDataGridID())) continue;
                        unCheckedGrids.add(c4.getDataGridID());
                    }
                    checkedGrids.add(dgid1);
                }
                if (dgid2 == -1 || dgid2 == dgid1) continue;
                for (IDataNode contact3 : IHLMod.datanet.getGrid((int)dgid2).telist) {
                    contact3.checkAttachedSlots();
                    if (contact3.getAttachedSlot() == null || checkedGrids.contains((c4 = contact3.getAttachedSlot().getOppositeContact(contact3)).getDataGridID())) continue;
                    unCheckedGrids.add(c4.getDataGridID());
                }
                checkedGrids.add(dgid2);
            }
            Iterator ugi = unCheckedGrids.iterator();
            while (!unCheckedGrids.isEmpty()) {
                Integer dgid2 = (Integer)ugi.next();
                ugi.remove();
                for (IDataNode contact3 : IHLMod.datanet.getGrid((int)dgid2.intValue()).telist) {
                    Contact c4;
                    contact3.checkAttachedSlots();
                    if (contact3.getAttachedSlot() == null || checkedGrids.contains((c4 = contact3.getAttachedSlot().getOppositeContact(contact3)).getDataGridID())) continue;
                    unCheckedGrids.add(c4.getDataGridID());
                }
                checkedGrids.add(dgid2);
            }
            this.linksOrInventoryChanged = false;
        }
        if (this.energy < 1) {
            this.energy = (short)(this.energy + (short)(this.dischargeSlot.discharge(this.getDemandedEnergy(), false) * 256.0));
        }
        if (this.tick++ % 256 == 0) {
            this.energy = (short)(this.energy - 1);
        }
    }

    public String func_145825_b() {
        return "redstoneSignalConverter";
    }

    @Override
    public boolean addDataCable(ItemStack cable) {
        for (int i = 0; i < this.cableSlots.size(); ++i) {
            if (this.cableSlots.get(i) != null) continue;
            this.cableSlots.put(i, cable);
            return true;
        }
        return false;
    }

    @Override
    public double[] getPortPos(EntityLivingBase player) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)IHLUtils.getFacingFromPlayerView(player, true)).getOpposite();
        return new double[]{(double)this.field_145851_c + 0.5 + 0.5 * (double)direction.offsetX, (double)this.field_145848_d + (double)direction.offsetY * 1.0, (double)this.field_145849_e + 0.5 + 0.5 * (double)direction.offsetZ};
    }

    @Override
    public Set<Integer> getDataCableList() {
        HashSet<Integer> dataCableList = new HashSet<Integer>();
        for (int i = 0; i < this.cableSlots.size(); ++i) {
            if (this.cableSlots.get(i) == null || !(this.cableSlots.get(i).func_77973_b() instanceof DataCableItem)) continue;
            dataCableList.add(this.cableSlots.get((int)i).field_77990_d.func_74762_e("chainUID"));
        }
        return dataCableList;
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        if (this.prevButtonPressed == -1 && event < 255) {
            this.prevButtonPressed = event;
        } else if (this.prevButtonPressed != event && event < 255) {
            int minor = Math.min(this.prevButtonPressed, event);
            int major = Math.max(this.prevButtonPressed, event);
            int link = minor << 8 | major;
            this.links.add(link);
            this.contacts[this.prevButtonPressed].establishLink(this.contacts[event]);
            this.prevButtonPressed = -1;
        } else if (event == 256 && !this.links.isEmpty()) {
            int link = this.links.remove(this.links.size() - 1);
            Contact contact1 = this.contacts[link >> 8];
            Contact contact2 = this.contacts[link & 0xFF];
            contact1.removeLinkTo(contact2);
        } else if (event == 257 && !this.links.isEmpty()) {
            this.links.clear();
            for (Contact contact1 : this.contacts) {
                contact1.removeConnections(this.contacts);
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (Contact contact1 : this.contacts) {
            contact1.writeToNBT(nbt);
        }
        if (!this.links.isEmpty()) {
            NBTTagList linkList1 = new NBTTagList();
            for (Integer link : this.links) {
                if (link == null) continue;
                NBTTagCompound linkNBT1 = new NBTTagCompound();
                linkNBT1.func_74768_a("link", link.intValue());
                linkList1.func_74742_a((NBTBase)linkNBT1);
            }
            nbt.func_74782_a("links", (NBTBase)linkList1);
        } else {
            nbt.func_74778_a("Empty", "");
        }
        nbt.func_74757_a("checkCables", this.checkCables);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (!nbt.func_74764_b("Empty")) {
            NBTTagList ll = nbt.func_150295_c("links", 10);
            for (int i = 0; i < ll.func_74745_c(); ++i) {
                NBTTagCompound llNBT1 = ll.func_150305_b(i);
                this.links.add(llNBT1.func_74762_e("link"));
            }
        }
        this.nbtread = nbt;
        this.checkCables = nbt.func_74767_n("checkCables");
    }

    public double getDemandedEnergy() {
        return (double)(Short.MAX_VALUE - this.energy) / 256.0;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean flag) {
        return new RedstoneSignalConverterGui(new RedstoneSignalConverterContainer(player, this));
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        return new RedstoneSignalConverterContainer(player, this);
    }

    public int getGUIEnergy(int i) {
        if ((float)this.energy < Float.MAX_VALUE) {
            return Math.round((float)this.energy / 32767.0f * (float)i);
        }
        return Math.round((float)((double)this.energy / 32767.0) * (float)i);
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public int isProvidingRedstonePower(int side) {
        return this.sensorEmitterSlots.isSlotActivated(side) ? 15 : 0;
    }

    public void removeAttachedChains() {
        Set<Integer> cl = this.getDataCableList();
        if (!cl.isEmpty()) {
            IHLMod.datanet.removeCableEntities(cl);
            for (int i = 0; i < this.cableSlots.size(); ++i) {
                TileEntity te;
                ItemStack is = this.cableSlots.get(i);
                if (is == null || is.field_77990_d == null) continue;
                int chainUID = is.field_77990_d.func_74762_e("chainUID");
                int x1 = is.field_77990_d.func_74762_e("connectorX1");
                int y1 = is.field_77990_d.func_74762_e("connectorY1");
                int z1 = is.field_77990_d.func_74762_e("connectorZ1");
                int x = is.field_77990_d.func_74762_e("connectorX");
                int y = is.field_77990_d.func_74762_e("connectorY");
                int z = is.field_77990_d.func_74762_e("connectorZ");
                if (x1 != this.field_145851_c || y1 != this.field_145848_d || z1 != this.field_145849_e) {
                    x = x1;
                    y = y1;
                    z = z1;
                }
                if (!((te = this.field_145850_b.func_147438_o(x, y, z)) instanceof IDataCableHolder)) continue;
                IDataCableHolder dch = (IDataCableHolder)te;
                Contact[] c = this.getContacts(chainUID);
                Contact[] c1 = dch.getContacts(chainUID);
                for (int i2 = 0; i2 < c.length; ++i2) {
                    c[i2].removeLinkTo(c1[i2]);
                }
                dch.removeCable(chainUID);
                this.removeCable(chainUID);
            }
        }
    }

    @Override
    public InvSlotSignalProcessor getDataCableSlots() {
        return this.cableSlots;
    }

    @Override
    public Contact[] getContacts(int chainUID) {
        for (int i = 0; i < this.cableSlots.size(); ++i) {
            ItemStack is = this.cableSlots.get(i);
            if (is == null || is.field_77990_d == null || is.field_77990_d.func_74762_e("chainUID") != chainUID) continue;
            Contact[] contactsOut = new Contact[8];
            for (int i1 = 0; i1 < contactsOut.length; ++i1) {
                contactsOut[i1] = this.contacts[i1 + i * 8 + 14];
            }
            return contactsOut;
        }
        return null;
    }

    @Override
    public void removeCable(int chainUID) {
        for (int i = 0; i < this.cableSlots.size(); ++i) {
            int chainUID1;
            ItemStack is = this.cableSlots.get(i);
            if (is == null || is.field_77990_d == null || (chainUID1 = is.field_77990_d.func_74762_e("chainUID")) != chainUID) continue;
            this.cableSlots.put(i, null);
            return;
        }
    }

    @Override
    public Contact getContact(int innerId1) {
        return this.contacts[innerId1];
    }

    @Override
    public boolean isCableRemoved(int chainUniqueID) {
        if (!this.checkCables) {
            return false;
        }
        for (int i = 0; i < this.cableSlots.size(); ++i) {
            ItemStack citem = this.cableSlots.get(i);
            if (citem == null || citem.field_77990_d == null || citem.field_77990_d.func_74762_e("chainUID") != chainUniqueID) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setCableCheck(boolean b) {
        this.checkCables = b;
    }
}

