/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.chemistry;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.IC2Items;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.network.NetworkManager;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import ihl.IHLMod;
import ihl.processing.chemistry.ElectricEvaporatorContainer;
import ihl.processing.chemistry.ElectricEvaporatorGui;
import ihl.processing.chemistry.EvaporatorTileEntity;
import ihl.utils.IHLInvSlotDischarge;
import ihl.utils.IHLUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidTank;

public class ElectricEvaporatorTileEntity
extends EvaporatorTileEntity
implements IEnergySink,
IUpgradableBlock,
INetworkTileEntityEventListener {
    public final InvSlotUpgrade upgradeSlot;
    private int tier;
    private int lastTier;
    public int maxStorage;
    private int defaultMaxStorage;
    private double energy;
    public final int defaultEnergyConsume;
    public final int defaultOperationLength;
    public final int defaultTier;
    public int energyConsume = 8;
    public AudioSource audioSource;
    private static final int EventStart = 0;
    private static final int EventInterrupt = 1;
    private static final int EventStop = 2;
    private int updateChecksum = 0;
    private boolean addedToEnergyNet = false;

    public ElectricEvaporatorTileEntity() {
        this.defaultEnergyConsume = 8;
        this.maxProgress = (short)400;
        this.defaultOperationLength = 400;
        this.energy = 0.0;
        this.defaultTier = 1;
        this.tier = 1;
        this.lastTier = 1;
        this.maxStorage = this.defaultMaxStorage = this.defaultEnergyConsume * this.defaultOperationLength;
        this.fuelSlot = new IHLInvSlotDischarge((TileEntityInventory)this, 1, InvSlot.Access.IO, this.tier, InvSlot.InvSide.BOTTOM);
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 4, 4);
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public List<String> getNetworkedFields() {
        List fields = super.getNetworkedFields();
        fields.add("tier");
        fields.add("maxStorage");
        return fields;
    }

    public void setOverclockRates() {
        int speedUp = 0;
        int tierUp = 0;
        int capacityUp = 0;
        int checksum = 0;
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            if (this.upgradeSlot.get(i) == null) continue;
            if (this.upgradeSlot.get(i).func_77960_j() == IC2Items.getItem((String)"overclockerUpgrade").func_77960_j()) {
                speedUp += this.upgradeSlot.get((int)i).field_77994_a;
            }
            if (this.upgradeSlot.get(i).func_77960_j() == IC2Items.getItem((String)"transformerUpgrade").func_77960_j()) {
                tierUp += this.upgradeSlot.get((int)i).field_77994_a;
            }
            if (this.upgradeSlot.get(i).func_77960_j() != IC2Items.getItem((String)"energyStorageUpgrade").func_77960_j()) continue;
            capacityUp += this.upgradeSlot.get((int)i).field_77994_a;
        }
        checksum = speedUp * 4096 + tierUp * 64 + capacityUp;
        if (this.updateChecksum != checksum) {
            this.maxProgress = (short)Math.max((double)this.defaultOperationLength * Math.pow(0.7, speedUp), 2.0);
            this.maxStorage = this.defaultMaxStorage + capacityUp * 10000;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "maxStorage");
            this.energyConsume = (int)Math.min((double)this.defaultEnergyConsume * Math.pow(1.6, speedUp), (double)this.maxStorage);
            this.tier = this.defaultTier + tierUp;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "tier");
            this.updateChecksum = checksum;
        }
    }

    public void onUnloaded() {
        super.onUnloaded();
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources((Object)this);
            this.audioSource = null;
        }
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74769_h("energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side && side != 0 && side != 1;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        if (this.outputSlot.get() != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.outputSlot.get()));
        }
        if (this.fuelSlot.get() != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.fuelSlot.get()));
        }
        if (this.emptyFluidItemsSlot.get() != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.emptyFluidItemsSlot.get()));
        }
        if (this.upgradeSlot.get(0) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(0)));
        }
        if (this.upgradeSlot.get(1) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(1)));
        }
        if (this.upgradeSlot.get(2) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(2)));
        }
        if (this.upgradeSlot.get(3) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(3)));
        }
        return new ItemStack(IHLMod.electricEvaporatorBlock, 1);
    }

    public int getGUIEnergy(int i) {
        if (this.energy < 3.4028234663852886E38) {
            return Math.round((float)this.energy / (float)this.maxStorage * (float)i);
        }
        return Math.round((float)(this.energy / (double)this.maxStorage) * (float)i);
    }

    @Override
    public boolean enableUpdateEntity() {
        return true;
    }

    public void updateEntityClient() {
        if (((IHLInvSlotDischarge)this.fuelSlot).tier != this.tier) {
            ((IHLInvSlotDischarge)this.fuelSlot).tier = this.tier;
        }
    }

    @Override
    public void updateEntityServer() {
        if (((IHLInvSlotDischarge)this.fuelSlot).tier != this.tier) {
            ((IHLInvSlotDischarge)this.fuelSlot).tier = this.tier;
        }
        if (IC2.platform.isSimulating()) {
            boolean needsInvUpdate = false;
            this.setOverclockRates();
            if (this.getDemandedEnergy() > 1.0) {
                double amount = ((IHLInvSlotDischarge)this.fuelSlot).discharge(this.getDemandedEnergy(), false);
                this.energy += amount;
            }
            if (this.needsFluid()) {
                IHLUtils.handleFluidSlotsBehaviour(null, this.fluidItemsSlot, this.emptyFluidItemsSlot, (IFluidTank)this.fluidTank);
            }
            if (this.canOperate() && this.energy >= (double)this.energyConsume) {
                this.setActive(true);
                if (this.progress == 0) {
                    ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 0, true);
                }
                this.progress = (short)(this.progress + 1);
                this.energy -= (double)this.energyConsume;
                if (this.progress >= this.maxProgress) {
                    this.operate();
                    needsInvUpdate = true;
                    this.progress = 0;
                    ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 2, true);
                }
            } else {
                if (this.progress != 0 && this.getActive()) {
                    ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 1, true);
                }
                if (!this.canOperate()) {
                    this.progress = 0;
                }
                this.setActive(false);
            }
            for (int i = 0; i < this.upgradeSlot.size(); ++i) {
                ItemStack stack = this.upgradeSlot.get(i);
                if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem) || !((IUpgradeItem)stack.func_77973_b()).onTick(stack, (IUpgradableBlock)this)) continue;
                needsInvUpdate = true;
            }
        }
    }

    private static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round(((double)base + (double)extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    public void onNetworkEvent(int event) {
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IC2.audioManager.createSource((Object)this, this.getStartSoundFile());
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }

    public String getStartSoundFile() {
        return "Machines/Electro Furnace/ElectroFurnaceLoop.ogg";
    }

    @Override
    public String func_145825_b() {
        return "Electric evaporator";
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ElectricEvaporatorContainer(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new ElectricEvaporatorGui(new ElectricEvaporatorContainer(entityPlayer, this));
    }

    @Override
    public boolean getGui(EntityPlayer player) {
        return this instanceof IHasGui ? (IC2.platform.isSimulating() ? IC2.platform.launchGui(player, (IHasGui)this) : true) : false;
    }

    @Override
    public int mX() {
        switch (this.getFacing()) {
            case 4: {
                return -1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int mZ() {
        switch (this.getFacing()) {
            case 2: {
                return -1;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    public void setEnergy(double i) {
        this.energy = i;
    }

    public double getDemandedEnergy() {
        return (double)this.maxStorage - this.energy;
    }

    public int getSinkTier() {
        return this.tier;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= (double)this.maxStorage) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public ItemStack getOutput(int arg0) {
        return this.outputSlot.get(arg0);
    }

    public int getOutputSize() {
        return this.outputSlot.size();
    }

    public void setOutput(int arg0, ItemStack arg1) {
        this.outputSlot.put(arg0, arg1);
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        HashSet<UpgradableProperty> properties = new HashSet<UpgradableProperty>();
        properties.add(UpgradableProperty.ItemProducing);
        properties.add(UpgradableProperty.EnergyStorage);
        properties.add(UpgradableProperty.Transformer);
        return properties;
    }
}

