/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.chemistry;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IC2Items;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.TileEntityLiquidTankInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableFuel;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotOutput;
import ihl.IHLMod;
import ihl.processing.chemistry.EvaporatorContainer;
import ihl.processing.chemistry.EvaporatorGui;
import ihl.processing.invslots.IHLInvSlotOutput;
import ihl.processing.invslots.InvSlotConsumableLiquidIHL;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLUtils;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class EvaporatorTileEntity
extends TileEntityLiquidTankInventory
implements IHasGui {
    public final IHLInvSlotOutput outputSlot;
    public InvSlot fuelSlot;
    public final InvSlotConsumableLiquidIHL fluidItemsSlot;
    public final InvSlotConsumableLiquidIHL fillItemsSlot;
    public final InvSlotOutput emptyFluidItemsSlot;
    public short progress = 0;
    public short maxProgress = (short)450;
    public int fuel = 0;
    public int maxFuel = 0;
    protected static final UniversalRecipeManager recipeManager = new UniversalRecipeManager("evaporator");

    public EvaporatorTileEntity() {
        super(8);
        this.outputSlot = new IHLInvSlotOutput((TileEntityInventory)this, "output", 0, 1);
        this.fuelSlot = new InvSlotConsumableFuel((TileEntityInventory)this, "fuel", 1, 1, true);
        this.fluidItemsSlot = new InvSlotConsumableLiquidIHL((TileEntityInventory)this, "drainInput", 2, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Drain);
        this.fillItemsSlot = new InvSlotConsumableLiquidIHL((TileEntityInventory)this, "fillInput", 4, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Fill);
        this.emptyFluidItemsSlot = new InvSlotOutput((TileEntityInventory)this, "fluidCellsOutput", 3, 1);
    }

    public static void init() {
        EvaporatorTileEntity.addRecipe(new FluidStack(FluidRegistry.getFluid((String)"fluidrubbertreesap"), 200), IC2Items.getItem((String)"resin"));
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.fuel = nbttagcompound.func_74762_e("fuel");
        }
        catch (Throwable var4) {
            this.fuel = nbttagcompound.func_74765_d("fuel");
        }
        try {
            this.maxFuel = nbttagcompound.func_74762_e("maxFuel");
        }
        catch (Throwable var3) {
            this.maxFuel = nbttagcompound.func_74765_d("maxFuel");
        }
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("fuel", this.fuel);
        nbttagcompound.func_74768_a("maxFuel", this.maxFuel);
        nbttagcompound.func_74777_a("progress", this.progress);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side && side != 0 && side != 1;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        if (this.outputSlot.get() != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.outputSlot.get()));
        }
        if (this.fuelSlot.get() != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.fuelSlot.get()));
        }
        if (this.emptyFluidItemsSlot.get() != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.emptyFluidItemsSlot.get()));
        }
        return new ItemStack(IHLMod.evaporatorBlock, 1);
    }

    public int gaugeProgressScaled(int i) {
        return this.progress * i / this.maxProgress;
    }

    public int gaugeFuelScaled(int i) {
        if (this.maxFuel == 0) {
            this.maxFuel = this.fuel;
            if (this.maxFuel == 0) {
                this.maxFuel = 160;
            }
        }
        return this.fuel * i / this.maxFuel;
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        if (this.needsFluid()) {
            IHLUtils.handleFluidSlotsBehaviour(this.fillItemsSlot, this.fluidItemsSlot, this.emptyFluidItemsSlot, (IFluidTank)this.fluidTank);
        }
        if (this.fuel <= 0 && this.canOperate()) {
            this.fuel = this.maxFuel = ((InvSlotConsumableFuel)this.fuelSlot).consumeFuel();
            if (this.fuel > 0) {
                needsInvUpdate = true;
            }
        }
        if (this.isBurning() && this.canOperate()) {
            this.progress = (short)(this.progress + 1);
            if (this.progress >= this.maxProgress) {
                this.progress = 0;
                this.operate();
                needsInvUpdate = true;
            }
        } else {
            this.progress = 0;
        }
        if (this.fuel > 0) {
            --this.fuel;
        }
        if (this.getActive() != this.isBurning()) {
            this.setActive(this.isBurning());
            needsInvUpdate = true;
        }
    }

    public void operate() {
        UniversalRecipeOutput output = this.getOutput();
        if (output != null && !output.getItemOutputs().isEmpty()) {
            this.outputSlot.add(this.getOutput().getItemOutputs().get(0).copy());
        }
        this.fluidTank.drain(recipeManager.getRecipeInput(Arrays.asList(this.fluidTank.getFluid()), null).getFluidInputs().get(0).getAmount(), true);
    }

    public boolean isBurning() {
        return this.fuel > 0;
    }

    public boolean canOperate() {
        if (this.fluidTank.getFluid() == null) {
            return false;
        }
        UniversalRecipeOutput output = recipeManager.getOutputFor(Arrays.asList(this.fluidTank.getFluid()), null, false, false);
        return output == null ? false : this.outputSlot.canAdd(output.getItemOutputs());
    }

    public String func_145825_b() {
        return "Solid fuel evaporator";
    }

    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new EvaporatorContainer(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new EvaporatorGui(new EvaporatorContainer(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return false;
    }

    public boolean canFill(ForgeDirection arg0, Fluid fluid1) {
        return true;
    }

    public boolean getGui(EntityPlayer player) {
        return this instanceof IHasGui ? (IC2.platform.isSimulating() ? IC2.platform.launchGui(player, (IHasGui)this) : true) : false;
    }

    public int mX() {
        switch (this.getFacing()) {
            case 4: {
                return -1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    public int mZ() {
        switch (this.getFacing()) {
            case 2: {
                return -1;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public static void addRecipe(FluidStack input, ItemStack output) {
        recipeManager.addRecipe(new UniversalRecipeInput(Arrays.asList(input), null), new UniversalRecipeOutput(null, Arrays.asList(output), 20));
    }

    public UniversalRecipeOutput getOutput() {
        if (this.fluidTank.getFluid() == null) {
            return null;
        }
        UniversalRecipeOutput output = recipeManager.getOutputFor(Arrays.asList(this.fluidTank.getFluid()), null, false, false);
        return output == null ? null : (this.outputSlot.canAdd(output.getItemOutputs()) ? output : null);
    }

    public static Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return recipeManager.getRecipes();
    }
}

