/*
 * Decompiled with CFR 0.152.
 */
package ihl.tunneling_shield;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.core.ContainerBase;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotOutput;
import ihl.processing.invslots.InvSlotConsumableLiquidIHL;
import ihl.processing.metallurgy.BasicElectricMotorTileEntity;
import ihl.tunneling_shield.DriverTileEntity;
import ihl.tunneling_shield.HydrotransportPulpRegeneratorContainer;
import ihl.tunneling_shield.HydrotransportPulpRegeneratorGui;
import ihl.utils.IHLFluidTank;
import ihl.utils.IHLUtils;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class HydrotransportPulpRegeneratorTileEntity
extends BasicElectricMotorTileEntity
implements IFluidHandler {
    public final InvSlotConsumableLiquidIHL drainInputSlot;
    public final InvSlotOutput emptyFluidItemsSlot;
    public final InvSlotOutput outputSlot;
    final IHLFluidTank fluidTank = new IHLFluidTank(2000);
    private int timer = 0;

    public HydrotransportPulpRegeneratorTileEntity() {
        this.drainInputSlot = new InvSlotConsumableLiquidIHL(this, "drainInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Drain);
        this.emptyFluidItemsSlot = new InvSlotOutput((TileEntityInventory)this, "fluidCellsOutput", 2, 1);
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 3, 12);
        this.isGuiScreenOpened = true;
        this.operationLength = (short)26;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
    }

    public ItemStack getWrenchDrop(EntityPlayer player) {
        return IHLUtils.getThisModItemStack("hydrotransportPulpRegenerator");
    }

    @Override
    public void updateEntityServer() {
        DriverTileEntity dte;
        super.updateEntityServer();
        ForgeDirection direction = ForgeDirection.getOrientation((int)this.getFacing());
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
        if (!this.getActive() && this.fluidTank.getFluid() != null && this.isMachineOperational()) {
            if (te instanceof DriverTileEntity) {
                this.setActive(true);
            }
        } else if (this.getActive()) {
            ++this.timer;
            if (!(te instanceof DriverTileEntity) || this.fluidTank.getFluid() == null || !this.isMachineOperational()) {
                this.setActive(false);
            }
        }
        if (this.timer > 100) {
            this.fluidTank.drain(1, true);
            this.energy -= 1.0;
            this.timer = 0;
        }
        if (this.timer % 10 == 0 && te instanceof DriverTileEntity && (dte = (DriverTileEntity)te).getActive()) {
            this.fluidTank.drain(1, true);
        }
        IHLUtils.handleFluidSlotsBehaviour(null, this.drainInputSlot, this.emptyFluidItemsSlot, this.fluidTank);
    }

    @Override
    public void operate() {
        int i0;
        int i1;
        ForgeDirection direction = ForgeDirection.getOrientation((int)this.getFacing()).getOpposite();
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
        for (i1 = i0 = 0; i1 < this.outputSlot.size(); ++i1) {
            if (this.outputSlot.get(i1) == null) continue;
            i0 = i1;
        }
        if (te instanceof ISidedInventory) {
            ISidedInventory si = (ISidedInventory)te;
            for (int i = 0; i < si.func_70302_i_() && this.outputSlot.get(i0) != null; ++i) {
                if (!si.func_102007_a(i, this.outputSlot.get(i0), Direction.fromForgeDirection((ForgeDirection)direction).toSideValue())) continue;
                if (si.func_70301_a(i) == null) {
                    si.func_70299_a(i, this.outputSlot.get(i0));
                    this.outputSlot.put(i0, null);
                    continue;
                }
                if (!IHLUtils.isItemStacksIsEqual(si.func_70301_a(i), this.outputSlot.get(i0), true)) continue;
                int stackSizeBefore = si.func_70301_a((int)i).field_77994_a;
                si.func_70301_a((int)i).field_77994_a += this.outputSlot.get((int)i0).field_77994_a;
                if (si.func_70301_a((int)i).field_77994_a > si.func_70297_j_()) {
                    si.func_70301_a((int)i).field_77994_a = si.func_70297_j_();
                    this.outputSlot.get((int)i0).field_77994_a -= si.func_70297_j_() - stackSizeBefore;
                    if (this.outputSlot.get((int)i0).field_77994_a > 0) continue;
                    this.outputSlot.put(i0, null);
                    continue;
                }
                this.outputSlot.put(i0, null);
            }
        } else if (te instanceof IInventory) {
            IInventory si = (IInventory)te;
            for (int i = 0; i < si.func_70302_i_() && this.outputSlot.get(i0) != null; ++i) {
                if (!si.func_94041_b(i, this.outputSlot.get(i0))) continue;
                if (si.func_70301_a(i) == null) {
                    si.func_70299_a(i, this.outputSlot.get(i0));
                    this.outputSlot.put(i0, null);
                    continue;
                }
                if (!IHLUtils.isItemStacksIsEqual(si.func_70301_a(i), this.outputSlot.get(i0), true)) continue;
                int stackSizeBefore = si.func_70301_a((int)i).field_77994_a;
                si.func_70301_a((int)i).field_77994_a += this.outputSlot.get((int)i0).field_77994_a;
                if (si.func_70301_a((int)i).field_77994_a > si.func_70297_j_()) {
                    si.func_70301_a((int)i).field_77994_a = si.func_70297_j_();
                    this.outputSlot.get((int)i0).field_77994_a -= si.func_70297_j_() - stackSizeBefore;
                    if (this.outputSlot.get((int)i0).field_77994_a > 0) continue;
                    this.outputSlot.put(i0, null);
                    continue;
                }
                this.outputSlot.put(i0, null);
            }
        } else {
            for (i1 = i0; i1 < this.outputSlot.size(); ++i1) {
                if (this.outputSlot.get(i1) == null) continue;
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)(this.field_145851_c + direction.offsetX) + 0.5, (double)(this.field_145848_d + direction.offsetY) + 0.5, (double)(this.field_145849_e + direction.offsetZ) + 0.5, this.outputSlot.get(i1)));
                this.outputSlot.put(i1, null);
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMachineOperational() {
        if (!this.engine.correctContent()) return false;
        this.getClass();
        if (!(this.energy >= 0.1 / (double)this.engine.getEfficiency())) return false;
        return true;
    }

    @Override
    public List[] getInput() {
        return null;
    }

    @Override
    public boolean canOperate() {
        return !this.outputSlot.isEmpty();
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean arg1) {
        return new HydrotransportPulpRegeneratorGui(new HydrotransportPulpRegeneratorContainer(player, this));
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        return new HydrotransportPulpRegeneratorContainer(player, this);
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return false;
    }

    public boolean canFill(ForgeDirection arg0, Fluid arg1) {
        return true;
    }

    public FluidStack drain(ForgeDirection arg0, FluidStack arg1, boolean arg2) {
        return null;
    }

    public FluidStack drain(ForgeDirection arg0, int arg1, boolean arg2) {
        return null;
    }

    public int fill(ForgeDirection arg0, FluidStack resource, boolean doFill) {
        return this.fluidTank.fill(resource, doFill);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection arg0) {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }
}

