/*
 * Decompiled with CFR 0.152.
 */
package ihl.utils;

import ihl.IHLMod;
import ihl.utils.IHLUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityIHLExplosion
extends Entity {
    private Explosion explosion;
    private boolean explosionDone = false;
    public Set<Long> effectBorderBlocks;
    public Set<Long> effectBorderBlocksWithLowPosition;
    public Set<Long> blocksConnectedWithBedrock;
    public Set<Long> blocksNotConnectedWithBedrock;
    public int explosionPower;
    public int x;
    public int y;
    public int z;
    private Map<Long, Entity> entityCache = new HashMap<Long, Entity>();

    public EntityIHLExplosion(World world, int x1, int y1, int z1, int explosionPower1) {
        super(world);
        this.effectBorderBlocks = new HashSet<Long>();
        this.effectBorderBlocksWithLowPosition = new HashSet<Long>();
        this.blocksConnectedWithBedrock = new HashSet<Long>();
        this.blocksNotConnectedWithBedrock = new HashSet<Long>();
        this.field_70178_ae = true;
        this.field_70145_X = true;
        this.func_70105_a(0.0f, 0.0f);
        this.x = x1;
        this.y = y1;
        this.z = z1;
        this.func_70107_b((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5);
        this.explosionPower = explosionPower1;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (!this.effectBorderBlocks.isEmpty()) {
                boolean hasSomeBlocksStickedToAir = false;
                for (long longNumber : this.effectBorderBlocks) {
                    int[] xyz = IHLUtils.decodeXYZ(longNumber);
                    Block block = this.field_70170_p.func_147439_a(this.x + xyz[0], this.y + xyz[1], this.z + xyz[2]);
                    if (block == Blocks.field_150350_a || block.isAir((IBlockAccess)this.field_70170_p, this.x + xyz[0], this.y + xyz[1], this.z + xyz[2])) continue;
                    if (block.func_149688_o().func_76224_d()) {
                        block.func_149695_a(this.field_70170_p, this.x + xyz[0], this.y + xyz[1], this.z + xyz[2], block);
                        continue;
                    }
                    if (this.isBlockConnectedWithBedrock(longNumber)) continue;
                    hasSomeBlocksStickedToAir = true;
                }
                for (long longNumber5 : this.blocksNotConnectedWithBedrock) {
                    int[] xyz = IHLUtils.decodeXYZ(longNumber5);
                    Block block = this.field_70170_p.func_147439_a(this.x + xyz[0], this.y + xyz[1], this.z + xyz[2]);
                    float bh = block.func_149712_f(this.field_70170_p, this.x + xyz[0], this.y + xyz[1], this.z + xyz[2]);
                    if (!(bh >= 0.0f) || !(bh < Float.MAX_VALUE)) continue;
                    block.func_149723_a(this.field_70170_p, this.x + xyz[0], this.y + xyz[1], this.z + xyz[2], this.explosion);
                }
            }
            if (!this.explosionDone) {
                IHLMod.explosionHandler.setPower(IHLMod.explosionHandler.startVectors, this.explosionPower);
                IHLMod.explosionHandler.doExplosion(this.field_70170_p, this.x, this.y, this.z, IHLMod.explosionHandler.startVectors);
                this.explosionDone = true;
            }
        }
    }

    private boolean isBlockConnectedWithBedrock(long longNumber) {
        if (this.blocksNotConnectedWithBedrock.contains(longNumber)) {
            return false;
        }
        HashSet<Long> path = new HashSet<Long>();
        Iterator pathi = path.iterator();
        HashSet<Long> deadlockBlocks = new HashSet<Long>();
        int[] xyz = IHLUtils.decodeXYZ(longNumber);
        int absX = this.x + xyz[0];
        int absY = this.y + xyz[1];
        int absZ = this.z + xyz[2];
        path.add(longNumber);
        while (absY > 4) {
            int[] xyzi = new int[]{0, 0, -1, 0, 0, 1, 0, 0};
            boolean deadlock = true;
            for (int i = 0; i <= 5; ++i) {
                Block block;
                int x2 = absX + xyzi[i];
                int y2 = absY + xyzi[i + 2];
                int z2 = absZ + xyzi[i + 1];
                long longNumber2 = IHLUtils.encodeXYZ(x2 - this.x, y2 - this.y, z2 - this.z);
                if (this.blocksConnectedWithBedrock.contains(longNumber2)) {
                    this.blocksConnectedWithBedrock.addAll(path);
                    return true;
                }
                if (path.contains(longNumber2) || (block = this.field_70170_p.func_147439_a(x2, y2, z2)) == Blocks.field_150350_a || block.isAir((IBlockAccess)this.field_70170_p, x2, y2, z2) || block.func_149688_o().func_76224_d()) continue;
                absX = x2;
                absY = y2;
                absZ = z2;
                path.add(longNumber2);
                if (absY <= 4) {
                    this.blocksConnectedWithBedrock.addAll(path);
                    return true;
                }
                deadlock = false;
                break;
            }
            if (!deadlock) continue;
            long longNumber3 = IHLUtils.encodeXYZ(absX - this.x, absY - this.y, absZ - this.z);
            deadlockBlocks.add(longNumber3);
            boolean deadEnd = true;
            while (pathi.hasNext()) {
                long longNumber4 = (Long)pathi.next();
                if (deadlockBlocks.contains(longNumber4)) continue;
                int[] xyz2 = IHLUtils.decodeXYZ(longNumber4);
                absX = this.x + xyz2[0];
                absY = this.y + xyz2[1];
                absZ = this.z + xyz2[2];
                deadEnd = false;
                break;
            }
            if (!deadEnd) continue;
            this.blocksNotConnectedWithBedrock.addAll(path);
            return false;
        }
        this.blocksConnectedWithBedrock.addAll(path);
        return true;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound arg0) {
    }

    protected void func_70014_b(NBTTagCompound arg0) {
    }
}

