/*
 * Decompiled with CFR 0.152.
 */
package ihl.utils;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ic2.core.util.DrawUtil;
import ihl.IHLMod;
import ihl.utils.IHLFluidTank;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class IHLRenderUtils {
    private FloatBuffer colorBuffer;
    private Map<Long, Integer> frameTooltipMap;
    private int displayScaledWidth = -1;
    private int displayScaledHeight = -1;
    private int guiXPos = -1;
    private int guiYPos = -1;
    private int prevDisplayWidth = -1;
    private int prevDisplayHeight = -1;
    private final int guiContainerWidth = 166;
    private final int guiContainerHeight = 176;
    private float lastPlayerYaw;
    private float lastPlayerPitch;
    private double lastPlayerPosY;
    private double lastPlayerPosZ;
    private double lastPlayerPosX;
    private double renderMinX = 0.0;
    private double renderMaxX = 1.0;
    private double renderMinY = 0.0;
    private double renderMaxY = 1.0;
    private double renderMinZ = 0.0;
    private double renderMaxZ = 1.0;
    public boolean renderFromInside = false;
    private float rotationPointX;
    private float rotationPointY;
    private float rotationPointZ;
    private double renderPositionX;
    private double renderPositionY;
    private double renderPositionZ;
    private float rotationX;
    private float rotationY;
    private float rotationZ;
    private float scale = 0.0625f;
    public boolean swapXandZ = false;
    public boolean swapXandY = false;
    public boolean swapYandZ = false;
    public boolean swapRenderBoundsX = false;
    public boolean swapRenderBoundsY = false;
    public boolean swapRenderBoundsZ = false;
    public int scaleFactor = 1;
    public static IHLRenderUtils instance;

    public IHLRenderUtils() {
        instance = this;
        this.colorBuffer = GLAllocation.func_74529_h((int)16);
        this.frameTooltipMap = new HashMap<Long, Integer>();
    }

    public void renderIHLFluidTank(IHLFluidTank fluidTank, int x1, int y1, int x2, int y2, float zLevel, int par1, int par2, int xOffset, int yOffset) {
        int liquidHeight = 0;
        int prevLiquidHeight = 0;
        int i = y2 - y1;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i2 = 0; i2 < fluidTank.getNumberOfFluids(); ++i2) {
            IIcon fluidIcon;
            Fluid fluid;
            FluidStack fluidStack = fluidTank.getFluid(i2);
            if (fluidStack == null || (fluid = fluidStack.getFluid()) == null || (fluidIcon = fluid.getIcon()) == null) continue;
            liquidHeight = fluidTank.getFluidAmount(i2) * i / fluidTank.getCapacity();
            DrawUtil.drawRepeated((IIcon)fluidIcon, (double)x1, (double)(y2 - liquidHeight - prevLiquidHeight), (double)(x2 - x1), (double)liquidHeight, (double)zLevel);
            prevLiquidHeight += liquidHeight;
        }
        this.drawIHLFluidTankTooltip(par1, par2, x1 + this.guiXPos - 6, y1 + this.guiYPos + 6, x2 + this.guiXPos - 6, y2 + this.guiYPos + 6, fluidTank);
    }

    public void drawMissingEngineTooltip(GuiContainer gui, int par1, int par2, int xPos, int yPos, int xOffset, int yOffset) {
        gui.func_73729_b(xPos, yPos, 194, 0, 3, 14);
        this.drawTooltip(par1, par2, 3, 14, xPos + xOffset, yPos + yOffset, StatCollector.func_74838_a((String)"ihl.gui.missing.engine"));
    }

    public void drawWorkspaceElementTooltip(int par1, int par2, int xPos, int yPos, ItemStack workSpaceElement) {
        this.drawTooltip(par1, par2, 16, 16, xPos, yPos, StatCollector.func_74838_a((String)(workSpaceElement.func_77977_a() + ".tooltip")));
    }

    public void drawIHLFluidTankTooltip(int par1, int par2, int x1, int y1, int x2, int y2, IHLFluidTank fluidTank) {
        String fluidListNames = "";
        List<FluidStack> fli = fluidTank.getFluidList();
        for (int i = fli.size() - 1; i >= 0; --i) {
            FluidStack fluidStack = fli.get(i);
            fluidListNames = fluidListNames + StatCollector.func_74838_a((String)fluidStack.getUnlocalizedName()) + ": " + fluidStack.amount + "mB /n ";
        }
        this.drawTooltip(par1, par2, x2 - x1, y2 - y1, x1, y1, fluidListNames);
    }

    public boolean drawTooltip(int cursorPosX, int cursorPosY, int width, int height, int xPos, int yPos, String text) {
        this.updateScreenSize();
        long key = xPos + yPos * 1024;
        Integer frame = 0;
        if (this.frameTooltipMap.containsKey(key)) {
            frame = this.frameTooltipMap.get(key);
        }
        boolean showString = true;
        if (cursorPosX < xPos || cursorPosX > xPos + width || cursorPosY < yPos || cursorPosY > yPos + height) {
            if (frame > 0) {
                frame = frame - 20;
                this.frameTooltipMap.put(key, frame);
            }
            showString = false;
        } else {
            frame = frame + 10;
            this.frameTooltipMap.put(key, frame);
        }
        if (frame > 0) {
            int i;
            int strokeHeight = 15;
            int tooltipHeight = 0;
            int tooltipWidth = 0;
            String[] splittedText = text.split(" /n ");
            for (i = 0; i < splittedText.length; ++i) {
                if (Minecraft.func_71410_x().field_71466_p.func_78256_a(splittedText[i]) + 8 <= tooltipWidth) continue;
                tooltipWidth = Math.min(frame, Minecraft.func_71410_x().field_71466_p.func_78256_a(splittedText[i]) + 8);
            }
            tooltipHeight = Math.min(Math.max(frame - tooltipWidth, strokeHeight), strokeHeight * splittedText.length);
            int x1 = cursorPosX - xPos;
            int x2 = x1 + tooltipWidth;
            int y1 = cursorPosY - this.guiYPos + 18;
            int y2 = y1 + tooltipHeight;
            GL11.glPushAttrib((int)16704);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (showString) {
                this.drawRectangle(Tessellator.field_78398_a, x1, y1, x2, y2, 128);
                GL11.glEnable((int)3553);
                for (i = 0; i < splittedText.length; ++i) {
                    if (i >= tooltipHeight / strokeHeight) continue;
                    Minecraft.func_71410_x().field_71466_p.func_78261_a(splittedText[i], x1 + 4, y1 + i * strokeHeight + 4, 16768125);
                }
            } else {
                this.drawRectangle(Tessellator.field_78398_a, x1, y1, x2, y2, Math.min(128, frame / 2));
                GL11.glEnable((int)3553);
            }
            GL11.glPopAttrib();
            frame = Math.min(tooltipWidth + tooltipHeight, frame);
            this.frameTooltipMap.put(key, frame);
            return true;
        }
        return false;
    }

    public void enableAmbientLighting() {
        GL11.glDisable((int)16384);
        GL11.glDisable((int)16385);
        GL11.glLightModel((int)2899, (FloatBuffer)this.setColorBuffer(1.0f, 1.0f, 1.0f, 1.0f));
    }

    public void disableAmbientLighting() {
        GL11.glEnable((int)16384);
        GL11.glEnable((int)16385);
        GL11.glLightModel((int)2899, (FloatBuffer)this.setColorBuffer(0.0f, 0.0f, 0.0f, 1.0f));
    }

    private FloatBuffer setColorBuffer(float par0, float par1, float par2, float par3) {
        this.colorBuffer.clear();
        this.colorBuffer.put(par0).put(par1).put(par2).put(par3);
        this.colorBuffer.flip();
        return this.colorBuffer;
    }

    private void drawRectangle(Tessellator tessellator, int x1, int y1, int x2, int y2, int color) {
        tessellator.func_78382_b();
        tessellator.func_78370_a(color >>> 24 & 0xFF, color >>> 16 & 0xFF, color >>> 8 & 0xFF, color & 0xFF);
        tessellator.func_78377_a((double)x2, (double)y1, 300.0);
        tessellator.func_78377_a((double)x1, (double)y1, 300.0);
        tessellator.func_78377_a((double)x1, (double)y2, 300.0);
        tessellator.func_78377_a((double)x2, (double)y2, 300.0);
        tessellator.func_78381_a();
    }

    public void drawThermometerTemperature(long temperature, boolean show) {
        this.updateScreenSize();
        long key = 0L;
        int frame = 0;
        if (this.frameTooltipMap.containsKey(key)) {
            frame = this.frameTooltipMap.get(key);
        }
        if (frame <= 0) {
            this.updatePlayerView();
        }
        boolean showString = true;
        if (show && frame <= 122) {
            this.frameTooltipMap.put(key, ++frame);
        } else {
            if (frame > 0) {
                this.frameTooltipMap.put(key, frame -= 2);
            }
            showString = false;
        }
        if (frame > 0) {
            int width = Math.min(frame, 122);
            int height = Math.min(frame, 48);
            int xShift = Math.round((float)(this.displayScaledWidth / 100) * (this.lastPlayerYaw - Minecraft.func_71410_x().field_71451_h.field_70126_B));
            int yShift = Math.round((float)(this.displayScaledHeight / 64) * (this.lastPlayerPitch - Minecraft.func_71410_x().field_71451_h.field_70127_C));
            int xPos = this.displayScaledWidth / 2 + xShift;
            int yPos = this.displayScaledHeight / 2 - 48 + yShift;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.drawTexturedModalRect(xPos, yPos, 0, 0, width, height);
            GL11.glDisable((int)2929);
            if (showString) {
                Minecraft.func_71410_x().field_71466_p.func_78261_a(temperature + "\u00b0K", xPos + 35, yPos + 3, 16768125);
            }
            GL11.glEnable((int)2929);
            GL11.glDisable((int)3042);
        }
    }

    public void drawTexturedModalRect(int x1, int y1, int u, int v, int x2, int y2) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 0.5f);
        tessellator.func_78374_a((double)(x1 + 0), (double)(y1 + y2), 300.0, (double)((float)(u + 0) * f), (double)((float)(v + y2) * f1));
        tessellator.func_78374_a((double)(x1 + x2), (double)(y1 + y2), 300.0, (double)((float)(u + x2) * f), (double)((float)(v + y2) * f1));
        tessellator.func_78374_a((double)(x1 + x2), (double)(y1 + 0), 300.0, (double)((float)(u + x2) * f), (double)((float)(v + 0) * f1));
        tessellator.func_78374_a((double)(x1 + 0), (double)(y1 + 0), 300.0, (double)((float)(u + 0) * f), (double)((float)(v + 0) * f1));
        tessellator.func_78381_a();
    }

    public void updateScreenSize() {
        if (this.prevDisplayHeight != Minecraft.func_71410_x().field_71440_d || this.prevDisplayWidth != Minecraft.func_71410_x().field_71443_c) {
            ScaledResolution var2 = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
            this.displayScaledWidth = var2.func_78326_a();
            this.displayScaledHeight = var2.func_78328_b();
            this.scaleFactor = var2.func_78325_e();
            this.guiXPos = (this.displayScaledWidth - 166) / 2;
            this.guiYPos = (this.displayScaledHeight - 176) / 2;
            this.prevDisplayWidth = Minecraft.func_71410_x().field_71443_c;
            this.prevDisplayHeight = Minecraft.func_71410_x().field_71440_d;
        }
    }

    public void updatePlayerView() {
        this.lastPlayerYaw = Minecraft.func_71410_x().field_71451_h.field_70126_B;
        this.lastPlayerPitch = Minecraft.func_71410_x().field_71451_h.field_70127_C;
        this.lastPlayerPosX = Minecraft.func_71410_x().field_71451_h.field_70169_q;
        this.lastPlayerPosY = Minecraft.func_71410_x().field_71451_h.field_70167_r;
        this.lastPlayerPosZ = Minecraft.func_71410_x().field_71451_h.field_70166_s;
    }

    public void drawKnee(double xPos, double yPos, double zPos, ForgeDirection direction12, ForgeDirection direction22, double radius1, double radius2, IIcon icon) {
        ForgeDirection direction1 = direction12;
        ForgeDirection direction2 = direction22;
        if (this.swapRenderBoundsX) {
            if (direction1.offsetX != 0) {
                direction1 = direction1.getOpposite();
            }
            if (direction2.offsetX != 0) {
                direction2 = direction2.getOpposite();
            }
        }
        if (this.swapRenderBoundsY) {
            if (direction1.offsetY != 0) {
                direction1 = direction1.getOpposite();
            }
            if (direction2.offsetY != 0) {
                direction2 = direction2.getOpposite();
            }
        }
        if (this.swapRenderBoundsZ) {
            if (direction1.offsetZ != 0) {
                direction1 = direction1.getOpposite();
            }
            if (direction2.offsetZ != 0) {
                direction2 = direction2.getOpposite();
            }
        }
        double[][] outervertexes1 = new double[8][3];
        double[][] innervertexes1 = new double[8][3];
        double[][] outervertexes2 = new double[8][3];
        double[][] innervertexes2 = new double[8][3];
        int i = 0;
        block24: for (i = 0; i < 8; ++i) {
            if (direction1.equals((Object)direction2)) {
                switch (direction1) {
                    case UP: {
                        outervertexes1[i] = new double[]{0.5f + 0.5f * (float)Math.cos(0.7853981633974483 * (double)i), 0.0, 0.5f + 0.5f * (float)Math.sin(0.7853981633974483 * (double)i)};
                        innervertexes1[i] = new double[]{0.5 + radius1 * 0.5 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 0.0, 0.5 + 0.5 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i))};
                        outervertexes2[i] = new double[]{0.5 + 0.5 * radius2 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 1.0, 0.5 + 0.5 * radius2 * (double)((float)Math.sin(0.7853981633974483 * (double)i))};
                        innervertexes2[i] = new double[]{0.5 + radius1 * radius2 * 0.5 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 1.0, 0.5 + 0.5 * radius2 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i))};
                        break;
                    }
                    case DOWN: {
                        outervertexes1[i] = new double[]{0.5 + 0.5 * radius2 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 0.0, 0.5 + 0.5 * radius2 * (double)((float)Math.sin(0.7853981633974483 * (double)i))};
                        innervertexes1[i] = new double[]{0.5 + radius1 * radius2 * 0.5 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 0.0, 0.5 + 0.5 * radius1 * radius2 * (double)((float)Math.sin(0.7853981633974483 * (double)i))};
                        outervertexes2[i] = new double[]{0.5f + 0.5f * (float)Math.cos(0.7853981633974483 * (double)i), 1.0, 0.5f + 0.5f * (float)Math.sin(0.7853981633974483 * (double)i)};
                        innervertexes2[i] = new double[]{0.5 + radius1 * 0.5 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 1.0, 0.5 + 0.5 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i))};
                        break;
                    }
                    case SOUTH: {
                        outervertexes1[i] = new double[]{0.5f + 0.5f * (float)Math.cos(0.7853981633974483 * (double)i), 0.5f + 0.5f * (float)Math.sin(0.7853981633974483 * (double)i), 1.0};
                        innervertexes1[i] = new double[]{0.5 + radius1 * 0.5 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 0.5 + 0.5 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 1.0};
                        outervertexes2[i] = new double[]{0.5 + 0.5 * radius2 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 0.5 + 0.5 * radius2 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 0.0};
                        innervertexes2[i] = new double[]{0.5 + radius1 * radius2 * 0.5 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 0.5 + 0.5 * radius1 * radius2 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 0.0};
                        break;
                    }
                    case NORTH: {
                        outervertexes1[i] = new double[]{0.5 + 0.5 * radius2 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 0.5 + 0.5 * radius2 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 1.0};
                        innervertexes1[i] = new double[]{0.5 + radius1 * radius2 * 0.5 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 0.5 + 0.5 * radius1 * radius2 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 1.0};
                        outervertexes2[i] = new double[]{0.5f + 0.5f * (float)Math.cos(0.7853981633974483 * (double)i), 0.5f + 0.5f * (float)Math.sin(0.7853981633974483 * (double)i), 0.0};
                        innervertexes2[i] = new double[]{0.5 + radius1 * 0.5 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 0.5 + 0.5 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 0.0};
                        break;
                    }
                    case EAST: {
                        outervertexes1[i] = new double[]{0.0, 0.5f + 0.5f * (float)Math.sin(0.7853981633974483 * (double)i), 0.5f + 0.5f * (float)Math.cos(0.7853981633974483 * (double)i)};
                        innervertexes1[i] = new double[]{0.0, 0.5 + 0.5 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 0.5 + radius1 * 0.5 * (double)((float)Math.cos(0.7853981633974483 * (double)i))};
                        outervertexes2[i] = new double[]{1.0, 0.5 + 0.5 * radius2 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 0.5 + 0.5 * radius2 * (double)((float)Math.cos(0.7853981633974483 * (double)i))};
                        innervertexes2[i] = new double[]{1.0, 0.5 + 0.5 * radius1 * radius2 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 0.5 + radius1 * radius2 * 0.5 * (double)((float)Math.cos(0.7853981633974483 * (double)i))};
                        break;
                    }
                    case WEST: {
                        outervertexes1[i] = new double[]{0.0, 0.5 + 0.5 * radius2 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 0.5 + 0.5 * radius2 * (double)((float)Math.cos(0.7853981633974483 * (double)i))};
                        innervertexes1[i] = new double[]{0.0, 0.5 + 0.5 * radius2 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 0.5 + radius1 * 0.5 * radius2 * (double)((float)Math.cos(0.7853981633974483 * (double)i))};
                        outervertexes2[i] = new double[]{1.0, 0.5f + 0.5f * (float)Math.sin(0.7853981633974483 * (double)i), 0.5f + 0.5f * (float)Math.cos(0.7853981633974483 * (double)i)};
                        innervertexes2[i] = new double[]{1.0, 0.5 + 0.5 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 0.5 + radius1 * 0.5 * (double)((float)Math.cos(0.7853981633974483 * (double)i))};
                        break;
                    }
                    default: {
                        outervertexes1[i] = new double[]{0.5f + 0.5f * (float)Math.cos(0.7853981633974483 * (double)i), 0.0, 0.5f + 0.5f * (float)Math.sin(0.7853981633974483 * (double)i)};
                        innervertexes1[i] = new double[]{0.5 + radius1 * 0.5 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 0.0, 0.5 + 0.5 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i))};
                        outervertexes2[i] = new double[]{0.5 + 0.5 * radius2 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 1.0, 0.5 + 0.5 * radius2 * (double)((float)Math.sin(0.7853981633974483 * (double)i))};
                        innervertexes2[i] = new double[]{0.5 + radius1 * radius2 * 0.5 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 1.0, 0.5 + 0.5 * radius2 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i))};
                        break;
                    }
                }
                continue;
            }
            switch (direction1) {
                case UP: {
                    outervertexes1[i] = new double[]{0.5 + 0.25 * radius2 * (double)((float)Math.cos(0.7853981633974483 * (double)i + Math.PI)), 1.0, 0.5 - 0.25 * radius2 * (double)((float)Math.sin(0.7853981633974483 * (double)i + Math.PI))};
                    innervertexes1[i] = new double[]{0.5 + radius1 * radius2 * 0.25 * (double)((float)Math.cos(0.7853981633974483 * (double)i + Math.PI)), 1.0, 0.5 - 0.25 * radius1 * radius2 * (double)((float)Math.sin(0.7853981633974483 * (double)i + Math.PI))};
                    break;
                }
                case DOWN: {
                    outervertexes1[i] = new double[]{0.5f + 0.25f * (float)Math.cos(0.7853981633974483 * (double)i), 0.0, 0.5f + 0.25f * (float)Math.sin(0.7853981633974483 * (double)i)};
                    innervertexes1[i] = new double[]{0.5 + radius1 * 0.25 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 0.0, 0.5 + 0.25 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i))};
                    break;
                }
                case SOUTH: {
                    outervertexes1[i] = new double[]{0.5f + 0.25f * (float)Math.cos(0.7853981633974483 * (double)i), 0.5f + 0.25f * (float)Math.sin(0.7853981633974483 * (double)i), 1.0};
                    innervertexes1[i] = new double[]{0.5 + radius1 * 0.25 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 0.5 + 0.25 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 1.0};
                    break;
                }
                case NORTH: {
                    outervertexes1[i] = new double[]{0.5 + 0.25 * radius2 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 0.5 + 0.25 * radius2 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 1.0};
                    innervertexes1[i] = new double[]{0.5 + radius1 * radius2 * 0.25 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 0.5 + 0.25 * radius1 * radius2 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 1.0};
                    break;
                }
                case EAST: {
                    outervertexes1[i] = new double[]{0.0, 0.5f + 0.25f * (float)Math.sin(0.7853981633974483 * (double)i), 0.5f + 0.25f * (float)Math.cos(0.7853981633974483 * (double)i)};
                    innervertexes1[i] = new double[]{0.0, 0.5 + 0.25 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 0.5 + radius1 * 0.25 * (double)((float)Math.cos(0.7853981633974483 * (double)i))};
                    break;
                }
                case WEST: {
                    outervertexes1[i] = new double[]{0.0, 0.5 + 0.25 * radius2 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 0.5 + (double)0.52f * radius2 * (double)((float)Math.cos(0.7853981633974483 * (double)i))};
                    innervertexes1[i] = new double[]{0.0, 0.5 + 0.25 * radius2 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 0.5 + radius1 * 0.25 * radius2 * (double)((float)Math.cos(0.7853981633974483 * (double)i))};
                    break;
                }
                default: {
                    outervertexes1[i] = new double[]{0.0, 0.5 + 0.25 * radius2 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 0.5 + (double)0.52f * radius2 * (double)((float)Math.cos(0.7853981633974483 * (double)i))};
                    innervertexes1[i] = new double[]{0.0, 0.5 + 0.25 * radius2 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 0.5 + radius1 * 0.25 * radius2 * (double)((float)Math.cos(0.7853981633974483 * (double)i))};
                }
            }
            switch (direction2) {
                case UP: {
                    outervertexes2[i] = new double[]{0.5 + 0.5 * radius2 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 1.0, 0.5 + 0.5 * radius2 * (double)((float)Math.sin(0.7853981633974483 * (double)i))};
                    innervertexes2[i] = new double[]{0.5 + radius1 * radius2 * 0.5 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 1.0, 0.5 + 0.5 * radius2 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i))};
                    continue block24;
                }
                case DOWN: {
                    outervertexes2[i] = new double[]{0.5f + 0.5f * (float)Math.cos(0.7853981633974483 * (double)i), 1.0, 0.5f + 0.5f * (float)Math.sin(0.7853981633974483 * (double)i)};
                    innervertexes2[i] = new double[]{0.5 + radius1 * 0.5 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 1.0, 0.5 + 0.5 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i))};
                    continue block24;
                }
                case WEST: {
                    outervertexes2[i] = new double[]{1.0, 0.5f + 0.25f * (float)Math.cos(0.7853981633974483 * (double)i), 0.5f - 0.25f * (float)Math.sin(0.7853981633974483 * (double)i)};
                    innervertexes2[i] = new double[]{1.0, 0.5 + radius1 * 0.25 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 0.5 - 0.25 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i))};
                    continue block24;
                }
                case EAST: {
                    outervertexes2[i] = new double[]{0.0, 0.5f + 0.25f * (float)Math.cos(0.7853981633974483 * (double)i), 0.5f + 0.25f * (float)Math.sin(0.7853981633974483 * (double)i)};
                    innervertexes2[i] = new double[]{0.0, 0.5 + radius1 * 0.25 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 0.5 + 0.25 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i))};
                    continue block24;
                }
                case NORTH: {
                    outervertexes2[i] = new double[]{0.5f + 0.25f * (float)Math.cos(0.7853981633974483 * (double)i), 0.5 - (double)(0.25f * (float)Math.sin(0.7853981633974483 * (double)i)), 1.0};
                    innervertexes2[i] = new double[]{0.5 + radius1 * 0.25 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 0.5 - 0.25 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 1.0};
                    continue block24;
                }
                case SOUTH: {
                    outervertexes2[i] = new double[]{0.5f + 0.25f * (float)Math.cos(0.7853981633974483 * (double)i), 0.5f + 0.25f * (float)Math.sin(0.7853981633974483 * (double)i), 0.0};
                    innervertexes2[i] = new double[]{0.5 + radius1 * 0.25 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 0.5 + 0.25 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i)), 0.0};
                    continue block24;
                }
                default: {
                    outervertexes2[i] = new double[]{0.5 + 0.5 * radius2 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 1.0, 0.5 + 0.5 * radius2 * (double)((float)Math.sin(0.7853981633974483 * (double)i))};
                    innervertexes2[i] = new double[]{0.5 + radius1 * radius2 * 0.5 * (double)((float)Math.cos(0.7853981633974483 * (double)i)), 1.0, 0.5 + 0.5 * radius2 * radius1 * (double)((float)Math.sin(0.7853981633974483 * (double)i))};
                }
            }
        }
        double[][][] quadList = new double[32][4][3];
        for (i = 0; i < 32; ++i) {
            if (i < 7) {
                quadList[i] = new double[][]{outervertexes1[i], outervertexes1[i + 1], innervertexes1[i + 1], innervertexes1[i]};
                continue;
            }
            if (i == 7) {
                quadList[i] = new double[][]{outervertexes1[i], outervertexes1[0], innervertexes1[0], innervertexes1[i]};
                continue;
            }
            if (i < 15) {
                quadList[i] = new double[][]{innervertexes2[i - 8], innervertexes2[i + 1 - 8], outervertexes2[i + 1 - 8], outervertexes2[i - 8]};
                continue;
            }
            if (i == 15) {
                quadList[i] = new double[][]{innervertexes2[i - 8], innervertexes2[0], outervertexes2[0], outervertexes2[i - 8]};
                continue;
            }
            if (i < 23) {
                quadList[i] = new double[][]{outervertexes1[i - 16], outervertexes2[i - 16], outervertexes2[i - 16 + 1], outervertexes1[i - 16 + 1]};
                continue;
            }
            if (i == 23) {
                quadList[i] = new double[][]{outervertexes1[i - 16], outervertexes2[i - 16], outervertexes2[0], outervertexes1[0]};
                continue;
            }
            if (i < 31) {
                quadList[i] = new double[][]{innervertexes1[i - 24 + 1], innervertexes2[i - 24 + 1], innervertexes2[i - 24], innervertexes1[i - 24]};
                continue;
            }
            if (i != 31) continue;
            quadList[i] = new double[][]{innervertexes1[0], innervertexes2[0], innervertexes2[i - 24], innervertexes1[i - 24]};
        }
        for (i = 0; i < 32; ++i) {
            this.drawSquare(xPos, yPos, zPos, quadList[i], icon);
        }
    }

    public void drawPipe(double xPos, double yPos, double zPos, ForgeDirection direction1, double radius1, double radius2, IIcon icon) {
        this.drawKnee(xPos, yPos, zPos, direction1, direction1, radius1, radius2, icon);
    }

    public void drawSquare(double xPos, double yPos, double zPos, double[][] vertexes, IIcon icon) {
        Tessellator var9 = Tessellator.field_78398_a;
        double u1 = icon.func_94214_a(this.renderMinZ * 16.0);
        double u2 = icon.func_94214_a(this.renderMaxZ * 16.0);
        double v2 = icon.func_94207_b(16.0 - this.renderMaxY * 16.0);
        double v1 = icon.func_94207_b(16.0 - this.renderMinY * 16.0);
        if (this.renderMinZ < 0.0 || this.renderMaxZ > 1.0) {
            u1 = icon.func_94209_e();
            u2 = icon.func_94212_f();
        }
        if (this.renderMinY < 0.0 || this.renderMaxY > 1.0) {
            v2 = icon.func_94206_g();
            v1 = icon.func_94210_h();
        }
        double[] us = new double[]{u1, u1, u2, u2};
        double[] vs = new double[]{v1, v2, v2, v1};
        double xDelta = this.renderMaxX - this.renderMinX;
        double yDelta = this.renderMaxY - this.renderMinY;
        double zDelta = this.renderMaxZ - this.renderMinZ;
        int startFrom = 0;
        int endTo = 3;
        if (this.renderFromInside) {
            startFrom = 3;
            endTo = 0;
        }
        for (int i = startFrom; i <= endTo && !this.renderFromInside || i >= endTo && this.renderFromInside; i += (endTo - startFrom) / 3) {
            double var0;
            double vX = vertexes[i][0] * xDelta + this.renderMinX;
            double vY = vertexes[i][1] * yDelta + this.renderMinY;
            double vZ = vertexes[i][2] * zDelta + this.renderMinZ;
            double[] vYZ = null;
            double[] vXZ = null;
            double[] vXY = null;
            if (this.rotationX != 0.0f) {
                vYZ = this.rotateCoordinateByAngle(vY - (double)((this.rotationPointY - 8.0f) * this.scale), vZ - (double)((this.rotationPointZ + 8.0f) * this.scale), this.rotationX);
                vY = vYZ[0] + (double)((this.rotationPointY - 8.0f) * this.scale);
                vZ = vYZ[1] + (double)((this.rotationPointZ + 8.0f) * this.scale);
            }
            if (this.rotationY != 0.0f) {
                vXZ = this.rotateCoordinateByAngle(vX - (double)((this.rotationPointX + 8.0f) * this.scale), vZ - (double)((this.rotationPointZ + 8.0f) * this.scale), this.rotationY);
                vX = vXZ[0] + (double)((this.rotationPointX + 8.0f) * this.scale);
                vZ = vXZ[1] - (double)((this.rotationPointZ + 8.0f) * this.scale);
            }
            if (this.rotationZ != 0.0f) {
                vXY = this.rotateCoordinateByAngle(vX - (double)((this.rotationPointX + 8.0f) * this.scale), vY - (double)((this.rotationPointY - 8.0f) * this.scale), this.rotationZ);
                vX = vXY[0] + (double)((this.rotationPointX + 8.0f) * this.scale);
                vY = vXY[1] + (double)((this.rotationPointY - 8.0f) * this.scale);
                if (this.swappingAxisOrBoundsAffectRotationOnAxisZ()) {
                    vY -= (this.renderMaxZ - (double)(this.rotationPointZ + 8.0f)) * (double)this.scale * Math.sin(this.rotationZ);
                }
            }
            if (this.swapXandY) {
                var0 = vX;
                vX = vY;
                vY = var0;
            }
            if (this.swapXandZ) {
                var0 = vX;
                vX = vZ;
                vZ = var0;
            }
            if (this.swapYandZ) {
                var0 = vY;
                vY = vZ;
                vZ = var0;
            }
            var9.func_78374_a(xPos + vX, yPos + vY, zPos + vZ, us[i], vs[i]);
        }
    }

    public void setRenderBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (this.swapRenderBoundsX) {
            this.renderMinX = 1.0 - maxX;
            this.renderMaxX = 1.0 - minX;
        } else {
            this.renderMinX = minX;
            this.renderMaxX = maxX;
        }
        if (this.swapRenderBoundsY) {
            this.renderMinY = 1.0 - maxY;
            this.renderMaxY = 1.0 - minY;
        } else {
            this.renderMinY = minY;
            this.renderMaxY = maxY;
        }
        if (this.swapRenderBoundsZ) {
            this.renderMinZ = 1.0 - maxZ;
            this.renderMaxZ = 1.0 - minZ;
        } else {
            this.renderMinZ = minZ;
            this.renderMaxZ = maxZ;
        }
    }

    public void setRotationPoint(float rX, float rY, float rZ) {
        this.rotationPointX = rX;
        this.rotationPointY = rY;
        this.rotationPointZ = rZ;
    }

    public void setPosition(double xPos, double yPos, double zPos) {
        this.renderPositionX = xPos;
        this.renderPositionY = yPos;
        this.renderPositionZ = zPos;
    }

    public void drawPipe(float fx, float fy, float fz, int xSize, int ySize, int zSize, float radius1, float radius2, ForgeDirection direction, IIcon icon) {
        this.setRenderBoundsFromModel(fx, fy, fz, xSize, ySize, zSize);
        this.drawPipe(this.renderPositionX, this.renderPositionY, this.renderPositionZ, direction, radius1, radius2, icon);
    }

    public void drawKnee(float fx, float fy, float fz, int xSize, int ySize, int zSize, float radius1, float radius2, ForgeDirection direction1, ForgeDirection direction2, IIcon icon) {
        this.setRenderBoundsFromModel(fx, fy, fz, xSize, ySize, zSize);
        this.drawKnee(this.renderPositionX, this.renderPositionY, this.renderPositionZ, direction1, direction2, radius1, radius2, icon);
    }

    public void drawBox(float fx, float fy, float fz, int xSize, int ySize, int zSize, Block block, int meta, RenderBlocks blockRenderer) {
        this.setRenderBoundsFromModel(fx, fy, fz, xSize, ySize, zSize);
        blockRenderer.func_147784_q(block, (int)this.renderPositionX, (int)this.renderPositionY, (int)this.renderPositionZ);
    }

    public void setRenderBoundsFromModel(float fx, float fy, float fz, int xSize, int ySize, int zSize) {
        float boundMinX = (-this.rotationPointX + 8.0f - fx - (float)xSize) * this.scale;
        float boundMaxX = (-this.rotationPointX + 8.0f - fx) * this.scale;
        float boundMinZ = (-this.rotationPointZ + 8.0f - fz - (float)zSize) * this.scale;
        float boundMaxZ = (-this.rotationPointZ + 8.0f - fz) * this.scale;
        float boundMinY = (this.rotationPointY - 8.0f - fy - (float)ySize) * this.scale;
        float boundMaxY = (this.rotationPointY - 8.0f - fy) * this.scale;
        this.setRenderBounds(boundMinX, boundMinY, boundMinZ, boundMaxX, boundMaxY, boundMaxZ);
    }

    public double[] rotateCoordinateByAngle(double coord1, double coord2, double angle) {
        double r = Math.sqrt(coord2 * coord2 + coord1 * coord1);
        double alpha0 = Math.asin(coord2 / r);
        if (coord1 < 0.0) {
            alpha0 = Math.PI - Math.asin(coord2 / r);
        }
        double alpha2 = alpha0 + angle;
        double coord21 = Math.sin(alpha2) * r;
        double coord11 = Math.cos(alpha2) * r;
        return new double[]{coord11, coord21};
    }

    public void setRotation(float rotationX1, float rotationY1, float rotationZ1) {
        this.rotationX = this.swapRenderBoundsX ? -rotationX1 : rotationX1;
        this.rotationY = this.swapRenderBoundsY ? -rotationY1 : rotationY1;
        this.rotationZ = this.swappingAxisOrBoundsAffectRotationOnAxisZ() ? -rotationZ1 : rotationZ1;
    }

    public void reset() {
        this.renderFromInside = false;
        this.swapXandZ = false;
        this.swapXandY = false;
        this.swapYandZ = false;
        this.swapRenderBoundsX = false;
        this.swapRenderBoundsY = false;
        this.swapRenderBoundsZ = false;
        this.setRotation(0.0f, 0.0f, 0.0f);
        this.setRotationPoint(0.0f, 0.0f, 0.0f);
    }

    private boolean swappingAxisOrBoundsAffectRotationOnAxisZ() {
        return this.swapRenderBoundsZ && !this.swapXandZ && !this.swapYandZ || this.swapRenderBoundsX && this.swapXandZ || this.swapRenderBoundsY && this.swapYandZ;
    }

    public List<String> splitStringByWidth(String string, int stringWidth) {
        ArrayList<String> output = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        String[] splittedBySpaces = string.split(" ");
        int arrayIndex = 0;
        for (String word : splittedBySpaces) {
            if (!word.contains("/n") && this.getStringWidth(sb) + this.getStringWidth(word) < stringWidth) {
                sb.append(word);
                sb.append(" ");
                continue;
            }
            output.add(sb.toString());
            sb.delete(0, sb.length());
            ++arrayIndex;
            if (!word.contains("/n")) {
                sb.append(word);
                sb.append(" ");
                continue;
            }
            sb.append("     ");
        }
        output.add(sb.toString());
        return output;
    }

    public int getStringWidth(StringBuffer sb) {
        return this.getStringWidth(sb.toString());
    }

    public int getStringWidth(String sb) {
        return Minecraft.func_71410_x().field_71466_p.func_78256_a(sb);
    }

    @SubscribeEvent
    public void drawBlockSelectionBox(DrawBlockHighlightEvent event) {
        WorldClient world;
        TileEntity te;
        if (event.target != null && event.target.field_72313_a.equals((Object)MovingObjectPosition.MovingObjectType.BLOCK) && (te = (world = Minecraft.func_71410_x().field_71441_e).func_147438_o(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d)) != null) {
            IHLMod.proxy.renderTESpecialSelectionBox(te, event.player, event.currentItem, event.target, event.partialTicks);
        }
    }
}

