/*
 * Decompiled with CFR 0.152.
 */
package ihl.enviroment;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkDataProvider;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import ic2.core.network.NetworkManager;
import ihl.enviroment.LightBulbBlock;
import ihl.utils.IHLUtils;
import java.util.List;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class LightBulbTileEntity
extends TileEntity
implements IEnergySink,
IWrenchable,
INetworkDataProvider {
    private boolean active = false;
    private short facing = 0;
    public boolean prevActive = false;
    public short prevFacing = 0;
    private double maxEnergy = 1.1;
    private double energy;
    public boolean addedToEnergyNet = false;
    private boolean loaded = false;
    private int ticker;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74769_h("energy");
        this.facing = nbttagcompound.func_74765_d("facing");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
        nbttagcompound.func_74777_a("facing", this.facing);
    }

    public void func_145829_t() {
        super.func_145829_t();
        IC2.tickHandler.addSingleTickCallback(this.field_145850_b, new ITickCallback(){

            public void tickCallback(World world) {
                if (!LightBulbTileEntity.this.func_145837_r() && world.func_72899_e(LightBulbTileEntity.this.field_145851_c, LightBulbTileEntity.this.field_145848_d, LightBulbTileEntity.this.field_145849_e)) {
                    LightBulbTileEntity.this.onLoaded();
                    if (LightBulbTileEntity.this.enableUpdateEntity()) {
                        world.field_147482_g.add(LightBulbTileEntity.this);
                    }
                }
            }
        });
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onLoaded() {
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating()) {
            if (this.addedToEnergyNet) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
                this.addedToEnergyNet = false;
            }
            this.active = false;
            this.updateLightState();
        }
    }

    public final boolean canUpdate() {
        return false;
    }

    public void func_145845_h() {
        if (++this.ticker % 4 == 0) {
            if (this.prevFacing != this.facing) {
                this.setFacing(this.facing);
            }
            if (this.energy > 0.0) {
                this.energy -= 1.0;
                this.setActive(this.energy > 0.0);
            } else {
                this.setActive(false);
            }
        }
    }

    protected void updateLightState() {
        int[] xyz = new int[]{0, 0, 1, 0, 0, -1, 0, 0};
        for (int i = 0; i <= 5; ++i) {
            int x = this.field_145851_c + xyz[i];
            int y = this.field_145848_d + xyz[i + 1];
            int z = this.field_145849_e + xyz[i + 2];
            Block block = this.field_145850_b.func_147439_a(x, y, z);
            if (!block.isAir((IBlockAccess)this.field_145850_b, x, y, z)) continue;
            if (this.getActive()) {
                this.field_145850_b.func_147449_b(x, y, z, (Block)LightBulbBlock.glowningAir);
            }
            if (this.getActive()) continue;
            this.field_145850_b.func_147468_f(x, y, z);
        }
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        switch (direction) {
            case UP: {
                return this.getFacing() == 0;
            }
            case DOWN: {
                return this.getFacing() == 1;
            }
            case SOUTH: {
                return this.getFacing() == 2;
            }
            case NORTH: {
                return this.getFacing() == 3;
            }
            case EAST: {
                return this.getFacing() == 4;
            }
            case WEST: {
                return this.getFacing() == 5;
            }
        }
        return false;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public short getFacing() {
        return this.facing;
    }

    public void setFacing(short facing1) {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        this.facing = facing1;
        if (IC2.platform.isSimulating() && this.prevFacing != this.facing) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "facing");
        }
        this.prevFacing = this.facing;
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>(2);
        ret.add("active");
        ret.add("facing");
        return ret;
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return IHLUtils.getThisModItemStack("lightBulb");
    }

    public double getDemandedEnergy() {
        return this.maxEnergy - this.energy;
    }

    public int getSinkTier() {
        return 1;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= this.maxEnergy) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active1) {
        this.active = active1;
        if (this.prevActive != active1) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "active");
            this.updateLightState();
        }
        this.prevActive = active1;
    }

    public void setActiveWithoutNotify(boolean active1) {
        this.active = active1;
        this.prevActive = active1;
    }
}

