/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import ic2.core.block.TileEntityInventory;
import ihl.IHLMod;
import ihl.flexible_cable.IHLGrid;
import ihl.flexible_cable.NodeEntity;
import ihl.interfaces.IEnergyNetNode;
import ihl.utils.IHLUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;

public abstract class FlexibleCableHolderBaseTileEntity
extends TileEntityInventory
implements IEnergyNetNode {
    protected double connectionX;
    protected double connectionY;
    protected double connectionZ;
    protected int gridID = -1;
    protected final Set<NBTTagCompound> cableList = new HashSet<NBTTagCompound>();
    public boolean checkCables = true;

    public void onLoaded() {
        super.onLoaded();
        if (this.gridID != -1) {
            IHLGrid grid = IHLMod.enet.getGrid(this.gridID);
            grid.add(this);
        }
    }

    public void setFacing(short facing1) {
        short facing2 = (short)Math.max(facing1, 2);
        double range = 2.0;
        AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)(this.connectionX - range), (double)(this.connectionY - range), (double)(this.connectionZ - range), (double)(this.connectionX + range), (double)(this.connectionY + range), (double)(this.connectionZ + range));
        List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
        super.setFacing(facing2);
        this.setConnectionX((double)this.field_145851_c + 0.5);
        this.setConnectionY((double)this.field_145848_d + 1.5);
        this.setConnectionZ((double)this.field_145849_e + 0.5);
        if (!nodeList.isEmpty()) {
            for (NodeEntity ne : nodeList) {
                if (ne.prevAnchorEntity != null && ne.nextAnchorEntity != null || !this.cableListContains(ne.getChainUniqueID())) continue;
                ne.setVirtualNodePos(this.connectionX, this.connectionY, this.connectionZ);
            }
        }
    }

    protected boolean cableListContains(int chainUniqueID) {
        for (NBTTagCompound c : this.getCableList()) {
            if (c.func_74762_e("chainUID") != chainUniqueID) continue;
            return true;
        }
        return false;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList cableNBTList = new NBTTagList();
        for (NBTTagCompound cable : this.cableList) {
            cableNBTList.func_74742_a((NBTBase)cable);
        }
        nbt.func_74782_a("cableList", (NBTBase)cableNBTList);
        nbt.func_74780_a("connectionX", this.connectionX);
        nbt.func_74780_a("connectionY", this.connectionY);
        nbt.func_74780_a("connectionZ", this.connectionZ);
        nbt.func_74768_a("gridID", this.gridID);
        nbt.func_74757_a("checkCables", this.checkCables);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList cableNBTList = nbt.func_150295_c("cableList", 10);
        for (int i = 0; i < cableNBTList.func_74745_c(); ++i) {
            this.cableList.add(cableNBTList.func_150305_b(i));
        }
        this.setConnectionX(nbt.func_74769_h("connectionX"));
        this.setConnectionY(nbt.func_74769_h("connectionY"));
        this.setConnectionZ(nbt.func_74769_h("connectionZ"));
        this.gridID = nbt.func_74762_e("gridID");
        this.checkCables = nbt.func_74767_n("checkCables");
    }

    @Override
    public void removeAttachedChains() {
        for (NBTTagCompound c : this.getCableList()) {
            IHLMod.enet.removeCableEntities(c);
            ItemStack is = IHLUtils.getThisModItemStack("copperWire");
            is.field_77990_d = c;
            EntityItem eitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, is);
            this.field_145850_b.func_72838_d((Entity)eitem);
        }
        if (this.gridID != -1) {
            IHLMod.enet.splitGrids(this.gridID, this);
        }
        this.getCableList().clear();
    }

    public void setConnectionX(double connectionX) {
        this.connectionX = connectionX;
    }

    public void setConnectionY(double connectionY) {
        this.connectionY = connectionY;
    }

    public void setConnectionZ(double connectionZ) {
        this.connectionZ = connectionZ;
    }

    @Override
    public double[] getPortPos(EntityLivingBase player) {
        return new double[]{this.connectionX, this.connectionY, this.connectionZ};
    }

    @Override
    public boolean addCable(NBTTagCompound cable) {
        return this.cableList.add(cable);
    }

    @Override
    public Set<NBTTagCompound> getCableList() {
        return this.cableList;
    }

    @Override
    public void setGrid(int newGridID) {
        if (newGridID != -1) {
            this.gridID = newGridID;
            IHLGrid newGrid = IHLMod.enet.getGrid(newGridID);
            IHLMod.enet.getGrid(newGridID).add(this);
        } else {
            this.gridID = -1;
        }
    }

    @Override
    public int getGridID() {
        return this.gridID;
    }

    @Override
    public IHLGrid getGrid() {
        return IHLMod.enet.getGrid(this.gridID);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    @Override
    public void remove(NBTTagCompound cable) {
        this.cableList.remove(cable);
    }

    @Override
    public boolean isCableRemoved(int chainUniqueID) {
        if (!this.checkCables) {
            return false;
        }
        for (NBTTagCompound cable : this.cableList) {
            if (cable.func_74762_e("chainUID") != chainUniqueID) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setCableCheck(boolean b) {
        this.checkCables = b;
    }
}

