/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import ic2.core.IC2;
import ihl.IHLMod;
import ihl.flexible_cable.AnchorTileEntity;
import ihl.flexible_cable.IHLGrid;
import ihl.interfaces.IEnergyNetNode;
import ihl.utils.IHLUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.MinecraftForge;

public class SubAnchorEnergyNetNode
implements IEnergyNetNode {
    private AnchorTileEntity base;
    private short facing;
    private int gridID = -1;
    private Set<NBTTagCompound> cableList = new HashSet<NBTTagCompound>();

    public SubAnchorEnergyNetNode(AnchorTileEntity base1, short facing1) {
        this.base = base1;
        this.facing = facing1;
    }

    @Override
    public double[] getPortPos(EntityLivingBase player) {
        double d = 0.5;
        double f = -0.05;
        switch (this.facing) {
            case 0: {
                return new double[]{(double)this.base.field_145851_c + d, (double)this.base.field_145848_d + 1.0 - f, (double)this.base.field_145849_e + 0.5};
            }
            case 1: {
                return new double[]{(double)this.base.field_145851_c + d, (double)this.base.field_145848_d + f, (double)this.base.field_145849_e + 0.5};
            }
            case 2: {
                return new double[]{(double)this.base.field_145851_c + 0.5, (double)this.base.field_145848_d + d, (double)this.base.field_145849_e + 1.0 - f};
            }
            case 3: {
                return new double[]{(double)this.base.field_145851_c + 0.5, (double)this.base.field_145848_d + d, (double)this.base.field_145849_e + f};
            }
            case 4: {
                return new double[]{(double)this.base.field_145851_c + 1.0 - f, (double)this.base.field_145848_d + d, (double)this.base.field_145849_e + 0.5};
            }
            case 5: {
                return new double[]{(double)this.base.field_145851_c + f, (double)this.base.field_145848_d + d, (double)this.base.field_145849_e + 0.5};
            }
        }
        return new double[]{(double)this.base.field_145851_c + f, (double)this.base.field_145848_d + d, (double)this.base.field_145849_e + 0.5};
    }

    @Override
    public IHLGrid getGrid() {
        if (this.gridID != -1) {
            return IHLMod.enet.getGrid(this.gridID);
        }
        return null;
    }

    @Override
    public int getGridID() {
        return this.gridID;
    }

    @Override
    public void setGrid(int newgridID) {
        if (IC2.platform.isSimulating() && this.base.addedToEnergyNet && this.base.func_145831_w() != null) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this.base));
            this.base.addedToEnergyNet = false;
        }
        if (newgridID != -1) {
            this.gridID = newgridID;
            IHLMod.enet.getGrid(newgridID).add(this);
        } else {
            this.gridID = -1;
        }
        if (IC2.platform.isSimulating() && !this.base.addedToEnergyNet && this.base.func_145831_w() != null) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this.base));
            this.base.addedToEnergyNet = true;
        }
    }

    @Override
    public double getMaxAllowableVoltage() {
        return 64000.0;
    }

    @Override
    public boolean addCable(NBTTagCompound cable) {
        this.base.hasCableOnSide[this.facing] = true;
        return this.cableList.add(cable);
    }

    @Override
    public Set<NBTTagCompound> getCableList() {
        return this.cableList;
    }

    @Override
    public void removeAttachedChains() {
        for (NBTTagCompound c : this.getCableList()) {
            IHLMod.enet.removeCableEntities(c);
            ItemStack is = IHLUtils.getThisModItemStack("copperWire");
            is.field_77990_d = c;
            EntityItem eitem = new EntityItem(this.base.func_145831_w(), (double)this.base.field_145851_c + 0.5, (double)this.base.field_145848_d + 0.5, (double)this.base.field_145849_e + 0.5, is);
            this.base.func_145831_w().func_72838_d((Entity)eitem);
        }
        if (this.gridID != -1) {
            IHLMod.enet.splitGrids(this.gridID, this);
        }
        this.getCableList().clear();
        this.base.hasCableOnSide[this.facing] = false;
        if (!this.base.func_145837_r()) {
            this.base.checkIfNoCablesLeft();
        }
    }

    public void onLoaded() {
        if (this.gridID != -1) {
            IHLGrid grid = IHLMod.enet.getGrid(this.gridID);
            grid.add(this);
        }
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList cableNBTList = new NBTTagList();
        for (NBTTagCompound cable : this.cableList) {
            cableNBTList.func_74742_a((NBTBase)cable);
        }
        nbt.func_74782_a("cableList", (NBTBase)cableNBTList);
        nbt.func_74768_a("gridID", this.gridID);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList cableNBTList = nbt.func_150295_c("cableList", 10);
        for (int i = 0; i < cableNBTList.func_74745_c(); ++i) {
            this.cableList.add(cableNBTList.func_150305_b(i));
        }
        this.gridID = nbt.func_74762_e("gridID");
        if (this.gridID != -1) {
            this.base.hasCableOnSide[this.facing] = true;
        }
    }

    public double getOfferedEnergy() {
        if (this.gridID == -1) {
            return 0.0;
        }
        return Math.max(this.getGrid().energy, 0.0);
    }

    public double getDemandedEnergy() {
        if (this.gridID == -1 || this.getGrid().energy > 1.0) {
            return 0.0;
        }
        return this.getGrid().getDemandedEnergy();
    }

    public double drawEnergy(double amount) {
        if (this.gridID == -1) {
            return 0.0;
        }
        double dEnergy = Math.min(this.getGrid().energy, amount);
        this.getGrid().energy -= dEnergy;
        return dEnergy;
    }

    public double getVoltage() {
        if (this.gridID == -1) {
            return 0.0;
        }
        return this.getGrid().getSinkVoltage(this);
    }

    @Override
    public void remove(NBTTagCompound cable) {
        this.cableList.remove(cable);
        if (this.cableList.isEmpty()) {
            this.base.hasCableOnSide[this.facing] = false;
            this.base.checkIfNoCablesLeft();
        }
    }

    public double injectEnergy(double amount) {
        if (this.gridID == -1) {
            return amount;
        }
        this.getGrid().injectEnergy(amount, 400.0, this);
        return 0.0;
    }

    @Override
    public boolean isCableRemoved(int chainUniqueID) {
        for (NBTTagCompound cable : this.cableList) {
            if (cable.func_74762_e("chainUID") != chainUniqueID) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setCableCheck(boolean b) {
        this.base.checkCables = b;
    }
}

