/*
 * Decompiled with CFR 0.152.
 */
package ihl.items_blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.tileentity.ITileEntityTemperature;
import ic2.api.reactor.IReactor;
import ic2.core.Ic2Items;
import ihl.IHLCreativeTab;
import ihl.IHLMod;
import ihl.interfaces.IHasTemperature;
import ihl.utils.IHLUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class IHLTool
extends Item {
    private static Map<Integer, IIcon> iconMap = new HashMap<Integer, IIcon>();
    private static Map<Integer, String> nameMap = new HashMap<Integer, String>();
    private static Map<Integer, String> hintMap = new HashMap<Integer, String>();
    private static Map<Integer, Integer> maxToolDamageMap = new HashMap<Integer, Integer>();
    private static Map<Integer, Boolean> isWeaponMap = new HashMap<Integer, Boolean>();
    private static Map<Integer, Float> damageVersusEntityMap = new HashMap<Integer, Float>();
    public static Item instance;
    private IIcon dice240;

    public IHLTool() {
        this.func_77656_e(0);
        this.setNoRepair();
        this.func_77627_a(true);
        this.func_77637_a(IHLCreativeTab.tab);
        this.func_77655_b("ihlTool");
        this.func_77625_d(1);
        instance = this;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (itemStack.func_77960_j() != 19 || world.field_72995_K) {
            return itemStack;
        }
        MovingObjectPosition movingobjectposition = IHLUtils.returnMOPFromPlayer(entityPlayer, world);
        if (movingobjectposition != null) {
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof IHasTemperature) {
                this.setThermometerTemperature(itemStack, entityPlayer, ((IHasTemperature)te).getTemperature());
            }
            if (te instanceof IReactor) {
                this.setThermometerTemperature(itemStack, entityPlayer, ((IReactor)te).getHeat() + 273);
            }
            if (IHLMod.isGregTechModLoaded && !IHLMod.isGT_API_Version_5 && te instanceof ITileEntityTemperature) {
                this.setThermometerTemperature(itemStack, entityPlayer, ((ITileEntityTemperature)te).getTemperatureValue((byte)IHLUtils.getFacingFromPlayerView((EntityLivingBase)entityPlayer, true)));
            }
        }
        return itemStack;
    }

    public final ItemStack getContainerItem(ItemStack stack) {
        ItemStack outStack = stack.func_77946_l();
        IHLUtils.damageItemViaNBTTag(outStack, 100);
        if (outStack.field_77994_a <= 0) {
            return null;
        }
        return outStack;
    }

    public final boolean func_77630_h(ItemStack aStack) {
        return false;
    }

    public final boolean hasContainerItem(ItemStack aStack) {
        return true;
    }

    public static void init() {
        if (IHLUtils.getFirstOreDictName(Ic2Items.bronzeAxe).equals("")) {
            OreDictionary.registerOre((String)"craftingToolAxe", (Item)Ic2Items.bronzeAxe.func_77973_b());
        }
        if (IHLUtils.getFirstOreDictName(Ic2Items.bronzePickaxe).equals("")) {
            OreDictionary.registerOre((String)"craftingToolPickaxe", (Item)Ic2Items.bronzePickaxe.func_77973_b());
        }
        IHLTool item = new IHLTool();
        GameRegistry.registerItem((Item)item, (String)item.func_77658_a());
        Type[] var1 = Type.values();
        for (int i = 0; i < var1.length; ++i) {
            nameMap.put(var1[i].itemDamage, var1[i].unLocalizedName);
            ItemStack stack = new ItemStack((Item)item, 1, var1[i].itemDamage);
            stack.field_77990_d = new NBTTagCompound();
            NBTTagCompound stats = new NBTTagCompound();
            stats.func_74768_a("MaxDamage", var1[i].maxToolDamage);
            stack.field_77990_d.func_74782_a("GT.ToolStats", (NBTBase)stats);
            if (var1[i].equals((Object)Type.SetOfDies1_5sqmm)) {
                stack.field_77990_d.func_74768_a("transverseSection", 15);
            }
            IHLUtils.registerLocally(var1[i].unLocalizedName, stack);
            if (var1[i].hint != null) {
                hintMap.put(var1[i].itemDamage, var1[i].hint);
            }
            isWeaponMap.put(var1[i].itemDamage, var1[i].isWeapon);
            damageVersusEntityMap.put(var1[i].itemDamage, Float.valueOf(var1[i].damageVersusEntity));
            if (var1[i].oreDictName == null || var1[i].oreDictName.length <= 0) continue;
            for (int i1 = 0; i1 < var1[i].oreDictName.length; ++i1) {
                OreDictionary.registerOre((String)var1[i].oreDictName[i1], (ItemStack)stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        Type[] var1 = Type.values();
        for (int i = 0; i < var1.length; ++i) {
            ItemStack stack = IHLUtils.getThisModItemStack(var1[i].unLocalizedName);
            itemList.add(stack);
            if (!var1[i].equals((Object)Type.SetOfDies1_5sqmm)) continue;
            stack = IHLUtils.getItemStackWithTag(var1[i].unLocalizedName, "transverseSection", 240);
            itemList.add(stack);
        }
    }

    public String func_77667_c(ItemStack stack) {
        return nameMap.get(stack.func_77960_j());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        Type[] var1 = Type.values();
        for (int i = 0; i < var1.length; ++i) {
            iconMap.put(var1[i].itemDamage, register.func_94245_a("ihl:" + var1[i].unLocalizedName));
        }
        this.dice240 = register.func_94245_a("ihl:setOfDies24sqmm");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int i) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("transverseSection") && stack.field_77990_d.func_74762_e("transverseSection") >= 240) {
            return this.dice240;
        }
        return this.func_77617_a(stack.func_77960_j());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int i) {
        return iconMap.get(i);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean flag) {
        info.add(EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"ihl.durability") + EnumChatFormatting.GREEN + (IHLUtils.getMaxDamageValueViaNBTTag(itemStack) - IHLUtils.getDamageValueViaNBTTag(itemStack)) + " / " + IHLUtils.getMaxDamageValueViaNBTTag(itemStack));
        info.add(EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"ihl.attack_damage") + EnumChatFormatting.DARK_BLUE + damageVersusEntityMap.get(itemStack.func_77960_j()));
        if (hintMap.containsKey(itemStack.func_77960_j())) {
            info.add(EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)hintMap.get(itemStack.func_77960_j())));
        }
        if (itemStack.field_77990_d.func_74764_b("transverseSection")) {
            info.add(EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"ihl.transversesection") + EnumChatFormatting.GREEN + (float)itemStack.field_77990_d.func_74762_e("transverseSection") / 10.0f + " sq. mm.");
        }
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        IHLUtils.damageItemViaNBTTag(stack, 1);
        if (target != null && target instanceof EntitySheep && !target.func_70631_g_() && target.func_110143_aJ() <= 0.0f) {
            target.func_70099_a(IHLUtils.getThisModItemStackWithSize("muttonLard", target.field_70170_p.field_73012_v.nextInt(2) + 2), 1.0f);
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity.func_70075_an() && !entity.func_85031_j((Entity)player)) {
            float tMagicDamage = entity instanceof EntityLivingBase ? EnchantmentHelper.func_77512_a((EntityLivingBase)player, (EntityLivingBase)((EntityLivingBase)entity)) : 0.0f;
            float tDamage = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() + damageVersusEntityMap.get(stack.func_77960_j()).floatValue();
            if (tDamage + tMagicDamage > 0.0f) {
                boolean tCriticalHit;
                boolean bl = tCriticalHit = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Potion.field_76440_q) && player.field_70154_o == null && entity instanceof EntityLivingBase;
                if (tCriticalHit && tDamage > 0.0f) {
                    tDamage *= 1.5f;
                }
                if (entity.func_70097_a(DamageSource.field_76377_j, tDamage += tMagicDamage)) {
                    int tKnockcack;
                    if (entity instanceof EntityLivingBase) {
                        entity.func_70015_d(EnchantmentHelper.func_90036_a((EntityLivingBase)player) * 4);
                    }
                    if ((tKnockcack = (player.func_70051_ag() ? 1 : 0) + (entity instanceof EntityLivingBase ? EnchantmentHelper.func_77507_b((EntityLivingBase)player, (EntityLivingBase)((EntityLivingBase)entity)) : 0)) > 0) {
                        entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)tKnockcack * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)tKnockcack * 0.5f));
                        player.field_70159_w *= 0.6;
                        player.field_70179_y *= 0.6;
                        player.func_70031_b(false);
                    }
                    if (tCriticalHit) {
                        player.func_71009_b(entity);
                    }
                    if (tMagicDamage > 0.0f) {
                        player.func_71047_c(entity);
                    }
                    if (tDamage >= 18.0f) {
                        player.func_71029_a((StatBase)AchievementList.field_75999_E);
                    }
                    player.func_130011_c(entity);
                    if (entity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entity), (Entity)player);
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)player, (Entity)entity);
                    if (entity instanceof EntityLivingBase) {
                        player.func_71064_a(StatList.field_75951_w, Math.round(tDamage * 10.0f));
                    }
                    int n = entity.field_70172_ad = isWeaponMap.get(stack.func_77960_j()) != false ? 0 : 1;
                    if (entity != null && entity instanceof EntitySheep && !((EntityLivingBase)entity).func_70631_g_() && ((EntityLivingBase)entity).func_110143_aJ() <= 0.0f && isWeaponMap.get(stack.func_77960_j()).booleanValue()) {
                        entity.func_70099_a(IHLUtils.getThisModItemStackWithSize("muttonLard", entity.field_70170_p.field_73012_v.nextInt(2) + 1), 1.0f);
                    }
                    player.func_71020_j(0.3f);
                    IHLUtils.damageItemViaNBTTag(stack, 1);
                }
            }
        }
        if (stack.field_77994_a <= 0) {
            player.func_71028_bD();
        }
        return true;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)IHLUtils.getDamageValueViaNBTTag(stack) / (double)IHLUtils.getMaxDamageValueViaNBTTag(stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotIndex, boolean isCurrentItem) {
        byte timerDelay;
        if (stack.field_77990_d != null && !world.field_72995_K && stack.field_77990_d.func_74764_b("showTemperature") && (timerDelay = stack.field_77990_d.func_74771_c("showTemperature")) > 0) {
            timerDelay = (byte)(timerDelay - 1);
            if (Math.abs(stack.field_77990_d.func_74769_h("playerPosX") - entity.field_70169_q) > 0.2 || Math.abs(stack.field_77990_d.func_74769_h("playerPosY") - entity.field_70167_r) > 0.2 || Math.abs(stack.field_77990_d.func_74769_h("playerPosZ") - entity.field_70166_s) > 0.2) {
                timerDelay = 0;
            }
            stack.field_77990_d.func_74774_a("showTemperature", timerDelay);
            if (timerDelay == 0 && entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).field_71069_bz.func_75142_b();
            }
        }
    }

    private void setThermometerTemperature(ItemStack itemStack, EntityPlayer entityPlayer, long l) {
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
        itemStack.field_77990_d.func_74772_a("temperature", l);
        itemStack.field_77990_d.func_74774_a("showTemperature", (byte)60);
        itemStack.field_77990_d.func_74780_a("playerPosX", entityPlayer.field_70169_q);
        itemStack.field_77990_d.func_74780_a("playerPosY", entityPlayer.field_70167_r);
        itemStack.field_77990_d.func_74780_a("playerPosZ", entityPlayer.field_70166_s);
        entityPlayer.field_71069_bz.func_75142_b();
    }

    public static enum Type {
        Thermometer("mercuryThermometer", 19, 1, 0.1f, false, null, null),
        FiberGlassDie("fiberGlassDieSteel", 18, 20000, 0.5f, false, null, null),
        SharpenedCarvingKnifeBronze("sharpenedCarvingKnifeBronze", 17, 2000, 3.5f, true, "ihl.mutton_drop_hint", "craftingToolBlade", "craftingToolKnife"),
        GlassBlowingTube("glassBlowingTubeSteel", 16, 2000, 0.5f, false, null, null),
        PolishingPucks("polishingPucksSteel", 15, 2000, 0.5f, false, null, null),
        GravelSteel("graverSteelHardened", 14, 10, 0.5f, false, null, null),
        DiceM10Steel("diceM10x1SteelHardened", 13, 2000, 0.5f, false, null, null),
        TapM10("tapM10x1SteelHardened", 12, 2000, 0.5f, false, null, null),
        Vise("viseSteel", 11, 200000, 0.5f, false, null, null),
        SetOfFiles("setOfFilesSteel", 10, 20000, 1.5f, false, null, "craftingToolFile"),
        HandDrillBronze("handDrillBronze", 9, 20000, 0.5f, false, null, null),
        HackSawSteel("hackSawSteel", 8, 200, 0.5f, false, null, "craftingToolSaw"),
        DrillSteel("drillSteelHardened", 7, 200, 0.5f, false, null, null),
        NeedleFile("needleFile", 6, 2000, 0.1f, false, null, null),
        Chisel("chisel", 5, 2000, 1.5f, false, null, "craftingToolChisel"),
        Grindstone("grindstone", 4, 2000, 0.5f, false, null, null),
        Hammer("hammer", 3, 20000, 2.5f, false, null, "craftingToolHardHammer", "craftingToolForgeHammer"),
        TinSnipsSteel("tinSnipsSteel", 2, 2000, 0.5f, false, null, "craftingToolWireCutter"),
        SetOfDies1_5sqmm("setOfDies1_5sqmm", 0, 2000, 0.5f, false, null, null);

        public final String unLocalizedName;
        public final String[] oreDictName;
        public final int itemDamage;
        public final int maxToolDamage;
        public final float damageVersusEntity;
        public final boolean isWeapon;
        public final String hint;

        private Type(String unlocalizedName1, int itemDamage1, int maxToolDamage1, float damageVersusEntity1, boolean isWeapon1, String hint1, String ... oreDictName1) {
            this.unLocalizedName = unlocalizedName1;
            this.itemDamage = itemDamage1;
            this.maxToolDamage = maxToolDamage1;
            this.damageVersusEntity = damageVersusEntity1;
            this.isWeapon = isWeapon1;
            this.hint = hint1;
            this.oreDictName = oreDictName1;
        }
    }
}

