/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.metallurgy;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.invslot.InvSlot;
import ic2.core.network.NetworkManager;
import ihl.flexible_cable.FlexibleCableHolderBaseTileEntity;
import ihl.flexible_cable.NodeEntity;
import ihl.processing.metallurgy.ElectricEngineInvSlot;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BasicElectricMotorTileEntity
extends FlexibleCableHolderBaseTileEntity
implements IHasGui,
INetworkClientTileEntityEventListener,
IEnergySink {
    public final ElectricEngineInvSlot engine;
    public short progress;
    protected short operationLength = (short)600;
    public boolean isGuiScreenOpened = false;
    protected final double energyConsume = 0.1;
    public double energy;
    public int maxStorage = 128;
    private boolean addedToEnergyNet = false;

    public BasicElectricMotorTileEntity() {
        this.engine = new ElectricEngineInvSlot(this, "engine", 0, InvSlot.Access.IO, 1, 1);
    }

    public String func_145825_b() {
        return "Lathe";
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void setFacing(short facing1) {
        short facing2 = (short)Math.max(facing1, 2);
        double d = 0.3;
        double f = -0.1;
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        double range = 2.0;
        AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)(this.connectionX - range), (double)(this.connectionY - range), (double)(this.connectionZ - range), (double)(this.connectionX + range), (double)(this.connectionY + range), (double)(this.connectionZ + range));
        List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
        super.setFacing(facing2);
        switch (this.getFacing()) {
            case 4: {
                this.setConnectionX((double)this.field_145851_c + 0.5);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + 1.0 - f);
                break;
            }
            case 5: {
                this.setConnectionX((double)this.field_145851_c + 0.5);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + f);
                break;
            }
            case 2: {
                this.setConnectionX((double)this.field_145851_c + 1.0 - f);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + 0.5);
                break;
            }
            case 3: {
                this.setConnectionX((double)this.field_145851_c + f);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + 0.5);
                break;
            }
            default: {
                this.setConnectionX((double)this.field_145851_c + 1.0 - f);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + 0.5);
            }
        }
        if (!nodeList.isEmpty()) {
            for (NodeEntity ne : nodeList) {
                if (ne.prevAnchorEntity != null && ne.nextAnchorEntity != null || !this.cableListContains(ne.getChainUniqueID())) continue;
                ne.setVirtualNodePos(this.connectionX, this.connectionY, this.connectionZ);
            }
        }
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public double getDemandedEnergy() {
        if (this.gridID == -1) {
            return (double)this.maxStorage - this.energy;
        }
        return this.getGrid().getDemandedEnergy();
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy < (double)this.maxStorage) {
            this.energy += amount;
            return 0.0;
        }
        if (this.gridID != -1 && this.getGrid().energy <= 0.0) {
            this.getGrid().injectEnergy(amount, 400.0, this);
            return 0.0;
        }
        return amount;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("progress", this.progress);
        nbt.func_74780_a("energy", this.energy);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74765_d("progress");
        this.energy = nbt.func_74769_h("energy");
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            case 0: {
                this.isGuiScreenOpened = false;
            }
        }
    }

    public abstract void operate();

    public void updateEntityServer() {
        if (this.gridID != -1 && this.getGrid().energy > 0.0 && this.energy < (double)this.maxStorage) {
            this.energy += 1.0;
            this.getGrid().drawEnergy(1.0, this);
        }
        if (this.canOperate() && this.engine.correctContent() && this.isGuiScreenOpened && this.energy >= this.energyConsume / (double)this.engine.getEfficiency()) {
            this.energy -= this.energyConsume / (double)this.engine.getEfficiency();
            if (this.progress == 0) {
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 0, true);
            }
            this.progress = (short)(this.progress + 1);
            if (this.progress >= this.operationLength) {
                this.operate();
                this.progress = 0;
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 2, true);
            }
        } else {
            if (this.progress != 0 && this.getActive()) {
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 1, true);
            }
            if (!this.canOperate()) {
                this.progress = 0;
            }
        }
    }

    public abstract List[] getInput();

    public abstract boolean canOperate();

    public void onGuiClosed(EntityPlayer arg0) {
    }

    public int getEnergy() {
        return (int)this.energy;
    }

    public int getGUIEnergy(int i) {
        if (this.energy < 3.4028234663852886E38) {
            return Math.round((float)this.energy / (float)this.maxStorage * (float)i);
        }
        return Math.round((float)(this.energy / (double)this.maxStorage) * (float)i);
    }

    public int gaugeProgressScaled(int i) {
        return this.progress * i / this.operationLength;
    }

    public void setEnergy(int value) {
        this.energy = value;
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getMaxAllowableVoltage() {
        return 64000.0;
    }
}

