/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.metallurgy;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.network.NetworkManager;
import ihl.interfaces.IHasTemperature;
import ihl.processing.chemistry.ApparatusProcessableInvSlot;
import ihl.processing.chemistry.ChemicalReactorTileEntity;
import ihl.processing.invslots.IHLInvSlotOutput;
import ihl.processing.invslots.InvSlotConsumableLiquidIHL;
import ihl.processing.metallurgy.ImpregnatingMachineContainer;
import ihl.processing.metallurgy.ImpregnatingMachineGui;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLFluidTank;
import ihl.utils.IHLUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class ImpregnatingMachineTileEntity
extends TileEntityInventory
implements IHasGui,
INetworkTileEntityEventListener,
IFluidHandler,
IHasTemperature {
    private static final UniversalRecipeManager recipeManager = new UniversalRecipeManager("tub");
    public final ApparatusProcessableInvSlot input;
    public final IHLInvSlotOutput outputSlot;
    public final InvSlotConsumableLiquidIHL drainInputSlot;
    public final InvSlotConsumableLiquidIHL fillInputSlot;
    public final InvSlotOutput emptyFluidItemsSlot;
    public short progress;
    protected short operationLength = (short)16383;
    private final IHLFluidTank fluidTank = new IHLFluidTank(8000);
    public short temperature = (short)20;
    public int visibleFluidId = -1;
    public int visibleFluidAmount = 1;

    public ImpregnatingMachineTileEntity() {
        this.outputSlot = new IHLInvSlotOutput(this, "output", 0, 2);
        this.drainInputSlot = new InvSlotConsumableLiquidIHL(this, "drainInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Drain);
        this.fillInputSlot = new InvSlotConsumableLiquidIHL(this, "fillInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.BOTTOM, InvSlotConsumableLiquid.OpType.Fill);
        this.emptyFluidItemsSlot = new InvSlotOutput((TileEntityInventory)this, "fluidCellsOutput", 2, 1);
        this.input = new ApparatusProcessableInvSlot(this, "input", 3, InvSlot.Access.IO, 1, 64);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return IHLUtils.getThisModItemStack("tubBronze");
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public List<String> getNetworkedFields() {
        List ret = super.getNetworkedFields();
        ret.add("visibleFluidId");
        ret.add("visibleFluidAmount");
        return ret;
    }

    public void updateEntityServer() {
        if (this.fluidTank.getFluid() != null && this.fluidTank.getLigthestFluid().getFluid().isGaseous()) {
            this.fluidTank.drainLightest(10, true);
        }
        if (this.fluidTank.getFluid() != null && (this.visibleFluidId != this.fluidTank.getFluid().getFluid().getID() || this.visibleFluidAmount != this.fluidTank.getFluidAmount())) {
            this.visibleFluidId = this.fluidTank.getFluid().getFluid().getID();
            this.visibleFluidAmount = this.fluidTank.getFluidAmount();
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "visibleFluidId");
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "visibleFluidAmount");
        } else if (this.fluidTank.getFluid() == null && this.visibleFluidId != -1) {
            this.visibleFluidId = -1;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "visibleFluidId");
        }
        this.temperature = (short)(this.fluidTank.getTemperature() - 273);
        IHLUtils.handleFluidSlotsBehaviour(this.fillInputSlot, this.drainInputSlot, this.emptyFluidItemsSlot, this.fluidTank);
        boolean needsInvUpdate = false;
        if (this.canOperate()) {
            this.setActive(true);
            if (this.progress == 0) {
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 0, true);
            }
            this.progress = (short)(this.progress + this.operationLength / this.getOutput().getTime());
            if (this.progress >= this.operationLength) {
                this.operate();
                needsInvUpdate = true;
                this.progress = 0;
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 2, true);
            }
        } else {
            if (this.progress != 0 && this.getActive()) {
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 1, true);
            }
            if (!this.canOperate()) {
                this.progress = 0;
            }
            this.setActive(false);
        }
    }

    public FluidStack drain(ForgeDirection from, int amount, boolean doDrain) {
        FluidStack fstack = this.fluidTank.drain(amount, doDrain);
        return fstack;
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return true;
    }

    public boolean canFill(ForgeDirection direction, Fluid arg1) {
        return true;
    }

    public String func_145825_b() {
        return "impregnatingMachine";
    }

    private int mX() {
        switch (this.getFacing()) {
            case 4: {
                return -1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    private int mZ() {
        switch (this.getFacing()) {
            case 3: {
                return 1;
            }
            case 2: {
                return -1;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
        }
        return -1;
    }

    private short getFacingFromXZ(int x, int z) {
        switch (x) {
            case -1: {
                return 4;
            }
            case 1: {
                return 5;
            }
        }
        switch (z) {
            case 1: {
                return 3;
            }
            case -1: {
                return 2;
            }
        }
        return 2;
    }

    public float getRenderLiquidLevel() {
        return (float)this.visibleFluidAmount / (float)this.fluidTank.getCapacity();
    }

    public void onNetworkEvent(int event) {
    }

    public int gaugeProgressScaled(int i) {
        return this.progress * i / this.operationLength;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean arg1) {
        return new ImpregnatingMachineGui(new ImpregnatingMachineContainer(player, this));
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        this.fluidTank.sortFluidsByDensity();
        return new ImpregnatingMachineContainer(player, this);
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public boolean canOperate() {
        return this.getOutput() != null && this.outputSlot.canAdd(this.getOutput().getItemOutputs());
    }

    public UniversalRecipeOutput getOutput() {
        return recipeManager.getOutputFor(this.getInput(), false, false);
    }

    public List[] getInput() {
        for (int i = 0; i < this.fluidTank.getNumberOfFluids(); ++i) {
            for (int i1 = 0; i1 < this.fluidTank.getNumberOfFluids(); ++i1) {
                List[] rInput;
                if (i == i1 || recipeManager.getOutputFor(rInput = new List[]{Arrays.asList(this.fluidTank.getFluid(i), this.fluidTank.getFluid(i1)), this.input.getItemStackList()}, false, false) == null) continue;
                return rInput;
            }
        }
        return new List[]{Arrays.asList(this.fluidTank.getFluid()), this.input.getItemStackList()};
    }

    public void operate() {
        UniversalRecipeInput recipeInput = recipeManager.getRecipeInput(this.getInput());
        UniversalRecipeOutput output1 = this.getOutput();
        for (int i = 0; i < recipeInput.getItemInputs().size(); ++i) {
            this.input.consume(i, recipeInput.getItemInputs().get(i).getAmount());
        }
        this.fluidTank.drain(recipeInput.getFluidInputs(), true);
        this.fluidTank.fill(output1.getFluidOutputs(), true);
        if (!output1.getItemOutputs().isEmpty() && output1.getItemOutputs().get(0) != null) {
            this.outputSlot.add(output1.getItemOutputs());
        }
    }

    public FluidStack drain(ForgeDirection arg0, FluidStack fluidStack, boolean doDrain) {
        if (this.fluidTank.getFluid() != null && this.fluidTank.getFluid().containsFluid(fluidStack)) {
            return this.fluidTank.drain(fluidStack, doDrain);
        }
        return null;
    }

    public int fill(ForgeDirection arg0, FluidStack arg1, boolean arg2) {
        return this.fluidTank.fill(arg1, arg2);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection arg0) {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }

    public short getFacing() {
        return 3;
    }

    public boolean needsFluid() {
        return this.fluidTank.getFluidAmount() <= this.fluidTank.getCapacity();
    }

    public FluidStack getFluidStackfromTank() {
        return this.fluidTank.getFluid();
    }

    public int getTankAmount() {
        return this.fluidTank.getFluidAmount();
    }

    public int gaugeLiquidScaled(int i, int index) {
        return this.fluidTank.getFluidAmount() <= 0 ? 0 : this.fluidTank.getFluidAmount(index) * i / this.fluidTank.getCapacity();
    }

    public static void addRecipe(UniversalRecipeInput input, UniversalRecipeOutput output) {
        recipeManager.addRecipe(input, output);
    }

    public int getNumberOfFluidsInTank() {
        return this.fluidTank.getNumberOfFluids();
    }

    public static Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return recipeManager.getRecipes();
    }

    public static void addQuenchingRecipe(String nameHot, String nameQuenched) {
        ImpregnatingMachineTileEntity.addRecipe(new UniversalRecipeInput(Arrays.asList(new FluidStack(FluidRegistry.WATER, 50)), Arrays.asList(IHLUtils.getThisModItemStack(nameHot))), new UniversalRecipeOutput(null, Arrays.asList(IHLUtils.getThisModItemStack(nameQuenched)), 2));
    }

    public IHLFluidTank getFluidTank() {
        return this.fluidTank;
    }

    public static void addChemicalRecipe(UniversalRecipeInput universalRecipeInput, UniversalRecipeOutput universalRecipeOutput) {
        ImpregnatingMachineTileEntity.addRecipe(universalRecipeInput, universalRecipeOutput);
        ChemicalReactorTileEntity.addRecipe(universalRecipeInput, universalRecipeOutput);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    @Override
    public int getTemperature() {
        return this.fluidTank.getTemperature();
    }
}

