/*
 * Decompiled with CFR 0.152.
 */
package ihl.recipes;

import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ihl.interfaces.IWire;
import ihl.recipes.RecipeInputWire;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class IronWorkbenchRecipe {
    public List<ItemStack> workspaceElements = new ArrayList<ItemStack>();
    public List<IRecipeInput> tools = new ArrayList<IRecipeInput>();
    public List<IRecipeInput> materials = new ArrayList<IRecipeInput>();
    public List<ItemStack> outputs = new ArrayList<ItemStack>();

    public IronWorkbenchRecipe(List tools1, List materials1, List<ItemStack> output1_1) {
        String oreDictName;
        ItemStack stack;
        if (tools1 != null) {
            for (Object tool : tools1) {
                if (tool instanceof ItemStack) {
                    stack = (ItemStack)tool;
                    oreDictName = IHLUtils.getFirstOreDictNameExcludingTagAny(stack);
                    if (!oreDictName.isEmpty() && oreDictName.length() > 3) {
                        this.tools.add((IRecipeInput)new RecipeInputOreDict(oreDictName));
                        continue;
                    }
                    this.tools.add((IRecipeInput)new RecipeInputItemStack(stack));
                    continue;
                }
                this.tools.add((IRecipeInput)tool);
            }
        }
        for (Object material : materials1) {
            if (material instanceof ItemStack) {
                stack = (ItemStack)material;
                oreDictName = IHLUtils.getFirstOreDictNameExcludingTagAny(stack);
                if (stack.func_77973_b() instanceof IWire) {
                    this.materials.add(new RecipeInputWire(stack));
                    continue;
                }
                if (!oreDictName.isEmpty() && oreDictName.length() > 3) {
                    this.materials.add((IRecipeInput)new RecipeInputOreDict(oreDictName, stack.field_77994_a));
                    continue;
                }
                this.materials.add((IRecipeInput)new RecipeInputItemStack(stack));
                continue;
            }
            this.materials.add((IRecipeInput)material);
        }
        this.outputs.addAll(output1_1);
        if (this.tools.size() > 8 || this.materials.size() > 12) {
            throw new IllegalArgumentException("Iron workbench recipe cannot contain more than 8 tools or materials!");
        }
    }

    public IronWorkbenchRecipe(List asList, List asList2, List<ItemStack> asList3, List<ItemStack> workspaceElements1) {
        this(asList, asList2, asList3);
        this.workspaceElements.addAll(workspaceElements1);
    }

    public boolean isCanBeCrafted(List<ItemStack> tools1, List<ItemStack> materials1, List<ItemStack> workspaceElements1) {
        if (this.workspaceElements != null && !this.workspaceElements.isEmpty()) {
            if (workspaceElements1 == null || workspaceElements1.isEmpty()) {
                return false;
            }
            for (ItemStack itemStack : this.workspaceElements) {
                if (this.isItemStackInList(itemStack, workspaceElements1)) continue;
                return false;
            }
        }
        if (this.tools != null && !this.tools.isEmpty()) {
            if (tools1 == null || tools1.isEmpty()) {
                return false;
            }
            for (IRecipeInput iRecipeInput : this.tools) {
                if (this.isItemStackInList(iRecipeInput, tools1)) continue;
                return false;
            }
        }
        if (this.materials != null && !this.materials.isEmpty()) {
            for (IRecipeInput iRecipeInput : this.materials) {
                if (this.isItemStackInList(iRecipeInput, materials1)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isItemStackInList(IRecipeInput tool, List<ItemStack> tools1) {
        for (ItemStack tool2 : tools1) {
            if (!tool.matches(tool2) || !(tool2.func_77973_b() instanceof IWire ? IHLUtils.getWireLength(tool2) >= tool.getAmount() : tool2.field_77994_a >= tool.getAmount())) continue;
            return true;
        }
        return false;
    }

    private boolean isItemStackInList(ItemStack tool, List<ItemStack> tools1) {
        for (ItemStack tool2 : tools1) {
            if (!IHLUtils.isItemStacksIsEqual(tool, tool2, true) || !(tool2.func_77973_b() instanceof IWire ? IHLUtils.getWireLength(tool2) >= IHLUtils.getWireLength(tool) : tool2.field_77994_a >= tool.field_77994_a)) continue;
            return true;
        }
        return false;
    }
}

