/*
 * Decompiled with CFR 0.152.
 */
package ihl.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import ihl.IHLMod;
import ihl.utils.IHLUtils;
import ihl.worldgen.WorldGenLiquidOre;
import ihl.worldgen.WorldGenMinableMeta;
import ihl.worldgen.ores.IHLFluid;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class IHLWorldGenerator
implements IWorldGenerator {
    private WorldGenMinableMeta apatiteGenerator;
    private WorldGenMinableMeta saltpeterGenerator;
    private WorldGenMinableMeta limestoneGenerator;
    private WorldGenMinableMeta gypsumGenerator;
    private WorldGenMinableMeta potassiumFeldsparGenerator;
    private WorldGenMinableMeta tronaGenerator;
    private WorldGenMinableMeta gyubneraGenerator;
    private WorldGenMinableMeta rocksaltGenerator;
    private WorldGenMinableMeta cinnabarGenerator;
    private WorldGenMinableMeta bauxiteGenerator;
    private WorldGenMinableMeta chromiteGenerator;
    private WorldGenMinableMeta muscoviteGenerator;
    private WorldGenMinableMeta oilGenerator;
    private WorldGenMinableMeta datoliteGenerator;
    private WorldGenMinableMeta saltwaterGenerator;
    private WorldGenMinableMeta bischofiteGenerator;
    private WorldGenMinableMeta currentGenerator;
    protected final Map<Long, Set<int[]>> oreCoordinatesToChunkCoordinates = new HashMap<Long, Set<int[]>>();
    protected final Map<Long, WorldGenMinableMeta> blockToOreCoordinates = new HashMap<Long, WorldGenMinableMeta>();
    public final Set<Long> precalculatedChunkChache = new HashSet<Long>();
    public static IHLWorldGenerator instance;

    public IHLWorldGenerator() {
        this.apatiteGenerator = new WorldGenMinableMeta(this.precalculatedChunkChache, this.blockToOreCoordinates, this.oreCoordinatesToChunkCoordinates, IHLUtils.getOreDictBlock("oreApatite"), 0, 360, Blocks.field_150348_b, Blocks.field_150351_n);
        this.saltpeterGenerator = new WorldGenMinableMeta(this.precalculatedChunkChache, this.blockToOreCoordinates, this.oreCoordinatesToChunkCoordinates, IHLUtils.getOreDictBlock("oreSaltpeter"), 0, 140, Blocks.field_150348_b, Blocks.field_150351_n);
        this.limestoneGenerator = new WorldGenMinableMeta(this.precalculatedChunkChache, this.blockToOreCoordinates, this.oreCoordinatesToChunkCoordinates, IHLUtils.getOreDictBlock("oreLimestone"), 0, 140, Blocks.field_150348_b, Blocks.field_150351_n);
        this.gypsumGenerator = new WorldGenMinableMeta(this.precalculatedChunkChache, this.blockToOreCoordinates, this.oreCoordinatesToChunkCoordinates, IHLUtils.getOreDictBlock("oreGypsum"), 0, 140, Blocks.field_150348_b, Blocks.field_150351_n);
        this.potassiumFeldsparGenerator = new WorldGenMinableMeta(this.precalculatedChunkChache, this.blockToOreCoordinates, this.oreCoordinatesToChunkCoordinates, IHLUtils.getOreDictBlock("orePotassiumFeldspar"), 0, 140, Blocks.field_150348_b, Blocks.field_150351_n);
        this.tronaGenerator = new WorldGenMinableMeta(this.precalculatedChunkChache, this.blockToOreCoordinates, this.oreCoordinatesToChunkCoordinates, IHLUtils.getOreDictBlock("oreTrona"), 0, 700, Blocks.field_150348_b, Blocks.field_150351_n);
        this.gyubneraGenerator = new WorldGenMinableMeta(this.precalculatedChunkChache, this.blockToOreCoordinates, this.oreCoordinatesToChunkCoordinates, IHLUtils.getOreDictBlock("oreGyubnera"), 0, 700, Blocks.field_150348_b, Blocks.field_150351_n);
        this.rocksaltGenerator = new WorldGenMinableMeta(this.precalculatedChunkChache, this.blockToOreCoordinates, this.oreCoordinatesToChunkCoordinates, IHLUtils.getOreDictBlock("oreRockSalt"), 0, 140, Blocks.field_150348_b, Blocks.field_150351_n);
        this.cinnabarGenerator = new WorldGenMinableMeta(this.precalculatedChunkChache, this.blockToOreCoordinates, this.oreCoordinatesToChunkCoordinates, IHLUtils.getOreDictBlock("oreCinnabar"), 0, 700, Blocks.field_150348_b, Blocks.field_150351_n);
        this.bauxiteGenerator = new WorldGenMinableMeta(this.precalculatedChunkChache, this.blockToOreCoordinates, this.oreCoordinatesToChunkCoordinates, IHLUtils.getOreDictBlock("oreBauxite"), 0, 700, Blocks.field_150348_b, Blocks.field_150351_n);
        this.chromiteGenerator = new WorldGenMinableMeta(this.precalculatedChunkChache, this.blockToOreCoordinates, this.oreCoordinatesToChunkCoordinates, IHLUtils.getOreDictBlock("oreChromite"), 0, 700, Blocks.field_150348_b, Blocks.field_150351_n);
        this.muscoviteGenerator = new WorldGenMinableMeta(this.precalculatedChunkChache, this.blockToOreCoordinates, this.oreCoordinatesToChunkCoordinates, IHLUtils.getOreDictBlock("oreMica"), 0, 140, Blocks.field_150348_b, Blocks.field_150351_n);
        this.oilGenerator = new WorldGenLiquidOre(this.precalculatedChunkChache, this.blockToOreCoordinates, this.oreCoordinatesToChunkCoordinates, IHLFluid.getBlock("oil"), Blocks.field_150435_aG, 0, 32, 0, 8, Blocks.field_150353_l, Blocks.field_150435_aG);
        this.datoliteGenerator = new WorldGenMinableMeta(this.precalculatedChunkChache, this.blockToOreCoordinates, this.oreCoordinatesToChunkCoordinates, IHLUtils.getOreDictBlock("oreDatolite"), 0, 700, Blocks.field_150348_b, Blocks.field_150351_n);
        this.saltwaterGenerator = new WorldGenLiquidOre(this.precalculatedChunkChache, this.blockToOreCoordinates, this.oreCoordinatesToChunkCoordinates, IHLFluid.getBlock("saltwater"), Blocks.field_150322_A, 0, 32, 62, 62, new Block[]{Blocks.field_150354_m, Blocks.field_150322_A});
        this.bischofiteGenerator = new WorldGenMinableMeta(this.precalculatedChunkChache, this.blockToOreCoordinates, this.oreCoordinatesToChunkCoordinates, IHLUtils.getOreDictBlock("oreBischofite"), 0, 1400, Blocks.field_150348_b, Blocks.field_150351_n);
        instance = this;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        Set<int[]> oreCoordinatesSet;
        int x1 = 0;
        int y1 = 0;
        int z1 = 0;
        for (int ix = -16 + chunkX; ix <= 16 + chunkX; ++ix) {
            for (int iz = -16 + chunkZ; iz <= 16 + chunkZ; ++iz) {
                long chunkKey = (ix << 16) + iz;
                if (this.precalculatedChunkChache.contains(chunkKey)) continue;
                if (!world.func_72863_F().func_73149_a(ix, iz) || ix == chunkX && iz == chunkZ) {
                    this.currentGenerator = this.switchCurrentOreGenerator(world, random, ix, iz);
                    if (this.currentGenerator == null || this.currentGenerator.generateNewVein(random, ix, iz)) {
                        // empty if block
                    }
                }
                this.precalculatedChunkChache.add(chunkKey);
            }
        }
        long chunkKey = (chunkX << 16) + chunkZ;
        if (this.precalculatedChunkChache.contains(chunkKey) && (oreCoordinatesSet = this.oreCoordinatesToChunkCoordinates.get(chunkKey)) != null) {
            Object[] oreCoordinatesSetA = oreCoordinatesSet.toArray();
            for (int i = 0; i < oreCoordinatesSetA.length; ++i) {
                int[] oreCoordinate = (int[])oreCoordinatesSetA[i];
                int x0 = oreCoordinate[0];
                int y0 = oreCoordinate[1];
                int z0 = oreCoordinate[2];
                long oreCoordinatesKey = (x0 << 30) + (y0 << 15) + z0;
                if (!this.blockToOreCoordinates.get(oreCoordinatesKey).func_76484_a(world, random, x0, y0, z0)) continue;
                x1 = x0;
                y1 = y0;
                z1 = z0;
            }
        }
    }

    private WorldGenMinableMeta switchCurrentOreGenerator(World world, Random random, int chunkX, int chunkZ) {
        switch (random.nextInt(1000)) {
            case 0: {
                if (!IHLMod.config.generateApatiteOre || !(random.nextFloat() < 0.25f)) break;
                return this.apatiteGenerator;
            }
            case 1: {
                if (!IHLMod.config.generateSaltpeterOre || !(random.nextFloat() < 0.25f)) break;
                return this.saltpeterGenerator;
            }
            case 2: {
                if (!IHLMod.config.generateGyubnera || !(random.nextFloat() < 0.25f)) break;
                return this.gyubneraGenerator;
            }
            case 3: {
                if (!IHLMod.config.generateCinnabar || !(random.nextFloat() < 0.25f)) break;
                return this.cinnabarGenerator;
            }
            case 4: {
                if (!IHLMod.config.generateRocksalt || !(random.nextFloat() < 0.2f)) break;
                return this.rocksaltGenerator;
            }
            case 5: {
                if (!IHLMod.config.generateLimestone) break;
                return this.limestoneGenerator;
            }
            case 6: {
                if (!IHLMod.config.generateGypsum) break;
                return this.gypsumGenerator;
            }
            case 7: {
                if (!IHLMod.config.generatePotassiumFeldspar) break;
                return this.potassiumFeldsparGenerator;
            }
            case 8: {
                if (!IHLMod.config.generateTrona) break;
                return this.tronaGenerator;
            }
            case 9: {
                if (!IHLMod.config.generateBauxite || !(random.nextFloat() < 0.25f)) break;
                return this.bauxiteGenerator;
            }
            case 10: {
                if (!IHLMod.config.generateChromite || !(random.nextFloat() < 0.25f)) break;
                return this.chromiteGenerator;
            }
            case 11: {
                if (!IHLMod.config.generateMuscovite) break;
                return this.muscoviteGenerator;
            }
            case 12: {
                if (!IHLMod.config.generateOil) break;
                return this.oilGenerator;
            }
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                if (!IHLMod.config.generateSaltwater) break;
                BiomeGenBase biome = world.func_72807_a(chunkX << 4, chunkZ << 4);
                if (!(biome.field_76750_F > 1.9f) || biome.field_76751_G != 0.0f) break;
                return this.saltwaterGenerator;
            }
            case 14: {
                if (!IHLMod.config.generateDatolite || !(random.nextFloat() < 0.25f)) break;
                return this.datoliteGenerator;
            }
            case 15: {
                if (!IHLMod.config.generateBischofite || !(random.nextFloat() < 0.25f)) break;
                return this.bischofiteGenerator;
            }
        }
        return null;
    }
}

