/*
 * Decompiled with CFR 0.152.
 */
package ihl.enviroment;

import ihl.IHLMod;
import ihl.enviroment.MirrorTileEntity;
import ihl.model.IHLBlockRenderer;
import ihl.utils.IHLRenderUtils;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.glu.Project;

public class MirrorRender
extends TileEntitySpecialRenderer {
    private int texture = -1;
    private int fb = -1;
    private static final IntBuffer textureIDBuffer = BufferUtils.createIntBuffer((int)1);
    private static final float zNear = 1.5f;
    private static final float zFar = 0.1f;
    private final int textureWidth = 512;
    private final int textureHeight = 512;
    private final int[] xdepth = new int[]{0, 0, 1, 1};
    private final int[] ydepth = new int[]{0, 1, 1, 0};
    private final int[] textureU = new int[]{0, 0, 1, 1};
    private final int[] textureV = new int[]{0, 1, 1, 0};
    private final Minecraft mc = Minecraft.func_71410_x();
    private static final boolean useARB = true;

    public void renderAModelAt(MirrorTileEntity tile, double x, double y, double z, float f) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float[] mAxis = tile.getMirrorAxis();
        if (this.texture == -1) {
            GL11.glGenTextures((IntBuffer)textureIDBuffer);
            this.texture = textureIDBuffer.get(0);
            this.fb = GL30.glGenFramebuffers();
            GL30.glBindFramebuffer((int)36160, (int)this.fb);
            GL11.glBindTexture((int)3553, (int)this.texture);
            GL11.glTexImage2D((int)3553, (int)0, (int)32849, (int)512, (int)512, (int)0, (int)6407, (int)5121, (ByteBuffer)null);
            GL11.glTexParameterf((int)3553, (int)10242, (float)10496.0f);
            GL11.glTexParameterf((int)3553, (int)10243, (float)10496.0f);
            GL11.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GL11.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            int depthBuffer = GL30.glGenRenderbuffers();
            GL30.glBindRenderbuffer((int)36161, (int)depthBuffer);
            GL30.glRenderbufferStorage((int)36161, (int)6402, (int)512, (int)512);
            GL30.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)depthBuffer);
            GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.texture, (int)0);
            IntBuffer drawBuffs = BufferUtils.createIntBuffer((int)1);
            drawBuffs.put(0, 36064);
            GL20.glDrawBuffers((IntBuffer)drawBuffs);
            if (GL30.glCheckFramebufferStatus((int)36160) != 36053) {
                IHLMod.log.error("Something went wrong while creating frame buffer!");
                IHLMod.log.error((Object)GL30.glCheckFramebufferStatus((int)36160));
            } else {
                IHLMod.log.info("FrameBuffer loaded correctly!");
            }
        }
        if (tile.shouldReflect && (x > -0.8 && mAxis[3] == -1.0f || x < -0.2 && mAxis[3] == 1.0f || y > -0.8 && mAxis[4] == -1.0f || y < -0.2 && mAxis[4] == 1.0f || z > -0.8 && mAxis[5] == -1.0f || z < -0.2 && mAxis[5] == 1.0f)) {
            GL30.glBindFramebuffer((int)36160, (int)this.fb);
            this.drawReflection(tile, x, y, z, f);
            this.mc.field_71460_t.func_78479_a(f, 0);
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            this.defineMeshAndTextureCoordinates(tile);
            IHLRenderUtils.instance.enableAmbientLighting();
            this.drawMirrorFrame(tile);
            IHLRenderUtils.instance.disableAmbientLighting();
            RenderHelper.func_74519_b();
            GL11.glPopMatrix();
        }
    }

    public void func_147500_a(TileEntity par1TileEntity, double par2, double par4, double par6, float par8) {
        this.renderAModelAt((MirrorTileEntity)par1TileEntity, par2, par4, par6, par8);
    }

    private void drawReflection(MirrorTileEntity tile, double x, double y, double z, float f) {
        GL11.glViewport((int)0, (int)0, (int)512, (int)512);
        GL11.glClear((int)16640);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.setMirrorView(tile, x, y, z);
        IHLRenderUtils.instance.enableAmbientLighting();
        this.mc.field_71438_f.func_72714_a(f);
        this.mc.field_71438_f.func_72718_b(f);
        IHLRenderUtils.instance.disableAmbientLighting();
        this.setMirrorView(tile, x, y, z);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_147499_a(TextureMap.field_110575_b);
        GL11.glTranslatef((float)(-tile.field_145851_c), (float)(-tile.field_145848_d), (float)(-tile.field_145849_e));
        if (tile.displayListCache != -1) {
            GL11.glCallList((int)tile.displayListCache);
            if (tile.needRenderUpdate) {
                IHLBlockRenderer.instance.refreshDisplayLists(tile.displayListCache, tile.bwc, tile.chunkCache);
                tile.needRenderUpdate = false;
            }
        } else if (tile.chunkCache != null) {
            tile.displayListCache = GLAllocation.func_74526_a((int)1);
            IHLBlockRenderer.instance.refreshDisplayLists(tile.displayListCache, tile.bwc, tile.chunkCache);
        }
        for (Entity centity : tile.reflectedEntity) {
            Render render = (Render)IHLMod.proxy.getRenderForEntityClass(centity.getClass());
            if (render == null) continue;
            render.func_76986_a(centity, centity.field_70169_q, centity.field_70167_r, centity.field_70166_s, 1.0f, f);
            GL11.glEnable((int)2903);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        for (TileEntity te : tile.reflectedTileEntity) {
            if (!TileEntityRendererDispatcher.field_147556_a.func_147545_a(te)) continue;
            TileEntitySpecialRenderer specialRenderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(te);
            specialRenderer.func_147500_a(te, (double)te.field_145851_c, (double)te.field_145848_d, (double)te.field_145849_e, f);
            GL11.glEnable((int)2903);
        }
        GL11.glViewport((int)0, (int)0, (int)Display.getWidth(), (int)Display.getHeight());
    }

    private void defineMeshAndTextureCoordinates(MirrorTileEntity tile) {
        switch (tile.getFacing()) {
            case 0: {
                this.xdepth[0] = 1 + tile.reflectExtensionRight;
                this.xdepth[1] = 1 + tile.reflectExtensionRight;
                this.xdepth[2] = 0;
                this.xdepth[3] = 0;
                this.ydepth[0] = 0;
                this.ydepth[1] = 1 + tile.reflectExtensionTop;
                this.ydepth[2] = 1 + tile.reflectExtensionTop;
                this.ydepth[3] = 0;
                this.textureU[0] = 0;
                this.textureU[1] = 0;
                this.textureU[2] = 1;
                this.textureU[3] = 1;
                this.textureV[0] = 0;
                this.textureV[1] = 1;
                this.textureV[2] = 1;
                this.textureV[3] = 0;
                break;
            }
            case 1: {
                this.xdepth[0] = -tile.reflectExtensionRight;
                this.xdepth[1] = -tile.reflectExtensionRight;
                this.xdepth[2] = 1;
                this.xdepth[3] = 1;
                this.ydepth[0] = -tile.reflectExtensionTop;
                this.ydepth[1] = 1;
                this.ydepth[2] = 1;
                this.ydepth[3] = -tile.reflectExtensionTop;
                this.textureU[0] = 0;
                this.textureU[1] = 0;
                this.textureU[2] = 1;
                this.textureU[3] = 1;
                this.textureV[0] = 0;
                this.textureV[1] = 1;
                this.textureV[2] = 1;
                this.textureV[3] = 0;
                break;
            }
            case 2: {
                this.xdepth[0] = 0;
                this.xdepth[1] = 0;
                this.xdepth[2] = 1 + tile.reflectExtensionRight;
                this.xdepth[3] = 1 + tile.reflectExtensionRight;
                this.ydepth[0] = 0;
                this.ydepth[1] = 1 + tile.reflectExtensionTop;
                this.ydepth[2] = 1 + tile.reflectExtensionTop;
                this.ydepth[3] = 0;
                this.textureU[0] = 0;
                this.textureU[1] = 0;
                this.textureU[2] = 1;
                this.textureU[3] = 1;
                this.textureV[0] = 0;
                this.textureV[1] = 1;
                this.textureV[2] = 1;
                this.textureV[3] = 0;
                break;
            }
            case 3: {
                this.xdepth[0] = -tile.reflectExtensionRight;
                this.xdepth[1] = 1;
                this.xdepth[2] = 1;
                this.xdepth[3] = -tile.reflectExtensionRight;
                this.ydepth[0] = 0;
                this.ydepth[1] = 0;
                this.ydepth[2] = 1 + tile.reflectExtensionTop;
                this.ydepth[3] = 1 + tile.reflectExtensionTop;
                this.textureU[0] = 1;
                this.textureU[1] = 0;
                this.textureU[2] = 0;
                this.textureU[3] = 1;
                this.textureV[0] = 0;
                this.textureV[1] = 0;
                this.textureV[2] = 1;
                this.textureV[3] = 1;
                break;
            }
            case 4: {
                this.xdepth[0] = -tile.reflectExtensionRight;
                this.xdepth[1] = 1;
                this.xdepth[2] = 1;
                this.xdepth[3] = -tile.reflectExtensionRight;
                this.ydepth[0] = 0;
                this.ydepth[1] = 0;
                this.ydepth[2] = 1 + tile.reflectExtensionTop;
                this.ydepth[3] = 1 + tile.reflectExtensionTop;
                this.textureU[0] = 1;
                this.textureU[1] = 0;
                this.textureU[2] = 0;
                this.textureU[3] = 1;
                this.textureV[0] = 0;
                this.textureV[1] = 0;
                this.textureV[2] = 1;
                this.textureV[3] = 1;
                break;
            }
            case 5: {
                this.xdepth[0] = 0;
                this.xdepth[1] = 0;
                this.xdepth[2] = 1 + tile.reflectExtensionRight;
                this.xdepth[3] = 1 + tile.reflectExtensionRight;
                this.ydepth[0] = 0;
                this.ydepth[1] = 1 + tile.reflectExtensionTop;
                this.ydepth[2] = 1 + tile.reflectExtensionTop;
                this.ydepth[3] = 0;
                this.textureU[0] = 0;
                this.textureU[1] = 0;
                this.textureU[2] = 1;
                this.textureU[3] = 1;
                this.textureV[0] = 0;
                this.textureV[1] = 1;
                this.textureV[2] = 1;
                this.textureV[3] = 0;
                break;
            }
        }
    }

    private void drawMirrorFrame(MirrorTileEntity tile) {
        GL11.glBindTexture((int)3553, (int)this.texture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        block8: for (int i = 0; i < this.xdepth.length; ++i) {
            switch (tile.getFacing()) {
                case 0: {
                    tessellator.func_78374_a((double)this.xdepth[i], 0.9, (double)this.ydepth[i], (double)this.textureU[i], (double)this.textureV[i]);
                    continue block8;
                }
                case 1: {
                    tessellator.func_78374_a((double)this.xdepth[i], 0.1, (double)this.ydepth[i], (double)this.textureU[i], (double)this.textureV[i]);
                    continue block8;
                }
                case 2: {
                    tessellator.func_78374_a((double)this.xdepth[i], (double)this.ydepth[i], 0.9, (double)this.textureU[i], (double)this.textureV[i]);
                    continue block8;
                }
                case 3: {
                    tessellator.func_78374_a((double)this.xdepth[i], (double)this.ydepth[i], 0.1, (double)this.textureU[i], (double)this.textureV[i]);
                    continue block8;
                }
                case 4: {
                    tessellator.func_78374_a(0.9, (double)this.ydepth[i], (double)this.xdepth[i], (double)this.textureU[i], (double)this.textureV[i]);
                    continue block8;
                }
                case 5: {
                    tessellator.func_78374_a(0.1, (double)this.ydepth[i], (double)this.xdepth[i], (double)this.textureU[i], (double)this.textureV[i]);
                    continue block8;
                }
            }
        }
        tessellator.func_78381_a();
    }

    private void setMirrorView(MirrorTileEntity tile, double x, double y, double z) {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        Project.gluPerspective((float)65.0f, (float)((float)this.mc.field_71443_c / (float)this.mc.field_71440_d), (float)0.05f, (float)((float)this.mc.field_71474_y.field_151451_c * 32.0f));
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        double aspectRatioMirror = Math.sqrt((double)(tile.reflectExtensionTop + 1) / (double)(tile.reflectExtensionRight + 1));
        double aspectRatio = (double)Display.getHeight() / (double)Display.getWidth() / aspectRatioMirror;
        float shiftCorrection = (float)tile.reflectExtensionTop * 0.45f + (float)tile.reflectExtensionRight * 0.45f - 0.5f;
        float kYS = 0.5f;
        float kZS = 0.0f;
        switch (tile.getFacing()) {
            case 0: {
                float mirrorHeightCoorrection = (float)(tile.reflectExtensionTop + 1) * 0.5f;
                float yShift = (float)(z + (double)mirrorHeightCoorrection) * kYS;
                float yCorrection = mirrorHeightCoorrection - yShift * ((float)tile.reflectExtensionTop * 0.5f + 1.0f);
                float zCorrection = 2.0f + shiftCorrection - kZS;
                float mirrorWidthCoorrection = (float)(-tile.reflectExtensionRight + 1) * 0.5f;
                float xShift = (float)(-x + (double)mirrorWidthCoorrection) * 0.5f - 0.5f;
                GL11.glFrustum((double)(-aspectRatio + (double)xShift), (double)(aspectRatio + (double)xShift), (double)(-aspectRatioMirror + (double)yShift), (double)(aspectRatioMirror + (double)yShift), (double)1.5, (double)0.1f);
                float xCorrection = mirrorWidthCoorrection + xShift * ((float)tile.reflectExtensionRight * 0.5f - 0.375f / (float)(tile.reflectExtensionRight + 1) + 1.125f);
                GLU.gluLookAt((float)(xCorrection + (float)tile.reflectExtensionRight), (float)zCorrection, (float)yCorrection, (float)(xCorrection + (float)tile.reflectExtensionRight), (float)(-32.0f + zCorrection), (float)yCorrection, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case 1: {
                float mirrorHeightCoorrection = (float)(-tile.reflectExtensionTop + 1) * 0.5f;
                float yShift = (float)(z + (double)mirrorHeightCoorrection) * kYS;
                float yCorrection = mirrorHeightCoorrection - yShift * ((float)tile.reflectExtensionTop * 0.5f + 1.0f);
                float zCorrection = -1.0f - shiftCorrection - kZS;
                float mirrorWidthCoorrection = (float)(-tile.reflectExtensionRight + 1) * 0.5f;
                float xShift = (float)(x + (double)mirrorWidthCoorrection) * 0.5f;
                GL11.glFrustum((double)(-aspectRatio + (double)xShift), (double)(aspectRatio + (double)xShift), (double)(-aspectRatioMirror + (double)yShift), (double)(aspectRatioMirror + (double)yShift), (double)1.5, (double)0.1f);
                float xCorrection = mirrorWidthCoorrection - xShift * ((float)tile.reflectExtensionRight * 0.5f + 1.0f);
                GLU.gluLookAt((float)xCorrection, (float)zCorrection, (float)yCorrection, (float)xCorrection, (float)(32.0f + zCorrection), (float)yCorrection, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case 2: {
                float mirrorHeightCoorrection = (float)(tile.reflectExtensionTop + 1) * 0.5f;
                float yShift = (float)(y + (double)mirrorHeightCoorrection) * kYS;
                float yCorrection = mirrorHeightCoorrection - yShift * ((float)tile.reflectExtensionTop * 0.5f + 1.0f);
                float zCorrection = 2.0f + shiftCorrection - kZS;
                float mirrorWidthCoorrection = (float)(tile.reflectExtensionRight + 1) * 0.5f;
                float xShift = (float)(x + (double)mirrorWidthCoorrection) * 0.5f;
                GL11.glFrustum((double)(-aspectRatio + (double)xShift), (double)(aspectRatio + (double)xShift), (double)(-aspectRatioMirror + (double)yShift), (double)(aspectRatioMirror + (double)yShift), (double)1.5, (double)0.1f);
                float xCorrection = mirrorWidthCoorrection - xShift * ((float)tile.reflectExtensionRight * 0.5f + 1.0f);
                GLU.gluLookAt((float)xCorrection, (float)yCorrection, (float)zCorrection, (float)xCorrection, (float)yCorrection, (float)(-32.0f + zCorrection), (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                float mirrorHeightCoorrection = (float)(tile.reflectExtensionTop + 1) * 0.5f;
                float yShift = (float)(y + (double)mirrorHeightCoorrection) * kYS;
                float yCorrection = mirrorHeightCoorrection - yShift * ((float)tile.reflectExtensionRight * 0.5f + 1.0f);
                float zCorrection = -1.0f - shiftCorrection - kZS;
                float mirrorWidthCoorrection = 0.5f - (float)tile.reflectExtensionRight * 0.5f;
                float xShift = (float)(-x - (double)mirrorWidthCoorrection) * 0.5f;
                GL11.glFrustum((double)(-aspectRatio + (double)xShift), (double)(aspectRatio + (double)xShift), (double)(-aspectRatioMirror + (double)yShift), (double)(aspectRatioMirror + (double)yShift), (double)1.5, (double)0.1f);
                float xCorrection = mirrorWidthCoorrection + xShift * ((float)tile.reflectExtensionTop * 0.5f - 0.375f / (float)(tile.reflectExtensionTop + 1) + 1.125f);
                GLU.gluLookAt((float)xCorrection, (float)yCorrection, (float)zCorrection, (float)xCorrection, (float)yCorrection, (float)(32.0f + zCorrection), (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                float mirrorHeightCoorrection = (float)(tile.reflectExtensionTop + 1) * 0.5f;
                float yShift = (float)(y + (double)mirrorHeightCoorrection) * kYS;
                float yCorrection = mirrorHeightCoorrection - yShift * ((float)tile.reflectExtensionTop * 0.5f + 1.0f);
                float zCorrection = 2.0f + shiftCorrection - kZS;
                float mirrorWidthCoorrection = 0.5f - (float)tile.reflectExtensionRight * 0.5f;
                float xShift = (float)(-z - (double)mirrorWidthCoorrection) * 0.5f;
                GL11.glFrustum((double)(-aspectRatio + (double)xShift), (double)(aspectRatio + (double)xShift), (double)(-aspectRatioMirror + (double)yShift), (double)(aspectRatioMirror + (double)yShift), (double)1.5, (double)0.1f);
                float xCorrection = mirrorWidthCoorrection + xShift * ((float)tile.reflectExtensionRight * 0.5f - 0.375f / (float)(tile.reflectExtensionRight + 1) + 1.125f);
                GLU.gluLookAt((float)zCorrection, (float)yCorrection, (float)xCorrection, (float)(zCorrection - 32.0f), (float)yCorrection, (float)xCorrection, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                float mirrorHeightCoorrection = (float)(tile.reflectExtensionTop + 1) * 0.5f;
                float yShift = (float)(y + (double)mirrorHeightCoorrection) * kYS;
                float yCorrection = mirrorHeightCoorrection - yShift * ((float)tile.reflectExtensionTop * 0.5f + 1.0f);
                float zCorrection = -1.0f - shiftCorrection - kZS;
                float mirrorWidthCoorrection = (float)(tile.reflectExtensionRight + 1) * 0.5f;
                float xShift = (float)(z + (double)mirrorWidthCoorrection) * 0.5f;
                GL11.glFrustum((double)(-aspectRatio + (double)xShift), (double)(aspectRatio + (double)xShift), (double)(-aspectRatioMirror + (double)yShift), (double)(aspectRatioMirror + (double)yShift), (double)1.5, (double)0.1f);
                float xCorrection = mirrorWidthCoorrection - xShift * ((float)tile.reflectExtensionRight * 0.5f + 1.0f);
                GLU.gluLookAt((float)zCorrection, (float)yCorrection, (float)xCorrection, (float)(zCorrection + 32.0f), (float)yCorrection, (float)xCorrection, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            default: {
                float mirrorHeightCoorrection = (float)(tile.reflectExtensionTop + 1) * 0.5f;
                float yShift = (float)(y + (double)mirrorHeightCoorrection) * kYS;
                float yCorrection = mirrorHeightCoorrection - yShift * ((float)tile.reflectExtensionTop * 0.5f + 1.0f);
                float zCorrection = 2.0f + shiftCorrection - kZS;
                float mirrorWidthCoorrection = (float)(tile.reflectExtensionRight + 1) * 0.5f;
                float xShift = (float)(x + (double)mirrorWidthCoorrection) * 0.5f;
                GL11.glFrustum((double)(-aspectRatio + (double)xShift), (double)(aspectRatio + (double)xShift), (double)(-aspectRatioMirror + (double)yShift), (double)(aspectRatioMirror + (double)yShift), (double)1.5, (double)0.1f);
                float xCorrection = mirrorWidthCoorrection - xShift * ((float)tile.reflectExtensionRight * 0.5f + 1.0f);
                GLU.gluLookAt((float)xCorrection, (float)yCorrection, (float)zCorrection, (float)xCorrection, (float)yCorrection, (float)(-32.0f + zCorrection), (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
    }

    public static void deleteTextures() {
        GL11.glDeleteTextures((IntBuffer)textureIDBuffer);
    }
}

