/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.IC2;
import ihl.IHLMod;
import ihl.flexible_cable.FlexibleCableHolderBaseTileEntity;
import ihl.flexible_cable.FrequencyGeneratorTileEntity;
import ihl.flexible_cable.IHLGrid;
import ihl.flexible_cable.NodeEntity;
import ihl.utils.IHLUtils;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class RectifierTransformerUnitTileEntity
extends FlexibleCableHolderBaseTileEntity
implements INetworkClientTileEntityEventListener,
IEnergySink {
    public double energy;
    public int maxStorage = 4096;
    private boolean addedToEnergyNet = false;
    private static final int[] voltageOutArray = new int[]{5, 10, 50, 500, 1000, 2000, 4000, 8000};
    public byte mode = 0;
    private FrequencyGeneratorTileEntity frequencyGenerator;

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void setFacing(short facing1) {
        short facing2 = (short)Math.max(facing1, 2);
        double range = 2.0;
        AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)(this.connectionX - range), (double)(this.connectionY - range), (double)(this.connectionZ - range), (double)(this.connectionX + range), (double)(this.connectionY + range), (double)(this.connectionZ + range));
        List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
        super.setFacing(facing2);
        this.setConnectionX((double)this.field_145851_c + 0.5);
        this.setConnectionY((double)this.field_145848_d + 1.7);
        this.setConnectionZ((double)this.field_145849_e + 0.5);
        if (!nodeList.isEmpty()) {
            for (NodeEntity ne : nodeList) {
                if (ne.prevAnchorEntity != null && ne.nextAnchorEntity != null || !this.cableListContains(ne.getChainUniqueID())) continue;
                ne.setVirtualNodePos(this.connectionX, this.connectionY, this.connectionZ);
            }
        }
    }

    private boolean checkACEnergySource(ForgeDirection orientation) {
        if (this.frequencyGenerator != null) {
            return true;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + orientation.offsetX, this.field_145848_d, this.field_145849_e + orientation.offsetZ);
        if (te instanceof FrequencyGeneratorTileEntity) {
            this.frequencyGenerator = (FrequencyGeneratorTileEntity)te;
            return true;
        }
        return false;
    }

    public ItemStack getWrenchDrop(EntityPlayer player) {
        return IHLUtils.getThisModItemStack("rectifierTransformerUnit");
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("energy", this.energy);
        nbt.func_74774_a("mode", this.mode);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy = nbt.func_74769_h("energy");
        this.mode = nbt.func_74771_c("mode");
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            default: 
        }
    }

    public void switchModeUp() {
        if (this.mode + 1 < voltageOutArray.length) {
            this.mode = (byte)(this.mode + 1);
            this.getGrid().injectEnergy(this.energy, voltageOutArray[this.mode], this);
            this.energy = 0.0;
        }
    }

    public void switchModeDown() {
        if (this.mode > 0) {
            this.mode = (byte)(this.mode - 1);
            this.getGrid().injectEnergy(this.energy, voltageOutArray[this.mode], this);
            this.energy = 0.0;
        }
    }

    public void updateEntityServer() {
        if (this.gridID != -1 && this.getGrid().energy < 1.0 && this.energy > 0.0) {
            this.getGrid().injectEnergy(this.energy, voltageOutArray[this.mode], this);
            this.energy = 0.0;
        }
        ForgeDirection orientation = ForgeDirection.getOrientation((int)this.getFacing());
        if (this.energy < (double)this.maxStorage && this.checkACEnergySource(orientation)) {
            this.energy += this.frequencyGenerator.requestEnergy(orientation.getOpposite(), Integer.MAX_VALUE);
        }
    }

    public double requestACEnergy(double amount) {
        double energyToReturn = Math.min(amount, this.energy);
        this.energy -= energyToReturn;
        return energyToReturn;
    }

    @Override
    public int getGridID() {
        return this.gridID;
    }

    @Override
    public IHLGrid getGrid() {
        return IHLMod.enet.getGrid(this.gridID);
    }

    public int getVoltageOut() {
        return voltageOutArray[this.mode];
    }

    @Override
    public double getMaxAllowableVoltage() {
        return 64000.0;
    }

    public String func_145825_b() {
        return null;
    }

    @Override
    public void remove(NBTTagCompound cable) {
        this.cableList.remove(cable);
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return !direction.equals((Object)ForgeDirection.UP);
    }

    public double getDemandedEnergy() {
        if (this.gridID != -1 && this.getGrid().energy < 1.0 && this.energy > 0.0) {
            return 2.147483647E9;
        }
        return 0.0;
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        this.energy += amount;
        return 0.0;
    }
}

