/*
 * Decompiled with CFR 0.152.
 */
package ihl.guidebook;

import ihl.IHLMod;
import ihl.datanet.GuiInvisibleButton;
import ihl.guidebook.IHLGuidebookContainer;
import ihl.guidebook.IHLGuidebookInventory;
import ihl.utils.IHLRenderUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import org.xml.sax.SAXException;

public class IHLGuidebookGui
extends GuiContainer {
    public IHLGuidebookContainer container;
    private static final ResourceLocation background = new ResourceLocation("ihl", "textures/gui/GUIGuidebook.png");
    public Map<Integer, Integer[]> linksCoordinatesMap = new HashMap<Integer, Integer[]>();
    private GuiInvisibleButton prevPageAreaButton;
    private GuiInvisibleButton nextPageAreaButton;
    private String title;
    private String[] localisedContent = new String[2];
    private ResourceLocation[] resourceLocationCache = new ResourceLocation[16];
    private int currentSection = 0;
    private int textBlockNumberOnPageTurn = 0;
    private int stringNumberOnPageTurn = 0;
    private final int titleX = 25;
    private final int titleY = 7;
    private final int textBlockWidth = 104;
    private final int textBlockX1 = 20;
    private final int textBlockY1 = 38;
    private final int textBlockX2 = 130;
    private final int textBlockY2 = 5;
    private final int textBlockMaxY = 200;
    private int stringHeight = 10;
    private int textRowInRightPage = 0;
    private int textBlockInRightPage = 0;
    private int textRowInNextPage = 0;
    private int textBlockInNextPage = 0;
    private int[] textRowStart = new int[2];
    private int textBlockStart = 0;
    private int pictureWidth;
    private int pictureHeight;
    private int maxSection = 0;

    public IHLGuidebookGui(IHLGuidebookContainer container1) {
        super((Container)container1);
        this.container = container1;
        this.field_146999_f = this.container.xSize;
        this.field_147000_g = this.container.ySize;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.prevPageAreaButton = new GuiInvisibleButton(0, x, y, this.field_146999_f / 2, 162, this.linksCoordinatesMap, this.field_146292_n);
        this.nextPageAreaButton = new GuiInvisibleButton(1, x + this.field_146999_f / 2, y, this.field_146999_f / 2, 162, this.linksCoordinatesMap, this.field_146292_n);
        this.clear();
        try {
            IHLMod.xmlparser.setupGuidebookGUI(this, 0);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        switch (button.field_146127_k) {
            case 0: {
                --this.currentSection;
                if (this.currentSection < 0) {
                    this.currentSection = this.maxSection;
                }
                this.textBlockStart = 0;
                this.textRowStart[0] = 0;
                this.textRowStart[1] = 0;
                break;
            }
            case 1: {
                if (this.textRowInNextPage == 0 && this.textBlockInNextPage == 0) {
                    ++this.currentSection;
                    this.textBlockStart = 0;
                    this.textRowStart[0] = 0;
                    this.textRowStart[1] = 0;
                    break;
                }
                this.textBlockStart = this.textBlockInNextPage;
                this.textRowStart[this.textBlockStart] = this.textRowInNextPage;
                this.textRowInNextPage = 0;
                this.textBlockInNextPage = 0;
            }
        }
        this.clear();
        try {
            IHLMod.xmlparser.setupGuidebookGUI(this, this.currentSection);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        for (int i = 0; i < ((IHLGuidebookInventory)this.container.base).content.length; ++i) {
            ((IHLGuidebookInventory)this.container.base).content[i] = null;
        }
        this.title = null;
        this.localisedContent[0] = null;
        this.localisedContent[1] = null;
    }

    public void setTitle(String title1) {
        this.title = StatCollector.func_74838_a((String)title1);
    }

    public void setPicture(String string, int width, int height) {
        IHLMod.log.debug("setting picture='" + string + "' \n height=" + height + " \n width=" + width);
        if (this.resourceLocationCache[this.currentSection] == null) {
            this.resourceLocationCache[this.currentSection] = new ResourceLocation("ihl", string);
        }
        this.pictureWidth = width;
        this.pictureHeight = height;
    }

    protected void func_146979_b(int par1, int par2) {
        IHLRenderUtils.instance.updateScreenSize();
        this.textRowInRightPage = 0;
        this.textBlockInRightPage = 0;
        this.drawPage(this.textBlockX1, this.textBlockY1);
    }

    private void drawPage(int startX, int startY) {
        int i1;
        List<String> splittedText;
        int xOffset = (this.field_146294_l - this.field_146999_f) / 2;
        int yOffset = (this.field_146295_m - this.field_147000_g) / 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146289_q.func_78276_b(this.title, this.titleX, this.titleY, 0);
        int xPos = startX;
        int yPos = startY;
        if (this.textBlockStart == 0) {
            if (this.localisedContent[0] != null) {
                splittedText = IHLRenderUtils.instance.splitStringByWidth(this.localisedContent[0], Math.round(104.0f));
                for (i1 = this.textRowStart[0]; i1 < splittedText.size(); ++i1) {
                    if ((yPos += this.stringHeight) < this.textBlockMaxY) {
                        this.field_146289_q.func_78276_b(splittedText.get(i1), Math.round(xPos), Math.round(yPos), 0);
                        continue;
                    }
                    if (xPos != this.textBlockX2) {
                        yPos = this.textBlockY2;
                        xPos = this.textBlockX2;
                        this.field_146289_q.func_78276_b(splittedText.get(i1), Math.round(xPos), Math.round(yPos), 0);
                        continue;
                    }
                    this.textRowInNextPage = i1;
                    this.textBlockInNextPage = 0;
                    return;
                }
            }
            if (this.resourceLocationCache[this.currentSection] != null) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (yPos + this.pictureHeight < this.textBlockMaxY) {
                    ITextureObject texture = this.field_146297_k.field_71446_o.func_110581_b(this.resourceLocationCache[this.currentSection]);
                    this.field_146297_k.field_71446_o.func_110577_a(this.resourceLocationCache[this.currentSection]);
                    this.func_73729_b(Math.round(xPos), Math.round(yPos += this.stringHeight), 0, 0, this.pictureWidth, this.pictureHeight);
                    yPos += Math.round(this.pictureHeight);
                } else {
                    yPos = this.textBlockY2;
                    xPos = this.textBlockX2;
                    this.field_146297_k.field_71446_o.func_110577_a(this.resourceLocationCache[this.currentSection]);
                    this.func_73729_b(Math.round(xPos), Math.round(yPos), 0, 0, this.pictureWidth, this.pictureHeight);
                    yPos += Math.round(this.pictureHeight);
                }
            }
        }
        if (this.localisedContent[1] != null) {
            splittedText = IHLRenderUtils.instance.splitStringByWidth(this.localisedContent[1], Math.round(104.0f));
            for (i1 = this.textRowStart[1]; i1 < splittedText.size(); ++i1) {
                if ((yPos += this.stringHeight) < this.textBlockMaxY) {
                    this.field_146289_q.func_78276_b(splittedText.get(i1), Math.round(xPos), Math.round(yPos), 0);
                    continue;
                }
                if (xPos != this.textBlockX2) {
                    yPos = this.textBlockY2;
                    xPos = this.textBlockX2;
                    this.field_146289_q.func_78276_b(splittedText.get(i1), Math.round(xPos), Math.round(yPos), 0);
                    continue;
                }
                this.textRowInNextPage = i1;
                this.textBlockInNextPage = 1;
                return;
            }
        }
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.field_71446_o.func_110577_a(background);
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void setSectionNumber(int i) {
        this.currentSection = 0;
    }

    public void setMaxSectionNumber(int i) {
        this.maxSection = Math.max(i, this.maxSection);
    }

    public int getMaxSectionNumber() {
        return this.maxSection;
    }

    public void addItemStack(ItemStack itemStack) {
        for (int i = 0; i < ((IHLGuidebookInventory)this.container.base).content.length; ++i) {
            if (((IHLGuidebookInventory)this.container.base).content[i] != null) continue;
            ((IHLGuidebookInventory)this.container.base).content[i] = itemStack;
            break;
        }
    }

    public void addTextBlock(String textContent) {
        for (int i = 0; i < this.localisedContent.length; ++i) {
            if (this.localisedContent[i] != null) continue;
            this.localisedContent[i] = StatCollector.func_74838_a((String)textContent);
            break;
        }
    }
}

