/*
 * Decompiled with CFR 0.152.
 */
package ihl.enviroment;

import ic2.core.block.TileEntityBlock;
import ihl.IHLMod;
import ihl.enviroment.MirrorBlock;
import ihl.handpump.BlockWithCoordinates;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class MirrorTileEntity
extends TileEntityBlock {
    public final List<BlockWithCoordinates> bwc = new ArrayList<BlockWithCoordinates>();
    public final List<Entity> reflectedEntity = new ArrayList<Entity>();
    public final List<TileEntity> reflectedTileEntity = new ArrayList<TileEntity>();
    private int bwcListPos = 0;
    private int reflectedEntityListPos = 0;
    private int reflectedTileEntityListPos = 0;
    private int reflectionVolumePos = 0;
    boolean firstTick = true;
    public int dnx;
    public int dpx;
    public int dny;
    public int dpy;
    public int dnz;
    public int dpz;
    boolean shouldReflect = true;
    int reflectExtensionRight = 0;
    int reflectExtensionTop = 0;
    int timer = 0;
    int blockReflectionUpdateTimer = 0;
    int reflectionVolumeSize = -1;
    AxisAlignedBB reflectionArea;
    int displayListCache = -1;
    public ChunkCache chunkCache;
    public boolean needRenderUpdate = false;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int minZ;
    private int maxZ;
    private int lastBWCSize;

    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.shouldReflect) {
            int i = 0;
            for (i = 0; i < Math.min(this.reflectionVolumeSize, IHLMod.config.mirrorReflectionUpdateSpeed); ++i) {
                this.checkReflectionVolume();
            }
            for (i = 0; i < Math.min(this.bwc.size(), IHLMod.config.mirrorReflectionUpdateSpeed); ++i) {
                this.checkBWCList();
            }
            for (i = 0; i < Math.min(this.reflectedTileEntity.size(), IHLMod.config.mirrorReflectionUpdateSpeed); ++i) {
                this.checkTileEntityList();
            }
        }
        if (this.timer++ > 20) {
            boolean isFirst = true;
            TileEntity t = this.field_145850_b.func_147438_o(this.field_145851_c - this.mXT(), this.field_145848_d - this.mYT(), this.field_145849_e - this.mZT());
            if (t instanceof MirrorTileEntity && ((MirrorTileEntity)t).getFacing() == this.getFacing()) {
                isFirst = false;
            }
            if ((t = this.field_145850_b.func_147438_o(this.field_145851_c - this.mXR(), this.field_145848_d - this.mYR(), this.field_145849_e - this.mZR())) instanceof MirrorTileEntity && ((MirrorTileEntity)t).getFacing() == this.getFacing()) {
                isFirst = false;
            }
            if (isFirst) {
                this.shouldReflect = true;
                this.reflectExtensionTop = 0;
                this.reflectExtensionRight = 0;
                int i = 1;
                while (i <= IHLMod.config.mirrorReflectionRange + 2 && (t = this.field_145850_b.func_147438_o(this.field_145851_c + this.mXT() * i, this.field_145848_d + this.mYT() * i, this.field_145849_e + this.mZT() * i)) instanceof MirrorTileEntity && ((MirrorTileEntity)t).getFacing() == this.getFacing()) {
                    MirrorTileEntity te = (MirrorTileEntity)t;
                    te.shouldReflect = false;
                    this.reflectExtensionTop = i++;
                }
                int i0 = 1;
                block4: while (i0 <= IHLMod.config.mirrorReflectionRange + 2) {
                    for (int i2 = 0; i2 <= this.reflectExtensionTop; ++i2) {
                        t = this.field_145850_b.func_147438_o(this.field_145851_c + this.mXT() * i2 + this.mXR() * i0, this.field_145848_d + this.mYT() * i2 + this.mYR() * i0, this.field_145849_e + this.mZT() * i2 + this.mZR() * i0);
                        if (!(t instanceof MirrorTileEntity) || ((MirrorTileEntity)t).getFacing() != this.getFacing()) break block4;
                        MirrorTileEntity te = (MirrorTileEntity)t;
                        te.shouldReflect = false;
                    }
                    this.reflectExtensionRight = i0++;
                }
            }
            if (this.reflectionArea != null) {
                this.reflectedEntity.clear();
                this.reflectedEntity.addAll(this.field_145850_b.func_72872_a(EntityLivingBase.class, this.reflectionArea));
                this.reflectedEntity.addAll(this.field_145850_b.func_72872_a(EntityBoat.class, this.reflectionArea));
                this.reflectedEntity.addAll(this.field_145850_b.func_72872_a(EntityItem.class, this.reflectionArea));
                this.reflectedEntity.addAll(this.field_145850_b.func_72872_a(EntityMinecart.class, this.reflectionArea));
            }
            this.timer = 0;
        }
        if (this.firstTick && this.shouldReflect) {
            int range = IHLMod.config.mirrorReflectionRange;
            ForgeDirection direction = ForgeDirection.getOrientation((int)this.getFacing());
            this.bwc.clear();
            this.dpx = direction.offsetX == -1 ? 0 : 1;
            this.dnx = direction.offsetX == 1 ? 0 : 1;
            this.dpy = direction.offsetY == -1 ? 0 : 1;
            this.dny = direction.offsetY == 1 ? 0 : 1;
            this.dpz = direction.offsetZ == -1 ? 0 : 1;
            this.dnz = direction.offsetZ == 1 ? 0 : 1;
            this.reflectionVolumeSize = (range * this.dnx + range * this.dpx + this.dnx) * (range * this.dny + range * this.dpy + this.dny) * (range * this.dnz + range * this.dpz + this.dnz);
            this.reflectionArea = AxisAlignedBB.func_72330_a((double)((double)(this.field_145851_c - range * this.dnx) - 1.0), (double)((double)(this.field_145848_d - range * this.dny) - 1.0), (double)((double)(this.field_145849_e - range * this.dnz) - 1.0), (double)((double)(this.field_145851_c + range * this.dpx + this.dnx) + 1.0), (double)((double)(this.field_145848_d + range * this.dpy + this.dny) + 1.0), (double)((double)(this.field_145849_e + range * this.dpz + this.dnz) + 1.0));
            this.minX = this.field_145851_c - range * this.dnx;
            this.maxX = this.field_145851_c + range * this.dpx + this.dnx;
            this.minY = Math.max(this.field_145848_d - range * this.dny, 0);
            this.maxY = Math.min(this.field_145848_d + range * this.dpy + this.dny, this.field_145850_b.func_72940_L());
            this.minZ = this.field_145849_e - range * this.dnz;
            this.maxZ = this.field_145849_e + range * this.dpz + this.dnz;
            this.chunkCache = new ChunkCache(this.field_145850_b, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, 16);
            for (int ix = this.minX; ix < this.maxX; ++ix) {
                for (int iy = this.minY; iy < this.maxY; ++iy) {
                    for (int iz = this.minZ; iz < this.maxZ; ++iz) {
                        Block block = this.field_145850_b.func_147439_a(ix, iy, iz);
                        if (block == null || block.isAir((IBlockAccess)this.field_145850_b, ix, iy, iz) || !this.isBlockVisible(block, ix, iy, iz)) continue;
                        TileEntity te = this.field_145850_b.func_147438_o(ix, iy, iz);
                        if (te != null && !te.func_145837_r() && !this.reflectedTileEntity.contains(te) && TileEntityRendererDispatcher.field_147556_a.func_147545_a(te) && !(te instanceof MirrorTileEntity)) {
                            this.reflectedTileEntity.add(te);
                        }
                        if (block.func_149645_b() < 0) continue;
                        this.bwc.add(new BlockWithCoordinates(block, ix, iy, iz, this.field_145850_b.func_72805_g(ix, iy, iz)));
                    }
                }
            }
            this.lastBWCSize = this.bwc.size();
            this.firstTick = false;
        }
    }

    private void dropMirrorStatusByDirection(ForgeDirection direction) {
        TileEntity t;
        for (int i = 1; i <= IHLMod.config.mirrorReflectionRange + 2 && (t = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX * i, this.field_145848_d + direction.offsetY * i, this.field_145849_e + direction.offsetZ * i)) instanceof MirrorTileEntity; ++i) {
            MirrorTileEntity te = (MirrorTileEntity)t;
            te.firstTick = false;
        }
    }

    private boolean isBlockVisible(Block block, int x, int y, int z) {
        if (block instanceof MirrorBlock) {
            ForgeDirection direction = ForgeDirection.getOrientation((int)this.getFacing());
            int x1 = x * direction.offsetX;
            int y1 = y * direction.offsetY;
            int z1 = z * direction.offsetZ;
            int x2 = this.field_145851_c * direction.offsetX;
            int y2 = this.field_145848_d * direction.offsetY;
            int z2 = this.field_145849_e * direction.offsetZ;
            return x1 != x2 || y1 != y2 || z1 != z2;
        }
        if (block.func_149646_a((IBlockAccess)this.field_145850_b, x, y - 1, z, 0)) {
            return true;
        }
        if (block.func_149646_a((IBlockAccess)this.field_145850_b, x, y + 1, z, 1)) {
            return true;
        }
        if (block.func_149646_a((IBlockAccess)this.field_145850_b, x, y, z - 1, 2)) {
            return true;
        }
        if (block.func_149646_a((IBlockAccess)this.field_145850_b, x, y, z + 1, 3)) {
            return true;
        }
        if (block.func_149646_a((IBlockAccess)this.field_145850_b, x - 1, y, z, 4)) {
            return true;
        }
        return block.func_149646_a((IBlockAccess)this.field_145850_b, x + 1, y, z, 5);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    public void setFacing(short side) {
        super.setFacing(side);
        this.bwc.clear();
        this.firstTick = true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return IHLUtils.getThisModItemStack("mirror");
    }

    public float[] getMirrorAxis() {
        ForgeDirection direction = ForgeDirection.getOrientation((int)this.getFacing());
        int mx = direction.offsetX != 0 ? -1 : 1;
        int my = direction.offsetY != 0 ? -1 : 1;
        int mz = direction.offsetZ != 0 ? -1 : 1;
        return new float[]{mx, my, mz, direction.offsetX, direction.offsetY, direction.offsetZ};
    }

    private void checkBWCList() {
        if (++this.bwcListPos >= this.bwc.size()) {
            this.bwcListPos = 0;
        }
        if (!this.bwc.isEmpty()) {
            BlockWithCoordinates bwcEntry = this.bwc.get(this.bwcListPos);
            if (bwcEntry.block != this.field_145850_b.func_147439_a(bwcEntry.x, bwcEntry.y, bwcEntry.z)) {
                this.bwc.remove(this.bwcListPos);
            }
        }
    }

    private void checkTileEntityList() {
        TileEntity entry;
        if (++this.reflectedTileEntityListPos >= this.reflectedTileEntity.size()) {
            this.reflectedTileEntityListPos = 0;
        }
        if (!this.reflectedTileEntity.isEmpty() && ((entry = this.reflectedTileEntity.get(this.reflectedTileEntityListPos)) == null || entry.func_145837_r() || entry != this.field_145850_b.func_147438_o(entry.field_145851_c, entry.field_145848_d, entry.field_145849_e))) {
            this.reflectedTileEntity.remove(this.reflectedTileEntityListPos);
        }
    }

    private void checkReflectionVolume() {
        if (++this.reflectionVolumePos >= this.reflectionVolumeSize) {
            this.reflectionVolumePos = 0;
            if (this.lastBWCSize != this.bwc.size()) {
                this.needRenderUpdate = true;
                this.lastBWCSize = this.bwc.size();
            }
        }
        if (this.reflectionVolumeSize > 0) {
            int range = IHLMod.config.mirrorReflectionRange;
            int y = this.reflectionVolumePos % ((this.maxX - this.minX) * (this.maxY - this.minY)) / (this.maxX - this.minX);
            int z = this.reflectionVolumePos / (this.maxX - this.minX) / (this.maxY - this.minY);
            int x = this.reflectionVolumePos - y * (this.maxX - this.minX) - z * (this.maxX - this.minX) * (this.maxY - this.minY);
            int ix = this.minX + x;
            int iy = this.minY + y;
            int iz = this.minZ + z;
            Block block = this.field_145850_b.func_147439_a(ix, iy, iz);
            if (block != null && !block.isAir((IBlockAccess)this.field_145850_b, ix, iy, iz) && this.isBlockVisible(block, ix, iy, iz)) {
                BlockWithCoordinates bwc1;
                TileEntity te = this.field_145850_b.func_147438_o(ix, iy, iz);
                if (te != null && !te.func_145837_r() && !this.reflectedTileEntity.contains(te) && TileEntityRendererDispatcher.field_147556_a.func_147545_a(te) && !(te instanceof MirrorTileEntity)) {
                    this.reflectedTileEntity.add(te);
                }
                if (block.func_149645_b() >= 0 && !this.bwc.contains(bwc1 = new BlockWithCoordinates(block, ix, iy, iz, this.field_145850_b.func_72805_g(ix, iy, iz)))) {
                    this.bwc.add(bwc1);
                }
            }
        }
    }

    private int mXR() {
        switch (this.getFacing()) {
            case 0: {
                return 1;
            }
            case 1: {
                return -1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return -1;
            }
        }
        return 0;
    }

    private int mYR() {
        return 0;
    }

    private int mZR() {
        switch (this.getFacing()) {
            case 4: {
                return -1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    private int mXT() {
        return 0;
    }

    private int mYT() {
        switch (this.getFacing()) {
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    private int mZT() {
        switch (this.getFacing()) {
            case 0: {
                return 1;
            }
            case 1: {
                return -1;
            }
        }
        return 0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        double xMinD = (double)this.field_145851_c - (double)(this.reflectExtensionRight * Math.abs(this.mXR())) - (double)(this.reflectExtensionTop * Math.abs(this.mXT()));
        double xMaxD = (double)this.field_145851_c + (double)(this.reflectExtensionRight * Math.abs(this.mXR())) + (double)(this.reflectExtensionTop * Math.abs(this.mXT())) + 1.0;
        double yMinD = (double)this.field_145848_d - (double)(this.reflectExtensionRight * Math.abs(this.mYR())) - (double)(this.reflectExtensionTop * Math.abs(this.mYT()));
        double yMaxD = (double)this.field_145848_d + (double)(this.reflectExtensionRight * Math.abs(this.mYR())) + (double)(this.reflectExtensionTop * Math.abs(this.mYT())) + 1.0;
        double zMinD = (double)this.field_145849_e - (double)(this.reflectExtensionRight * Math.abs(this.mZR())) - (double)(this.reflectExtensionTop * Math.abs(this.mZT()));
        double zMaxD = (double)this.field_145849_e + (double)(this.reflectExtensionRight * Math.abs(this.mZR())) + (double)(this.reflectExtensionTop * Math.abs(this.mZT())) + 1.0;
        return AxisAlignedBB.func_72330_a((double)xMinD, (double)yMinD, (double)zMinD, (double)xMaxD, (double)yMaxD, (double)zMaxD);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }
}

