/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import ihl.flexible_cable.IHLCable;
import java.util.HashSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class IHLCableSet
extends HashSet {
    public void loadFromNBT(NBTTagCompound nbt) {
        NBTTagList var2 = nbt.func_150295_c("cableList", 10);
        for (int i = 0; i < var2.func_74745_c(); ++i) {
            NBTTagCompound var4 = var2.func_150305_b(i);
            int cableID = var4.func_74762_e("cableID");
            int length = var4.func_74762_e("length");
            int resistivity = var4.func_74762_e("resistivity");
            int voltageLimit = var4.func_74762_e("voltageLimit");
            String itemName = var4.func_74779_i("itemName");
            if (itemName.isEmpty()) {
                itemName = "flexibleCableWithClamp";
            }
            IHLCable cable = new IHLCable(cableID, length, resistivity, voltageLimit, itemName);
            this.add(cable);
        }
    }

    public void saveToNBT(NBTTagCompound nbt) {
        NBTTagList var2 = new NBTTagList();
        for (IHLCable cc : this) {
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74768_a("cableID", cc.cableID);
            var4.func_74768_a("length", cc.length);
            var4.func_74768_a("resistivity", cc.resistivity);
            var4.func_74768_a("voltageLimit", cc.voltageLimit);
            var4.func_74778_a("itemName", cc.itemName);
            var2.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("cableList", (NBTBase)var2);
    }

    @Override
    public boolean contains(Object obj) {
        if (obj != null && obj instanceof IHLCable) {
            IHLCable cable = (IHLCable)obj;
            for (IHLCable cc : this) {
                if (cable.cableID != cc.cableID) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsID(int chainUniqueID) {
        for (IHLCable c : this) {
            if (c.cableID != chainUniqueID) continue;
            return true;
        }
        return false;
    }
}

