/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import ihl.IHLMod;
import ihl.flexible_cable.IHLGrid;
import ihl.flexible_cable.NodeEntity;
import ihl.interfaces.IEnergyNetNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;

public class IHLENet {
    public Map<Integer, IHLGrid> grids = new HashMap<Integer, IHLGrid>();
    public Map<Integer, IHLGrid> cablesToGrids = new HashMap<Integer, IHLGrid>();
    private int griduid = 0;

    public int getNewUniqueGridID() {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.grids.get(++this.griduid) != null) continue;
            return this.griduid;
        }
        return -1;
    }

    public int mergeGrids(int gridID, int gridID2) {
        if (gridID == -1 && gridID2 != -1) {
            return gridID2;
        }
        if (gridID != -1 && gridID2 == -1) {
            return gridID;
        }
        if (gridID == -1 && gridID2 == -1) {
            int newGridID = this.getNewUniqueGridID();
            IHLGrid cgrid = new IHLGrid();
            this.grids.put(newGridID, cgrid);
            return newGridID;
        }
        if (gridID != gridID2) {
            for (IEnergyNetNode te : this.grids.get((Object)Integer.valueOf((int)gridID2)).telist) {
                te.setGrid(gridID);
            }
            this.grids.remove(gridID2);
            return gridID;
        }
        return gridID2;
    }

    public IHLGrid getGrid(int gridID) {
        if (this.grids.get(gridID) == null) {
            IHLGrid cgrid = new IHLGrid();
            this.grids.put(gridID, cgrid);
            return cgrid;
        }
        return this.grids.get(gridID);
    }

    public void splitGrids(int gridID, IEnergyNetNode exclude) {
        Set<IEnergyNetNode> telist = this.grids.get((Object)Integer.valueOf((int)gridID)).telist;
        telist.remove(exclude);
        for (IEnergyNetNode cte : telist) {
            cte.getCableList().removeAll(exclude.getCableList());
            cte.setGrid(-1);
        }
        block1: for (IEnergyNetNode cte : telist) {
            if (cte.getGridID() != -1) continue;
            for (IEnergyNetNode cte2 : telist) {
                if (cte2 == cte || !this.hasSame(cte.getCableList(), cte2.getCableList())) continue;
                int result = this.mergeGrids(cte.getGridID(), cte2.getGridID());
                cte.setGrid(result);
                cte2.setGrid(result);
                continue block1;
            }
        }
    }

    public void removeCableAndSplitGrids(int gridID, NBTTagCompound cable) {
        this.grids.get(gridID).removeCableAndSplitGrids(cable);
    }

    public boolean hasSame(Set<NBTTagCompound> set, Set<NBTTagCompound> set2) {
        for (NBTTagCompound num1 : set) {
            if (!set2.contains(num1)) continue;
            return true;
        }
        return false;
    }

    public void setOnFire(NBTTagCompound cable) {
        Set<NodeEntity> cs = IHLMod.proxy.nodeEntityRegistry.get(cable.func_74762_e("chainUID"));
        for (NodeEntity ne : cs) {
            ne.func_70015_d(10);
        }
    }

    public void removeCableEntities(NBTTagCompound cable) {
        int uid = cable.func_74762_e("chainUID");
        Set<NodeEntity> cs = IHLMod.proxy.nodeEntityRegistry.get(uid);
        if (cs != null) {
            for (NodeEntity ne : cs) {
                if (ne == null) continue;
                ne.func_70106_y();
            }
        }
        this.cablesToGrids.remove(uid);
    }
}

