/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import ic2.core.IC2DamageSource;
import ic2.core.item.armor.ItemArmorHazmat;
import ihl.IHLMod;
import ihl.flexible_cable.IHLGrid;
import ihl.flexible_cable.NodeEntity;
import ihl.interfaces.IEnergyNetNode;
import ihl.utils.IHLUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S29PacketSoundEffect;
import net.minecraft.network.play.server.S2APacketParticles;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class PowerCableNodeEntity
extends NodeEntity
implements IEnergyNetNode {
    private Set<NBTTagCompound> cableList;
    private NBTTagCompound cable;
    private double soundRange = 10.0;
    private static final float groundConductivity = 0.005f;
    private int lastCheckTimer = 0;

    public PowerCableNodeEntity(World world) {
        super(world);
    }

    public boolean func_70067_L() {
        return !this.field_70170_p.field_72995_K && !this.field_70145_X;
    }

    public boolean func_70104_M() {
        return !this.field_70170_p.field_72995_K && !this.field_70145_X;
    }

    @Override
    public void func_70071_h_() {
        IHLGrid grid;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && (grid = IHLMod.enet.cablesToGrids.get(this.chainUniqueID)) != null && grid.energy > 0.0) {
            double voltage = grid.getSinkVoltage(this);
            if (this.field_70122_E && voltage >= 10.0 && this.getMaxAllowableVoltage() < voltage) {
                grid.drawEnergy(voltage * voltage * (double)0.005f, this);
                if (Math.abs(this.lastCheckTimer - this.checkTimer) > 10) {
                    for (Object player : this.field_70170_p.func_72872_a(EntityPlayerMP.class, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - this.soundRange), (double)(this.field_70163_u - this.soundRange), (double)(this.field_70161_v - this.soundRange), (double)(this.field_70165_t + this.soundRange), (double)(this.field_70163_u + this.soundRange), (double)(this.field_70161_v + this.soundRange)))) {
                        if (!(player instanceof EntityPlayerMP)) continue;
                        EntityPlayerMP playerMP = (EntityPlayerMP)player;
                        playerMP.field_71135_a.func_147359_a((Packet)new S2APacketParticles("largesmoke", (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, this.field_70170_p.field_73012_v.nextFloat() * 0.1f - 0.05f, 0.1f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f - 0.05f, 0.1f, 4));
                    }
                    this.lastCheckTimer = this.checkTimer;
                }
            }
            if (this.nextAnchorEntity != null) {
                List entityList = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(4.0, 4.0, 4.0));
                for (EntityLivingBase elb : entityList) {
                    if (elb.field_70121_D == null || !IHLUtils.isSegmentInsideAABB(elb.field_70121_D, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.nextAnchorEntity.field_70165_t, this.nextAnchorEntity.field_70163_u, this.nextAnchorEntity.field_70161_v)) continue;
                    this.func_70108_f((Entity)elb);
                }
            }
        }
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return this.field_70121_D;
    }

    public void func_70108_f(Entity entity) {
        super.func_70108_f(entity);
        IHLGrid grid = IHLMod.enet.cablesToGrids.get(this.chainUniqueID);
        if (entity instanceof EntityLivingBase && grid != null && grid.energy > 0.0) {
            EntityLivingBase victim;
            double voltage = grid.getSinkVoltage(this);
            if (this.getMaxAllowableVoltage() < voltage && !ItemArmorHazmat.hasCompleteHazmat((EntityLivingBase)(victim = (EntityLivingBase)entity))) {
                float damage = (float)voltage * 0.005f;
                victim.func_70097_a((DamageSource)IC2DamageSource.electricity, damage);
                grid.drawEnergy((double)damage * voltage, this);
                if (voltage > 1000.0) {
                    this.sendSound();
                    IHLMod.proxy.spawnParticleFromServer(3, this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, 0.0, 0.0, 0.0, 10.0f);
                }
            }
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("cable")) {
            this.addCable(nbt.func_74775_l("cable"));
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.cable != null) {
            nbt.func_74782_a("cable", (NBTBase)this.cable);
        }
    }

    @Override
    public IHLGrid getGrid() {
        return IHLMod.enet.cablesToGrids.get(this.chainUniqueID);
    }

    @Override
    public int getGridID() {
        return 0;
    }

    @Override
    public void setGrid(int newGridID) {
    }

    @Override
    public double getMaxAllowableVoltage() {
        if (this.cable != null) {
            return this.cable.func_74762_e("maxVoltage");
        }
        return 2.147483647E9;
    }

    @Override
    public boolean addCable(NBTTagCompound cable1) {
        this.cable = cable1;
        return true;
    }

    @Override
    public Set<NBTTagCompound> getCableList() {
        if (this.cableList == null) {
            this.cableList = new HashSet<NBTTagCompound>(1);
            if (this.cable != null) {
                this.cableList.add(this.cable);
            }
        }
        return this.cableList;
    }

    @Override
    public void removeAttachedChains() {
    }

    public void sendSound() {
        for (Object player : this.field_70170_p.func_72872_a(EntityPlayerMP.class, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - this.soundRange), (double)(this.field_70163_u - this.soundRange), (double)(this.field_70161_v - this.soundRange), (double)(this.field_70165_t + this.soundRange), (double)(this.field_70163_u + this.soundRange), (double)(this.field_70161_v + this.soundRange)))) {
            if (!(player instanceof EntityPlayerMP)) continue;
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            playerMP.field_71135_a.func_147359_a((Packet)new S29PacketSoundEffect("ihl:electrocution", this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, 1.0f));
        }
    }

    @Override
    public double[] getPortPos(EntityLivingBase player) {
        return new double[3];
    }

    @Override
    public void remove(NBTTagCompound cable) {
        this.cableList.remove(cable);
    }

    @Override
    public boolean isCableRemoved(int chainUniqueID) {
        return false;
    }

    @Override
    public void setCableCheck(boolean b) {
    }
}

