/*
 * Decompiled with CFR 0.152.
 */
package ihl.items_blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ihl.IHLCreativeTab;
import ihl.interfaces.IWire;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class WireItem
extends Item
implements IWire {
    protected String info;
    protected int leadsNum;
    protected WireMaterial material;
    protected WireBasicTransverseSection ts;
    private String registryName;

    public WireItem(WireMaterial material1, WireBasicTransverseSection ts1, int leadsNum1, String registryName1) {
        this.registryName = registryName1;
        this.material = material1;
        this.ts = ts1;
        this.info = this.material.description + ", " + this.ts.value * (float)leadsNum1 + " sq. mm.";
        this.leadsNum = leadsNum1;
        this.func_77637_a(IHLCreativeTab.tab);
        this.func_77625_d(1);
        this.func_77655_b(this.registryName);
        this.material.wiresMap.put(Float.valueOf(this.ts.value * (float)leadsNum1), new ItemStack((Item)this));
    }

    public WireItem() {
    }

    public static void init() {
        WireMaterial[] var1 = WireMaterial.values();
        for (int i = 0; i < var1.length; ++i) {
            WireBasicTransverseSection[] var2 = WireBasicTransverseSection.values();
            for (int i1 = 0; i1 < var2.length; ++i1) {
                String registryName = var1[i].description.toLowerCase() + "Wire";
                if (i1 >= 1) {
                    registryName = var1[i].description.toLowerCase() + "Wire" + 16 + "x";
                }
                GameRegistry.registerItem((Item)new WireItem(var1[i], var2[i1], 1, registryName), (String)registryName);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        ItemStack stack = new ItemStack(item);
        stack.field_77990_d = new NBTTagCompound();
        stack.field_77990_d.func_74768_a("fullLength", 16);
        stack.field_77990_d.func_74768_a("length", 16);
        itemList.add(stack);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean flag) {
        if (itemStack.field_77990_d != null) {
            info.add("Length " + itemStack.field_77990_d.func_74762_e("length") + "m");
        }
        info.add(this.info);
    }

    @Override
    public String getTag() {
        return "length";
    }

    public int getDefaultLength() {
        return 16;
    }

    @Override
    public String getTagSecondary() {
        return "fullLength";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("ihl:" + this.registryName);
    }

    public ItemStack getCoiledResult() {
        if (this.material.wiresMap.get(this.leadsNum * 2) != null) {
            return this.material.wiresMap.get(this.leadsNum * 2).func_77946_l();
        }
        return null;
    }

    public ItemStack getInsulatedResult() {
        return this.material.cablesMap.get(Float.valueOf(this.ts.value * (float)this.leadsNum)).func_77946_l();
    }

    public ItemStack getVulcanizedRubberInsulatedResult() {
        return this.material.vulcanizedRubberCablesMap.get(Float.valueOf(this.ts.value * (float)this.leadsNum)).func_77946_l();
    }

    protected static int i2P(int value) {
        switch (value) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 16;
            }
            case 5: {
                return 32;
            }
            case 6: {
                return 64;
            }
        }
        return 1;
    }

    public static enum WireBasicTransverseSection {
        S1_5sqmm(1.5f, 3),
        S24sqmm(24.0f, 0);

        public float value;
        public int maxLeadsMultiplier;

        private WireBasicTransverseSection(float value1, int maxLeadsMultiplier1) {
            this.value = value1;
            this.maxLeadsMultiplier = maxLeadsMultiplier1;
        }
    }

    public static enum WireMaterial {
        Copper("Copper", 10000),
        Steel("Steel", 75553);

        public Map<Float, ItemStack> wiresMap;
        public Map<Float, ItemStack> cablesMap;
        public Map<Float, ItemStack> vulcanizedRubberCablesMap;
        public String description;
        int baseResistance;

        private WireMaterial(String description1, int baseResistance1) {
            this.description = description1;
            this.baseResistance = baseResistance1;
            this.wiresMap = new HashMap<Float, ItemStack>();
            this.cablesMap = new HashMap<Float, ItemStack>();
            this.vulcanizedRubberCablesMap = new HashMap<Float, ItemStack>();
        }
    }
}

