/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.chemistry;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.network.NetworkManager;
import ihl.flexible_cable.FlexibleCableHolderBaseTileEntity;
import ihl.processing.chemistry.ApparatusProcessableInvSlot;
import ihl.processing.chemistry.ElectrolysisBathContainer;
import ihl.processing.chemistry.ElectrolysisBathGui;
import ihl.processing.invslots.InvSlotConsumableLiquidIHL;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLFluidTank;
import ihl.utils.IHLUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class ElectrolysisBathTileEntity
extends FlexibleCableHolderBaseTileEntity
implements IHasGui,
INetworkClientTileEntityEventListener,
IFluidHandler {
    private static final UniversalRecipeManager recipeManager = new UniversalRecipeManager("electrolysisbath");
    public final ApparatusProcessableInvSlot input;
    public final InvSlotConsumableLiquidIHL drainInputSlot;
    public final InvSlotConsumableLiquidIHL fillInputSlot;
    public final InvSlotOutput emptyFluidItemsSlot;
    public short progress;
    protected short operationLength = (short)20000;
    private final IHLFluidTank fluidTank = new IHLFluidTank(2000);
    public short temperature = (short)20;
    private static final double resistance = 5.0;

    public ElectrolysisBathTileEntity() {
        this.drainInputSlot = new InvSlotConsumableLiquidIHL(this, "drainInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Drain);
        this.fillInputSlot = new InvSlotConsumableLiquidIHL(this, "fillInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.BOTTOM, InvSlotConsumableLiquid.OpType.Fill);
        this.emptyFluidItemsSlot = new InvSlotOutput((TileEntityInventory)this, "fluidCellsOutput", 2, 1);
        this.input = new ApparatusProcessableInvSlot(this, "input", 3, InvSlot.Access.IO, 1, 64);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
        NBTTagCompound fractionalOutputNBT = new NBTTagCompound();
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return IHLUtils.getThisModItemStack("electrolysisBath");
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        this.temperature = (short)(this.fluidTank.getTemperature() - 273);
        IHLUtils.handleFluidSlotsBehaviour(this.fillInputSlot, this.drainInputSlot, this.emptyFluidItemsSlot, this.fluidTank);
        boolean needsInvUpdate = false;
        if (this.canOperate()) {
            this.setActive(true);
            if (this.progress == 0) {
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 0, true);
            }
            if (this.getGrid().energy > 0.0) {
                double voltage = this.getGrid().getSinkVoltage(this);
                double drawEnergy = voltage * voltage / 5.0;
                this.progress = (short)((double)this.progress + drawEnergy);
                this.getGrid().drawEnergy(drawEnergy, this);
            }
            if (this.progress >= this.operationLength) {
                this.operate();
                needsInvUpdate = true;
                this.progress = 0;
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 2, true);
            }
        } else {
            if (this.progress != 0 && this.getActive()) {
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 1, true);
            }
            if (!this.canOperate()) {
                this.progress = 0;
            }
            this.setActive(false);
        }
    }

    public FluidStack drain(ForgeDirection from, int amount, boolean doDrain) {
        FluidStack fstack = this.fluidTank.drain(amount, doDrain);
        return fstack;
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return true;
    }

    public boolean canFill(ForgeDirection direction, Fluid arg1) {
        return true;
    }

    public String func_145825_b() {
        return "Electrolysis bath";
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        IFluidHandler ifhte;
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (te instanceof IFluidHandler && this.fluidTank.getFluid() != null && (ifhte = (IFluidHandler)te).canFill(ForgeDirection.UP, this.fluidTank.getFluid().getFluid())) {
            int filled = ifhte.fill(ForgeDirection.UP, this.fluidTank.drain(this.getTankAmount(), false), true);
            this.fluidTank.drain(filled, true);
        }
    }

    public int gaugeProgressScaled(int i) {
        return this.progress * i / this.operationLength;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean arg1) {
        return new ElectrolysisBathGui(new ElectrolysisBathContainer(player, this));
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        this.fluidTank.sortFluidsByDensity();
        return new ElectrolysisBathContainer(player, this);
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public boolean canOperate() {
        return this.getOutput() != null;
    }

    public UniversalRecipeOutput getOutput() {
        return recipeManager.getOutputFor(this.getInput(), false, false);
    }

    public List[] getInput() {
        for (int i = 0; i < this.fluidTank.getNumberOfFluids(); ++i) {
            List[] rInput = new List[]{Arrays.asList(this.fluidTank.getFluid(i)), this.input.getItemStackList()};
            if (recipeManager.getOutputFor(rInput, false, false) == null) continue;
            return rInput;
        }
        return new List[]{Arrays.asList(this.fluidTank.getFluid()), this.input.getItemStackList()};
    }

    public void operate() {
        UniversalRecipeInput recipeInput = recipeManager.getRecipeInput(this.getInput());
        UniversalRecipeOutput output1 = this.getOutput();
        for (int i = 0; i < recipeInput.getItemInputs().size(); ++i) {
            this.input.consume(i, recipeInput.getItemInputs().get(i).getAmount());
        }
        this.fluidTank.fill(output1.getFluidOutputs(), true);
    }

    public FluidStack drain(ForgeDirection arg0, FluidStack fluidStack, boolean doDrain) {
        if (this.fluidTank.getFluid() != null && this.fluidTank.getFluid().containsFluid(fluidStack)) {
            return this.fluidTank.drain(fluidStack, doDrain);
        }
        return null;
    }

    public int fill(ForgeDirection arg0, FluidStack arg1, boolean arg2) {
        return this.fluidTank.fill(arg1, arg2);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection arg0) {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }

    public boolean needsFluid() {
        return this.fluidTank.getFluidAmount() <= this.fluidTank.getCapacity();
    }

    public FluidStack getFluidStackfromTank() {
        return this.fluidTank.getFluid();
    }

    public int getTankAmount() {
        return this.fluidTank.getFluidAmount();
    }

    public int gaugeLiquidScaled(int i, int index) {
        return this.fluidTank.getFluidAmount() <= 0 ? 0 : this.fluidTank.getFluidAmount(index) * i / this.fluidTank.getCapacity();
    }

    public static void addRecipe(UniversalRecipeInput input, UniversalRecipeOutput output) {
        recipeManager.addRecipe(input, output);
    }

    public int getNumberOfFluidsInTank() {
        return this.fluidTank.getNumberOfFluids();
    }

    public static Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return recipeManager.getRecipes();
    }

    public IHLFluidTank getFluidTank() {
        return this.fluidTank;
    }

    @Override
    public double getMaxAllowableVoltage() {
        return 64000.0;
    }
}

