/*
 * Decompiled with CFR 0.152.
 */
package ihl.recipes;

import ic2.api.recipe.IRecipeInput;
import ihl.interfaces.IWire;
import ihl.items_blocks.FlexibleCableItem;
import ihl.utils.IHLUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;

public class RecipeInputWire
implements IRecipeInput {
    public final ItemStack input;
    public final int amount;

    public RecipeInputWire(ItemStack aInput) {
        this(aInput, IHLUtils.getWireLength(aInput));
    }

    public RecipeInputWire(ItemStack aInput, int aAmount) {
        if (aInput.func_77973_b() == null || !(aInput.func_77973_b() instanceof IWire)) {
            throw new IllegalArgumentException("Invalid item stack specfied");
        }
        this.input = aInput.func_77946_l();
        this.amount = aAmount;
    }

    public RecipeInputWire(String string, int i) {
        this(IHLUtils.getThisModWireItemStackWithLength(string, i), i);
    }

    public RecipeInputWire(String material, int length, int transverseSection) {
        this(IHLUtils.getUninsulatedWire(material, length, transverseSection), length);
    }

    public RecipeInputWire(String material, int length, int transverseSection, String insulationMaterial, int insulationThickness, int insulationBreakdownVoltage) {
        this(IHLUtils.getInsulatedWire(material, length, transverseSection, insulationMaterial, insulationThickness), length);
    }

    public boolean matches(ItemStack subject) {
        if (subject.func_77973_b() == this.input.func_77973_b() && (subject.func_77960_j() == this.input.func_77960_j() || this.input.func_77960_j() == Short.MAX_VALUE)) {
            if (subject.func_77973_b() instanceof FlexibleCableItem) {
                FlexibleCableItem item = (FlexibleCableItem)subject.func_77973_b();
                return item.isSameWire(this.input, subject);
            }
            return true;
        }
        return false;
    }

    public int getAmount() {
        return this.amount;
    }

    public List<ItemStack> getInputs() {
        return Arrays.asList(this.input);
    }

    public String toString() {
        ItemStack stack = this.input.func_77946_l();
        return "RInputWireItemStack<" + stack + ">";
    }
}

