/*
 * Decompiled with CFR 0.152.
 */
package ihl.worldgen;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenMinableMeta
extends WorldGenerator {
    protected final Block mineableBlock;
    protected final Set<Block> replaceableBlocks = new HashSet<Block>();
    protected final Block liquidBedBlock;
    protected final int mineableBlockMeta;
    protected final int numberOfBlocks;
    protected int blockCounter;
    protected final int veinMaxHeightLimit;
    protected final int veinMinHeightLimit;
    public boolean maxBlockReached = false;
    public int lastX = -1;
    public int lastY = 64;
    public int lastZ = -1;
    protected ForgeDirection veinDirection = ForgeDirection.SOUTH;
    protected final Map<Long, Set<int[]>> oreCoordinatesToChunkCoordinates;
    protected final Map<Long, WorldGenMinableMeta> blockToOreCoordinates;
    protected final Set<Long> precalculatedChunkChache;

    public WorldGenMinableMeta(Set<Long> precalculatedChunkChache1, Map<Long, WorldGenMinableMeta> blockToOreCoordinates1, Map<Long, Set<int[]>> oreCoordinatesToChunkCoordinates2, Block block, int meta, int numberOfBlocks1, Block ... blocks) {
        this(precalculatedChunkChache1, blockToOreCoordinates1, oreCoordinatesToChunkCoordinates2, block, Blocks.field_150435_aG, meta, numberOfBlocks1, 0, 128, blocks);
    }

    public WorldGenMinableMeta(Set<Long> precalculatedChunkChache1, Map<Long, WorldGenMinableMeta> blockToOreCoordinates1, Map<Long, Set<int[]>> oreCoordinatesToChunkCoordinates1, Block block, Block liquidBedBlock1, int meta, int numberOfBlocks1, int veinMinHeightLimit1, int veinMaxHeightLimit1, Block ... replacedBlock1) {
        this.precalculatedChunkChache = precalculatedChunkChache1;
        this.blockToOreCoordinates = blockToOreCoordinates1;
        this.oreCoordinatesToChunkCoordinates = oreCoordinatesToChunkCoordinates1;
        this.mineableBlock = block;
        this.replaceableBlocks.addAll(Arrays.asList(replacedBlock1));
        this.mineableBlockMeta = meta;
        this.liquidBedBlock = liquidBedBlock1;
        this.numberOfBlocks = numberOfBlocks1;
        this.veinMaxHeightLimit = veinMaxHeightLimit1;
        this.veinMinHeightLimit = veinMinHeightLimit1;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        boolean success = false;
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        int[] xyz = new int[]{0, 0, 1, 0, 0, -1, 0, 0};
        for (int i = 0; i <= 5; ++i) {
            int x0 = x + xyz[i];
            int y0 = y + xyz[i + 1];
            int z0 = z + xyz[i + 2];
            if (x0 >> 4 != chunkX || z0 >> 4 != chunkZ || !this.replaceableBlocks.contains(world.func_147439_a(x0, y0, z0))) continue;
            world.func_147465_d(x0, y0, z0, this.mineableBlock, this.mineableBlockMeta, 2);
            success = true;
        }
        return false;
    }

    public boolean generateNewVein(Random random, int chunkX1, int chunkZ1) {
        Vec3 veinVector = Vec3.func_72443_a((double)(random.nextFloat() * 2.0f - 1.0f), (double)(random.nextFloat() - 0.5f), (double)(random.nextFloat() * 2.0f - 1.0f));
        veinVector.func_72432_b();
        int chunkX = chunkX1;
        int chunkZ = chunkZ1;
        int x0 = chunkX << 4;
        int z0 = chunkZ << 4;
        int y0 = random.nextInt(this.veinMaxHeightLimit);
        float fx = x0;
        float fy = y0;
        float fz = z0;
        long chunkKey = (chunkX << 16) + chunkZ;
        for (int i = 0; i < this.numberOfBlocks; ++i) {
            int[] oreCoordinatesArray = new int[]{x0, y0, z0};
            long oreCoordinatesKey = (x0 << 30) + (y0 << 15) + z0;
            chunkX = x0 >> 4;
            chunkZ = z0 >> 4;
            chunkKey = (chunkX << 16) + chunkZ;
            this.updateOreCoordinatesToChunkCoordinates(chunkKey, oreCoordinatesArray);
            this.blockToOreCoordinates.put(oreCoordinatesKey, this);
            this.precalculatedChunkChache.add(chunkKey);
            fx = (float)((double)fx + (veinVector.field_72450_a + (double)(random.nextFloat() * 0.25f)));
            fy = (float)((double)fy + (veinVector.field_72448_b + (double)(random.nextFloat() * 0.25f)));
            fz = (float)((double)fz + (veinVector.field_72449_c + (double)(random.nextFloat() * 0.25f)));
            x0 = Math.round(fx);
            y0 = Math.round(fy);
            z0 = Math.round(fz);
        }
        return true;
    }

    protected void updateOreCoordinatesToChunkCoordinates(long chunkKey, int[] oreCoordinates) {
        if (this.oreCoordinatesToChunkCoordinates.containsKey(chunkKey)) {
            this.oreCoordinatesToChunkCoordinates.get(chunkKey).add(oreCoordinates);
        } else {
            HashSet<int[]> oreCoordinatesS = new HashSet<int[]>();
            oreCoordinatesS.add(oreCoordinates);
            this.oreCoordinatesToChunkCoordinates.put(chunkKey, oreCoordinatesS);
        }
    }
}

