/*
 * Decompiled with CFR 0.152.
 */
package ihl;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;

public class IHL3dPathFinder {
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    public int lowestPointX;
    public int lowestPointY;
    public int lowestPointZ;
    public double targetX;
    public double targetY;
    public double targetZ;
    private Entity entity;

    public IHL3dPathFinder(Entity entity1) {
        this.entity = entity1;
    }

    public boolean findPath(double x2, double y2, double z2) {
        if (this.isCourseTraversable(x2, y2, z2, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v)) {
            this.waypointX = x2;
            this.waypointY = y2;
            this.waypointZ = z2;
            return true;
        }
        return this.takeVector(x2, y2, z2);
    }

    private boolean isCourseTraversable(double toX, double toY, double toZ, double fromX, double fromY, double fromZ) {
        double var9 = toX - fromX;
        double var11 = toY - fromY;
        double var13 = toZ - fromZ;
        double var7 = MathHelper.func_76133_a((double)(var9 * var9 + var11 * var11 + var13 * var13));
        var9 /= var7;
        var11 /= var7;
        var13 /= var7;
        AxisAlignedBB var15 = this.entity.field_70121_D.func_72329_c();
        int var16 = 1;
        while ((double)var16 < var7) {
            var15.func_72317_d(var9, var11, var13);
            if (!this.entity.field_70170_p.func_72945_a(this.entity, var15).isEmpty()) {
                return false;
            }
            ++var16;
        }
        return true;
    }

    private boolean takeVector(double toX, double toY, double toZ) {
        int x = Math.round((float)toX);
        int y = Math.round((float)toY);
        int z = Math.round((float)toZ);
        int[] xyz = new int[]{0, 0, 1, 0, 0, -1, 0, 0};
        ArrayList<Long> list = new ArrayList<Long>();
        block0: for (int thread = 0; thread <= 256; ++thread) {
            Block block;
            int i;
            if (this.isCourseTraversable((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v)) {
                this.waypointX = (double)x + 0.5;
                this.waypointY = (double)y + 0.5;
                this.waypointZ = (double)z + 0.5;
                return true;
            }
            long number = new Long((long)x * 256L * 256L + (long)y * 256L + (long)z);
            list.add(number);
            double lastDistanceSquared = this.entity.func_70092_e((double)x, (double)y, (double)z);
            boolean skip = false;
            for (i = 0; i <= 5; ++i) {
                block = this.entity.field_70170_p.func_147439_a(x + xyz[i], y + xyz[i + 1], z + xyz[i + 2]);
                number = new Long((long)(x + xyz[i]) * 256L * 256L + (long)(y + xyz[i + 1]) * 256L + (long)z + (long)xyz[i + 2]);
                if (!block.isAir((IBlockAccess)this.entity.field_70170_p, x + xyz[i], y + xyz[i + 1], z + xyz[i + 2]) || list.contains(number) || !(this.entity.func_70092_e((double)x + (double)xyz[i], (double)y + (double)xyz[i + 1], (double)z + (double)xyz[i + 2]) < lastDistanceSquared)) continue;
                x += xyz[i];
                y += xyz[i + 1];
                z += xyz[i + 2];
                skip = true;
                break;
            }
            if (skip) continue;
            for (i = 0; i <= 5; ++i) {
                block = this.entity.field_70170_p.func_147439_a(x + xyz[i], y + xyz[i + 1], z + xyz[i + 2]);
                number = new Long((long)(x + xyz[i]) * 256L * 256L + (long)(y + xyz[i + 1]) * 256L + (long)z + (long)xyz[i + 2]);
                if (!block.isAir((IBlockAccess)this.entity.field_70170_p, x + xyz[i], y + xyz[i + 1], z + xyz[i + 2]) || list.contains(number)) continue;
                x += xyz[i];
                y += xyz[i + 1];
                z += xyz[i + 2];
                continue block0;
            }
        }
        return false;
    }
}

