/*
 * Decompiled with CFR 0.152.
 */
package ihl;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import ihl.IHLMod;
import ihl.flexible_cable.NodeEntity;
import ihl.interfaces.INetworkListener;
import ihl.items_blocks.FlexibleCableItem;
import ihl.items_blocks.MachineBaseBlock;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;

public class ServerProxy {
    protected static FMLEventChannel channel;
    public static final int updatePeriod = 1;
    private static final int maxPacketDataLength = 128;
    protected Map<Integer, INetworkListener> entityList = new HashMap<Integer, INetworkListener>();
    protected Set<INetworkListener> entityServerList = new HashSet<INetworkListener>();
    protected Map<Integer, ByteBuf> delayedEntityDataPacket = new HashMap<Integer, ByteBuf>();
    public Map<Integer, Set<NodeEntity>> nodeEntityRegistry = new HashMap<Integer, Set<NodeEntity>>();

    public void load() throws ParserConfigurationException {
        if (channel == null) {
            channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("ihl");
            channel.register((Object)this);
        }
    }

    public void spawnParticle(int particle, World world, double x, double y, double z, double mx, double my, double mz, float paticleScale) {
    }

    public void spawnParticleFromServer(int particle, World world, double x, double y, double z, double mx, double my, double mz, float paticleScale) {
        ByteBuf bb = Unpooled.buffer((int)36);
        ByteBufOutputStream byteBufOutputStream = new ByteBufOutputStream(bb);
        try {
            byteBufOutputStream.write(0);
            byteBufOutputStream.write(particle);
            byteBufOutputStream.writeFloat((float)x);
            byteBufOutputStream.writeFloat((float)y);
            byteBufOutputStream.writeFloat((float)z);
            byteBufOutputStream.writeFloat((float)mx);
            byteBufOutputStream.writeFloat((float)my);
            byteBufOutputStream.writeFloat((float)mz);
            byteBufOutputStream.writeFloat(paticleScale);
            channel.sendToAllAround(new FMLProxyPacket(byteBufOutputStream.buffer(), "ihl"), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, x, y, z, 32.0));
            byteBufOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void registerIcons(TextureStitchEvent.Pre event) {
    }

    public void initBlockRenderer() {
    }

    public Object getRenderForEntityClass(Class<? extends Entity> entityClass) {
        return null;
    }

    public int getGLDisplayList() {
        return -1;
    }

    public File getMinecraftDir() {
        return new File(".");
    }

    public int shareBlockRendererByMachineType(MachineBaseBlock.MachineType type) {
        return 0;
    }

    public void addEntityToList(INetworkListener entity) {
        this.entityList.put(entity.getId(), entity);
    }

    public void recieveDelayedDataPacket(INetworkListener listener) {
        ByteBuf data = this.delayedEntityDataPacket.remove(listener.getId());
        if (data != null) {
            ByteBufInputStream byteBufInputStream = new ByteBufInputStream(data);
            try {
                listener.recieveData(byteBufInputStream);
                byteBufInputStream.close();
                IHLMod.log.debug("Delayed data read.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            IHLMod.log.debug("Delayed data is null. Entity ID=" + listener.getId());
        }
    }

    public void sendFromServerToAll(FMLProxyPacket fmlProxyPacket) {
        channel.sendToAll(fmlProxyPacket);
    }

    public void sendFromServerToPlayer(FMLProxyPacket fmlProxyPacket, EntityPlayerMP player) {
        channel.sendTo(fmlProxyPacket, player);
    }

    @SubscribeEvent
    public void onPlayerConnectedToServer(PlayerEvent.PlayerLoggedInEvent event) {
        IHLMod.log.debug("player connected");
        Iterator<INetworkListener> inli = this.entityServerList.iterator();
        while (inli.hasNext()) {
            INetworkListener inl = inli.next();
            if (inl.isInvalid()) {
                inli.remove();
                continue;
            }
            if (!(event.player instanceof EntityPlayerMP)) continue;
            inl.registerAndSendData((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerTeleport(PlayerEvent.PlayerChangedDimensionEvent event) {
        FlexibleCableItem.instance.onPlayerTeleport(event);
        Iterator<INetworkListener> inli = this.entityServerList.iterator();
        while (inli.hasNext()) {
            INetworkListener inl = inli.next();
            if (inl.isInvalid()) {
                inli.remove();
                continue;
            }
            if (!(event.player instanceof EntityPlayerMP)) continue;
            inl.registerAndSendData((EntityPlayerMP)event.player);
        }
    }

    public void addEntityToServerList(INetworkListener entity) {
        this.entityServerList.add(entity);
    }

    public boolean renderTESpecialSelectionBox(TileEntity te, EntityPlayer player, ItemStack currentItem, MovingObjectPosition target, float partialTicks) {
        return false;
    }
}

