/*
 * Decompiled with CFR 0.152.
 */
package ihl.datanet;

import ic2.core.Ic2Items;
import ihl.IHLMod;
import ihl.datanet.DataGrid;
import ihl.interfaces.IDataCableHolder;
import ihl.interfaces.IDataNode;
import ihl.processing.invslots.InvSlotSignalProcessor;
import ihl.utils.IHLUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Contact
implements IDataNode {
    public final int innerId;
    private int dataGridID = -1;
    private Set<IDataNode> connectedContacts = new HashSet<IDataNode>();
    public final InvSlotSignalProcessor attachedSlot;
    public final int attachedSlotNumber;
    public final int type;
    private final TileEntity base;

    public Contact(TileEntity base1, int innerId1, InvSlotSignalProcessor attachedSlot1, int attachedSlotNumber1, int type1) {
        this.type = type1;
        this.base = base1;
        this.innerId = innerId1;
        this.attachedSlot = attachedSlot1;
        this.attachedSlotNumber = attachedSlotNumber1;
    }

    public void onLoad() {
        if (this.dataGridID != -1) {
            DataGrid grid = IHLMod.datanet.getGrid(this.dataGridID);
            grid.telist.add(this);
        }
    }

    @Override
    public int getDataGridID() {
        return this.dataGridID;
    }

    @Override
    public void setDataGrid(int newGridID) {
        this.dataGridID = newGridID;
        this.onLoad();
    }

    @Override
    public Set<IDataNode> getConnectedDataNodes() {
        return this.connectedContacts;
    }

    public void removeLinkTo(Contact contact2) {
        this.connectedContacts.remove(contact2);
        contact2.getConnectedDataNodes().remove(this);
        if (this.dataGridID != -1) {
            IHLMod.datanet.splitGrids(this.dataGridID);
        }
        if (this.dataGridID != -1) {
            for (IDataNode contact3 : IHLMod.datanet.getGrid((int)this.dataGridID).telist) {
                contact3.checkAttachedSlots();
            }
        } else {
            this.checkAttachedSlots();
        }
        if (contact2.getDataGridID() != -1) {
            for (IDataNode contact3 : IHLMod.datanet.getGrid((int)contact2.getDataGridID()).telist) {
                contact3.checkAttachedSlots();
            }
        } else {
            contact2.checkAttachedSlots();
        }
    }

    public void removeConnections(Contact[] contacts) {
        if (this.dataGridID != -1) {
            this.connectedContacts.removeAll(Arrays.asList(contacts));
            IHLMod.datanet.splitGrids(this.dataGridID);
        }
    }

    public void establishLink(Contact contact) {
        this.connectedContacts.add(contact);
        contact.getConnectedDataNodes().add(this);
        if (this.dataGridID != contact.getDataGridID() || this.dataGridID == -1 || contact.getDataGridID() == -1) {
            int newDataGridID = IHLMod.datanet.mergeGrids(this.dataGridID, contact.getDataGridID());
            if (this.dataGridID == -1) {
                this.setDataGrid(newDataGridID);
            }
            if (contact.getDataGridID() == -1) {
                contact.setDataGrid(newDataGridID);
            }
            for (IDataNode contact2 : IHLMod.datanet.getGrid((int)newDataGridID).telist) {
                contact2.checkAttachedSlots();
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("dataGridID", this.dataGridID);
        NBTTagList connections = new NBTTagList();
        for (IDataNode contact1 : this.connectedContacts) {
            NBTTagCompound contactNBT = new NBTTagCompound();
            contactNBT.func_74768_a("x", contact1.getXPos());
            contactNBT.func_74768_a("y", contact1.getYPos());
            contactNBT.func_74768_a("z", contact1.getZPos());
            contactNBT.func_74768_a("innerId", contact1.getInnerId());
            connections.func_74742_a((NBTBase)contactNBT);
        }
        nbt.func_74782_a("connections" + this.innerId, (NBTBase)connections);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.setDataGrid(nbt.func_74762_e("dataGridID"));
        NBTTagList connections = nbt.func_150295_c("connections" + this.innerId, 10);
        for (int i = 0; i < connections.func_74745_c(); ++i) {
            NBTTagCompound contactNBT = connections.func_150305_b(i);
            int innerId1 = contactNBT.func_74762_e("innerId");
            int x = contactNBT.func_74762_e("x");
            int y = contactNBT.func_74762_e("y");
            int z = contactNBT.func_74762_e("z");
            World world = this.base.func_145831_w();
            TileEntity te = world.func_147438_o(x, y, z);
            if (te != null && te instanceof IDataCableHolder) {
                IDataCableHolder idch = (IDataCableHolder)te;
                Contact contact1 = idch.getContact(innerId1);
                this.establishLink(contact1);
                continue;
            }
            IHLMod.log.error("Can't load contacts, because IDataCableHolder is null.");
        }
    }

    @Override
    public int getXPos() {
        return this.base.field_145851_c;
    }

    @Override
    public int getYPos() {
        return this.base.field_145848_d;
    }

    @Override
    public int getZPos() {
        return this.base.field_145849_e;
    }

    @Override
    public int getInnerId() {
        return this.innerId;
    }

    public boolean isConnectedToContact(int id) {
        if (this.dataGridID != -1) {
            return IHLMod.datanet.getGrid(this.getDataGridID()).isConnectedToContact(this, id);
        }
        return false;
    }

    @Override
    public boolean isIndirectlyConnectedWithContact(int id) {
        if (this.attachedSlot != null) {
            return this.attachedSlot.isIndirectlyConnectedWithContact(this, id);
        }
        return false;
    }

    @Override
    public void checkAttachedSlots() {
        if (this.attachedSlot != null) {
            ItemStack is = this.attachedSlot.get(this.attachedSlotNumber);
            this.attachedSlot.slotStatus[this.attachedSlotNumber] = is != null && IHLUtils.isItemStacksIsEqual(is, Ic2Items.detectorCableItem, true) ? this.isConnectedToContact(0) && this.attachedSlot.getOppositeContact(this).isConnectedToContact(1) || this.isConnectedToContact(1) && this.attachedSlot.getOppositeContact(this).isConnectedToContact(0) : false;
            this.attachedSlot.notifyNeighbors();
        }
    }

    @Override
    public InvSlotSignalProcessor getAttachedSlot() {
        return this.attachedSlot;
    }

    @Override
    public int getAttachedSlotNumber() {
        return this.attachedSlotNumber;
    }

    @Override
    public int getType() {
        return this.type;
    }
}

