/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.metallurgy;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.core.ContainerBase;
import ic2.core.block.invslot.InvSlot;
import ihl.IHLMod;
import ihl.processing.chemistry.ApparatusProcessableInvSlot;
import ihl.processing.metallurgy.AchesonFurnaceGui;
import ihl.processing.metallurgy.AchesonFurnanceContainer;
import ihl.processing.metallurgy.Crucible;
import ihl.processing.metallurgy.MachineBaseTileEntity;
import ihl.recipes.RecipeOutputItemStack;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class AchesonFurnanceTileEntity
extends MachineBaseTileEntity {
    public final ApparatusProcessableInvSlot inputElectrode;
    protected static UniversalRecipeManager recipeManager = new UniversalRecipeManager("achesonfurnace");
    private final RecipeInputOreDict[] validElectrodeTypes = new RecipeInputOreDict[]{new RecipeInputOreDict("stickCoal"), new RecipeInputOreDict("stickGraphite"), new RecipeInputOreDict("plateCoal"), new RecipeInputOreDict("plateGraphite")};

    public AchesonFurnanceTileEntity() {
        super(2);
        this.inputElectrode = new ApparatusProcessableInvSlot(this, "inputElectrode", 1, InvSlot.Access.IO, 2, 1);
    }

    public static void addRecipe(IRecipeInput input1, IRecipeInput input2, String output1) {
        recipeManager.addRecipe(new UniversalRecipeInput(null, Arrays.asList(input1, input2)), new UniversalRecipeOutput(null, Arrays.asList(IHLUtils.getThisModItemStack(output1)), 20));
    }

    @Override
    public String getStartSoundFile() {
        return "Machines/Electro Furnace/ElectroFurnaceLoop.ogg";
    }

    @Override
    public String getLoopSoundFile() {
        return null;
    }

    @Override
    public String getStopSoundFile() {
        return null;
    }

    @Override
    public String func_145825_b() {
        return "AchesonFurnance";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean arg1) {
        return new AchesonFurnaceGui(new AchesonFurnanceContainer(player, this));
    }

    @Override
    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        return new AchesonFurnanceContainer(player, this);
    }

    @Override
    public void operate() {
        int i;
        List<RecipeOutputItemStack> output = recipeManager.getOutputFor(this.getInput(), true, true).getItemOutputs();
        for (i = 0; i < this.inputElectrode.size(); ++i) {
            ItemStack electrodeIS = this.inputElectrode.get(i);
            if (this.validElectrodeTypes[0].matches(electrodeIS)) {
                this.inputElectrode.put(i, IHLUtils.getThisModItemStack("stickGraphite"));
                continue;
            }
            if (!this.validElectrodeTypes[2].matches(electrodeIS)) continue;
            this.inputElectrode.put(i, IHLUtils.getThisModItemStack("plateGraphite"));
        }
        for (i = 0; i < this.input.size(); ++i) {
            if (output.size() > i) {
                ItemStack stack = output.get((int)i).itemStack.func_77946_l();
                stack.field_77994_a = Math.round(output.get((int)i).quantity);
                this.input.put(i, stack);
            }
            if (this.input.get(i) == null || this.input.get((int)i).field_77994_a > 0) continue;
            this.input.put(i, null);
        }
        ItemStack crucible = this.input.getItemStack(IHLMod.crucible);
        if (crucible != null) {
            ItemStack itemStack = ((Crucible)crucible.func_77973_b()).processContent(crucible, (IInventory)this);
        }
    }

    @Override
    public boolean canOperate() {
        return this.isValidElectrode(this.inputElectrode.get(0)) && this.isValidElectrode(this.inputElectrode.get(1)) && this.getOutput() != null;
    }

    @Override
    public List[] getInput() {
        return new List[]{null, this.input.getItemStackList()};
    }

    public static Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return recipeManager.getRecipes();
    }

    @Override
    public UniversalRecipeOutput getOutput() {
        return recipeManager.getOutputFor(this.getInput(), false, false);
    }

    private boolean isValidElectrode(ItemStack stack) {
        if (stack != null) {
            for (int i = 0; i < this.validElectrodeTypes.length; ++i) {
                if (!this.validElectrodeTypes[i].matches(stack)) continue;
                return true;
            }
        }
        return false;
    }
}

