/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.metallurgy;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkDataProvider;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.network.NetworkManager;
import ihl.items_blocks.FlexibleCableItem;
import ihl.processing.metallurgy.IProductionLine;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class VulcanizationExtrudingMoldTileEntity
extends TileEntity
implements IWrenchable,
INetworkDataProvider,
IEnergySink,
IProductionLine,
IFluidHandler {
    private short facing = (short)2;
    private short lastFacing = (short)2;
    public double energy;
    public int maxStorage = 64;
    private double energyConsume = 16.0;
    private boolean addedToEnergyNet = false;
    private FluidTank fluidTank = new FluidTank(5000);
    protected static final UniversalRecipeManager recipeManager = new UniversalRecipeManager("vulcanizationextrudingmold");

    public static void addRecipe(FluidStack inputFluid, ItemStack input, ItemStack output1) {
        recipeManager.addRecipe(new UniversalRecipeInput(Arrays.asList(inputFluid), Arrays.asList(input)), new UniversalRecipeOutput(null, Arrays.asList(output1), 200));
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_145843_s() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.func_145843_s();
    }

    public List<String> getNetworkedFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("facing");
        return fields;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
        if (this.lastFacing != this.facing) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "facing");
            this.lastFacing = this.facing;
        }
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side;
    }

    @Override
    public short getFacing() {
        return this.facing;
    }

    public void setFacing(short facing1) {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        this.facing = (short)Math.max(2, facing1);
        if (IC2.platform.isSimulating()) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "facing");
            this.lastFacing = this.facing;
        }
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return IHLUtils.getThisModItemStack("vulcanizationExtrudingMold");
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
        this.facing = nbttagcompound.func_74765_d("facing");
        this.energy = nbttagcompound.func_74769_h("energy");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
        nbttagcompound.func_74777_a("facing", this.facing);
        nbttagcompound.func_74780_a("energy", this.energy);
    }

    public double getDemandedEnergy() {
        return (double)this.maxStorage - this.energy;
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy < (double)this.maxStorage) {
            this.energy += amount;
            return 0.0;
        }
        return amount;
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    private ItemStack processWire(ItemStack wire, boolean doProcess) {
        UniversalRecipeOutput rOutput = recipeManager.getOutputFor(Arrays.asList(this.fluidTank.getFluid()), Arrays.asList(wire), false, false);
        if (rOutput == null || !(wire.func_77973_b() instanceof FlexibleCableItem) || this.energy < this.energyConsume) {
            return wire;
        }
        UniversalRecipeInput rInput = recipeManager.getRecipeInput(Arrays.asList(this.fluidTank.getFluid()), Arrays.asList(wire));
        ItemStack cableAsRO = rOutput.getItemOutputs().get((int)0).itemStack;
        ItemStack cable = wire.func_77946_l();
        FlexibleCableItem fci = (FlexibleCableItem)cableAsRO.func_77973_b();
        cable.field_77990_d.func_74778_a("insulationMaterial", fci.getInsulationMaterial(cableAsRO));
        cable.field_77990_d.func_74768_a("insulationThickness", fci.getInsulationThickness(cableAsRO));
        cable.field_77990_d.func_74768_a("maxVoltage", IHLUtils.getInsulationMaxVoltage(fci.getInsulationMaterial(cableAsRO), fci.getInsulationThickness(cableAsRO)));
        if (doProcess) {
            this.energy -= this.energyConsume;
            this.fluidTank.drain(rInput.getFluidInputs().get(0).getAmount() * IHLUtils.getWireLength(cable), true);
        }
        return cable;
    }

    @Override
    public boolean canProcess(ItemStack wire) {
        ItemStack cable = this.processWire(wire, false);
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.getFacing()).getRotation(ForgeDirection.UP);
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        if (te instanceof IProductionLine && ForgeDirection.getOrientation((int)((IProductionLine)te).getFacing()).equals((Object)dir.getRotation(ForgeDirection.DOWN))) {
            return ((IProductionLine)te).canProcess(cable);
        }
        return false;
    }

    @Override
    public void process(ItemStack wire) {
        ItemStack cable = this.processWire(wire, true);
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.getFacing()).getRotation(ForgeDirection.UP);
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        if (te instanceof IProductionLine && ForgeDirection.getOrientation((int)((IProductionLine)te).getFacing()).equals((Object)dir.getRotation(ForgeDirection.DOWN))) {
            ((IProductionLine)te).process(cable);
        }
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return false;
    }

    public boolean canFill(ForgeDirection arg0, Fluid arg1) {
        return ForgeDirection.getOrientation((int)this.facing) == arg0;
    }

    public FluidStack drain(ForgeDirection arg0, FluidStack arg1, boolean arg2) {
        return null;
    }

    public FluidStack drain(ForgeDirection arg0, int arg1, boolean arg2) {
        return null;
    }

    public int fill(ForgeDirection arg0, FluidStack arg1, boolean arg2) {
        return this.fluidTank.fill(arg1, arg2);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection arg0) {
        return null;
    }

    public static Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return recipeManager.getRecipes();
    }
}

