/*
 * Decompiled with CFR 0.152.
 */
package ihl.recipes;

import ihl.recipes.RecipeOutputItemStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class UniversalRecipeOutput {
    private final List<FluidStack> fluidOutputs = new ArrayList<FluidStack>();
    private final List<RecipeOutputItemStack> itemOutputs = new ArrayList<RecipeOutputItemStack>();
    private final int time;
    public final boolean specialConditions;

    public UniversalRecipeOutput(List<FluidStack> fluidOutputs1, List itemOutputs1, int time1) {
        this(fluidOutputs1, itemOutputs1, time1, false);
    }

    public UniversalRecipeOutput(List<FluidStack> fluidOutputs1, List itemOutputs1, int time1, boolean specialConditions1) {
        if (fluidOutputs1 != null) {
            for (FluidStack fStack : fluidOutputs1) {
                if (fStack == null) {
                    throw new NullPointerException("Recipe cannot contain null elements!");
                }
                this.fluidOutputs.add(fStack);
            }
        }
        if (itemOutputs1 != null) {
            for (Object io : itemOutputs1) {
                if (io == null) {
                    throw new NullPointerException("Recipe output cannot be null!");
                }
                if (io instanceof ItemStack) {
                    this.itemOutputs.add(new RecipeOutputItemStack((ItemStack)io));
                    continue;
                }
                this.itemOutputs.add((RecipeOutputItemStack)io);
            }
        }
        this.specialConditions = specialConditions1;
        this.time = time1;
    }

    public boolean matches(List<FluidStack> fluidOutputs1, List<ItemStack> itemOutputs1) {
        if (this.fluidOutputs.size() != fluidOutputs1.size() || this.itemOutputs.size() != this.itemOutputs.size()) {
            return false;
        }
        Iterator<FluidStack> fi1 = fluidOutputs1.iterator();
        Iterator<ItemStack> ii1 = itemOutputs1.iterator();
        Iterator<FluidStack> fi = this.fluidOutputs.iterator();
        Iterator<RecipeOutputItemStack> ii = this.itemOutputs.iterator();
        while (fi.hasNext()) {
            FluidStack fs = fi.next();
            FluidStack fs1 = fi1.next();
            if (fs.getFluid() == fs1.getFluid()) continue;
            return false;
        }
        while (ii.hasNext()) {
            ItemStack is1;
            RecipeOutputItemStack is = ii.next();
            if (is.matches(is1 = ii1.next())) continue;
            return false;
        }
        return true;
    }

    public List<FluidStack> getFluidOutputs() {
        return this.fluidOutputs;
    }

    public List<RecipeOutputItemStack> getItemOutputs() {
        return this.itemOutputs;
    }

    public UniversalRecipeOutput copyWithMultiplier(int mulipier) {
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        ArrayList<RecipeOutputItemStack> itemStacks = new ArrayList<RecipeOutputItemStack>();
        if (this.fluidOutputs != null && !this.fluidOutputs.isEmpty()) {
            for (FluidStack fs : this.fluidOutputs) {
                FluidStack newFs = fs.copy();
                newFs.amount *= mulipier;
                fluidStacks.add(newFs);
            }
        }
        if (this.itemOutputs != null && !this.itemOutputs.isEmpty()) {
            for (RecipeOutputItemStack is : this.itemOutputs) {
                RecipeOutputItemStack newIs = is.copy(mulipier);
                itemStacks.add(newIs);
            }
        }
        return new UniversalRecipeOutput(fluidStacks, itemStacks, this.getTime(), false);
    }

    public int getTime() {
        return this.time;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        for (FluidStack fluid : this.fluidOutputs) {
            out.append(fluid.getLocalizedName() + ": " + fluid.amount + "/n");
        }
        for (RecipeOutputItemStack stack : this.itemOutputs) {
            out.append(stack.itemStack.func_82833_r() + ": " + stack.quantity + "/n");
        }
        return out.toString();
    }
}

