/*
 * Decompiled with CFR 0.152.
 */
package chocohead.AdvMachines.te;

import chocohead.AdvMachines.te.TileEntityHeatingMachine;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.core.gui.dynamic.IFluidTankProvider;
import ic2.core.network.GuiSynced;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class TileEntityHeatingWaterMachine
extends TileEntityHeatingMachine
implements IFluidTankProvider {
    @GuiSynced
    protected final FluidTank tank = new FluidTank(8000){

        public int fillInternal(FluidStack resource, boolean doFill) {
            int out = super.fillInternal(resource, doFill);
            if (out > 0) {
                TileEntityHeatingWaterMachine.this.onFluidFill(doFill, out);
            }
            return out;
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && fluid.getFluid() == FluidRegistry.WATER;
        }

        public boolean canDrain() {
            return false;
        }
    };
    protected final short activeWaterUse;

    public TileEntityHeatingWaterMachine(int maxHeat, byte numberOfOutputs, IMachineRecipeManager recipeSet, short activeWaterUse) {
        super(maxHeat, numberOfOutputs, recipeSet);
        this.activeWaterUse = activeWaterUse;
    }

    public TileEntityHeatingWaterMachine(int maxHeat, byte tier, byte numberOfOutputs, IMachineRecipeManager recipeSet, short activeWaterUse) {
        super(maxHeat, tier, numberOfOutputs, recipeSet);
        this.activeWaterUse = activeWaterUse;
    }

    public TileEntityHeatingWaterMachine(int maxHeat, byte numberOfOutputs, IMachineRecipeManager recipeSet, int idleEU, int activeEU, short activeWaterUse) {
        super(maxHeat, numberOfOutputs, recipeSet, idleEU, activeEU);
        this.activeWaterUse = activeWaterUse;
    }

    public TileEntityHeatingWaterMachine(int maxHeat, byte tier, byte numberOfOutputs, IMachineRecipeManager recipeSet, int idleEU, int activeEU, short activeWaterUse) {
        super(maxHeat, tier, numberOfOutputs, recipeSet, idleEU, activeEU);
        this.activeWaterUse = activeWaterUse;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.tank.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        this.tank.writeToNBT(nbt);
        return super.writeToNBT(nbt);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    protected void onFluidFill(boolean didFill, int amount) {
    }

    @Override
    public boolean canIdle() {
        if (super.canIdle()) {
            int waterNeeded = this.getIdleWaterUse();
            if (waterNeeded == 0) {
                return true;
            }
            FluidStack stack = this.tank.drainInternal(waterNeeded, false);
            if (stack != null && stack.amount == waterNeeded) {
                this.tank.drainInternal(waterNeeded, true);
                return true;
            }
        }
        return false;
    }

    protected abstract int getIdleWaterUse();

    @Override
    public boolean canOperate() {
        FluidStack stack;
        return super.canOperate() && (stack = this.tank.drainInternal((int)this.activeWaterUse, false)) != null && stack.amount == this.activeWaterUse;
    }

    @Override
    public void operate() {
        super.operate();
        this.tank.drainInternal((int)this.activeWaterUse, true);
    }

    public IFluidTank getFluidTank(String name) {
        if ("tank".equals(name)) {
            return this.tank;
        }
        throw new IllegalArgumentException("Unknown tank name: " + name);
    }

    protected boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        int space;
        if (heldItem != null && FluidUtil.tryEmptyContainer((ItemStack)heldItem, (IFluidHandler)this.tank, (int)(space = this.tank.getCapacity() - this.tank.getFluidAmount()), (EntityPlayer)player, (boolean)false) != null) {
            ItemStack stack = FluidUtil.tryEmptyContainer((ItemStack)heldItem, (IFluidHandler)this.tank, (int)space, (EntityPlayer)player, (boolean)true);
            player.setHeldItem(hand, stack == null || stack.stackSize == 0 ? null : stack);
            return true;
        }
        return super.onActivated(player, hand, heldItem, side, hitX, hitY, hitZ);
    }
}

